'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _glMatrix = require('gl-matrix');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Vector3 = function (_MathArray) {
  _inherits(Vector3, _MathArray);

  // Creates a new vec3, either empty, or from an array or from values
  function Vector3() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

    _classCallCheck(this, Vector3);

    var _this = _possibleConstructorReturn(this, (Vector3.__proto__ || Object.getPrototypeOf(Vector3)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z);
    }
    return _this;
  }

  _createClass(Vector3, [{
    key: 'set',
    value: function set(x, y, z) {
      _glMatrix.vec3.set(this, x, y, z);
      this.check();
      return this;
    }
  }, {
    key: 'equals',
    value: function equals(vector) {
      return _glMatrix.vec3.equals(this, vector);
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(vector) {
      return _glMatrix.vec3.exactEquals(this, vector);
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'distance',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    value: function distance(vector) {
      return _glMatrix.vec3.distance(vector);
    }
  }, {
    key: 'dist',
    value: function dist(vector) {
      return _glMatrix.vec3.dist(vector);
    }
  }, {
    key: 'angle',
    value: function angle(vector) {
      return _glMatrix.vec3.angle(vector);
    }

    // MODIFIERS

  }, {
    key: 'add',
    value: function add() {
      for (var _len = arguments.length, vectors = Array(_len), _key = 0; _key < _len; _key++) {
        vectors[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = vectors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var vector = _step.value;

          _glMatrix.vec3.add(this, vector);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'subtract',
    value: function subtract() {
      for (var _len2 = arguments.length, vectors = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        vectors[_key2] = arguments[_key2];
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = vectors[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var vector = _step2.value;

          _glMatrix.vec3.subtract(this, vector);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'multiply',
    value: function multiply() {
      for (var _len3 = arguments.length, vectors = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        vectors[_key3] = arguments[_key3];
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = vectors[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var vector = _step3.value;

          _glMatrix.vec3.multiply(this, vector);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'divide',
    value: function divide() {
      for (var _len4 = arguments.length, vectors = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        vectors[_key4] = arguments[_key4];
      }

      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = vectors[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var vector = _step4.value;

          _glMatrix.vec3.divide(this, vector);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'ceil',
    value: function ceil() {
      _glMatrix.vec3.ceil(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'floor',
    value: function floor() {
      _glMatrix.vec3.floor(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'min',
    value: function min() {
      _glMatrix.vec3.min(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'max',
    value: function max() {
      _glMatrix.vec3.max(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'scale',
    value: function scale(_scale) {
      _glMatrix.vec3.scale(this, this, _scale);
      this.check();
      return this;
    }
  }, {
    key: 'scaleAndAdd',
    value: function scaleAndAdd(vector, scale) {
      _glMatrix.vec3.scaleAndAdd(this, this, vector, scale);
      this.check();
      return this;
    }
  }, {
    key: 'negate',
    value: function negate() {
      _glMatrix.vec3.negate(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'inverse',
    value: function inverse() {
      _glMatrix.vec3.inverse(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'normalize',
    value: function normalize() {
      _glMatrix.vec3.normalize(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'dot',
    value: function dot(vector) {
      _glMatrix.vec3.dot(this, this, vector);
      this.check();
      return this;
    }
  }, {
    key: 'cross',
    value: function cross(vector) {
      _glMatrix.vec3.cross(this, this, vector);
      this.check();
      return this;
    }
  }, {
    key: 'lerp',
    value: function lerp(scale) {
      _glMatrix.vec3.lerp(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'hermite',
    value: function hermite(scale) {
      _glMatrix.vec3.hermite(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'bezier',
    value: function bezier(scale) {
      _glMatrix.vec3.bezier(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'random',
    value: function random(scale) {
      _glMatrix.vec3.cross(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'rotateX',
    value: function rotateX(origin, angle) {
      _glMatrix.vec3.rotateX(this, this, origin, angle);
      this.check();
      return this;
    }
  }, {
    key: 'rotateY',
    value: function rotateY(origin, angle) {
      _glMatrix.vec3.rotateY(this, this, origin, angle);
      this.check();
      return this;
    }
  }, {
    key: 'rotateZ',
    value: function rotateZ(origin, angle) {
      _glMatrix.vec3.rotateZ(this, this, origin, angle);
      this.check();
      return this;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 3;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }], [{
    key: 'fromArray',
    value: function fromArray(array) {
      if (array instanceof Vector3) {
        return array;
      }
      return new (Function.prototype.bind.apply(Vector3, [null].concat(_toConsumableArray(array))))();
    }
  }, {
    key: 'dot',
    value: function dot(a, b) {
      return Vector3.fromArray(a).dot(b);
    }
  }, {
    key: 'cross',
    value: function cross(a, b) {
      return Vector3.fromArray(a).cross(b);
    }
  }]);

  return Vector3;
}(_mathArray2.default);

exports.default = Vector3;
//# sourceMappingURL=data:application/json;base64,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