'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _glMatrix = require('gl-matrix');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Vector4 = function (_MathArray) {
  _inherits(Vector4, _MathArray);

  // Creates a new, empty vec4
  function Vector4() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

    _classCallCheck(this, Vector4);

    var _this = _possibleConstructorReturn(this, (Vector4.__proto__ || Object.getPrototypeOf(Vector4)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z, w);
    }
    return _this;
  }

  _createClass(Vector4, [{
    key: 'set',
    value: function set(x, y, z, w) {
      _glMatrix.vec4.set(this, x, y, z, w);
      this.check();
      return this;
    }
  }, {
    key: 'equals',
    value: function equals(vector) {
      return _glMatrix.vec4.equals(this, vector);
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(vector) {
      return _glMatrix.vec4.exactEquals(this, vector);
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'distance',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    value: function distance(vector) {
      return _glMatrix.vec4.distance(vector);
    }
  }, {
    key: 'dist',
    value: function dist(vector) {
      return _glMatrix.vec4.dist(vector);
    }
  }, {
    key: 'angle',
    value: function angle(vector) {
      return _glMatrix.vec4.angle(vector);
    }
  }, {
    key: 'add',
    value: function add() {
      for (var _len = arguments.length, vectors = Array(_len), _key = 0; _key < _len; _key++) {
        vectors[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = vectors[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var vector = _step.value;

          _glMatrix.vec4.add(this, vector);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'subtract',
    value: function subtract() {
      for (var _len2 = arguments.length, vectors = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        vectors[_key2] = arguments[_key2];
      }

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = vectors[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var vector = _step2.value;

          _glMatrix.vec4.subtract(this, vector);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'multiply',
    value: function multiply() {
      for (var _len3 = arguments.length, vectors = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        vectors[_key3] = arguments[_key3];
      }

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = vectors[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var vector = _step3.value;

          _glMatrix.vec4.multiply(this, vector);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'divide',
    value: function divide() {
      for (var _len4 = arguments.length, vectors = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        vectors[_key4] = arguments[_key4];
      }

      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = vectors[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var vector = _step4.value;

          _glMatrix.vec4.divide(this, vector);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      this.check();
      return this;
    }
  }, {
    key: 'ceil',
    value: function ceil() {
      _glMatrix.vec4.ceil(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'floor',
    value: function floor() {
      _glMatrix.vec4.floor(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'min',
    value: function min() {
      _glMatrix.vec4.min(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'max',
    value: function max() {
      _glMatrix.vec4.max(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'scale',
    value: function scale(_scale) {
      _glMatrix.vec4.scale(this, this, _scale);
      this.check();
      return this;
    }
  }, {
    key: 'scaleAndAdd',
    value: function scaleAndAdd(vector, scale) {
      _glMatrix.vec4.scaleAndAdd(this, this, vector, scale);
      this.check();
      return this;
    }
  }, {
    key: 'negate',
    value: function negate() {
      _glMatrix.vec4.negate(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'inverse',
    value: function inverse() {
      _glMatrix.vec4.inverse(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'normalize',
    value: function normalize() {
      _glMatrix.vec4.normalize(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'dot',
    value: function dot(scale) {
      _glMatrix.vec4.dot(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'cross',
    value: function cross(scale) {
      _glMatrix.vec4.cross(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'lerp',
    value: function lerp(scale) {
      _glMatrix.vec4.lerp(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'hermite',
    value: function hermite(scale) {
      _glMatrix.vec4.hermite(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'bezier',
    value: function bezier(scale) {
      _glMatrix.vec4.bezier(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'random',
    value: function random(scale) {
      _glMatrix.vec4.random(this, this, scale);
      this.check();
      return this;
    }
  }, {
    key: 'rotateX',
    value: function rotateX(origin, angle) {
      _glMatrix.vec4.rotateX(this, this, origin, angle);
      this.check();
      return this;
    }
  }, {
    key: 'rotateY',
    value: function rotateY(origin, angle) {
      _glMatrix.vec4.rotateY(this, this, origin, angle);
      this.check();
      return this;
    }
  }, {
    key: 'rotateZ',
    value: function rotateZ(origin, angle) {
      _glMatrix.vec4.rotateZ(this, this, origin, angle);
      this.check();
      return this;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 4;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'w',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }]);

  return Vector4;
}(_mathArray2.default);

exports.default = Vector4;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9wYWNrYWdlcy9tYXRoL3NyYy92ZWN0b3I0LmpzIl0sIm5hbWVzIjpbIlZlY3RvcjQiLCJ4IiwieSIsInoiLCJ3IiwiQXJyYXkiLCJpc0FycmF5IiwiYXJndW1lbnRzIiwibGVuZ3RoIiwiY29weSIsInNldCIsImNoZWNrIiwidmVjdG9yIiwiZXF1YWxzIiwiZXhhY3RFcXVhbHMiLCJkaXN0YW5jZSIsImRpc3QiLCJhbmdsZSIsInZlY3RvcnMiLCJhZGQiLCJzdWJ0cmFjdCIsIm11bHRpcGx5IiwiZGl2aWRlIiwiY2VpbCIsImZsb29yIiwibWluIiwibWF4Iiwic2NhbGUiLCJzY2FsZUFuZEFkZCIsIm5lZ2F0ZSIsImludmVyc2UiLCJub3JtYWxpemUiLCJkb3QiLCJjcm9zcyIsImxlcnAiLCJoZXJtaXRlIiwiYmV6aWVyIiwicmFuZG9tIiwib3JpZ2luIiwicm90YXRlWCIsInJvdGF0ZVkiLCJyb3RhdGVaIiwidmFsdWUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7O0FBQ0E7Ozs7Ozs7Ozs7SUFFcUJBLE87OztBQUNuQjtBQUNBLHFCQUF3QztBQUFBLFFBQTVCQyxDQUE0Qix1RUFBeEIsQ0FBd0I7QUFBQSxRQUFyQkMsQ0FBcUIsdUVBQWpCLENBQWlCO0FBQUEsUUFBZEMsQ0FBYyx1RUFBVixDQUFVO0FBQUEsUUFBUEMsQ0FBTyx1RUFBSCxDQUFHOztBQUFBOztBQUFBOztBQUV0QyxRQUFJQyxNQUFNQyxPQUFOLENBQWNMLENBQWQsS0FBb0JNLFVBQVVDLE1BQVYsS0FBcUIsQ0FBN0MsRUFBZ0Q7QUFDOUMsWUFBS0MsSUFBTCxDQUFVUixDQUFWO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsWUFBS1MsR0FBTCxDQUFTVCxDQUFULEVBQVlDLENBQVosRUFBZUMsQ0FBZixFQUFrQkMsQ0FBbEI7QUFDRDtBQU5xQztBQU92Qzs7Ozt3QkFFR0gsQyxFQUFHQyxDLEVBQUdDLEMsRUFBR0MsQyxFQUFHO0FBQ2QscUJBQUtNLEdBQUwsQ0FBUyxJQUFULEVBQWVULENBQWYsRUFBa0JDLENBQWxCLEVBQXFCQyxDQUFyQixFQUF3QkMsQ0FBeEI7QUFDQSxXQUFLTyxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OzsyQkFFTUMsTSxFQUFRO0FBQ2IsYUFBTyxlQUFLQyxNQUFMLENBQVksSUFBWixFQUFrQkQsTUFBbEIsQ0FBUDtBQUNEOzs7Z0NBRVdBLE0sRUFBUTtBQUNsQixhQUFPLGVBQUtFLFdBQUwsQ0FBaUIsSUFBakIsRUFBdUJGLE1BQXZCLENBQVA7QUFDRDs7QUFFRDtBQUNBOzs7OztBQVVBOzs2QkFFU0EsTSxFQUFRO0FBQ2YsYUFBTyxlQUFLRyxRQUFMLENBQWNILE1BQWQsQ0FBUDtBQUNEOzs7eUJBRUlBLE0sRUFBUTtBQUNYLGFBQU8sZUFBS0ksSUFBTCxDQUFVSixNQUFWLENBQVA7QUFDRDs7OzBCQUVLQSxNLEVBQVE7QUFDWixhQUFPLGVBQUtLLEtBQUwsQ0FBV0wsTUFBWCxDQUFQO0FBQ0Q7OzswQkFFZTtBQUFBLHdDQUFUTSxPQUFTO0FBQVRBLGVBQVM7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFDZCw2QkFBcUJBLE9BQXJCLDhIQUE4QjtBQUFBLGNBQW5CTixNQUFtQjs7QUFDNUIseUJBQUtPLEdBQUwsQ0FBUyxJQUFULEVBQWVQLE1BQWY7QUFDRDtBQUhhO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBSWQsV0FBS0QsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7K0JBRW9CO0FBQUEseUNBQVRPLE9BQVM7QUFBVEEsZUFBUztBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUNuQiw4QkFBcUJBLE9BQXJCLG1JQUE4QjtBQUFBLGNBQW5CTixNQUFtQjs7QUFDNUIseUJBQUtRLFFBQUwsQ0FBYyxJQUFkLEVBQW9CUixNQUFwQjtBQUNEO0FBSGtCO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBSW5CLFdBQUtELEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OytCQUVvQjtBQUFBLHlDQUFUTyxPQUFTO0FBQVRBLGVBQVM7QUFBQTs7QUFBQTtBQUFBO0FBQUE7O0FBQUE7QUFDbkIsOEJBQXFCQSxPQUFyQixtSUFBOEI7QUFBQSxjQUFuQk4sTUFBbUI7O0FBQzVCLHlCQUFLUyxRQUFMLENBQWMsSUFBZCxFQUFvQlQsTUFBcEI7QUFDRDtBQUhrQjtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBOztBQUluQixXQUFLRCxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7Ozs2QkFFa0I7QUFBQSx5Q0FBVE8sT0FBUztBQUFUQSxlQUFTO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQ2pCLDhCQUFxQkEsT0FBckIsbUlBQThCO0FBQUEsY0FBbkJOLE1BQW1COztBQUM1Qix5QkFBS1UsTUFBTCxDQUFZLElBQVosRUFBa0JWLE1BQWxCO0FBQ0Q7QUFIZ0I7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTs7QUFJakIsV0FBS0QsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7MkJBRU07QUFDTCxxQkFBS1ksSUFBTCxDQUFVLElBQVYsRUFBZ0IsSUFBaEI7QUFDQSxXQUFLWixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7Ozs0QkFFTztBQUNOLHFCQUFLYSxLQUFMLENBQVcsSUFBWCxFQUFpQixJQUFqQjtBQUNBLFdBQUtiLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzBCQUVLO0FBQ0oscUJBQUtjLEdBQUwsQ0FBUyxJQUFULEVBQWUsSUFBZjtBQUNBLFdBQUtkLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzBCQUVLO0FBQ0oscUJBQUtlLEdBQUwsQ0FBUyxJQUFULEVBQWUsSUFBZjtBQUNBLFdBQUtmLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzBCQUVLZ0IsTSxFQUFPO0FBQ1gscUJBQUtBLEtBQUwsQ0FBVyxJQUFYLEVBQWlCLElBQWpCLEVBQXVCQSxNQUF2QjtBQUNBLFdBQUtoQixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OztnQ0FFV0MsTSxFQUFRZSxLLEVBQU87QUFDekIscUJBQUtDLFdBQUwsQ0FBaUIsSUFBakIsRUFBdUIsSUFBdkIsRUFBNkJoQixNQUE3QixFQUFxQ2UsS0FBckM7QUFDQSxXQUFLaEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7NkJBRVE7QUFDUCxxQkFBS2tCLE1BQUwsQ0FBWSxJQUFaLEVBQWtCLElBQWxCO0FBQ0EsV0FBS2xCLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzhCQUVTO0FBQ1IscUJBQUttQixPQUFMLENBQWEsSUFBYixFQUFtQixJQUFuQjtBQUNBLFdBQUtuQixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OztnQ0FFVztBQUNWLHFCQUFLb0IsU0FBTCxDQUFlLElBQWYsRUFBcUIsSUFBckI7QUFDQSxXQUFLcEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7d0JBRUdnQixLLEVBQU87QUFDVCxxQkFBS0ssR0FBTCxDQUFTLElBQVQsRUFBZSxJQUFmLEVBQXFCTCxLQUFyQjtBQUNBLFdBQUtoQixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OzswQkFFS2dCLEssRUFBTztBQUNYLHFCQUFLTSxLQUFMLENBQVcsSUFBWCxFQUFpQixJQUFqQixFQUF1Qk4sS0FBdkI7QUFDQSxXQUFLaEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7eUJBRUlnQixLLEVBQU87QUFDVixxQkFBS08sSUFBTCxDQUFVLElBQVYsRUFBZ0IsSUFBaEIsRUFBc0JQLEtBQXRCO0FBQ0EsV0FBS2hCLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzRCQUVPZ0IsSyxFQUFPO0FBQ2IscUJBQUtRLE9BQUwsQ0FBYSxJQUFiLEVBQW1CLElBQW5CLEVBQXlCUixLQUF6QjtBQUNBLFdBQUtoQixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OzsyQkFFTWdCLEssRUFBTztBQUNaLHFCQUFLUyxNQUFMLENBQVksSUFBWixFQUFrQixJQUFsQixFQUF3QlQsS0FBeEI7QUFDQSxXQUFLaEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7MkJBRU1nQixLLEVBQU87QUFDWixxQkFBS1UsTUFBTCxDQUFZLElBQVosRUFBa0IsSUFBbEIsRUFBd0JWLEtBQXhCO0FBQ0EsV0FBS2hCLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzRCQUVPMkIsTSxFQUFRckIsSyxFQUFPO0FBQ3JCLHFCQUFLc0IsT0FBTCxDQUFhLElBQWIsRUFBbUIsSUFBbkIsRUFBeUJELE1BQXpCLEVBQWlDckIsS0FBakM7QUFDQSxXQUFLTixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7Ozs0QkFFTzJCLE0sRUFBUXJCLEssRUFBTztBQUNyQixxQkFBS3VCLE9BQUwsQ0FBYSxJQUFiLEVBQW1CLElBQW5CLEVBQXlCRixNQUF6QixFQUFpQ3JCLEtBQWpDO0FBQ0EsV0FBS04sS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOzs7NEJBRU8yQixNLEVBQVFyQixLLEVBQU87QUFDckIscUJBQUt3QixPQUFMLENBQWEsSUFBYixFQUFtQixJQUFuQixFQUF5QkgsTUFBekIsRUFBaUNyQixLQUFqQztBQUNBLFdBQUtOLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7O3dCQWpLYztBQUFFLGFBQU8sQ0FBUDtBQUFXOzs7d0JBQ2Y7QUFBRSxhQUFPLEtBQUssQ0FBTCxDQUFQO0FBQWlCLEs7c0JBQzFCK0IsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLENBQUwsSUFBVSx5QkFBWUEsS0FBWixDQUFqQjtBQUFzQzs7O3dCQUN4QztBQUFFLGFBQU8sS0FBSyxDQUFMLENBQVA7QUFBaUIsSztzQkFDMUJBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozt3QkFDeEM7QUFBRSxhQUFPLEtBQUssQ0FBTCxDQUFQO0FBQWlCLEs7c0JBQzFCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssQ0FBTCxJQUFVLHlCQUFZQSxLQUFaLENBQWpCO0FBQXNDOzs7d0JBQ3hDO0FBQUUsYUFBTyxLQUFLLENBQUwsQ0FBUDtBQUFpQixLO3NCQUMxQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLENBQUwsSUFBVSx5QkFBWUEsS0FBWixDQUFqQjtBQUFzQzs7Ozs7O2tCQW5DbEMxQyxPIiwiZmlsZSI6InZlY3RvcjQuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgTWF0aEFycmF5IGZyb20gJy4vbWF0aC1hcnJheSc7XG5pbXBvcnQge2NoZWNrTnVtYmVyfSBmcm9tICcuL2NvbW1vbic7XG5pbXBvcnQge3ZlYzR9IGZyb20gJ2dsLW1hdHJpeCc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFZlY3RvcjQgZXh0ZW5kcyBNYXRoQXJyYXkge1xuICAvLyBDcmVhdGVzIGEgbmV3LCBlbXB0eSB2ZWM0XG4gIGNvbnN0cnVjdG9yKHggPSAwLCB5ID0gMCwgeiA9IDAsIHcgPSAwKSB7XG4gICAgc3VwZXIoKTtcbiAgICBpZiAoQXJyYXkuaXNBcnJheSh4KSAmJiBhcmd1bWVudHMubGVuZ3RoID09PSAxKSB7XG4gICAgICB0aGlzLmNvcHkoeCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuc2V0KHgsIHksIHosIHcpO1xuICAgIH1cbiAgfVxuXG4gIHNldCh4LCB5LCB6LCB3KSB7XG4gICAgdmVjNC5zZXQodGhpcywgeCwgeSwgeiwgdyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgZXF1YWxzKHZlY3Rvcikge1xuICAgIHJldHVybiB2ZWM0LmVxdWFscyh0aGlzLCB2ZWN0b3IpO1xuICB9XG5cbiAgZXhhY3RFcXVhbHModmVjdG9yKSB7XG4gICAgcmV0dXJuIHZlYzQuZXhhY3RFcXVhbHModGhpcywgdmVjdG9yKTtcbiAgfVxuXG4gIC8vIEdldHRlcnMvc2V0dGVyc1xuICAvKiBlc2xpbnQtZGlzYWJsZSBuby1tdWx0aS1zcGFjZXMsIGJyYWNlLXN0eWxlLCBuby1yZXR1cm4tYXNzaWduICovXG4gIGdldCBFTEVNRU5UUygpIHsgcmV0dXJuIDQ7IH1cbiAgZ2V0IHgoKSAgICAgIHsgcmV0dXJuIHRoaXNbMF07IH1cbiAgc2V0IHgodmFsdWUpIHsgcmV0dXJuIHRoaXNbMF0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IHkoKSAgICAgIHsgcmV0dXJuIHRoaXNbMV07IH1cbiAgc2V0IHkodmFsdWUpIHsgcmV0dXJuIHRoaXNbMV0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IHooKSAgICAgIHsgcmV0dXJuIHRoaXNbMl07IH1cbiAgc2V0IHoodmFsdWUpIHsgcmV0dXJuIHRoaXNbMl0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IHcoKSAgICAgIHsgcmV0dXJuIHRoaXNbM107IH1cbiAgc2V0IHcodmFsdWUpIHsgcmV0dXJuIHRoaXNbM10gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgLyogZXNsaW50LWVuYWJsZSBuby1tdWx0aS1zcGFjZXMsIGJyYWNlLXN0eWxlLCBuby1yZXR1cm4tYXNzaWduICovXG5cbiAgZGlzdGFuY2UodmVjdG9yKSB7XG4gICAgcmV0dXJuIHZlYzQuZGlzdGFuY2UodmVjdG9yKTtcbiAgfVxuXG4gIGRpc3QodmVjdG9yKSB7XG4gICAgcmV0dXJuIHZlYzQuZGlzdCh2ZWN0b3IpO1xuICB9XG5cbiAgYW5nbGUodmVjdG9yKSB7XG4gICAgcmV0dXJuIHZlYzQuYW5nbGUodmVjdG9yKTtcbiAgfVxuXG4gIGFkZCguLi52ZWN0b3JzKSB7XG4gICAgZm9yIChjb25zdCB2ZWN0b3Igb2YgdmVjdG9ycykge1xuICAgICAgdmVjNC5hZGQodGhpcywgdmVjdG9yKTtcbiAgICB9XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgc3VidHJhY3QoLi4udmVjdG9ycykge1xuICAgIGZvciAoY29uc3QgdmVjdG9yIG9mIHZlY3RvcnMpIHtcbiAgICAgIHZlYzQuc3VidHJhY3QodGhpcywgdmVjdG9yKTtcbiAgICB9XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgbXVsdGlwbHkoLi4udmVjdG9ycykge1xuICAgIGZvciAoY29uc3QgdmVjdG9yIG9mIHZlY3RvcnMpIHtcbiAgICAgIHZlYzQubXVsdGlwbHkodGhpcywgdmVjdG9yKTtcbiAgICB9XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgZGl2aWRlKC4uLnZlY3RvcnMpIHtcbiAgICBmb3IgKGNvbnN0IHZlY3RvciBvZiB2ZWN0b3JzKSB7XG4gICAgICB2ZWM0LmRpdmlkZSh0aGlzLCB2ZWN0b3IpO1xuICAgIH1cbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBjZWlsKCkge1xuICAgIHZlYzQuY2VpbCh0aGlzLCB0aGlzKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBmbG9vcigpIHtcbiAgICB2ZWM0LmZsb29yKHRoaXMsIHRoaXMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIG1pbigpIHtcbiAgICB2ZWM0Lm1pbih0aGlzLCB0aGlzKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBtYXgoKSB7XG4gICAgdmVjNC5tYXgodGhpcywgdGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgc2NhbGUoc2NhbGUpIHtcbiAgICB2ZWM0LnNjYWxlKHRoaXMsIHRoaXMsIHNjYWxlKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBzY2FsZUFuZEFkZCh2ZWN0b3IsIHNjYWxlKSB7XG4gICAgdmVjNC5zY2FsZUFuZEFkZCh0aGlzLCB0aGlzLCB2ZWN0b3IsIHNjYWxlKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBuZWdhdGUoKSB7XG4gICAgdmVjNC5uZWdhdGUodGhpcywgdGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgaW52ZXJzZSgpIHtcbiAgICB2ZWM0LmludmVyc2UodGhpcywgdGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgbm9ybWFsaXplKCkge1xuICAgIHZlYzQubm9ybWFsaXplKHRoaXMsIHRoaXMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGRvdChzY2FsZSkge1xuICAgIHZlYzQuZG90KHRoaXMsIHRoaXMsIHNjYWxlKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBjcm9zcyhzY2FsZSkge1xuICAgIHZlYzQuY3Jvc3ModGhpcywgdGhpcywgc2NhbGUpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGxlcnAoc2NhbGUpIHtcbiAgICB2ZWM0LmxlcnAodGhpcywgdGhpcywgc2NhbGUpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGhlcm1pdGUoc2NhbGUpIHtcbiAgICB2ZWM0Lmhlcm1pdGUodGhpcywgdGhpcywgc2NhbGUpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGJlemllcihzY2FsZSkge1xuICAgIHZlYzQuYmV6aWVyKHRoaXMsIHRoaXMsIHNjYWxlKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICByYW5kb20oc2NhbGUpIHtcbiAgICB2ZWM0LnJhbmRvbSh0aGlzLCB0aGlzLCBzY2FsZSk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgcm90YXRlWChvcmlnaW4sIGFuZ2xlKSB7XG4gICAgdmVjNC5yb3RhdGVYKHRoaXMsIHRoaXMsIG9yaWdpbiwgYW5nbGUpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHJvdGF0ZVkob3JpZ2luLCBhbmdsZSkge1xuICAgIHZlYzQucm90YXRlWSh0aGlzLCB0aGlzLCBvcmlnaW4sIGFuZ2xlKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICByb3RhdGVaKG9yaWdpbiwgYW5nbGUpIHtcbiAgICB2ZWM0LnJvdGF0ZVoodGhpcywgdGhpcywgb3JpZ2luLCBhbmdsZSk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG4iXX0=