/* eslint-disable no-console */
/* global console */
var cache = {};

var _log = {
  priority: 0,
  table: function table(priority, _table) {
    if (priority <= _log.priority && _table) {
      console.table(_table);
    }
  },
  log: function log(priority) {
    if (priority <= _log.priority) {
      var _console;

      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      (_console = console).debug.apply(_console, args);
    }
  },
  info: function info(priority) {
    if (priority <= _log.priority) {
      var _console2;

      for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      (_console2 = console).log.apply(_console2, args);
    }
  },
  warn: function warn(priority) {
    if (priority <= _log.priority) {
      var _console3;

      for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
        args[_key3 - 1] = arguments[_key3];
      }

      (_console3 = console).warn.apply(_console3, args);
    }
  },
  once: function once(priority, arg) {
    if (!cache[arg]) {
      for (var _len4 = arguments.length, args = Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
        args[_key4 - 2] = arguments[_key4];
      }

      _log.log.apply(_log, [priority, arg].concat(args));
    }
    cache[arg] = true;
  }
};

function formatArrayValue(v, opts) {
  var _opts$maxElts = opts.maxElts,
      maxElts = _opts$maxElts === undefined ? 16 : _opts$maxElts,
      _opts$size = opts.size,
      size = _opts$size === undefined ? 1 : _opts$size;

  var string = '[';
  for (var i = 0; i < v.length && i < maxElts; ++i) {
    if (i > 0) {
      string += ',' + (i % size === 0 ? ' ' : '');
    }
    string += formatValue(v[i], opts);
  }
  var terminator = v.length > maxElts ? '...' : ']';
  return '' + string + terminator;
}

export function formatValue(v) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _opts$isInteger = opts.isInteger,
      isInteger = _opts$isInteger === undefined ? false : _opts$isInteger;

  if (Array.isArray(v) || ArrayBuffer.isView(v)) {
    return formatArrayValue(v, opts);
  }
  if (!Number.isFinite(v)) {
    return String(v);
  }
  if (isInteger) {
    return v.toFixed(0);
  }
  if (Math.abs(v) > 100 && Math.abs(v) < 10000) {
    return v.toFixed(0);
  }
  var string = v.toPrecision(2);
  var decimal = string.indexOf('.0');
  return decimal === string.length - 2 ? string.slice(0, -1) : string;
}

export default _log;
//# sourceMappingURL=data:application/json;base64,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