var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { GL, WebGLBuffer, glTypeFromArray } from './webgl';
import { assertWebGLContext, assertWebGL2Context, assertArrayTypeMatch } from './webgl-checks';
import assert from 'assert';

export var BufferLayout =
/**
 * @classdesc
 * Store characteristics of a data layout
 * This data can be used when updating vertex attributes with
 * the associated buffer, freeing the application from keeping
 * track of this metadata.
 *
 * @class
 * @param {GLuint} size - number of values per element (1-4)
 * @param {GLuint} type - type of values (e.g. gl.FLOAT)
 * @param {GLbool} normalized=false - normalize integers to [-1,1] or [0,1]
 * @param {GLuint} integer=false - WebGL2 only, int-to-float conversion
 * @param {GLuint} stride=0 - supports strided arrays
 * @param {GLuint} offset=0 - supports strided arrays
 */
function BufferLayout() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      type = _ref.type,
      _ref$size = _ref.size,
      size = _ref$size === undefined ? 1 : _ref$size,
      _ref$offset = _ref.offset,
      offset = _ref$offset === undefined ? 0 : _ref$offset,
      _ref$stride = _ref.stride,
      stride = _ref$stride === undefined ? 0 : _ref$stride,
      _ref$normalized = _ref.normalized,
      normalized = _ref$normalized === undefined ? false : _ref$normalized,
      _ref$integer = _ref.integer,
      integer = _ref$integer === undefined ? false : _ref$integer,
      _ref$instanced = _ref.instanced,
      instanced = _ref$instanced === undefined ? 0 : _ref$instanced;

  _classCallCheck(this, BufferLayout);

  this.type = type;
  this.size = size;
  this.offset = offset;
  this.stride = stride;
  this.normalized = normalized;
  this.integer = integer;
  this.instanced = instanced;
};

// Encapsulates a WebGLBuffer object

var Buffer = function () {
  _createClass(Buffer, null, [{
    key: 'makeFrom',


    /**
     * Returns a Buffer wrapped WebGLBuffer from a variety of inputs.
     * Allows other functions to transparently accept raw WebGLBuffers etc
     * and manipulate them using the methods in the `Buffer` class.
     * Checks for ".handle" (allows use of stack.gl's gl-buffer)
     *
     * @param {WebGLRenderingContext} gl - if a new buffer needs to be initialized
     * @param {*} object - candidate that will be coerced to a buffer
     * @returns {Buffer} - Buffer object that wraps the buffer parameter
     */
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Buffer ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Buffer(gl).setData({ handle: object.handle || object });
    }

    /*
     * @classdesc
     * Can be used to store vertex data, pixel data retrieved from images
     * or the framebuffer, and a variety of other things.
     *
     * Mainly used for uploading VertexAttributes to GPU
     * Setting data on a buffers (arrays) uploads it to the GPU.
     *
     * Holds an attribute name as a convenience
     * setData - Initializes size of buffer and sets
     *
     * @param {WebGLRenderingContext} gl - gl context
     * @param {string} opt.id - id for debugging
     */

  }]);

  function Buffer() {
    var gl = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        id = _ref2.id,
        handle = _ref2.handle;

    _classCallCheck(this, Buffer);

    assertWebGLContext(gl);

    handle = handle || gl.createBuffer();
    if (!(handle instanceof WebGLBuffer)) {
      throw new Error('Failed to create WebGLBuffer');
    }

    this.gl = gl;
    this.handle = handle;
    this.id = id;
    this.bytes = undefined;
    this.data = null;
    this.target = GL.ARRAY_BUFFER;
    this.layout = null;

    this.userData = {};
    Object.seal(this);
  }

  _createClass(Buffer, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      if (this.handle) {
        gl.deleteBuffer(this.handle);
        this.handle = null;
      }
      return this;
    }

    /**
     * Creates and initializes the buffer object's data store.
     *
     * @param {ArrayBufferView} opt.data - contents
     * @param {GLsizeiptr} opt.bytes - the size of the buffer object's data store.
     * @param {GLenum} opt.usage=gl.STATIC_DRAW - Allocation hint for GPU driver
     *
     * Characteristics of stored data, hints for vertex attribute
     *
     * @param {GLenum} opt.dataType=gl.FLOAT - type of data stored in buffer
     * @param {GLuint} opt.size=1 - number of values per vertex
     * @returns {Buffer} Returns itself for chaining.
     */

  }, {
    key: 'setData',
    value: function setData() {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          data = _ref3.data,
          bytes = _ref3.bytes,
          _ref3$target = _ref3.target,
          target = _ref3$target === undefined ? GL.ARRAY_BUFFER : _ref3$target,
          _ref3$usage = _ref3.usage,
          usage = _ref3$usage === undefined ? GL.STATIC_DRAW : _ref3$usage,
          layout = _ref3.layout,
          type = _ref3.type,
          _ref3$size = _ref3.size,
          size = _ref3$size === undefined ? 1 : _ref3$size,
          _ref3$offset = _ref3.offset,
          offset = _ref3$offset === undefined ? 0 : _ref3$offset,
          _ref3$stride = _ref3.stride,
          stride = _ref3$stride === undefined ? 0 : _ref3$stride,
          _ref3$normalized = _ref3.normalized,
          normalized = _ref3$normalized === undefined ? false : _ref3$normalized,
          _ref3$integer = _ref3.integer,
          integer = _ref3$integer === undefined ? false : _ref3$integer,
          _ref3$instanced = _ref3.instanced,
          instanced = _ref3$instanced === undefined ? 0 : _ref3$instanced;

      var gl = this.gl;

      assert(data || bytes >= 0, 'Buffer.setData needs data or bytes');
      type = type || glTypeFromArray(data);

      if (data) {
        assertArrayTypeMatch(data, type, 'in Buffer.setData');
      }

      this.bytes = bytes;
      this.data = data;
      this.target = target;
      this.layout = layout || new BufferLayout({
        type: type,
        size: size,
        offset: offset,
        stride: stride,
        normalized: normalized,
        integer: integer,
        instanced: instanced
      });

      // Note: When we are just creating and/or filling the buffer with data,
      // the target we use doesn't technically matter, so use ARRAY_BUFFER
      // https://www.opengl.org/wiki/Buffer_Object
      this.bind({ target: target });
      gl.bufferData(target, data || bytes, usage);
      this.unbind({ target: target });

      return this;
    }

    /**
     * Updates a subset of a buffer object's data store.
     * @param {ArrayBufferView} opt.data - contents
     * @returns {Buffer} Returns itself for chaining.
     */

  }, {
    key: 'subData',
    value: function subData() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          data = _ref4.data,
          _ref4$offset = _ref4.offset,
          offset = _ref4$offset === undefined ? 0 : _ref4$offset;

      var gl = this.gl;

      assert(data, 'Buffer.updateData needs data');

      // Note: When we are just creating and/or filling the buffer with data,
      // the target we use doesn't technically matter, so use ARRAY_BUFFER
      // https://www.opengl.org/wiki/Buffer_Object
      this.bind({ target: GL.ARRAY_BUFFER });
      gl.bufferSubData(GL.ARRAY_BUFFER, offset, data);
      this.unbind({ target: GL.ARRAY_BUFFER });

      return this;
    }

    /**
     * Binds a buffer to a given binding point (target).
     *
     * @param {Glenum} target - target for the bind operation.
     *  Possible values: gl.TRANSFORM_FEEDBACK_BUFFER and gl.UNIFORM_BUFFER
     * @param {GLuint} index - the index of the target.
     * @returns {Buffer} - Returns itself for chaining.
     */

  }, {
    key: 'bind',
    value: function bind() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref5$target = _ref5.target,
          target = _ref5$target === undefined ? this.target : _ref5$target;

      this.gl.bindBuffer(target, this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref6$target = _ref6.target,
          target = _ref6$target === undefined ? this.target : _ref6$target;

      // this.gl.bindBuffer(target, null);
      return this;
    }

    /**
     * Note: WEBGL2
     * Binds a buffer to a given binding point (target) at a given index.
     *
     * @param {Glenum} target - target for the bind operation.
     *  Possible values: gl.TRANSFORM_FEEDBACK_BUFFER and gl.UNIFORM_BUFFER
     * @param {GLuint} index - the index of the target.
     * @returns {Buffer} - Returns itself for chaining.
     */

  }, {
    key: 'bindBase',
    value: function bindBase() {
      var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref7$target = _ref7.target,
          target = _ref7$target === undefined ? this.target : _ref7$target,
          index = _ref7.index;

      assertWebGL2Context(this.gl);
      this.gl.bindBufferBase(target, index, this.handle);
      return this;
    }
  }, {
    key: 'unbindBase',
    value: function unbindBase() {
      var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref8$target = _ref8.target,
          target = _ref8$target === undefined ? this.target : _ref8$target,
          index = _ref8.index;

      assertWebGL2Context(this.gl);
      this.gl.bindBufferBase(target, index, null);
      return this;
    }

    /**
     * Note: WEBGL2
     * binds a range of a given WebGLBuffer to a given binding point (target)
     * at a given index.
     *
     * @param {Glenum} target - target for the bind operation.
     *  Possible values: gl.TRANSFORM_FEEDBACK_BUFFER and gl.UNIFORM_BUFFER
     * @param {GLuint} index - the index of the target.
     * @returns {Buffer} - Returns itself for chaining.
     */

  }, {
    key: 'bindRange',
    value: function bindRange() {
      var _ref9 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref9$target = _ref9.target,
          target = _ref9$target === undefined ? this.target : _ref9$target,
          index = _ref9.index,
          _ref9$offset = _ref9.offset,
          offset = _ref9$offset === undefined ? 0 : _ref9$offset,
          size = _ref9.size;

      assertWebGL2Context(this.gl);
      this.gl.bindBufferRange(target, index, this.handle, offset, size);
      return this;
    }
  }, {
    key: 'unbindRange',
    value: function unbindRange() {
      var _ref10 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref10$target = _ref10.target,
          target = _ref10$target === undefined ? this.target : _ref10$target,
          index = _ref10.index;

      assertWebGL2Context(this.gl);
      this.gl.bindBufferBase(target, index, null);
      return this;
    }
  }]);

  return Buffer;
}();

export { Buffer as default };
//# sourceMappingURL=data:application/json;base64,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