/* eslint-disable */
// TODO - generic draw call
// One of the good things about GL is that there are so many ways to draw things
import { getExtension } from './context';
import { GL, glGet } from './webgl';
import { assertWebGLContext, assertDrawMode, assertIndexType, isWebGL2Context } from './webgl-checks';
import assert from 'assert';

// A good thing about webGL is that there are so many ways to draw things,
// e.g. depending on whether data is indexed and/or isInstanced.
// This function unifies those into a single call with simple parameters
// that have sane defaults.
export function draw(gl, _ref) {
  var _ref$drawMode = _ref.drawMode,
      drawMode = _ref$drawMode === undefined ? GL.TRIANGLES : _ref$drawMode,
      vertexCount = _ref.vertexCount,
      _ref$offset = _ref.offset,
      offset = _ref$offset === undefined ? 0 : _ref$offset,
      _ref$isIndexed = _ref.isIndexed,
      isIndexed = _ref$isIndexed === undefined ? false : _ref$isIndexed,
      _ref$indexType = _ref.indexType,
      indexType = _ref$indexType === undefined ? GL.UNSIGNED_SHORT : _ref$indexType,
      _ref$isInstanced = _ref.isInstanced,
      isInstanced = _ref$isInstanced === undefined ? false : _ref$isInstanced,
      _ref$instanceCount = _ref.instanceCount,
      instanceCount = _ref$instanceCount === undefined ? 0 : _ref$instanceCount;

  assertWebGLContext(gl);

  drawMode = glGet(drawMode);
  indexType = glGet(indexType);

  assertDrawMode(drawMode, 'in draw');
  if (isIndexed) {
    assertIndexType(indexType, 'in draw');
  }

  // TODO - Use polyfilled WebGL2RenderingContext instead of ANGLE extension
  if (isInstanced) {
    var webgl2 = isWebGL2Context(gl);
    var extension = gl.getExtension('ANGLE_instanced_arrays');
    var context = webgl2 ? gl : extension;
    var suffix = webgl2 ? '' : 'ANGLE';
    var drawElements = 'drawElementsInstanced' + suffix;
    var drawArrays = 'drawArraysInstanced' + suffix;

    if (isIndexed) {
      context[drawElements](drawMode, vertexCount, indexType, offset, instanceCount);
    } else {
      context[drawArrays](drawMode, offset, vertexCount, instanceCount);
    }
  } else if (isIndexed) {
    gl.drawElements(drawMode, vertexCount, indexType, offset);
  } else {
    gl.drawArrays(drawMode, offset, vertexCount);
  }
}
//# sourceMappingURL=data:application/json;base64,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