var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _ERR_FRAMEBUFFER;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable */
import { GL, glGet, glArrayFromType, glTypeFromArray } from './webgl-types';
import { assertWebGLContext, assertWebGL2Context } from './webgl-checks';
import { Texture2D } from './texture';
import Renderbuffer from './renderbuffer';

/* eslint-disable max-len, no-multi-str */
var ERR_FRAMEBUFFER = (_ERR_FRAMEBUFFER = {}, _defineProperty(_ERR_FRAMEBUFFER, GL.FRAMEBUFFER_COMPLETE, 'Success. Framebuffer is correctly set up'), _defineProperty(_ERR_FRAMEBUFFER, GL.FRAMEBUFFER_INCOMPLETE_ATTACHMENT, 'The attachment types are mismatched or not all framebuffer attachment \
points are framebuffer attachment complete.'), _defineProperty(_ERR_FRAMEBUFFER, GL.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT, 'There is no attachment.'), _defineProperty(_ERR_FRAMEBUFFER, GL.FRAMEBUFFER_INCOMPLETE_DIMENSIONS, 'Height and width of the attachment are not the same.'), _defineProperty(_ERR_FRAMEBUFFER, GL.FRAMEBUFFER_UNSUPPORTED, 'The format of the attachment is not supported or if depth and stencil \
attachments are not the same renderbuffer.'), _defineProperty(_ERR_FRAMEBUFFER, GL.FRAMEBUFFER_INCOMPLETE_MULTISAMPLE, 'The values of GL.RENDERBUFFER_SAMPLES are different among attached \
renderbuffers, or are non-zero if the attached images are a mix of \
renderbuffers and textures.'), _ERR_FRAMEBUFFER);
/* eslint-enable max-len */

function getFrameBufferStatus(status) {
  return ERR_FRAMEBUFFER[status] || 'Framebuffer error ' + status;
}

function glFormatComponents(format) {
  switch (format) {
    case GL.ALPHA:
      return 1;
    case GL.RGB:
      return 3;
    case GL.RGBA:
      return 4;
    default:
      throw new Error('Unknown format');
  }
}

var Framebuffer = function () {
  _createClass(Framebuffer, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Framebuffer ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Framebuffer(gl, { handle: object.handle || object });
    }
  }]);

  function Framebuffer(gl) {
    _classCallCheck(this, Framebuffer);

    assertWebGLContext(gl);

    this.gl = gl;
    this.handle = gl.createFramebuffer();
    if (!this.handle) {
      throw new Error('Failed to create WebGL Framebuffer');
    }
  }

  _createClass(Framebuffer, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      gl.deleteFramebuffer(this.handle);
    }

    // SIMPLIFIED INTERFACE

    // WEBGL INTERFACE

  }, {
    key: 'bind',
    value: function bind() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$target = _ref.target,
          target = _ref$target === undefined ? GL.FRAMEBUFFER : _ref$target;

      var gl = this.gl;

      gl.bindFramebuffer(glGet(target), this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$target = _ref2.target,
          target = _ref2$target === undefined ? GL.FRAMEBUFFER : _ref2$target;

      var gl = this.gl;

      gl.bindFramebuffer(glGet(target), null);
      return this;
    }

    // TODO - move out of renderbuffer since it should also work on draw buffer?
    //
    // NOTE: Slow requires roundtrip to GPU
    // App can provide pixelArray or have it auto allocated by this method
    // @returns {Uint8Array|Uint16Array|FloatArray} - pixel array,
    //  newly allocated by this method unless provided by app.

  }, {
    key: 'readPixels',
    value: function readPixels(_ref3) {
      var _ref3$x = _ref3.x,
          x = _ref3$x === undefined ? 0 : _ref3$x,
          _ref3$y = _ref3.y,
          y = _ref3$y === undefined ? 0 : _ref3$y,
          width = _ref3.width,
          height = _ref3.height,
          _ref3$format = _ref3.format,
          format = _ref3$format === undefined ? GL.RGBA : _ref3$format,
          type = _ref3.type,
          _ref3$pixelArray = _ref3.pixelArray,
          pixelArray = _ref3$pixelArray === undefined ? null : _ref3$pixelArray;
      var gl = this.gl;

      // Deduce type and allocated pixelArray if needed

      if (!pixelArray) {
        // Allocate pixel array if not already available, using supplied type
        type = type || GL.UNSIGNED_BYTE;
        var ArrayType = glArrayFromType(type);
        var components = glFormatComponents(format);
        // TODO - check for composite type (components = 1).
        pixelArray = pixelArray || new ArrayType(width * height * components);
      }

      // Pixel array available, if necessary, deduce type from it.
      type = type || glTypeFromArray(pixelArray);

      this.bind();
      gl.readPixels(x, y, width, height, format, type, pixelArray);
      this.unbind();

      return pixelArray;
    }

    /**
     * Used to attach textures to a framebuffer, the textures will store
     * the various buffers.
     *
     *  The set of available attachments is larger in WebGL2, and also the
     *  extensions WEBGL_draw_buffers and WEBGL_depth_texture provide additional
     *  attachments that match or exceed the WebGL2 set.
     *
     * @param {Texture2D|TextureCube|WebGLTexture|null} opt.texture=null -
     *    default is null which unbinds the texture for the attachment
     * @param {String|Number} opt.attachment= - which attachment to bind
     *    defaults to gl.COLOR_ATTACHMENT0.
     * @param {String|Number} opt.target= - bind point, normally gl.FRAMEBUFFER
     *    (WebGL2 support separating bet)
     * @param {String|Number} opt.textureTarget= - can be used to specify
     *    faces of a cube map.
     * @returns {FrameBuffer} returns itself to enable chaining
     */

  }, {
    key: 'attachTexture',
    value: function attachTexture() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$texture = _ref4.texture,
          texture = _ref4$texture === undefined ? null : _ref4$texture,
          _ref4$target = _ref4.target,
          target = _ref4$target === undefined ? GL.FRAMEBUFFER : _ref4$target,
          _ref4$attachment = _ref4.attachment,
          attachment = _ref4$attachment === undefined ? GL.COLOR_ATTACHMENT0 : _ref4$attachment,
          _ref4$textureTarget = _ref4.textureTarget,
          textureTarget = _ref4$textureTarget === undefined ? GL.TEXTURE_2D : _ref4$textureTarget,
          _ref4$mipmapLevel = _ref4.mipmapLevel,
          mipmapLevel = _ref4$mipmapLevel === undefined ? 0 : _ref4$mipmapLevel;

      var gl = this.gl;


      texture = texture && Texture2D.makeFrom(gl, texture);

      this.bind({ target: target });

      gl.framebufferTexture2D(glGet(target), glGet(attachment), glGet(textureTarget), texture.handle, mipmapLevel);

      this.unbind();
      return this;
    }

    /**
     * Used to attach a renderbuffer to a framebuffer, the renderbuffer will
     * store the various buffers.
     * @param {Object} opts= - named parameters
     * @param {RenderBuffer|WebGLRenderBuffer|null} opts.renderbuffer=null -
     *    renderbuffer to bind
     *    default is null which unbinds the renderbuffer for the attachment
     * @param {String|Number} opts.attachment= - which buffer to bind
     * @returns {FrameBuffer} returns itself to enable chaining
     */

  }, {
    key: 'attachRenderbuffer',
    value: function attachRenderbuffer() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref5$renderbuffer = _ref5.renderbuffer,
          renderbuffer = _ref5$renderbuffer === undefined ? null : _ref5$renderbuffer,
          _ref5$attachment = _ref5.attachment,
          attachment = _ref5$attachment === undefined ? GL.COLOR_ATTACHMENT0 : _ref5$attachment,
          _ref5$target = _ref5.target,
          target = _ref5$target === undefined ? GL.FRAMEBUFFER : _ref5$target,
          _ref5$renderbufferTar = _ref5.renderbufferTarget,
          renderbufferTarget = _ref5$renderbufferTar === undefined ? GL.RENDERBUFFER : _ref5$renderbufferTar;

      var gl = this.gl;

      renderbuffer = renderbuffer && Renderbuffer.makeFrom(gl, renderbuffer);

      this.bind({ target: target });

      gl.framebufferRenderbuffer(glGet(target), glGet(attachment), glGet(renderbufferTarget), renderbuffer.handle);

      this.unbind({ target: target });

      return this;
    }
  }, {
    key: 'checkStatus',
    value: function checkStatus() {
      var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref6$target = _ref6.target,
          target = _ref6$target === undefined ? GL.FRAMEBUFFER : _ref6$target;

      var gl = this.gl;


      this.bind({ target: target });

      var status = gl.checkFramebufferStatus(glGet(target));

      this.unbind({ target: target });

      if (status !== gl.FRAMEBUFFER_COMPLETE) {
        throw new Error(getFrameBufferStatus(status));
      }

      return this;
    }

    // WEBGL2 INTERFACE

  }, {
    key: 'blit',
    value: function blit(_ref7) {
      var srcX0 = _ref7.srcX0,
          srcY0 = _ref7.srcY0,
          srcX1 = _ref7.srcX1,
          srcY1 = _ref7.srcY1,
          dstX0 = _ref7.dstX0,
          dstY0 = _ref7.dstY0,
          dstX1 = _ref7.dstX1,
          dstY1 = _ref7.dstY1,
          mask = _ref7.mask,
          _ref7$filter = _ref7.filter,
          filter = _ref7$filter === undefined ? GL.NEAREST : _ref7$filter;
      var gl = this.gl;

      assertWebGL2Context(gl);
      gl.blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
      return this;
    }
  }, {
    key: 'textureLayer',
    value: function textureLayer() {
      var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref8$target = _ref8.target,
          target = _ref8$target === undefined ? GL.FRAMEBUFFER : _ref8$target,
          attachment = _ref8.attachment,
          texture = _ref8.texture,
          level = _ref8.level,
          layer = _ref8.layer;

      var gl = this.gl;

      assertWebGL2Context(gl);
      gl.framebufferTextureLayer(target, attachment, texture, level, layer);
      return this;
    }
  }, {
    key: 'invalidate',
    value: function invalidate(_ref9) {
      var _ref9$target = _ref9.target,
          target = _ref9$target === undefined ? GL.FRAMEBUFFER : _ref9$target,
          _ref9$attachments = _ref9.attachments,
          attachments = _ref9$attachments === undefined ? [] : _ref9$attachments;
      var gl = this.gl;

      assertWebGL2Context(gl);
      gl.invalidateFramebuffer(target, attachments);
      return this;
    }
  }, {
    key: 'invalidateSub',
    value: function invalidateSub(_ref10) {
      var _ref10$target = _ref10.target,
          target = _ref10$target === undefined ? GL.FRAMEBUFFER : _ref10$target,
          _ref10$attachments = _ref10.attachments,
          attachments = _ref10$attachments === undefined ? [] : _ref10$attachments,
          _ref10$x = _ref10.x,
          x = _ref10$x === undefined ? 0 : _ref10$x,
          _ref10$y = _ref10.y,
          y = _ref10$y === undefined ? 0 : _ref10$y,
          width = _ref10.width,
          height = _ref10.height;
      var gl = this.gl;

      assertWebGL2Context(gl);
      gl.invalidateFramebuffer(target, attachments, x, y, width, height);
      return this;
    }

    // Selects a color buffer as the source for pixels for subsequent calls to
    // copyTexImage2D, copyTexSubImage2D, copyTexSubImage3D or readPixels.
    // src
    //  gl.BACK: Reads from the back color buffer.
    //  gl.NONE: Reads from no color buffer.
    //  gl.COLOR_ATTACHMENT{0-15}: Reads from one of 16 color attachment buffers.

  }, {
    key: 'readBuffer',
    value: function readBuffer(_ref11) {
      var src = _ref11.src;
      var gl = this.gl;

      assertWebGL2Context(gl);
      gl.readBuffer(src);
      return this;
    }

    // @returns {GLint}

  }, {
    key: 'alphaSize',
    value: function alphaSize() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'blueSize',
    value: function blueSize() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE);
    }

    // @returns {GLenum}

  }, {
    key: 'colorEncoding',
    value: function colorEncoding() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING);
    }

    // @returns {GLenum}

  }, {
    key: 'componentType',
    value: function componentType() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE);
    }

    // @returns {GLint}

  }, {
    key: 'depthSize',
    value: function depthSize() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'greenSize',
    value: function greenSize() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE);
    }

    // @returns {WebGLRenderbuffer|WebGLTexture}

  }, {
    key: 'objectName',
    value: function objectName() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME);
    }

    // @returns {GLenum}

  }, {
    key: 'objectType',
    value: function objectType() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE);
    }

    // @returns {GLint}

  }, {
    key: 'redSize',
    value: function redSize() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_RED_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'stencilSize',
    value: function stencilSize() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'cubeMapFace',
    value: function cubeMapFace() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE);
    }

    // @returns {GLint}

  }, {
    key: 'layer',
    value: function layer() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER);
    }

    // @returns {GLint}

  }, {
    key: 'level',
    value: function level() {
      return this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL);
    }
  }, {
    key: 'getParameters',
    value: function getParameters() {
      return {
        alphaSize: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE),
        blueSize: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE),
        colorEncoding: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING),
        componentType: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE),
        depthSize: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE),
        greenSize: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE),
        objectName: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME),
        objectType: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE),
        redSize: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_RED_SIZE),
        stencilSize: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE),
        cubeMapFace: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE),
        layer: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER),
        level: this.getAttachmentParameter(GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL)
      };
    }

    // (OpenGL ES 3.0.4 §6.1.13, similar to glGetFramebufferAttachmentParameteriv)
    // Return the value for the passed pname given the target and attachment.
    // The type returned is the natural type for the requested pname:
    // pname returned type
    // FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_BLUE_SIZE  GLint
    // FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING GLenum
    // FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE GLenum
    // FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_GREEN_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_OBJECT_NAME  WebGLRenderbuffer or WebGLTexture
    // FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE  GLenum
    // FRAMEBUFFER_ATTACHMENT_RED_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE  GLint
    // FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER  GLint
    // FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL  GLint
    // If pname is not in the table above, generates an INVALID_ENUM error.
    // If an OpenGL error is generated, returns null.

  }, {
    key: 'getAttachmentParameter',
    value: function getAttachmentParameter() {
      var _ref12 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          pname = _ref12.pname,
          target = _ref12.target,
          attachment = _ref12.attachment;

      var gl = this.gl;

      assertWebGL2Context(gl);
      var value = gl.getFramebufferAttachmentParameter(target, attachment, pname);
      return value;
    }
  }]);

  return Framebuffer;
}();

export { Framebuffer as default };
//# sourceMappingURL=data:application/json;base64,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