var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ERR_DELETED = 'Query was deleted before result was available';
var ERR_CANCEL = 'Query was canceled before result was available';

var noop = function noop(x) {
  return x;
};

var QueryManager = function () {

  /**
   * Internal class that helps "asynchronous WebGL query objects" manage
   * pending requests (e.g. for EXT_disjoint_timer_query and WebGL2 queries)
   *
   * Creates and manages promises for the queries.
   * Tracks pending queries enabling polling.
   * Tracks pending queries enabling invalidation.
   * Encapsulates some standard error messages.
   *
   * Remarks:
   * - Maintains a minimal list of pending queries only to minimize GC impact
   * - Exported as a singleton class instance.
   */
  function QueryManager() {
    _classCallCheck(this, QueryManager);

    this.pendingQueries = new Set();
    this.invalidQueryType = null;
    this.invalidErrorMessage = '';
    this.checkInvalid = function () {
      return false;
    };
  }

  // API THAT SHOULD BE EXPOSED TO APPLICATION

  // Checks invalidation callback and then all pending queries for completion
  // Should only be called once per tick


  _createClass(QueryManager, [{
    key: 'poll',
    value: function poll(gl) {
      this.cancelInvalidQueries(gl);

      // Now check availability of results and resolve promises as appropriate
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.pendingQueries.values()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var query = _step.value;

          var resultAvailable = query.isResultAvailable();
          if (resultAvailable) {
            var result = query.getResult();
            this.resolveQuery(query, result);
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }

    // API FOR MANAGED QUERY CLASSES

    // Registers query invalidation method - used to detect disjoint timer queries

  }, {
    key: 'setInvalidator',
    value: function setInvalidator(_ref) {
      var queryType = _ref.queryType,
          errorMessage = _ref.errorMessage,
          checkInvalid = _ref.checkInvalid;

      this.invalidQueryType = queryType;
      this.invalidErrorMessage = errorMessage;
      this.checkInvalid = checkInvalid;
    }

    // Starts a query, sets up a new promise

  }, {
    key: 'beginQuery',
    value: function beginQuery(query) {
      var onComplete = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;
      var onError = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : noop;

      // Make sure disjoint state is cleared, so that this query starts fresh
      // Cancel other queries if needed
      this.cancelInvalidQueries(query.gl);

      // Cancel current promise - noop if already resolved or rejected
      this.cancelQuery(query);

      // Create a new promise with attached resolve and reject methods
      var resolvers = {};
      query.promise = new Promise(function (resolve, reject) {
        resolvers.resolve = resolve;
        resolvers.reject = reject;
      });
      Object.assign(query.promise, resolvers);

      // Add this query to the pending queries
      this.pendingQueries.add(query);
      // Register the callbacks
      return query.promise.then(onComplete).catch(onError);
    }

    // Resolves a query with a result

  }, {
    key: 'resolveQuery',
    value: function resolveQuery(query, result) {
      this.pendingQueries.delete(query);
      query.promise.resolve(result);
    }

    // Rejects the promise

  }, {
    key: 'rejectQuery',
    value: function rejectQuery(query, errorMessage) {
      this.pendingQueries.delete(query);
      if (query.promise) {
        query.promise.reject(new Error(errorMessage));
      }
    }

    // Rejects promise with standard message for Query.delete()

  }, {
    key: 'deleteQuery',
    value: function deleteQuery(query) {
      return this.rejectQuery(query, ERR_DELETED);
    }

    // Rejects promise with standard message for Query.cancel()

  }, {
    key: 'cancelQuery',
    value: function cancelQuery(query) {
      return this.rejectQuery(query, ERR_CANCEL);
    }

    // Rejects promise with registered message for invalidation

  }, {
    key: 'invalidateQuery',
    value: function invalidateQuery(query) {
      if (query instanceof this.invalidQueryType) {
        this.rejectQuery(query, this.invalidErrorMessage);
      }
    }

    // Checks all queries to see if need to be invalidated

  }, {
    key: 'cancelInvalidQueries',
    value: function cancelInvalidQueries(gl) {
      // We assume that we can cancel queries for all context.
      // Should be OK since this is used to check for "disjoint" GPU state
      if (this.checkInvalid(gl)) {
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = this.pendingQueries.values()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var query = _step2.value;

            this.invalidateQuery(query);
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2.return) {
              _iterator2.return();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }
      }
    }
  }]);

  return QueryManager;
}();

export default new QueryManager();
//# sourceMappingURL=data:application/json;base64,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