// WebGL2 polyfill of drawBuffers using the 'WEBGL_draw_buffers' extension.
// Note: The tricky part is copying the extension constants onto the gl context

/* global WebGLRenderingContext, WebGL2RenderingContext */
import assert from 'assert';

export var DRAWING_BUFFERS = [
// The fragment shader is not written to any color buffer.
'NONE',
// Fragment shader is written to the back color buffer.
'BACK',
// Fragment shader is written to the nth color attachment of the framebuffer.
'COLOR_ATTACHMENT0', 'COLOR_ATTACHMENT1', 'COLOR_ATTACHMENT2', 'COLOR_ATTACHMENT3', 'COLOR_ATTACHMENT4', 'COLOR_ATTACHMENT5', 'COLOR_ATTACHMENT6', 'COLOR_ATTACHMENT7', 'COLOR_ATTACHMENT8', 'COLOR_ATTACHMENT9', 'COLOR_ATTACHMENT10', 'COLOR_ATTACHMENT11', 'COLOR_ATTACHMENT12', 'COLOR_ATTACHMENT13', 'COLOR_ATTACHMENT14', 'COLOR_ATTACHMENT15'];

// Map bufferName string or enum to correct enum (extension version)
function getExtConstant(ext, constant) {
  if (constant.indexOf('COLOR_ATTACHMENT') === 0) {
    constant = constant + '_WEBGL';
  }
  return ext[constant];
}

/**
 * @param {WebGLRenderingContext} gl - gl context
 * @param {GLenum/String[]} buffers - array of enums
 */
function drawBuffers(gl, buffers) {
  var ext = gl.getExtension('WEBGL_draw_buffers');
  assert(ext, 'WEBGL_draw_buffers');
  ext.drawBuffersWEBGL(buffers);
}

// Only add if WebGL2RenderingContext is not available
if (!WebGL2RenderingContext) {

  var prototype = WebGLRenderingContext.prototype;

  prototype.drawBuffers = prototype.drawBuffers || drawBuffers;
}

export default function initializeDrawBuffers(gl) {
  var ext = gl.getExtension('WEBGL_draw_buffers');
  assert(ext, 'WEBGL_draw_buffers');
  for (var constant in DRAWING_BUFFERS) {
    gl[constant] = gl[constant] || getExtConstant(ext, constant);
  }
}
//# sourceMappingURL=data:application/json;base64,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