// WebGL2 Polyfills for iVertexArray Objects
// using OES_vertex_array_object extension

/* global WebGLRenderingContext, WebGL2RenderingContext */
import assert from 'assert';

function createVertexArray(gl) {
  var ext = gl.getExtension('OES_vertex_array_object');
  assert(gl, 'OES_vertex_array_object');
  return ext.createVertexArrayOES();
}

function deleteVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  assert(gl, 'OES_vertex_array_object');
  ext.deleteVertexArrayOES(vertexArray);
}

function isVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  assert(gl, 'OES_vertex_array_object');
  return ext.isVertexArrayOES(vertexArray);
}

function bindVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  assert(gl, 'OES_vertex_array_object');
  return ext.bindVertexArrayOES(vertexArray);
}

// Only add if WebGL2RenderingContext is not available
if (!WebGL2RenderingContext) {

  var prototype = WebGLRenderingContext.prototype;

  prototype.createVertexArray = prototype.createVertexArray || createVertexArray;

  prototype.deleteVertexArray = prototype.deleteVertexArray || deleteVertexArray;

  prototype.isVertexArray = prototype.isVertexArray || isVertexArray;

  prototype.bindVertexArray = prototype.bindVertexArray || bindVertexArray;
}
//# sourceMappingURL=data:application/json;base64,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