var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import GL, { glGet } from './webgl';
import { assertWebGLContext, assertWebGL2Context } from './webgl-checks';

import assert from 'assert';

var Renderbuffer = function () {
  _createClass(Renderbuffer, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Renderbuffer ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Renderbuffer(gl, { handle: object.handle || object });
    }
  }]);

  function Renderbuffer(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Renderbuffer);

    assertWebGLContext(gl);

    this.gl = gl;
    this.handle = gl.createRenderbuffer();
    if (!this.handle) {
      throw new Error('Failed to create WebGL Renderbuffer');
    }
  }

  _createClass(Renderbuffer, [{
    key: 'delete',
    value: function _delete() {
      this.gl.deleteRenderbuffer(this.handle);
      return this;
    }
  }, {
    key: 'bind',
    value: function bind() {
      this.gl.bindRenderbuffer(GL.RENDERBUFFER, this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      this.gl.bindRenderbuffer(GL.RENDERBUFFER, null);
      return this;
    }

    /**
     * Creates and initializes a renderbuffer object's data store
     *
     * @param {GLenum} opt.internalFormat -
     * @param {GLint} opt.width -
     * @param {GLint} opt.height
     * @param {Boolean} opt.autobind=true - method call will bind/unbind object
     * @returns {Renderbuffer} returns itself to enable chaining
     */

  }, {
    key: 'storage',
    value: function storage(_ref) {
      var internalFormat = _ref.internalFormat,
          width = _ref.width,
          height = _ref.height;
      var gl = this.gl;

      assert(internalFormat, 'Needs internalFormat');
      this.bind();
      gl.renderbufferStorage(GL.RENDERBUFFER, glGet(internalFormat), width, height);
      this.unbind();
      return this;
    }

    // @param {Boolean} opt.autobind=true - method call will bind/unbind object
    // @returns {GLenum|GLint} - depends on pname

  }, {
    key: 'getParameter',
    value: function getParameter(pname) {
      var gl = this.gl;

      this.bind();
      var value = gl.getRenderbufferParameter(GL.RENDERBUFFER, glGet(pname));
      this.unbind();
      return value;
    }

    // @returns {GLint} - width of the image of the currently bound renderbuffer.

  }, {
    key: 'storageMultisample',


    // WEBGL2 METHODS

    // (OpenGL ES 3.0.4 §4.4.2)
    value: function storageMultisample() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          samples = _ref2.samples,
          internalformat = _ref2.internalformat,
          width = _ref2.width,
          height = _ref2.height;

      var gl = this.gl;

      assertWebGL2Context(gl);
      gl.renderbufferStorageMultisample(GL.RENDERBUFFER, samples, internalformat, width, height);
      return this;
    }

    // (OpenGL ES 3.0.4 §6.1.15)

  }, {
    key: 'getInternalformatParameter',
    value: function getInternalformatParameter(_ref3) {
      var internalformat = _ref3.internalformat,
          _ref3$pname = _ref3.pname,
          pname = _ref3$pname === undefined ? 'SAMPLES' : _ref3$pname;
      var gl = this.gl;

      assertWebGL2Context(gl);
      return gl.getInternalformatParameter(GL.RENDERBUFFER, internalformat, pname);
    }
  }, {
    key: 'width',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_WIDTH);
    }

    // @returns {GLint} - height of the image of the currently bound renderbuffer.

  }, {
    key: 'height',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_HEIGHT);
    }

    // @returns {GLenum} internal format of the currently bound renderbuffer.
    // The default is gl.RGBA4. Possible return values:
    // gl.RGBA4: 4 red bits, 4 green bits, 4 blue bits 4 alpha bits.
    // gl.RGB565: 5 red bits, 6 green bits, 5 blue bits.
    // gl.RGB5_A1: 5 red bits, 5 green bits, 5 blue bits, 1 alpha bit.
    // gl.DEPTH_COMPONENT16: 16 depth bits.
    // gl.STENCIL_INDEX8: 8 stencil bits.

  }, {
    key: 'internalFormat',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_INTERNAL_FORMAT);
    }

    //  @returns {GLint} - resolution size (in bits) for the green color.

  }, {
    key: 'greenSize',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_GREEN_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the blue color.

  }, {
    key: 'blueSize',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_BLUE_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the red color.

  }, {
    key: 'redSize',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_RED_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the alpha component.

  }, {
    key: 'alphaSize',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_ALPHA_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the depth component.

  }, {
    key: 'depthSize',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_DEPTH_SIZE);
    }

    // @returns {GLint} - resolution size (in bits) for the stencil component.

  }, {
    key: 'stencilSize',
    get: function get() {
      return this.getParameter(GL.RENDERBUFFER_STENCIL_SIZE);
    }

    // When using a WebGL 2 context, the following value is available

  }, {
    key: 'samples',
    get: function get() {
      return this.getParameter(this.gl.RENDERBUFFER_SAMPLES);
    }
  }]);

  return Renderbuffer;
}();

export { Renderbuffer as default };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWJnbC9yZW5kZXJidWZmZXIuanMiXSwibmFtZXMiOlsiR0wiLCJnbEdldCIsImFzc2VydFdlYkdMQ29udGV4dCIsImFzc2VydFdlYkdMMkNvbnRleHQiLCJhc3NlcnQiLCJSZW5kZXJidWZmZXIiLCJnbCIsIm9iamVjdCIsImhhbmRsZSIsIm9wdHMiLCJjcmVhdGVSZW5kZXJidWZmZXIiLCJFcnJvciIsImRlbGV0ZVJlbmRlcmJ1ZmZlciIsImJpbmRSZW5kZXJidWZmZXIiLCJSRU5ERVJCVUZGRVIiLCJpbnRlcm5hbEZvcm1hdCIsIndpZHRoIiwiaGVpZ2h0IiwiYmluZCIsInJlbmRlcmJ1ZmZlclN0b3JhZ2UiLCJ1bmJpbmQiLCJwbmFtZSIsInZhbHVlIiwiZ2V0UmVuZGVyYnVmZmVyUGFyYW1ldGVyIiwic2FtcGxlcyIsImludGVybmFsZm9ybWF0IiwicmVuZGVyYnVmZmVyU3RvcmFnZU11bHRpc2FtcGxlIiwiZ2V0SW50ZXJuYWxmb3JtYXRQYXJhbWV0ZXIiLCJnZXRQYXJhbWV0ZXIiLCJSRU5ERVJCVUZGRVJfV0lEVEgiLCJSRU5ERVJCVUZGRVJfSEVJR0hUIiwiUkVOREVSQlVGRkVSX0lOVEVSTkFMX0ZPUk1BVCIsIlJFTkRFUkJVRkZFUl9HUkVFTl9TSVpFIiwiUkVOREVSQlVGRkVSX0JMVUVfU0laRSIsIlJFTkRFUkJVRkZFUl9SRURfU0laRSIsIlJFTkRFUkJVRkZFUl9BTFBIQV9TSVpFIiwiUkVOREVSQlVGRkVSX0RFUFRIX1NJWkUiLCJSRU5ERVJCVUZGRVJfU1RFTkNJTF9TSVpFIiwiUkVOREVSQlVGRkVSX1NBTVBMRVMiXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPQSxFQUFQLElBQVlDLEtBQVosUUFBd0IsU0FBeEI7QUFDQSxTQUFRQyxrQkFBUixFQUE0QkMsbUJBQTVCLFFBQXNELGdCQUF0RDs7QUFFQSxPQUFPQyxNQUFQLE1BQW1CLFFBQW5COztJQUVxQkMsWTs7OzZCQUVIQyxFLEVBQWlCO0FBQUEsVUFBYkMsTUFBYSx1RUFBSixFQUFJOztBQUMvQixhQUFPQSxrQkFBa0JGLFlBQWxCLEdBQWlDRSxNQUFqQztBQUNMO0FBQ0EsVUFBSUYsWUFBSixDQUFpQkMsRUFBakIsRUFBcUIsRUFBQ0UsUUFBUUQsT0FBT0MsTUFBUCxJQUFpQkQsTUFBMUIsRUFBckIsQ0FGRjtBQUdEOzs7QUFFRCx3QkFBWUQsRUFBWixFQUEyQjtBQUFBLFFBQVhHLElBQVcsdUVBQUosRUFBSTs7QUFBQTs7QUFDekJQLHVCQUFtQkksRUFBbkI7O0FBRUEsU0FBS0EsRUFBTCxHQUFVQSxFQUFWO0FBQ0EsU0FBS0UsTUFBTCxHQUFjRixHQUFHSSxrQkFBSCxFQUFkO0FBQ0EsUUFBSSxDQUFDLEtBQUtGLE1BQVYsRUFBa0I7QUFDaEIsWUFBTSxJQUFJRyxLQUFKLENBQVUscUNBQVYsQ0FBTjtBQUNEO0FBQ0Y7Ozs7OEJBRVE7QUFDUCxXQUFLTCxFQUFMLENBQVFNLGtCQUFSLENBQTJCLEtBQUtKLE1BQWhDO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7OzsyQkFFTTtBQUNMLFdBQUtGLEVBQUwsQ0FBUU8sZ0JBQVIsQ0FBeUJiLEdBQUdjLFlBQTVCLEVBQTBDLEtBQUtOLE1BQS9DO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7Ozs2QkFFUTtBQUNQLFdBQUtGLEVBQUwsQ0FBUU8sZ0JBQVIsQ0FBeUJiLEdBQUdjLFlBQTVCLEVBQTBDLElBQTFDO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7Ozs7Ozs7Ozs7OztrQ0FTeUM7QUFBQSxVQUFoQ0MsY0FBZ0MsUUFBaENBLGNBQWdDO0FBQUEsVUFBaEJDLEtBQWdCLFFBQWhCQSxLQUFnQjtBQUFBLFVBQVRDLE1BQVMsUUFBVEEsTUFBUztBQUFBLFVBQ2hDWCxFQURnQyxHQUMxQixJQUQwQixDQUNoQ0EsRUFEZ0M7O0FBRXZDRixhQUFPVyxjQUFQLEVBQXVCLHNCQUF2QjtBQUNBLFdBQUtHLElBQUw7QUFDQVosU0FBR2EsbUJBQUgsQ0FDRW5CLEdBQUdjLFlBREwsRUFDbUJiLE1BQU1jLGNBQU4sQ0FEbkIsRUFDMENDLEtBRDFDLEVBQ2lEQyxNQURqRDtBQUdBLFdBQUtHLE1BQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDtBQUNBOzs7O2lDQUNhQyxLLEVBQU87QUFBQSxVQUNYZixFQURXLEdBQ0wsSUFESyxDQUNYQSxFQURXOztBQUVsQixXQUFLWSxJQUFMO0FBQ0EsVUFBTUksUUFDSmhCLEdBQUdpQix3QkFBSCxDQUE0QnZCLEdBQUdjLFlBQS9CLEVBQTZDYixNQUFNb0IsS0FBTixDQUE3QyxDQURGO0FBRUEsV0FBS0QsTUFBTDtBQUNBLGFBQU9FLEtBQVA7QUFDRDs7QUFFRDs7Ozs7O0FBd0RBOztBQUVBO3lDQU1RO0FBQUEsc0ZBQUosRUFBSTtBQUFBLFVBSk5FLE9BSU0sU0FKTkEsT0FJTTtBQUFBLFVBSE5DLGNBR00sU0FITkEsY0FHTTtBQUFBLFVBRk5ULEtBRU0sU0FGTkEsS0FFTTtBQUFBLFVBRE5DLE1BQ00sU0FETkEsTUFDTTs7QUFBQSxVQUNDWCxFQURELEdBQ08sSUFEUCxDQUNDQSxFQUREOztBQUVOSCwwQkFBb0JHLEVBQXBCO0FBQ0FBLFNBQUdvQiw4QkFBSCxDQUNFMUIsR0FBR2MsWUFETCxFQUNtQlUsT0FEbkIsRUFDNEJDLGNBRDVCLEVBQzRDVCxLQUQ1QyxFQUNtREMsTUFEbkQ7QUFHQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7OztzREFDZ0U7QUFBQSxVQUFwQ1EsY0FBb0MsU0FBcENBLGNBQW9DO0FBQUEsOEJBQXBCSixLQUFvQjtBQUFBLFVBQXBCQSxLQUFvQiwrQkFBWixTQUFZO0FBQUEsVUFDdkRmLEVBRHVELEdBQ2pELElBRGlELENBQ3ZEQSxFQUR1RDs7QUFFOURILDBCQUFvQkcsRUFBcEI7QUFDQSxhQUFPQSxHQUFHcUIsMEJBQUgsQ0FDTDNCLEdBQUdjLFlBREUsRUFDWVcsY0FEWixFQUM0QkosS0FENUIsQ0FBUDtBQUdEOzs7d0JBL0VXO0FBQ1YsYUFBTyxLQUFLTyxZQUFMLENBQWtCNUIsR0FBRzZCLGtCQUFyQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7d0JBQ2E7QUFDWCxhQUFPLEtBQUtELFlBQUwsQ0FBa0I1QixHQUFHOEIsbUJBQXJCLENBQVA7QUFDRDs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozt3QkFDcUI7QUFDbkIsYUFBTyxLQUFLRixZQUFMLENBQWtCNUIsR0FBRytCLDRCQUFyQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7d0JBQ2dCO0FBQ2QsYUFBTyxLQUFLSCxZQUFMLENBQWtCNUIsR0FBR2dDLHVCQUFyQixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7d0JBQ2U7QUFDYixhQUFPLEtBQUtKLFlBQUwsQ0FBa0I1QixHQUFHaUMsc0JBQXJCLENBQVA7QUFDRDs7QUFFRDs7Ozt3QkFDYztBQUNaLGFBQU8sS0FBS0wsWUFBTCxDQUFrQjVCLEdBQUdrQyxxQkFBckIsQ0FBUDtBQUNEOztBQUVEOzs7O3dCQUNnQjtBQUNkLGFBQU8sS0FBS04sWUFBTCxDQUFrQjVCLEdBQUdtQyx1QkFBckIsQ0FBUDtBQUNEOztBQUVEOzs7O3dCQUNnQjtBQUNkLGFBQU8sS0FBS1AsWUFBTCxDQUFrQjVCLEdBQUdvQyx1QkFBckIsQ0FBUDtBQUNEOztBQUVEOzs7O3dCQUNrQjtBQUNoQixhQUFPLEtBQUtSLFlBQUwsQ0FBa0I1QixHQUFHcUMseUJBQXJCLENBQVA7QUFDRDs7QUFFRDs7Ozt3QkFDYztBQUNaLGFBQU8sS0FBS1QsWUFBTCxDQUFrQixLQUFLdEIsRUFBTCxDQUFRZ0Msb0JBQTFCLENBQVA7QUFDRDs7Ozs7O1NBdEhrQmpDLFkiLCJmaWxlIjoicmVuZGVyYnVmZmVyLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEdMLCB7Z2xHZXR9IGZyb20gJy4vd2ViZ2wnO1xuaW1wb3J0IHthc3NlcnRXZWJHTENvbnRleHQsIGFzc2VydFdlYkdMMkNvbnRleHR9IGZyb20gJy4vd2ViZ2wtY2hlY2tzJztcblxuaW1wb3J0IGFzc2VydCBmcm9tICdhc3NlcnQnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSZW5kZXJidWZmZXIge1xuXG4gIHN0YXRpYyBtYWtlRnJvbShnbCwgb2JqZWN0ID0ge30pIHtcbiAgICByZXR1cm4gb2JqZWN0IGluc3RhbmNlb2YgUmVuZGVyYnVmZmVyID8gb2JqZWN0IDpcbiAgICAgIC8vIFVzZSAuaGFuZGxlIChlLmcgZnJvbSBzdGFjay5nbCdzIGdsLWJ1ZmZlciksIGVsc2UgdXNlIGJ1ZmZlciBkaXJlY3RseVxuICAgICAgbmV3IFJlbmRlcmJ1ZmZlcihnbCwge2hhbmRsZTogb2JqZWN0LmhhbmRsZSB8fCBvYmplY3R9KTtcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKGdsLCBvcHRzID0ge30pIHtcbiAgICBhc3NlcnRXZWJHTENvbnRleHQoZ2wpO1xuXG4gICAgdGhpcy5nbCA9IGdsO1xuICAgIHRoaXMuaGFuZGxlID0gZ2wuY3JlYXRlUmVuZGVyYnVmZmVyKCk7XG4gICAgaWYgKCF0aGlzLmhhbmRsZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdGYWlsZWQgdG8gY3JlYXRlIFdlYkdMIFJlbmRlcmJ1ZmZlcicpO1xuICAgIH1cbiAgfVxuXG4gIGRlbGV0ZSgpIHtcbiAgICB0aGlzLmdsLmRlbGV0ZVJlbmRlcmJ1ZmZlcih0aGlzLmhhbmRsZSk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBiaW5kKCkge1xuICAgIHRoaXMuZ2wuYmluZFJlbmRlcmJ1ZmZlcihHTC5SRU5ERVJCVUZGRVIsIHRoaXMuaGFuZGxlKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHVuYmluZCgpIHtcbiAgICB0aGlzLmdsLmJpbmRSZW5kZXJidWZmZXIoR0wuUkVOREVSQlVGRkVSLCBudWxsKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGFuZCBpbml0aWFsaXplcyBhIHJlbmRlcmJ1ZmZlciBvYmplY3QncyBkYXRhIHN0b3JlXG4gICAqXG4gICAqIEBwYXJhbSB7R0xlbnVtfSBvcHQuaW50ZXJuYWxGb3JtYXQgLVxuICAgKiBAcGFyYW0ge0dMaW50fSBvcHQud2lkdGggLVxuICAgKiBAcGFyYW0ge0dMaW50fSBvcHQuaGVpZ2h0XG4gICAqIEBwYXJhbSB7Qm9vbGVhbn0gb3B0LmF1dG9iaW5kPXRydWUgLSBtZXRob2QgY2FsbCB3aWxsIGJpbmQvdW5iaW5kIG9iamVjdFxuICAgKiBAcmV0dXJucyB7UmVuZGVyYnVmZmVyfSByZXR1cm5zIGl0c2VsZiB0byBlbmFibGUgY2hhaW5pbmdcbiAgICovXG4gIHN0b3JhZ2Uoe2ludGVybmFsRm9ybWF0LCB3aWR0aCwgaGVpZ2h0fSkge1xuICAgIGNvbnN0IHtnbH0gPSB0aGlzO1xuICAgIGFzc2VydChpbnRlcm5hbEZvcm1hdCwgJ05lZWRzIGludGVybmFsRm9ybWF0Jyk7XG4gICAgdGhpcy5iaW5kKCk7XG4gICAgZ2wucmVuZGVyYnVmZmVyU3RvcmFnZShcbiAgICAgIEdMLlJFTkRFUkJVRkZFUiwgZ2xHZXQoaW50ZXJuYWxGb3JtYXQpLCB3aWR0aCwgaGVpZ2h0XG4gICAgKTtcbiAgICB0aGlzLnVuYmluZCgpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gQHBhcmFtIHtCb29sZWFufSBvcHQuYXV0b2JpbmQ9dHJ1ZSAtIG1ldGhvZCBjYWxsIHdpbGwgYmluZC91bmJpbmQgb2JqZWN0XG4gIC8vIEByZXR1cm5zIHtHTGVudW18R0xpbnR9IC0gZGVwZW5kcyBvbiBwbmFtZVxuICBnZXRQYXJhbWV0ZXIocG5hbWUpIHtcbiAgICBjb25zdCB7Z2x9ID0gdGhpcztcbiAgICB0aGlzLmJpbmQoKTtcbiAgICBjb25zdCB2YWx1ZSA9XG4gICAgICBnbC5nZXRSZW5kZXJidWZmZXJQYXJhbWV0ZXIoR0wuUkVOREVSQlVGRkVSLCBnbEdldChwbmFtZSkpO1xuICAgIHRoaXMudW5iaW5kKCk7XG4gICAgcmV0dXJuIHZhbHVlO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMaW50fSAtIHdpZHRoIG9mIHRoZSBpbWFnZSBvZiB0aGUgY3VycmVudGx5IGJvdW5kIHJlbmRlcmJ1ZmZlci5cbiAgZ2V0IHdpZHRoKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVJfV0lEVEgpO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMaW50fSAtIGhlaWdodCBvZiB0aGUgaW1hZ2Ugb2YgdGhlIGN1cnJlbnRseSBib3VuZCByZW5kZXJidWZmZXIuXG4gIGdldCBoZWlnaHQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9IRUlHSFQpO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMZW51bX0gaW50ZXJuYWwgZm9ybWF0IG9mIHRoZSBjdXJyZW50bHkgYm91bmQgcmVuZGVyYnVmZmVyLlxuICAvLyBUaGUgZGVmYXVsdCBpcyBnbC5SR0JBNC4gUG9zc2libGUgcmV0dXJuIHZhbHVlczpcbiAgLy8gZ2wuUkdCQTQ6IDQgcmVkIGJpdHMsIDQgZ3JlZW4gYml0cywgNCBibHVlIGJpdHMgNCBhbHBoYSBiaXRzLlxuICAvLyBnbC5SR0I1NjU6IDUgcmVkIGJpdHMsIDYgZ3JlZW4gYml0cywgNSBibHVlIGJpdHMuXG4gIC8vIGdsLlJHQjVfQTE6IDUgcmVkIGJpdHMsIDUgZ3JlZW4gYml0cywgNSBibHVlIGJpdHMsIDEgYWxwaGEgYml0LlxuICAvLyBnbC5ERVBUSF9DT01QT05FTlQxNjogMTYgZGVwdGggYml0cy5cbiAgLy8gZ2wuU1RFTkNJTF9JTkRFWDg6IDggc3RlbmNpbCBiaXRzLlxuICBnZXQgaW50ZXJuYWxGb3JtYXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9JTlRFUk5BTF9GT1JNQVQpO1xuICB9XG5cbiAgLy8gIEByZXR1cm5zIHtHTGludH0gLSByZXNvbHV0aW9uIHNpemUgKGluIGJpdHMpIGZvciB0aGUgZ3JlZW4gY29sb3IuXG4gIGdldCBncmVlblNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UGFyYW1ldGVyKEdMLlJFTkRFUkJVRkZFUl9HUkVFTl9TSVpFKTtcbiAgfVxuXG4gIC8vIEByZXR1cm5zIHtHTGludH0gLSByZXNvbHV0aW9uIHNpemUgKGluIGJpdHMpIGZvciB0aGUgYmx1ZSBjb2xvci5cbiAgZ2V0IGJsdWVTaXplKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVJfQkxVRV9TSVpFKTtcbiAgfVxuXG4gIC8vIEByZXR1cm5zIHtHTGludH0gLSByZXNvbHV0aW9uIHNpemUgKGluIGJpdHMpIGZvciB0aGUgcmVkIGNvbG9yLlxuICBnZXQgcmVkU2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRQYXJhbWV0ZXIoR0wuUkVOREVSQlVGRkVSX1JFRF9TSVpFKTtcbiAgfVxuXG4gIC8vIEByZXR1cm5zIHtHTGludH0gLSByZXNvbHV0aW9uIHNpemUgKGluIGJpdHMpIGZvciB0aGUgYWxwaGEgY29tcG9uZW50LlxuICBnZXQgYWxwaGFTaXplKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVJfQUxQSEFfU0laRSk7XG4gIH1cblxuICAvLyBAcmV0dXJucyB7R0xpbnR9IC0gcmVzb2x1dGlvbiBzaXplIChpbiBiaXRzKSBmb3IgdGhlIGRlcHRoIGNvbXBvbmVudC5cbiAgZ2V0IGRlcHRoU2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRQYXJhbWV0ZXIoR0wuUkVOREVSQlVGRkVSX0RFUFRIX1NJWkUpO1xuICB9XG5cbiAgLy8gQHJldHVybnMge0dMaW50fSAtIHJlc29sdXRpb24gc2l6ZSAoaW4gYml0cykgZm9yIHRoZSBzdGVuY2lsIGNvbXBvbmVudC5cbiAgZ2V0IHN0ZW5jaWxTaXplKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcihHTC5SRU5ERVJCVUZGRVJfU1RFTkNJTF9TSVpFKTtcbiAgfVxuXG4gIC8vIFdoZW4gdXNpbmcgYSBXZWJHTCAyIGNvbnRleHQsIHRoZSBmb2xsb3dpbmcgdmFsdWUgaXMgYXZhaWxhYmxlXG4gIGdldCBzYW1wbGVzKCkge1xuICAgIHJldHVybiB0aGlzLmdldFBhcmFtZXRlcih0aGlzLmdsLlJFTkRFUkJVRkZFUl9TQU1QTEVTKTtcbiAgfVxuXG4gIC8vIFdFQkdMMiBNRVRIT0RTXG5cbiAgLy8gKE9wZW5HTCBFUyAzLjAuNCDCpzQuNC4yKVxuICBzdG9yYWdlTXVsdGlzYW1wbGUoe1xuICAgIHNhbXBsZXMsXG4gICAgaW50ZXJuYWxmb3JtYXQsXG4gICAgd2lkdGgsXG4gICAgaGVpZ2h0XG4gIH0gPSB7fSkge1xuICAgIGNvbnN0IHtnbH0gPSB0aGlzO1xuICAgIGFzc2VydFdlYkdMMkNvbnRleHQoZ2wpO1xuICAgIGdsLnJlbmRlcmJ1ZmZlclN0b3JhZ2VNdWx0aXNhbXBsZShcbiAgICAgIEdMLlJFTkRFUkJVRkZFUiwgc2FtcGxlcywgaW50ZXJuYWxmb3JtYXQsIHdpZHRoLCBoZWlnaHRcbiAgICApO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gKE9wZW5HTCBFUyAzLjAuNCDCpzYuMS4xNSlcbiAgZ2V0SW50ZXJuYWxmb3JtYXRQYXJhbWV0ZXIoe2ludGVybmFsZm9ybWF0LCBwbmFtZSA9ICdTQU1QTEVTJ30pIHtcbiAgICBjb25zdCB7Z2x9ID0gdGhpcztcbiAgICBhc3NlcnRXZWJHTDJDb250ZXh0KGdsKTtcbiAgICByZXR1cm4gZ2wuZ2V0SW50ZXJuYWxmb3JtYXRQYXJhbWV0ZXIoXG4gICAgICBHTC5SRU5ERVJCVUZGRVIsIGludGVybmFsZm9ybWF0LCBwbmFtZVxuICAgICk7XG4gIH1cbn1cbiJdfQ==