var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// WebGL2 Sampler Helper
// https://developer.mozilla.org/en-US/docs/Web/API/WebGLQuery

import { assertWebGL2Context, glCheckError } from '../webgl-checks';

var Sampler = function () {

  /**
   * @class
   * @param {WebGL2RenderingContext} gl
   */
  function Sampler(gl) {
    _classCallCheck(this, Sampler);

    assertWebGL2Context(gl);
    this.gl = gl;
    this.handle = gl.createSampler();
    glCheckError(gl);
    this.userData = {};
    Object.seal(this);
  }

  /**
   * @return {Sampler} returns self to enable chaining
   */


  _createClass(Sampler, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      gl.deleteSampler(this.handle);
      this.handle = null;
      glCheckError(gl);
      return this;
    }

    /**
     * @param {GLuint} unit
     * @return {Sampler} returns self to enable chaining
     */

  }, {
    key: 'bind',
    value: function bind(unit) {
      var gl = this.gl;

      gl.bindSampler(unit, this.handle);
      glCheckError(gl);
      return this;
    }

    /**
     * @param {GLuint} unit
     * @return {Sampler} returns self to enable chaining
     */

  }, {
    key: 'unbind',
    value: function unbind(unit) {
      var gl = this.gl;

      gl.bindSampler(unit, null);
      glCheckError(gl);
      return this;
    }

    /**
     * Batch update sampler settings
     *
     * @param {GLenum} compare_func - texture comparison function.
     * @param {GLenum} compare_mode - texture comparison mode.
     * @param {GLenum} mag_filter - texture magnification filter.
     * @param {GLenum} MIN_FILTER - texture minification filter
     * @param {GLfloat} MAX_LOD: maximum level-of-detail value.
     * @param {GLfloat} MIN_LOD: minimum level-of-detail value.
     * @param {GLenum} WRAP_R: texture wrapping function for texture coordinate r.
     * @param {GLenum} WRAP_S: texture wrapping function for texture coordinate s.
     * @param {GLenum} WRAP_T: texture wrapping function for texture coordinate t.
     */
    /* eslint-disable max-statements */

  }, {
    key: 'setParameters',
    value: function setParameters(_ref) {
      var compareFunc = _ref.compareFunc,
          compareMode = _ref.compareMode,
          magFilter = _ref.magFilter,
          minFilter = _ref.minFilter,
          minLOD = _ref.minLOD,
          maxLOD = _ref.maxLOD,
          wrapR = _ref.wrapR,
          wrapS = _ref.wrapS,
          wrapT = _ref.wrapT;
      var gl = this.gl;

      if (compareFunc) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_COMPARE_FUNC, compareFunc);
      }
      if (compareMode) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_COMPARE_MODE, compareMode);
      }
      if (magFilter) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_MAG_FILTER, magFilter);
      }
      if (minFilter) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_MIN_FILTER, minFilter);
      }
      if (minLOD) {
        gl.samplerParameterf(this.handle, gl.TEXTURE_MIN_LOD, minLOD);
      }
      if (maxLOD) {
        gl.samplerParameterf(this.handle, gl.TEXTURE_MAX_LOD, maxLOD);
      }
      if (wrapR) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_WRAP_R, wrapR);
      }
      if (wrapS) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_WRAP_S, wrapS);
      }
      if (wrapT) {
        gl.samplerParameteri(this.handle, gl.TEXTURE_WRAP_T, wrapT);
      }
    }
    /* eslint-enable max-statements */

    /**
     * @param {GLenum} pname
     * @param {GLint} param
     * @return {Sampler} returns self to enable chaining
     */

  }, {
    key: 'parameteri',
    value: function parameteri(pname, param) {
      var gl = this.gl;

      gl.samplerParameteri(this.handle, pname, param);
      glCheckError(gl);
      return this;
    }

    /**
     * @param {GLenum} pname
     * @param {GLfloat} param
     * @return {Sampler} returns self to enable chaining
     */

  }, {
    key: 'parameterf',
    value: function parameterf(pname, param) {
      var gl = this.gl;

      gl.samplerParameterf(this.handle, pname, param);
      glCheckError(gl);
      return this;
    }

    // @param {GLenum} pname
    // @return {*} result

  }, {
    key: 'getParameter',
    value: function getParameter(pname) {
      var gl = this.gl;

      var result = gl.getSamplerParameter(this.handle, pname);
      glCheckError(gl);
      return result;
    }
  }]);

  return Sampler;
}();

export { Sampler as default };
//# sourceMappingURL=data:application/json;base64,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