var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { GL } from './webgl';
import { assertWebGLContext } from './webgl-checks';
import { getShaderName, formatGLSLCompilerError } from './webgl-format-glsl-error';
import { uid, isBrowser } from '../utils';
import assert from 'assert';

var ERR_SOURCE = 'Shader: GLSL source code must be a JavaScript string';

// For now this is an internal class
export var Shader = function () {

  /* eslint-disable max-statements */
  function Shader(gl, source, shaderType) {
    _classCallCheck(this, Shader);

    assertWebGLContext(gl);
    assert(typeof source === 'string', ERR_SOURCE);

    this.id = getShaderName(source) || uid(this.getTypeName(shaderType));
    this.gl = gl;
    this.shaderType = shaderType;
    this.source = source;
    this.handle = gl.createShader(shaderType);
    if (this.handle === null) {
      throw new Error('Error creating shader with type ' + shaderType);
    }
    this.compile();
  }

  _createClass(Shader, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      if (this.handle) {
        gl.deleteShader(this.handle);
        this.handle = null;
      }
    }
  }, {
    key: 'toString',
    value: function toString() {
      return this.getTypeName(this.shaderType) + ':' + this.id;
    }
  }, {
    key: 'getName',
    value: function getName() {
      return getShaderName(this.source);
    }
  }, {
    key: 'getTypeName',
    value: function getTypeName(shaderType) {
      switch (shaderType) {
        case GL.VERTEX_SHADER:
          return 'vertex-shader';
        case GL.FRAGMENT_SHADER:
          return 'fragment-shader';
        default:
          return 'shader';
      }
    }
  }, {
    key: 'compile',
    value: function compile() {
      var gl = this.gl;

      gl.shaderSource(this.handle, this.source);
      gl.compileShader(this.handle);

      // Shader compilation error is checked only when debug context is used
      if (gl.debug) {
        var compiled = gl.getShaderParameter(this.handle, GL.COMPILE_STATUS);
        if (!compiled) {
          var infoLog = gl.getShaderInfoLog(this.handle);
          var error = formatGLSLCompilerError(infoLog, this.source, this.shaderType);
          this.delete();
          throw new Error('Error while compiling the shader ' + error);
        }
      }
    }
    /* eslint-enable max-statements */

    // TODO - move to debug utils?

  }, {
    key: 'copyToClipboard',
    value: function copyToClipboard(text) {
      if (isBrowser) {
        /* global document */
        var input = document.createElement('textarea');
        document.body.appendChild(input);
        input.value = text;
        input.focus();
        input.select();
        if (!document.execCommand('copy')) {
          /* eslint-disable no-console */
          /* global console */
          console.log('Failed to copy to clipboard');
        }
        input.remove();
      }
    }
  }]);

  return Shader;
}();

export var VertexShader = function (_Shader) {
  _inherits(VertexShader, _Shader);

  function VertexShader(gl, source) {
    _classCallCheck(this, VertexShader);

    return _possibleConstructorReturn(this, (VertexShader.__proto__ || Object.getPrototypeOf(VertexShader)).call(this, gl, source, GL.VERTEX_SHADER));
  }

  return VertexShader;
}(Shader);

export var FragmentShader = function (_Shader2) {
  _inherits(FragmentShader, _Shader2);

  function FragmentShader(gl, source) {
    _classCallCheck(this, FragmentShader);

    return _possibleConstructorReturn(this, (FragmentShader.__proto__ || Object.getPrototypeOf(FragmentShader)).call(this, gl, source, GL.FRAGMENT_SHADER));
  }

  return FragmentShader;
}(Shader);
//# sourceMappingURL=data:application/json;base64,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