var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// WebGL2 Sync Object Helper
// https://developer.mozilla.org/en-US/docs/Web/API/WebGLQuery
import { assertWebGL2Context, glCheckError } from '../webgl/webgl-checks';
import queryManager from './queryManager';

// WebGLSync? fenceSync(GLenum condition, GLbitfield flags);
// [WebGLHandlesContextLoss] GLboolean isSync(WebGLSync? sync);
// void deleteSync(WebGLSync? sync);
// GLenum clientWaitSync(WebGLSync? sync, GLbitfield flags, GLint64 timeout);
// void waitSync(WebGLSync? sync, GLbitfield flags, GLint64 timeout);
// any getSyncParameter(WebGLSync? sync, GLenum pname);

var Sync = function () {
  /**
   * @class
   * @param {WebGL2RenderingContext} gl
   */
  function Sync(gl) {
    _classCallCheck(this, Sync);

    assertWebGL2Context(gl);

    var handle = gl.fenceSync(gl.SYNC_GPU_COMMANDS_COMPLETE, 0);
    glCheckError(gl);

    this.gl = gl;
    this.handle = handle;
    this.userData = {};

    // query manager needs a promise field
    this.promise = null;

    Object.seal(this);
  }

  /**
   * @return {Sync} returns self to enable chaining
   */


  _createClass(Sync, [{
    key: 'delete',
    value: function _delete() {
      queryManager.deleteQuery(this);
      if (this.handle) {
        this.gl.deleteSync(this.handle);
        this.handle = null;
        glCheckError(this.gl);
      }
      return this;
    }

    /**
     * @param {GLbitfield} flags
     * @param {GLint64} timeout
     * @return {Sync} returns self to enable chaining
     */

  }, {
    key: 'wait',
    value: function wait(flags, timeout) {
      this.gl.waitSync(this.handle, flags, timeout);
      glCheckError(this.gl);
      return this;
    }

    /**
     * @param {GLbitfield} flags
     * @param {GLint64} timeout
     * @return {GLenum} result
     */

  }, {
    key: 'clientWait',
    value: function clientWait(flags, timeout) {
      var result = this.gl.clientWaitSync(this.handle, flags, timeout);
      glCheckError(this.gl);
      return result;
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      queryManager.cancelQuery(this);
    }
  }, {
    key: 'isResultAvailable',
    value: function isResultAvailable() {
      var status = this.gl.getSyncParameter(this.handle, this.gl.SYNC_STATUS);
      return status === this.gl.SIGNALED;
    }
  }, {
    key: 'getResult',
    value: function getResult() {
      return this.gl.SIGNALED;
    }
  }]);

  return Sync;
}();

export { Sync as default };
//# sourceMappingURL=data:application/json;base64,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