var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _objectDestructuringEmpty(obj) { if (obj == null) throw new TypeError("Cannot destructure undefined"); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { GL } from './webgl';
import { assertWebGLContext } from './webgl-checks';
import Texture from './texture';

var Texture2D = function (_Texture) {
  _inherits(Texture2D, _Texture);

  _createClass(Texture2D, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Texture2D ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Texture2D(gl, { handle: object.handle || object });
    }
  }, {
    key: 'makeFromSolidColor',
    value: function makeFromSolidColor(gl, _ref) {
      var _ref2 = _slicedToArray(_ref, 4),
          _ref2$ = _ref2[0],
          r = _ref2$ === undefined ? 0 : _ref2$,
          _ref2$2 = _ref2[1],
          g = _ref2$2 === undefined ? 0 : _ref2$2,
          _ref2$3 = _ref2[2],
          b = _ref2$3 === undefined ? 0 : _ref2$3,
          _ref2$4 = _ref2[3],
          a = _ref2$4 === undefined ? 1 : _ref2$4;

      return new Texture2D(gl, {
        pixels: new Uint8Array([r, g, b, a]),
        width: 1,
        format: gl.RGBA,
        magFilter: gl.NEAREST,
        minFilter: gl.NEAREST
      });
    }
  }, {
    key: 'makeFromPixelArray',
    value: function makeFromPixelArray(gl, opts) {
      var dataArray = opts.dataArray,
          _opts$format = opts.format,
          format = _opts$format === undefined ? GL.RGBA : _opts$format,
          _opts$width = opts.width,
          width = _opts$width === undefined ? 1 : _opts$width,
          height = opts.height;
      // Don't need to do this if the data is already in a typed array

      var dataTypedArray = new Uint8Array(dataArray);
      return new Texture2D(gl, Object.assign({
        pixels: dataTypedArray,
        width: width,
        height: height,
        format: format
      }, opts));
    }

    /**
     * @classdesc
     * 2D WebGL Texture
     * Note: Constructor will initialize your texture.
     *
     * @class
     * @param {WebGLRenderingContext} gl - gl context
     * @param {Image|ArrayBuffer|null} opts= - named options
     * @param {Image|ArrayBuffer|null} opts.data= - buffer
     * @param {GLint} width - width of texture
     * @param {GLint} height - height of texture
     */

  }]);

  function Texture2D(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Texture2D);

    assertWebGLContext(gl);

    var _this = _possibleConstructorReturn(this, (Texture2D.__proto__ || Object.getPrototypeOf(Texture2D)).call(this, gl, Object.assign({}, opts, { target: gl.TEXTURE_2D })));

    _this.width = null;
    _this.height = null;
    Object.seal(_this);

    _this.setImageData(opts);
    if (opts.generateMipmap) {
      _this.generateMipmap();
    }
    return _this;
  }

  // target cannot be modified by bind:
  // textures are special because when you first bind them to a target,
  // they get special information. When you first bind a texture as a
  // GL_TEXTURE_2D, you are actually setting special state in the texture.
  // You are saying that this texture is a 2D texture.
  // And it will always be a 2D texture; this state cannot be changed ever.
  // If you have a texture that was first bound as a GL_TEXTURE_2D,
  // you must always bind it as a GL_TEXTURE_2D;
  // attempting to bind it as GL_TEXTURE_1D will give rise to an error
  // (while run-time).

  _createClass(Texture2D, [{
    key: 'bind',
    value: function bind() {
      var textureUnit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.textureUnit;
      var gl = this.gl;

      if (textureUnit === undefined) {
        throw new Error('Texture.bind: must specify texture unit');
      }
      this.textureUnit = textureUnit;
      gl.activeTexture(gl.TEXTURE0 + textureUnit);
      gl.bindTexture(this.target, this.handle);
      return textureUnit;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var gl = this.gl;

      if (this.textureUnit === undefined) {
        throw new Error('Texture.unbind: texture unit not specified');
      }
      gl.activeTexture(gl.TEXTURE0 + this.textureUnit);
      gl.bindTexture(this.target, null);
      return this.textureUnit;
    }
  }, {
    key: 'getActiveUnit',
    value: function getActiveUnit() {
      return this.gl.getParameter(GL.ACTIVE_TEXTURE) - GL.TEXTURE0;
    }

    // WebGL2

  }, {
    key: 'setPixels',
    value: function setPixels() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var buffer = opts.buffer,
          _opts$width2 = opts.width,
          width = _opts$width2 === undefined ? null : _opts$width2,
          _opts$height = opts.height,
          height = _opts$height === undefined ? null : _opts$height,
          _opts$mipmapLevel = opts.mipmapLevel,
          mipmapLevel = _opts$mipmapLevel === undefined ? 0 : _opts$mipmapLevel,
          _opts$format2 = opts.format,
          format = _opts$format2 === undefined ? GL.RGBA : _opts$format2,
          _opts$type = opts.type,
          type = _opts$type === undefined ? GL.UNSIGNED_BYTE : _opts$type,
          _opts$border = opts.border,
          border = _opts$border === undefined ? 0 : _opts$border;
      var gl = this.gl;

      // This signature of texImage2D uses currently bound GL_PIXEL_UNPACK_BUFFER

      gl.bindBuffer(GL.PIXEL_UNPACK_BUFFER, buffer.target);
      // And as always, we must also bind the texture itself
      this.bind();

      gl.texImage2D(gl.TEXTURE_2D, mipmapLevel, format, width, height, border, format, type, buffer.target);

      this.unbind();
      gl.bindBuffer(GL.GL_PIXEL_UNPACK_BUFFER, null);
      return this;
    }
  }, {
    key: 'setImageDataFromCompressedBuffer',
    value: function setImageDataFromCompressedBuffer(opts) {
      var buffer = opts.buffer,
          _opts$width3 = opts.width,
          width = _opts$width3 === undefined ? null : _opts$width3,
          _opts$height2 = opts.height,
          height = _opts$height2 === undefined ? null : _opts$height2,
          _opts$mipmapLevel2 = opts.mipmapLevel,
          mipmapLevel = _opts$mipmapLevel2 === undefined ? 0 : _opts$mipmapLevel2,
          _opts$internalFormat = opts.internalFormat,
          internalFormat = _opts$internalFormat === undefined ? GL.RGBA : _opts$internalFormat,
          _opts$border2 = opts.border,
          border = _opts$border2 === undefined ? 0 : _opts$border2;
      var gl = this.gl;

      gl.compressedTexImage2D(this.target, mipmapLevel, internalFormat, width, height, border, buffer);
      // gl.compressedTexSubImage2D(target,
      //   level, xoffset, yoffset, width, height, format, ArrayBufferView? pixels);
      return this;
    }

    /**
     * Defines a two-dimensional texture image or cube-map texture image with
     * pixels from the current framebuffer (rather than from client memory).
     * (gl.copyTexImage2D wrapper)
     */

  }, {
    key: 'copyImageFromFramebuffer',
    value: function copyImageFromFramebuffer(opts) {
      var framebuffer = opts.framebuffer,
          x = opts.x,
          y = opts.y,
          width = opts.width,
          height = opts.height,
          _opts$mipmapLevel3 = opts.mipmapLevel,
          mipmapLevel = _opts$mipmapLevel3 === undefined ? 0 : _opts$mipmapLevel3,
          _opts$internalFormat2 = opts.internalFormat,
          internalFormat = _opts$internalFormat2 === undefined ? GL.RGBA : _opts$internalFormat2,
          _opts$border3 = opts.border,
          border = _opts$border3 === undefined ? 0 : _opts$border3;
      var gl = this.gl;

      framebuffer.bind();

      // target
      this.bind();
      gl.copyTexImage2D(this.target, mipmapLevel, internalFormat, x, y, width, height, border);
      this.unbind();

      framebuffer.unbind();
    }
  }, {
    key: 'copySubImage',
    value: function copySubImage(opts) {
      _objectDestructuringEmpty(opts);

      // if (pixels instanceof ArrayBufferView) {
      //   gl.texSubImage2D(target, level, x, y, width, height, format, type, pixels);
      // }
      // gl.texSubImage2D(target, level, x, y, format, type, ? pixels);
      // gl.texSubImage2D(target, level, x, y, format, type, HTMLImageElement pixels);
      // gl.texSubImage2D(target, level, x, y, format, type, HTMLCanvasElement pixels);
      // gl.texSubImage2D(target, level, x, y, format, type, HTMLVideoElement pixels);
      // // Additional signature in a WebGL 2 context:
      // gl.texSubImage2D(target, level, x, y, format, type, GLintptr offset);

    }
  }]);

  return Texture2D;
}(Texture);

export { Texture2D as default };
//# sourceMappingURL=data:application/json;base64,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