var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { GL } from './webgl';
import { assertWebGLContext } from './webgl-checks';
import Texture from './texture';

var TextureCube = function (_Texture) {
  _inherits(TextureCube, _Texture);

  _createClass(TextureCube, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof TextureCube ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new TextureCube(gl, { handle: object.handle || object });
    }
  }]);

  function TextureCube(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, TextureCube);

    assertWebGLContext(gl);

    var _this = _possibleConstructorReturn(this, (TextureCube.__proto__ || Object.getPrototypeOf(TextureCube)).call(this, gl, Object.assign({}, opts, { target: GL.TEXTURE_CUBE_MAP })));

    _this.setCubeMapImageData(opts);
    return _this;
  }

  _createClass(TextureCube, [{
    key: 'bind',
    value: function bind() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          index = _ref.index;

      var gl = this.gl;

      if (index !== undefined) {
        gl.activeTexture(GL.TEXTURE0 + index);
      }
      gl.bindTexture(GL.TEXTURE_CUBE_MAP, this.handle);
      if (index === undefined) {
        var result = gl.getParameter(gl.ACTIVE_TEXTURE) - GL.TEXTURE0;
        return result;
      }
      return index;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var gl = this.gl;

      gl.bindTexture(GL.TEXTURE_CUBE_MAP, null);
    }

    /* eslint-disable max-statements, max-len */

  }, {
    key: 'setCubeMapImageData',
    value: function setCubeMapImageData(_ref2) {
      var width = _ref2.width,
          height = _ref2.height,
          pixels = _ref2.pixels,
          data = _ref2.data,
          _ref2$border = _ref2.border,
          border = _ref2$border === undefined ? 0 : _ref2$border,
          _ref2$format = _ref2.format,
          format = _ref2$format === undefined ? GL.RGBA : _ref2$format,
          _ref2$type = _ref2.type,
          type = _ref2$type === undefined ? GL.UNSIGNED_BYTE : _ref2$type,
          _ref2$generateMipmap = _ref2.generateMipmap,
          generateMipmap = _ref2$generateMipmap === undefined ? false : _ref2$generateMipmap;
      var gl = this.gl;

      pixels = pixels || data;
      this.bind();
      if (this.width || this.height) {
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_POSITIVE_X, 0, format, width, height, border, format, type, pixels.pos.x);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_POSITIVE_Y, 0, format, width, height, border, format, type, pixels.pos.y);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_POSITIVE_Z, 0, format, width, height, border, format, type, pixels.pos.z);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_NEGATIVE_X, 0, format, width, height, border, format, type, pixels.neg.x);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_NEGATIVE_Y, 0, format, width, height, border, format, type, pixels.neg.y);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_NEGATIVE_Z, 0, format, width, height, border, format, type, pixels.neg.z);
      } else {
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_POSITIVE_X, 0, format, format, type, pixels.pos.x);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_POSITIVE_Y, 0, format, format, type, pixels.pos.y);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_POSITIVE_Z, 0, format, format, type, pixels.pos.z);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_NEGATIVE_X, 0, format, format, type, pixels.neg.x);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_NEGATIVE_Y, 0, format, format, type, pixels.neg.y);
        gl.texImage2D(GL.TEXTURE_CUBE_MAP_NEGATIVE_Z, 0, format, format, type, pixels.neg.z);
      }

      this.unbind();

      if (generateMipmap) {
        this.generateMipmap();
      }
      return this;
    }
  }]);

  return TextureCube;
}(Texture);

export { TextureCube as default };
//# sourceMappingURL=data:application/json;base64,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