var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { GL, WebGL2RenderingContext, WebGLBuffer, glTypeFromArray } from './webgl';
import { assertWebGLContext } from './webgl-checks';
import Buffer from './buffer';
import { uid } from '../utils';
import assert from 'assert';

var Texture = function () {
  function Texture(gl, opts) {
    _classCallCheck(this, Texture);

    var _opts$id = opts.id,
        id = _opts$id === undefined ? uid('texture') : _opts$id,
        _opts$unpackFlipY = opts.unpackFlipY,
        unpackFlipY = _opts$unpackFlipY === undefined ? true : _opts$unpackFlipY,
        _opts$magFilter = opts.magFilter,
        magFilter = _opts$magFilter === undefined ? GL.NEAREST : _opts$magFilter,
        _opts$minFilter = opts.minFilter,
        minFilter = _opts$minFilter === undefined ? GL.NEAREST : _opts$minFilter,
        _opts$wrapS = opts.wrapS,
        wrapS = _opts$wrapS === undefined ? GL.CLAMP_TO_EDGE : _opts$wrapS,
        _opts$wrapT = opts.wrapT,
        wrapT = _opts$wrapT === undefined ? GL.CLAMP_TO_EDGE : _opts$wrapT,
        _opts$target = opts.target,
        target = _opts$target === undefined ? GL.TEXTURE_2D : _opts$target,
        handle = opts.handle;


    assertWebGLContext(gl);

    this.handle = handle || gl.createTexture();
    this.id = id;
    this.gl = gl;
    this.target = target;
    this.hasFloatTexture = gl.getExtension('OES_texture_float');
    this.width = null;
    this.height = null;
    this.textureUnit = undefined;
    this.userData = {};

    this.setPixelStorageModes(Object.assign({}, opts, { unpackFlipY: unpackFlipY }));
    this.setParameters(Object.assign({}, opts, { magFilter: magFilter, minFilter: minFilter, wrapS: wrapS, wrapT: wrapT }));
  }

  _createClass(Texture, [{
    key: 'delete',
    value: function _delete() {
      if (this.handle) {
        this.gl.deleteTexture(this.handle);
        this.handle = null;
      }
      return this;
    }
  }, {
    key: 'toString',
    value: function toString() {
      return 'Texture(' + this.id + ',' + this.width + 'x' + this.height + ')';
    }
  }, {
    key: 'generateMipmap',
    value: function generateMipmap() {
      this.gl.bindTexture(this.target, this.handle);
      this.gl.generateMipmap(this.target);
      this.gl.bindTexture(this.target, null);
      return this;
    }

    /*
     * @param {*} pixels -
     *  null - create empty texture of specified format
     *  Typed array - init from image data in typed array
     *  Buffer|WebGLBuffer - (WEBGL2) init from image data in WebGLBuffer
     *  HTMLImageElement|Image - Inits with content of image. Auto width/height
     *  HTMLCanvasElement - Inits with contents of canvas. Auto width/height
     *  HTMLVideoElement - Creates video texture. Auto width/height
     *
     * @param {GLint} width -
     * @param {GLint} height -
     * @param {GLint} mipMapLevel -
     * @param {GLenum} format - format of image data.
     * @param {GLenum} type
     *  - format of array (autodetect from type) or
     *  - (WEBGL2) format of buffer
     * @param {Number} offset - (WEBGL2) offset from start of buffer
     * @param {GLint} border - must be 0.
     */
    /* eslint-disable max-len, max-statements, complexity */

  }, {
    key: 'setImageData',
    value: function setImageData(_ref) {
      var _ref$target = _ref.target,
          target = _ref$target === undefined ? this.target : _ref$target,
          _ref$pixels = _ref.pixels,
          pixels = _ref$pixels === undefined ? null : _ref$pixels,
          _ref$data = _ref.data,
          data = _ref$data === undefined ? null : _ref$data,
          width = _ref.width,
          height = _ref.height,
          _ref$mipmapLevel = _ref.mipmapLevel,
          mipmapLevel = _ref$mipmapLevel === undefined ? 0 : _ref$mipmapLevel,
          _ref$format = _ref.format,
          format = _ref$format === undefined ? GL.RGBA : _ref$format,
          type = _ref.type,
          _ref$offset = _ref.offset,
          offset = _ref$offset === undefined ? 0 : _ref$offset,
          _ref$border = _ref.border,
          border = _ref$border === undefined ? 0 : _ref$border;
      var gl = this.gl;


      pixels = pixels || data;

      // Support ndarrays
      if (pixels && pixels.data) {
        var ndarray = pixels;
        pixels = ndarray.data;
        width = ndarray.shape[0];
        height = ndarray.shape[1];
      }

      gl.bindTexture(this.target, this.handle);

      if (pixels === null) {

        // Create an minimal texture
        width = width || 1;
        height = height || 1;
        type = type || GL.UNSIGNED_BYTE;
        // pixels = new Uint8Array([255, 0, 0, 1]);
        gl.texImage2D(target, mipmapLevel, format, width, height, border, format, type, pixels);
        this.width = width;
        this.height = height;
      } else if (ArrayBuffer.isView(pixels)) {

        // Create from a typed array
        assert(width > 0 && height > 0, 'Texture2D: Width and height required');
        type = type || glTypeFromArray(pixels);
        // TODO - WebGL2 check?
        if (type === gl.FLOAT && !this.hasFloatTexture) {
          throw new Error('floating point textures are not supported.');
        }
        gl.texImage2D(target, mipmapLevel, format, width, height, border, format, type, pixels);
        this.width = width;
        this.height = height;
      } else if (pixels instanceof WebGLBuffer || pixels instanceof Buffer) {

        // WebGL2 allows us to create texture directly from a WebGL buffer
        assert(gl instanceof WebGL2RenderingContext, 'Requires WebGL2');
        type = type || GL.UNSIGNED_BYTE;
        // This texImage2D signature uses currently bound GL_PIXEL_UNPACK_BUFFER
        var buffer = Buffer.makeFrom(pixels);
        gl.bindBuffer(GL.PIXEL_UNPACK_BUFFER, buffer.handle);
        gl.texImage2D(target, mipmapLevel, format, width, height, border, format, type, offset);
        gl.bindBuffer(GL.GL_PIXEL_UNPACK_BUFFER, null);
        this.width = width;
        this.height = height;
      } else {

        var imageSize = this._deduceImageSize(pixels);
        // Assume pixels is a browser supported object (ImageData, Canvas, ...)
        assert(width === undefined && height === undefined, 'Texture2D.setImageData: Width and height must not be provided');
        type = type || GL.UNSIGNED_BYTE;
        gl.texImage2D(target, mipmapLevel, format, format, type, pixels);
        this.width = imageSize.width;
        this.height = imageSize.height;
      }

      gl.bindTexture(this.target, null);

      return this;
    }
    /* eslint-enable max-len, max-statements, complexity */

    /* global ImageData, HTMLImageElement, HTMLCanvasElement, HTMLVideoElement */

  }, {
    key: '_deduceImageSize',
    value: function _deduceImageSize(image) {
      if (typeof ImageData !== 'undefined' && image instanceof ImageData) {
        return { width: image.width, height: image.height };
      } else if (typeof HTMLImageElement !== 'undefined' && image instanceof HTMLImageElement) {
        return { width: image.naturalWidth, height: image.naturalHeight };
      } else if (typeof HTMLCanvasElement !== 'undefined' && image instanceof HTMLCanvasElement) {
        return { width: image.width, height: image.height };
      } else if (typeof HTMLVideoElement !== 'undefined' && image instanceof HTMLVideoElement) {
        return { width: image.videoWidth, height: image.videoHeight };
      }
      throw new Error('Unknown image data format. Failed to deduce image size');
    }

    /**
     * Batch update pixel storage modes
     * @param {GLint} packAlignment - Packing of pixel data in memory (1,2,4,8)
     * @param {GLint} unpackAlignment - Unpacking pixel data from memory(1,2,4,8)
     * @param {GLboolean} unpackFlipY -  Flip source data along its vertical axis
     * @param {GLboolean} unpackPremultiplyAlpha -
     *   Multiplies the alpha channel into the other color channels
     * @param {GLenum} unpackColorspaceConversion -
     *   Default color space conversion or no color space conversion.
     *
     * @param {GLint} packRowLength -
     *  Number of pixels in a row.
     * @param {} packSkipPixels -
     *   Number of pixels skipped before the first pixel is written into memory.
     * @param {} packSkipRows -
     *   Number of rows of pixels skipped before first pixel is written to memory.
     * @param {} unpackRowLength -
     *   Number of pixels in a row.
     * @param {} unpackImageHeight -
     *   Image height used for reading pixel data from memory
     * @param {} unpackSkipPixels -
     *   Number of pixel images skipped before first pixel is read from memory
     * @param {} unpackSkipRows -
     *   Number of rows of pixels skipped before first pixel is read from memory
     * @param {} unpackSkipImages -
     *   Number of pixel images skipped before first pixel is read from memory
     */
    /* eslint-disable complexity, max-statements */

  }, {
    key: 'setPixelStorageModes',
    value: function setPixelStorageModes() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          packAlignment = _ref2.packAlignment,
          unpackAlignment = _ref2.unpackAlignment,
          unpackFlipY = _ref2.unpackFlipY,
          unpackPremultiplyAlpha = _ref2.unpackPremultiplyAlpha,
          unpackColorspaceConversion = _ref2.unpackColorspaceConversion,
          packRowLength = _ref2.packRowLength,
          packSkipPixels = _ref2.packSkipPixels,
          packSkipRows = _ref2.packSkipRows,
          unpackRowLength = _ref2.unpackRowLength,
          unpackImageHeight = _ref2.unpackImageHeight,
          unpackSkipPixels = _ref2.unpackSkipPixels,
          unpackSkipRows = _ref2.unpackSkipRows,
          unpackSkipImages = _ref2.unpackSkipImages;

      var gl = this.gl;


      gl.bindTexture(this.target, this.handle);

      if (packAlignment) {
        gl.pixelStorei(gl.PACK_ALIGNMENT, packAlignment);
      }
      if (unpackAlignment) {
        gl.pixelStorei(gl.UNPACK_ALIGNMENT, unpackAlignment);
      }
      if (unpackFlipY) {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, unpackFlipY);
      }
      if (unpackPremultiplyAlpha) {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, unpackPremultiplyAlpha);
      }
      if (unpackColorspaceConversion) {
        gl.pixelStorei(gl.UNPACK_COLORSPACE_CONVERSION_WEBGL, unpackColorspaceConversion);
      }

      // WEBGL2
      if (packRowLength) {
        gl.pixelStorei(gl.PACK_ROW_LENGTH, packRowLength);
      }
      if (packSkipPixels) {
        gl.pixelStorei(gl.PACK_SKIP_PIXELS, packSkipPixels);
      }
      if (packSkipRows) {
        gl.pixelStorei(gl.PACK_SKIP_ROWS, packSkipRows);
      }
      if (unpackRowLength) {
        gl.pixelStorei(gl.UNPACK_ROW_LENGTH, unpackRowLength);
      }
      if (unpackImageHeight) {
        gl.pixelStorei(gl.UNPACK_IMAGE_HEIGHT, unpackImageHeight);
      }
      if (unpackSkipPixels) {
        gl.pixelStorei(gl.UNPACK_SKIP_PIXELS, unpackSkipPixels);
      }
      if (unpackSkipRows) {
        gl.pixelStorei(gl.UNPACK_SKIP_ROWS, unpackSkipRows);
      }
      if (unpackSkipImages) {
        gl.pixelStorei(gl.UNPACK_SKIP_IMAGES, unpackSkipImages);
      }

      gl.bindTexture(this.target, null);
      return this;
    }
    /* eslint-enable complexity, max-statements */

    /**
     * Batch update sampler settings
     *
     * @param {GLenum} magFilter - texture magnification filter.
     * @param {GLenum} minFilter - texture minification filter
     * @param {GLenum} wrapS - texture wrapping function for texture coordinate s.
     * @param {GLenum} wrapT - texture wrapping function for texture coordinate t.
     * WEBGL2 only:
     * @param {GLenum} wrapR - texture wrapping function for texture coordinate r.
     * @param {GLenum} compareFunc - texture comparison function.
     * @param {GLenum} compareMode - texture comparison mode.
     * @param {GLfloat} minLOD - minimum level-of-detail value.
     * @param {GLfloat} maxLOD - maximum level-of-detail value.
     * @param {GLfloat} baseLevel - Texture mipmap level
     * @param {GLfloat} maxLevel - Maximum texture mipmap array level
     */
    /* eslint-disable complexity, max-statements */

  }, {
    key: 'setParameters',
    value: function setParameters(_ref3) {
      var magFilter = _ref3.magFilter,
          minFilter = _ref3.minFilter,
          wrapS = _ref3.wrapS,
          wrapT = _ref3.wrapT,
          wrapR = _ref3.wrapR,
          baseLevel = _ref3.baseLevel,
          maxLevel = _ref3.maxLevel,
          minLOD = _ref3.minLOD,
          maxLOD = _ref3.maxLOD,
          compareFunc = _ref3.compareFunc,
          compareMode = _ref3.compareMode;
      var gl = this.gl;

      gl.bindTexture(this.target, this.handle);

      if (magFilter) {
        gl.texParameteri(this.target, gl.TEXTURE_MAG_FILTER, magFilter);
      }
      if (minFilter) {
        gl.texParameteri(this.target, gl.TEXTURE_MIN_FILTER, minFilter);
      }
      if (wrapS) {
        gl.texParameteri(this.target, gl.TEXTURE_WRAP_S, wrapS);
      }
      if (wrapT) {
        gl.texParameteri(this.target, gl.TEXTURE_WRAP_T, wrapT);
      }
      // WEBGL2
      if (wrapR) {
        gl.texParameteri(this.target, gl.TEXTURE_WRAP_R, wrapR);
      }
      if (baseLevel) {
        gl.texParameteri(this.target, gl.TEXTURE_BASE_LEVEL, baseLevel);
      }
      if (maxLevel) {
        gl.texParameteri(this.target, gl.TEXTURE_MAX_LEVEL, maxLevel);
      }
      if (compareFunc) {
        gl.texParameteri(this.target, gl.TEXTURE_COMPARE_FUNC, compareFunc);
      }
      if (compareMode) {
        gl.texParameteri(this.target, gl.TEXTURE_COMPARE_MODE, compareMode);
      }
      if (minLOD) {
        gl.texParameterf(this.target, gl.TEXTURE_MIN_LOD, minLOD);
      }
      if (maxLOD) {
        gl.texParameterf(this.target, gl.TEXTURE_MAX_LOD, maxLOD);
      }

      gl.bindTexture(this.target, null);
      return this;
    }
    /* eslint-enable complexity, max-statements */

  }, {
    key: 'getParameters',
    value: function getParameters() {
      var gl = this.gl;

      gl.bindTexture(this.target, this.handle);
      var webglParams = {
        magFilter: gl.getTexParameter(this.target, gl.TEXTURE_MAG_FILTER),
        minFilter: gl.getTexParameter(this.target, gl.TEXTURE_MIN_FILTER),
        wrapS: gl.getTexParameter(this.target, gl.TEXTURE_WRAP_S),
        wrapT: gl.getTexParameter(this.target, gl.TEXTURE_WRAP_T)
      };
      gl.bindTexture(this.target, null);
      return webglParams;
    }

    // Deprecated methods

  }, {
    key: 'image2D',
    value: function image2D(_ref4) {
      var pixels = _ref4.pixels,
          _ref4$format = _ref4.format,
          format = _ref4$format === undefined ? GL.RGBA : _ref4$format,
          _ref4$type = _ref4.type,
          type = _ref4$type === undefined ? GL.UNSIGNED_BYTE : _ref4$type;

      // TODO - WebGL2 check?
      if (type === GL.FLOAT && !this.hasFloatTexture) {
        throw new Error('floating point textures are not supported.');
      }

      this.gl.bindTexture(this.target, this.handle);
      this.gl.texImage2D(GL.TEXTURE_2D, 0, format, format, type, pixels);
      this.gl.bindTexture(this.target, null);
      return this;
    }
  }, {
    key: 'update',
    value: function update(opts) {
      throw new Error('Texture.update() is deprecated()');
    }
  }]);

  return Texture;
}();

export { Texture as default };
//# sourceMappingURL=data:application/json;base64,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