var _UNIFORM_BASE_DESCRIP;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { GL } from './webgl';
import Texture from './texture';
import { formatValue } from '../utils';
import assert from 'assert';

// TODO - use tables to reduce complexity of method below
/* eslint-disable max-len */
var UNIFORM_BASE_DESCRIPTORS = (_UNIFORM_BASE_DESCRIP = {}, _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT, { function: 'uniform1f', type: Float32Array }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.INT, { function: 'uniform1i', type: Uint16Array }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.BOOL, { function: 'uniform1i', type: Uint16Array }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT_VEC2, { function: 'uniform2fv', type: Float32Array, elements: 2 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT_VEC3, { function: 'uniform3fv', type: Float32Array, elements: 3 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT_VEC4, { function: 'uniform4fv', type: Float32Array, elements: 4 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.INT_VEC2, { function: 'uniform2iv', type: Uint16Array, elements: 2 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.INT_VEC3, { function: 'uniform3iv', type: Uint16Array, elements: 3 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.INT_VEC4, { function: 'uniform4iv', type: Uint16Array, elements: 4 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.BOOL_VEC2, { function: 'uniform2iv', type: Uint16Array, elements: 2 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.BOOL_VEC3, { function: 'uniform3fv', type: Uint16Array, elements: 3 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.BOOL_VEC4, { function: 'uniform4iv', type: Uint16Array, elements: 4 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT_MAT2, { function: 'uniformMatrix2fv', type: Float32Array, matrix: true, elements: 4 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT_MAT3, { mfunction: 'uniformMatrix3fv', type: Float32Array, matrix: true, elements: 9 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.FLOAT_MAT4, { function: 'uniformMatrix4fv', type: Float32Array, matrix: true, elements: 16 }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.SAMPLER_2D, { function: 'uniform1i', type: Uint16Array, texture: true }), _defineProperty(_UNIFORM_BASE_DESCRIP, GL.SAMPLER_CUBE, { function: 'uniform1i', type: Uint16Array, texture: true }), _UNIFORM_BASE_DESCRIP);
/* eslint-enable max-len */

export function parseUniformName(name) {
  // name = name[name.length - 1] === ']' ?
  // name.substr(0, name.length - 3) : name;

  // if array name then clean the array brackets
  var UNIFORM_NAME_REGEXP = /([^\[]*)(\[[0-9]+\])?/;
  var matches = name.match(UNIFORM_NAME_REGEXP);
  if (!matches || matches.length < 2) {
    throw new Error('Failed to parse GLSL uniform name ' + name);
  }

  return {
    name: matches[1],
    length: matches[2] || 1,
    isArray: Boolean(matches[2])
  };
}

// Returns a Magic Uniform Setter
/* eslint-disable complexity */
export function getUniformSetter(gl, location, info) {
  var descriptor = UNIFORM_BASE_DESCRIPTORS[info.type];
  if (!descriptor) {
    throw new Error('Unknown GLSL uniform type ' + info.type);
  }

  var glFunction = gl[descriptor.function].bind(gl);
  var TypedArray = descriptor.type;

  // How many data elements does app need to provide
  var flatArrayLength = info.size * (descriptor.elements || 1);

  // console.log('getSetter', location, info, flatArrayLength);

  // Set a uniform array
  var setter = void 0;
  if (flatArrayLength > 1) {
    setter = function setter(val) {
      if (!(val instanceof TypedArray)) {
        var typedArray = new TypedArray(flatArrayLength);
        typedArray.set(val);
        val = typedArray;
      }
      assert(val.length === flatArrayLength);
      if (descriptor.matrix) {
        // Second param: whether to transpose the matrix. Must be false.
        glFunction(location, false, val);
      } else {
        glFunction(location, val);
      }
    };
  } else {
    setter = function setter(val) {
      return glFunction(location, val);
    };
  }

  // Set a primitive-valued uniform
  return setter;
}

// Basic checks of uniform values without knowledge of program
// To facilitate early detection of e.g. undefined values in JavaScript
export function checkUniformValues(uniforms, source) {
  for (var uniformName in uniforms) {
    var value = uniforms[uniformName];
    if (!checkUniformValue(value)) {
      // Add space to source
      source = source ? source + ' ' : '';
      /* eslint-disable no-console */
      /* global console */
      // Value could be unprintable so write the object on console
      console.error(source + ' Bad uniform ' + uniformName, value);
      /* eslint-enable no-console */
      throw new Error(source + ' Bad uniform ' + uniformName);
    }
  }
  return true;
}

function checkUniformValue(value) {
  var ok = true;

  // Test for texture (for sampler uniforms)
  // WebGL2: if (value instanceof Texture || value instanceof Sampler) {
  if (value instanceof Texture) {
    ok = true;
    // Check that every element in array is a number, and at least 1 element
  } else if (Array.isArray(value)) {
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = value[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var element = _step.value;

        if (!isFinite(element)) {
          ok = false;
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    ok = ok && value.length > 0;
    // Typed arrays can only contain numbers, but check length
  } else if (ArrayBuffer.isView(value)) {
    ok = value.length > 0;
    // Check that single value is a number
  } else if (!isFinite(value)) {
    ok = false;
  }

  return ok;
}

// Prepares a table suitable for console.table
/* eslint-disable max-statements */
export function getUniformsTable() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$header = _ref.header,
      header = _ref$header === undefined ? 'Uniforms' : _ref$header,
      program = _ref.program,
      uniforms = _ref.uniforms;

  assert(program);

  var uniformLocations = program._uniformSetters;
  var table = _defineProperty({}, header, {});

  // Add program's provided uniforms
  for (var uniformName in uniformLocations) {
    var uniform = uniforms[uniformName];
    if (uniform !== undefined) {
      table[uniformName] = {
        Type: uniform,
        Value: formatValue(uniform)
      };
    }
  }

  // Add program's unprovided uniforms
  for (var _uniformName in uniformLocations) {
    var _uniform = uniforms[_uniformName];
    if (_uniform === undefined) {
      table[_uniformName] = {
        Type: 'NOT PROVIDED',
        Value: 'N/A'
      };
    }
  }

  var unusedTable = {};
  var unusedCount = 0;

  // List any unused uniforms
  for (var _uniformName2 in uniforms) {
    var _uniform2 = uniforms[_uniformName2];
    if (!table[_uniformName2]) {
      unusedCount++;
      unusedTable[_uniformName2] = {
        Type: 'NOT USED: ' + _uniform2,
        Value: formatValue(_uniform2)
      };
    }
  }

  return { table: table, unusedTable: unusedTable, unusedCount: unusedCount };
}

/*
  if (vector) {
    switch (type) {
    case GL.FLOAT:
      glFunction = gl.uniform1f;
      break;
    case GL.FLOAT_VEC2:
      glFunction = gl.uniform2fv;
      TypedArray = isArray ? Float32Array : new Float32Array(2);
      break;
    case GL.FLOAT_VEC3:
      glFunction = gl.uniform3fv;
      TypedArray = isArray ? Float32Array : new Float32Array(3);
      break;
    case GL.FLOAT_VEC4:
      glFunction = gl.uniform4fv;
      TypedArray = isArray ? Float32Array : new Float32Array(4);
      break;
    case GL.INT:
    case GL.BOOL:
    case GL.SAMPLER_2D:
    case GL.SAMPLER_CUBE:
      glFunction = gl.uniform1i;
      break;
    case GL.INT_VEC2:
    case GL.BOOL_VEC2:
      glFunction = gl.uniform2iv;
      TypedArray = isArray ? Uint16Array : new Uint16Array(2);
      break;
    case GL.INT_VEC3:
    case GL.BOOL_VEC3:
      glFunction = gl.uniform3iv;
      TypedArray = isArray ? Uint16Array : new Uint16Array(3);
      break;
    case GL.INT_VEC4:
    case GL.BOOL_VEC4:
      glFunction = gl.uniform4iv;
      TypedArray = isArray ? Uint16Array : new Uint16Array(4);
      break;
    case GL.FLOAT_MAT2:
      matrix = true;
      glFunction = gl.uniformMatrix2fv;
      break;
    case GL.FLOAT_MAT3:
      matrix = true;
      glFunction = gl.uniformMatrix3fv;
      break;
    case GL.FLOAT_MAT4:
      matrix = true;
      glFunction = gl.uniformMatrix4fv;
      break;
    default:
      break;
    }
  }
*/
//# sourceMappingURL=data:application/json;base64,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