var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// WebGL2 VertexArray Objects Helper
import { WebGL2RenderingContext } from '../webgl/webgl-types';
import { assertWebGLContext } from '../webgl/webgl-checks';
import assert from 'assert';

/* eslint-disable camelcase */
var OES_vertex_array_object = 'OES_vertex_array_object';

var VertexArrayObject = function () {
  _createClass(VertexArrayObject, null, [{
    key: 'isSupported',


    // Returns true if VertexArrayObject is supported by implementation
    value: function isSupported(gl) {
      assertWebGLContext(gl);
      return gl instanceof WebGL2RenderingContext || gl.getExtension('OES_vertex_array_object');
    }

    // Wraps a WebGLVertexArrayObject in a VertexArrayObject

  }, {
    key: 'wrap',
    value: function wrap(gl, object) {
      return object instanceof VertexArrayObject ? object : new VertexArrayObject(gl, { handle: object.handle || object });
    }

    // Create a VertexArrayObject

  }]);

  function VertexArrayObject(gl) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        handle = _ref.handle;

    _classCallCheck(this, VertexArrayObject);

    assertWebGLContext(gl);
    assert(VertexArrayObject.isSupported(gl), 'VertexArrayObject: WebGL2 or OES_vertex_array_object required');

    handle = handle || createVertexArray(gl);
    // TODO isVertexArray fails when using extension for some reason
    // if (!isVertexArray(gl, handle)) {
    if (!handle) {
      throw new Error('Could not create VertexArrayObject');
    }

    this.gl = gl;
    this.handle = handle;
    this.userData = {};
    Object.seal(this);
  }

  _createClass(VertexArrayObject, [{
    key: 'delete',
    value: function _delete() {
      deleteVertexArray(this.gl, this.handle);
      return this;
    }
  }, {
    key: 'bind',
    value: function bind() {
      bindVertexArray(this.gl, this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      bindVertexArray(this.gl, null);
      return this;
    }
  }]);

  return VertexArrayObject;
}();

export { VertexArrayObject as default };


function createVertexArray(gl) {
  if (gl instanceof WebGL2RenderingContext) {
    return gl.createVertexArray();
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    return ext.createVertexArrayOES();
  }
  return null;
}

function deleteVertexArray(gl, vertexArray) {
  if (gl instanceof WebGL2RenderingContext) {
    gl.deleteVertexArray(vertexArray);
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    ext.deleteVertexArrayOES(vertexArray);
  }
}

export function isVertexArray(gl, vertexArray) {
  if (gl instanceof WebGL2RenderingContext) {
    return gl.isVertexArray(vertexArray);
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    return ext.isVertexArrayOES(vertexArray);
  }
  return false;
}

function bindVertexArray(gl, vertexArray) {
  if (gl instanceof WebGL2RenderingContext) {
    gl.bindVertexArray(vertexArray);
  }
  var ext = gl.getExtension(OES_vertex_array_object);
  if (ext) {
    ext.bindVertexArrayOES(vertexArray);
  }
}
//# sourceMappingURL=data:application/json;base64,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