import GL from './webgl-constants';

// TYPED ARRAYS

export function glTypeFromArray(arrayOrType) {
  // If typed array, look up type name
  var type = ArrayBuffer.isView(arrayOrType) ? arrayOrType.constructor : arrayOrType;

  switch (type) {
    case Float32Array:
      return GL.FLOAT;
    case Uint16Array:
      return GL.UNSIGNED_SHORT;
    case Uint32Array:
      return GL.UNSIGNED_INT;
    case Uint8Array:
      return GL.UNSIGNED_BYTE;
    case Uint8ClampedArray:
      return GL.UNSIGNED_BYTE;
    case Int8Array:
      return GL.BYTE;
    case Int16Array:
      return GL.SHORT;
    case Int32Array:
      return GL.INT;
    default:
      throw new Error('Failed to deduce type from array/array type');
  }
}

/* eslint-disable complexity */
export function glTypeToArray(glType) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$clamped = _ref.clamped,
      clamped = _ref$clamped === undefined ? true : _ref$clamped;

  // Sorted in some order of likelihood to reduce amount of comparisons
  switch (glType) {
    case GL.FLOAT:
      return Float32Array;
    case GL.UNSIGNED_SHORT:
    case GL.UNSIGNED_SHORT_5_6_5:
    case GL.UNSIGNED_SHORT_4_4_4_4:
    case GL.UNSIGNED_SHORT_5_5_5_1:
      return Uint16Array;
    case GL.UNSIGNED_INT:
      return Uint32Array;
    case GL.UNSIGNED_BYTE:
      return clamped ? Uint8ClampedArray : Uint8Array;
    case GL.BYTE:
      return Int8Array;
    case GL.SHORT:
      return Int16Array;
    case GL.INT:
      return Int32Array;
    default:
      throw new Error('Failed to deduce type from array');
  }
}
/* eslint-enable complexity */

// Deprecated
export { glTypeToArray as glArrayFromType };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWJnbC93ZWJnbC1hcnJheXMuanMiXSwibmFtZXMiOlsiR0wiLCJnbFR5cGVGcm9tQXJyYXkiLCJhcnJheU9yVHlwZSIsInR5cGUiLCJBcnJheUJ1ZmZlciIsImlzVmlldyIsImNvbnN0cnVjdG9yIiwiRmxvYXQzMkFycmF5IiwiRkxPQVQiLCJVaW50MTZBcnJheSIsIlVOU0lHTkVEX1NIT1JUIiwiVWludDMyQXJyYXkiLCJVTlNJR05FRF9JTlQiLCJVaW50OEFycmF5IiwiVU5TSUdORURfQllURSIsIlVpbnQ4Q2xhbXBlZEFycmF5IiwiSW50OEFycmF5IiwiQllURSIsIkludDE2QXJyYXkiLCJTSE9SVCIsIkludDMyQXJyYXkiLCJJTlQiLCJFcnJvciIsImdsVHlwZVRvQXJyYXkiLCJnbFR5cGUiLCJjbGFtcGVkIiwiVU5TSUdORURfU0hPUlRfNV82XzUiLCJVTlNJR05FRF9TSE9SVF80XzRfNF80IiwiVU5TSUdORURfU0hPUlRfNV81XzVfMSIsImdsQXJyYXlGcm9tVHlwZSJdLCJtYXBwaW5ncyI6IkFBQUEsT0FBT0EsRUFBUCxNQUFlLG1CQUFmOztBQUVBOztBQUVBLE9BQU8sU0FBU0MsZUFBVCxDQUF5QkMsV0FBekIsRUFBc0M7QUFDM0M7QUFDQSxNQUFNQyxPQUFPQyxZQUFZQyxNQUFaLENBQW1CSCxXQUFuQixJQUNYQSxZQUFZSSxXQURELEdBRVhKLFdBRkY7O0FBSUEsVUFBUUMsSUFBUjtBQUNBLFNBQUtJLFlBQUw7QUFBbUIsYUFBT1AsR0FBR1EsS0FBVjtBQUNuQixTQUFLQyxXQUFMO0FBQWtCLGFBQU9ULEdBQUdVLGNBQVY7QUFDbEIsU0FBS0MsV0FBTDtBQUFrQixhQUFPWCxHQUFHWSxZQUFWO0FBQ2xCLFNBQUtDLFVBQUw7QUFBaUIsYUFBT2IsR0FBR2MsYUFBVjtBQUNqQixTQUFLQyxpQkFBTDtBQUF3QixhQUFPZixHQUFHYyxhQUFWO0FBQ3hCLFNBQUtFLFNBQUw7QUFBZ0IsYUFBT2hCLEdBQUdpQixJQUFWO0FBQ2hCLFNBQUtDLFVBQUw7QUFBaUIsYUFBT2xCLEdBQUdtQixLQUFWO0FBQ2pCLFNBQUtDLFVBQUw7QUFBaUIsYUFBT3BCLEdBQUdxQixHQUFWO0FBQ2pCO0FBQ0UsWUFBTSxJQUFJQyxLQUFKLENBQVUsNkNBQVYsQ0FBTjtBQVZGO0FBWUQ7O0FBRUQ7QUFDQSxPQUFPLFNBQVNDLGFBQVQsQ0FBdUJDLE1BQXZCLEVBQXNEO0FBQUEsaUZBQUosRUFBSTtBQUFBLDBCQUF0QkMsT0FBc0I7QUFBQSxNQUF0QkEsT0FBc0IsZ0NBQVosSUFBWTs7QUFDM0Q7QUFDQSxVQUFRRCxNQUFSO0FBQ0EsU0FBS3hCLEdBQUdRLEtBQVI7QUFDRSxhQUFPRCxZQUFQO0FBQ0YsU0FBS1AsR0FBR1UsY0FBUjtBQUNBLFNBQUtWLEdBQUcwQixvQkFBUjtBQUNBLFNBQUsxQixHQUFHMkIsc0JBQVI7QUFDQSxTQUFLM0IsR0FBRzRCLHNCQUFSO0FBQ0UsYUFBT25CLFdBQVA7QUFDRixTQUFLVCxHQUFHWSxZQUFSO0FBQ0UsYUFBT0QsV0FBUDtBQUNGLFNBQUtYLEdBQUdjLGFBQVI7QUFDRSxhQUFPVyxVQUFVVixpQkFBVixHQUE4QkYsVUFBckM7QUFDRixTQUFLYixHQUFHaUIsSUFBUjtBQUNFLGFBQU9ELFNBQVA7QUFDRixTQUFLaEIsR0FBR21CLEtBQVI7QUFDRSxhQUFPRCxVQUFQO0FBQ0YsU0FBS2xCLEdBQUdxQixHQUFSO0FBQ0UsYUFBT0QsVUFBUDtBQUNGO0FBQ0UsWUFBTSxJQUFJRSxLQUFKLENBQVUsa0NBQVYsQ0FBTjtBQW5CRjtBQXFCRDtBQUNEOztBQUVBO0FBQ0EsU0FBUUMsaUJBQWlCTSxlQUF6QiIsImZpbGUiOiJ3ZWJnbC1hcnJheXMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgR0wgZnJvbSAnLi93ZWJnbC1jb25zdGFudHMnO1xuXG4vLyBUWVBFRCBBUlJBWVNcblxuZXhwb3J0IGZ1bmN0aW9uIGdsVHlwZUZyb21BcnJheShhcnJheU9yVHlwZSkge1xuICAvLyBJZiB0eXBlZCBhcnJheSwgbG9vayB1cCB0eXBlIG5hbWVcbiAgY29uc3QgdHlwZSA9IEFycmF5QnVmZmVyLmlzVmlldyhhcnJheU9yVHlwZSkgP1xuICAgIGFycmF5T3JUeXBlLmNvbnN0cnVjdG9yIDpcbiAgICBhcnJheU9yVHlwZTtcblxuICBzd2l0Y2ggKHR5cGUpIHtcbiAgY2FzZSBGbG9hdDMyQXJyYXk6IHJldHVybiBHTC5GTE9BVDtcbiAgY2FzZSBVaW50MTZBcnJheTogcmV0dXJuIEdMLlVOU0lHTkVEX1NIT1JUO1xuICBjYXNlIFVpbnQzMkFycmF5OiByZXR1cm4gR0wuVU5TSUdORURfSU5UO1xuICBjYXNlIFVpbnQ4QXJyYXk6IHJldHVybiBHTC5VTlNJR05FRF9CWVRFO1xuICBjYXNlIFVpbnQ4Q2xhbXBlZEFycmF5OiByZXR1cm4gR0wuVU5TSUdORURfQllURTtcbiAgY2FzZSBJbnQ4QXJyYXk6IHJldHVybiBHTC5CWVRFO1xuICBjYXNlIEludDE2QXJyYXk6IHJldHVybiBHTC5TSE9SVDtcbiAgY2FzZSBJbnQzMkFycmF5OiByZXR1cm4gR0wuSU5UO1xuICBkZWZhdWx0OlxuICAgIHRocm93IG5ldyBFcnJvcignRmFpbGVkIHRvIGRlZHVjZSB0eXBlIGZyb20gYXJyYXkvYXJyYXkgdHlwZScpO1xuICB9XG59XG5cbi8qIGVzbGludC1kaXNhYmxlIGNvbXBsZXhpdHkgKi9cbmV4cG9ydCBmdW5jdGlvbiBnbFR5cGVUb0FycmF5KGdsVHlwZSwge2NsYW1wZWQgPSB0cnVlfSA9IHt9KSB7XG4gIC8vIFNvcnRlZCBpbiBzb21lIG9yZGVyIG9mIGxpa2VsaWhvb2QgdG8gcmVkdWNlIGFtb3VudCBvZiBjb21wYXJpc29uc1xuICBzd2l0Y2ggKGdsVHlwZSkge1xuICBjYXNlIEdMLkZMT0FUOlxuICAgIHJldHVybiBGbG9hdDMyQXJyYXk7XG4gIGNhc2UgR0wuVU5TSUdORURfU0hPUlQ6XG4gIGNhc2UgR0wuVU5TSUdORURfU0hPUlRfNV82XzU6XG4gIGNhc2UgR0wuVU5TSUdORURfU0hPUlRfNF80XzRfNDpcbiAgY2FzZSBHTC5VTlNJR05FRF9TSE9SVF81XzVfNV8xOlxuICAgIHJldHVybiBVaW50MTZBcnJheTtcbiAgY2FzZSBHTC5VTlNJR05FRF9JTlQ6XG4gICAgcmV0dXJuIFVpbnQzMkFycmF5O1xuICBjYXNlIEdMLlVOU0lHTkVEX0JZVEU6XG4gICAgcmV0dXJuIGNsYW1wZWQgPyBVaW50OENsYW1wZWRBcnJheSA6IFVpbnQ4QXJyYXk7XG4gIGNhc2UgR0wuQllURTpcbiAgICByZXR1cm4gSW50OEFycmF5O1xuICBjYXNlIEdMLlNIT1JUOlxuICAgIHJldHVybiBJbnQxNkFycmF5O1xuICBjYXNlIEdMLklOVDpcbiAgICByZXR1cm4gSW50MzJBcnJheTtcbiAgZGVmYXVsdDpcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ0ZhaWxlZCB0byBkZWR1Y2UgdHlwZSBmcm9tIGFycmF5Jyk7XG4gIH1cbn1cbi8qIGVzbGludC1lbmFibGUgY29tcGxleGl0eSAqL1xuXG4vLyBEZXByZWNhdGVkXG5leHBvcnQge2dsVHlwZVRvQXJyYXkgYXMgZ2xBcnJheUZyb21UeXBlfTtcbiJdfQ==