function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// WEBGL BUILT-IN TYPES
// 1) Exports all WebGL constants as {GL}
// 2) Enables app to "import" WebGL types
//    - Importing these types makes them known to eslint etc.
//    - Provides dummy types for WebGL2 when not available to streamline
//      library code.
//    - Exports types from headless gl when running under Node.js

import luma, { global } from '../init';

var DummyType = function DummyType() {
  _classCallCheck(this, DummyType);
};

var _ref = luma.globals.headlessTypes || global,
    _ref$WebGLRenderingCo = _ref.WebGLRenderingContext,
    WebGLRenderingContext = _ref$WebGLRenderingCo === undefined ? DummyType : _ref$WebGLRenderingCo,
    _ref$WebGLProgram = _ref.WebGLProgram,
    WebGLProgram = _ref$WebGLProgram === undefined ? DummyType : _ref$WebGLProgram,
    _ref$WebGLShader = _ref.WebGLShader,
    WebGLShader = _ref$WebGLShader === undefined ? DummyType : _ref$WebGLShader,
    _ref$WebGLBuffer = _ref.WebGLBuffer,
    WebGLBuffer = _ref$WebGLBuffer === undefined ? DummyType : _ref$WebGLBuffer,
    _ref$WebGLFramebuffer = _ref.WebGLFramebuffer,
    WebGLFramebuffer = _ref$WebGLFramebuffer === undefined ? DummyType : _ref$WebGLFramebuffer,
    _ref$WebGLRenderbuffe = _ref.WebGLRenderbuffer,
    WebGLRenderbuffer = _ref$WebGLRenderbuffe === undefined ? DummyType : _ref$WebGLRenderbuffe,
    _ref$WebGLTexture = _ref.WebGLTexture,
    WebGLTexture = _ref$WebGLTexture === undefined ? DummyType : _ref$WebGLTexture,
    _ref$WebGLUniformLoca = _ref.WebGLUniformLocation,
    WebGLUniformLocation = _ref$WebGLUniformLoca === undefined ? DummyType : _ref$WebGLUniformLoca,
    _ref$WebGLActiveInfo = _ref.WebGLActiveInfo,
    WebGLActiveInfo = _ref$WebGLActiveInfo === undefined ? DummyType : _ref$WebGLActiveInfo,
    _ref$WebGLShaderPreci = _ref.WebGLShaderPrecisionFormat,
    WebGLShaderPrecisionFormat = _ref$WebGLShaderPreci === undefined ? DummyType : _ref$WebGLShaderPreci;

export var webGLTypesAvailable = WebGLRenderingContext !== DummyType && WebGLProgram !== DummyType && WebGLShader !== DummyType && WebGLBuffer !== DummyType && WebGLFramebuffer !== DummyType && WebGLRenderbuffer !== DummyType && WebGLTexture !== DummyType && WebGLUniformLocation !== DummyType && WebGLActiveInfo !== DummyType && WebGLShaderPrecisionFormat !== DummyType;

// Ensures that WebGL2RenderingContext is defined in non-WebGL2 environments
// so that apps can test their gl contexts with instanceof
// E.g. if (gl instanceof WebGL2RenderingContext) { }
function getWebGL2RenderingContext() {
  var WebGL2RenderingContextNotSupported = function WebGL2RenderingContextNotSupported() {
    _classCallCheck(this, WebGL2RenderingContextNotSupported);
  };

  return global.WebGL2RenderingContext || WebGL2RenderingContextNotSupported;
}

// Ensure that Image is defined under Node.js
function getImage() {
  var ImageNotSupported = function ImageNotSupported() {
    _classCallCheck(this, ImageNotSupported);
  };

  return global.Image || ImageNotSupported;
}

var WebGL2RenderingContext = getWebGL2RenderingContext();
var Image = getImage();

// Export the standard WebGL types
export { Image, WebGLRenderingContext, WebGLProgram, WebGLShader, WebGLBuffer, WebGLFramebuffer, WebGLRenderbuffer, WebGLTexture, WebGLUniformLocation, WebGLActiveInfo, WebGLShaderPrecisionFormat, WebGL2RenderingContext };
//# sourceMappingURL=data:application/json;base64,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