'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHTMLTemplate = getHTMLTemplate;
exports.getShadersFromHTML = getShadersFromHTML;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* global document */

function getHTMLTemplate(id) {
  return document.getElementById(id).innerHTML;
}

function getShadersFromHTML(_ref) {
  var vs = _ref.vs,
      fs = _ref.fs,
      id = _ref.id;

  (0, _assert2.default)(vs);
  (0, _assert2.default)(fs);
  return {
    id: id,
    vs: getHTMLTemplate(vs),
    fs: getHTMLTemplate(fs)
  };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hZGRvbnMvaGVscGVycy5qcyJdLCJuYW1lcyI6WyJnZXRIVE1MVGVtcGxhdGUiLCJnZXRTaGFkZXJzRnJvbUhUTUwiLCJpZCIsImRvY3VtZW50IiwiZ2V0RWxlbWVudEJ5SWQiLCJpbm5lckhUTUwiLCJ2cyIsImZzIl0sIm1hcHBpbmdzIjoiOzs7OztRQUdnQkEsZSxHQUFBQSxlO1FBSUFDLGtCLEdBQUFBLGtCOztBQVBoQjs7Ozs7O0FBQ0E7O0FBRU8sU0FBU0QsZUFBVCxDQUF5QkUsRUFBekIsRUFBNkI7QUFDbEMsU0FBT0MsU0FBU0MsY0FBVCxDQUF3QkYsRUFBeEIsRUFBNEJHLFNBQW5DO0FBQ0Q7O0FBRU0sU0FBU0osa0JBQVQsT0FBMEM7QUFBQSxNQUFiSyxFQUFhLFFBQWJBLEVBQWE7QUFBQSxNQUFUQyxFQUFTLFFBQVRBLEVBQVM7QUFBQSxNQUFMTCxFQUFLLFFBQUxBLEVBQUs7O0FBQy9DLHdCQUFPSSxFQUFQO0FBQ0Esd0JBQU9DLEVBQVA7QUFDQSxTQUFPO0FBQ0xMLFVBREs7QUFFTEksUUFBSU4sZ0JBQWdCTSxFQUFoQixDQUZDO0FBR0xDLFFBQUlQLGdCQUFnQk8sRUFBaEI7QUFIQyxHQUFQO0FBS0QiLCJmaWxlIjoiaGVscGVycy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBhc3NlcnQgZnJvbSAnYXNzZXJ0Jztcbi8qIGdsb2JhbCBkb2N1bWVudCAqL1xuXG5leHBvcnQgZnVuY3Rpb24gZ2V0SFRNTFRlbXBsYXRlKGlkKSB7XG4gIHJldHVybiBkb2N1bWVudC5nZXRFbGVtZW50QnlJZChpZCkuaW5uZXJIVE1MO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2V0U2hhZGVyc0Zyb21IVE1MKHt2cywgZnMsIGlkfSkge1xuICBhc3NlcnQodnMpO1xuICBhc3NlcnQoZnMpO1xuICByZXR1cm4ge1xuICAgIGlkLFxuICAgIHZzOiBnZXRIVE1MVGVtcGxhdGUodnMpLFxuICAgIGZzOiBnZXRIVE1MVGVtcGxhdGUoZnMpXG4gIH07XG59XG4iXX0=