'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postProcessImage = postProcessImage;

var _webgl = require('../webgl');

var _models = require('../models');

var _camera = require('../core/camera');

var _scenegraph = require('../deprecated/scenegraph');

var _scenegraph2 = _interopRequireDefault(_scenegraph);

var _utils = require('../utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// length given a 45 fov angle, and 0.2 distance to camera
var length = 0.16568542494923805; // media has utility functions for image, video and audio manipulation (and
// maybe others like device, etc).

/* eslint-disable */ // TODO - this file needs cleanup

var camera = new _camera.PerspectiveCamera({
  fov: 45,
  aspect: 1,
  near: 0.1,
  far: 500,
  position: [0, 0, 0.2]
});

// post process an image by setting it to a texture with a specified fragment
// and vertex shader.
function postProcessImage() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      program = _ref.program,
      fromTexture = _ref.fromTexture,
      toFrameBuffer = _ref.toFrameBuffer,
      toScreen = _ref.toScreen,
      width = _ref.width,
      height = _ref.height,
      _ref$viewportX = _ref.viewportX,
      viewportX = _ref$viewportX === undefined ? 0 : _ref$viewportX,
      _ref$viewportY = _ref.viewportY,
      viewportY = _ref$viewportY === undefined ? 0 : _ref$viewportY,
      _ref$aspectRatio = _ref.aspectRatio,
      aspectRatio = _ref$aspectRatio === undefined ? Math.max(height / width, width / height) : _ref$aspectRatio;

  var textures = opt.fromTexture ? (0, _utils.splat)(opt.fromTexture) : [];
  var framebuffer = opt.toFrameBuffer;
  var screen = !!opt.toScreen;
  var width = opt.width || app.canvas.width;
  var height = opt.height || app.canvas.height;
  var x = opt.viewportX;
  var y = opt.viewportY;

  var plane = new _models.Plane({
    program: program,
    type: 'x,y',
    xlen: length,
    ylen: length,
    offset: 0
  });
  plane.textures = textures;
  plane.program = program;

  camera.aspect = opt.aspectRatio;
  camera.update();

  var scene = new _scenegraph2.default(app, program, camera);
  scene.program = program;

  if (!scene.models.length) {
    scene.add(plane);
  }

  var fbo = new FrameBuffer(framebuffer, {
    width: width,
    height: height,
    bindToTexture: {
      parameters: [{
        name: 'TEXTURE_MAG_FILTER',
        value: 'LINEAR'
      }, {
        name: 'TEXTURE_MIN_FILTER',
        value: 'LINEAR',
        generateMipmap: false
      }]
    },
    bindToRenderBuffer: false
  });

  fbo.bind();
  gl.viewport(x, y, width, height);
  gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
  program.setUniforms(opt.uniforms || {});
  scene.renderToTexture(framebuffer);
  app.setFrameBuffer(framebuffer, false);

  if (screen) {
    program.use();
    gl.viewport(x, y, width, height);
    gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
    program.setUniforms(opt.uniforms || {});
    scene.render();
  }

  return this;
}
//# sourceMappingURL=data:application/json;base64,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