'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.cancelAnimationFrame = exports.requestAnimationFrame = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* global window, setTimeout, clearTimeout */


var _utils = require('../utils');

var _webglChecks = require('../webgl/webgl-checks');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Node.js polyfills for requestAnimationFrame and cancelAnimationFrame
var requestAnimationFrame = exports.requestAnimationFrame = function requestAnimationFrame(callback) {
  return _utils.isBrowser ? window.requestAnimationFrame(callback) : setTimeout(callback, 1000 / 60);
};

var cancelAnimationFrame = exports.cancelAnimationFrame = function cancelAnimationFrame(timerId) {
  return _utils.isBrowser ? window.cancelAnimationFrame(timerId) : clearTimeout(timerId);
};

var AnimationFrame = function () {
  /*
   * @param {HTMLCanvasElement} canvas - if provided, with and height will be
   *   passed to context
   */
  function AnimationFrame() {
    var _this = this;

    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, AnimationFrame);

    var _opts$gl = opts.gl,
        gl = _opts$gl === undefined ? null : _opts$gl,
        _opts$width = opts.width,
        width = _opts$width === undefined ? null : _opts$width,
        _opts$height = opts.height,
        height = _opts$height === undefined ? null : _opts$height,
        _opts$autoResizeViewp = opts.autoResizeViewport,
        autoResizeViewport = _opts$autoResizeViewp === undefined ? true : _opts$autoResizeViewp,
        _opts$autoResizeCanva = opts.autoResizeCanvas,
        autoResizeCanvas = _opts$autoResizeCanva === undefined ? true : _opts$autoResizeCanva,
        _opts$autoResizeDrawi = opts.autoResizeDrawingBuffer,
        autoResizeDrawingBuffer = _opts$autoResizeDrawi === undefined ? true : _opts$autoResizeDrawi,
        _opts$useDevicePixelR = opts.useDevicePixelRatio,
        useDevicePixelRatio = _opts$useDevicePixelR === undefined ? true : _opts$useDevicePixelR;


    this.start = this.start.bind(this);
    this.stop = this.stop.bind(this);
    this._frame = this._frame.bind(this);

    this.update({
      autoResizeViewport: autoResizeViewport,
      autoResizeCanvas: autoResizeCanvas,
      autoResizeDrawingBuffer: autoResizeDrawingBuffer,
      useDevicePixelRatio: useDevicePixelRatio
    });

    this.width = width;
    this.height = height;

    // Don't do a
    this._startPromise = _utils.pageLoadPromise.then(function (page) {
      _this.gl = gl;
      return page;
    });
  }

  _createClass(AnimationFrame, [{
    key: 'update',
    value: function update(_ref) {
      var _ref$autoResizeDrawin = _ref.autoResizeDrawingBuffer,
          autoResizeDrawingBuffer = _ref$autoResizeDrawin === undefined ? true : _ref$autoResizeDrawin,
          _ref$autoResizeCanvas = _ref.autoResizeCanvas,
          autoResizeCanvas = _ref$autoResizeCanvas === undefined ? true : _ref$autoResizeCanvas,
          _ref$autoResizeViewpo = _ref.autoResizeViewport,
          autoResizeViewport = _ref$autoResizeViewpo === undefined ? true : _ref$autoResizeViewpo,
          _ref$useDevicePixelRa = _ref.useDevicePixelRatio,
          useDevicePixelRatio = _ref$useDevicePixelRa === undefined ? true : _ref$useDevicePixelRa;

      this.autoResizeViewport = autoResizeViewport;
      this.autoResizeCanvas = autoResizeCanvas;
      this.autoResizeDrawingBuffer = autoResizeDrawingBuffer;
      this.useDevicePixelRatio = useDevicePixelRatio;
      return this;
    }
  }, {
    key: 'context',
    value: function context(onCreateContext) {
      var _this2 = this;

      if (this.gl) {
        throw new Error('AnimationFrame.context - context already provided');
      }
      this._startPromise = this._startPromise.then(function () {
        _this2.gl = onCreateContext();
        if (!(0, _webglChecks.isWebGLContext)(_this2.gl)) {
          throw new Error('AnimationFrame.context - illegal context returned');
        }
      });
      return this;
    }
  }, {
    key: 'init',
    value: function init(onInit) {
      var _this3 = this;

      this._startPromise = this._startPromise.then(function () {
        if (!_this3.gl) {
          throw new Error('AnimationFrame.context - no context provided');
        }
        _this3._initializeContext();
        return onInit(_this3._context) || {};
      });

      return this;
    }
  }, {
    key: 'setupFrame',
    value: function setupFrame(onSetupFrame) {
      this._onSetupFrame = onSetupFrame;
      return this;
    }

    /**
     * Starts a global render loop with the given frame function
     * @param {Function} onRenderFrame - application frame renderer function
     *  expected to take a context parameter
     * @param {Object} context - contains frame specific info
     *  (E.g. tick, width, height, etc)
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: 'frame',
    value: function frame(onRenderFrame) {
      this._onRenderFrame = onRenderFrame;
      return this;
    }

    /**
     * Starts a render loop if not already running
     */

  }, {
    key: 'start',
    value: function start() {
      var _this4 = this;

      // Wait for start promise before rendering frame
      this._startPromise.then(function () {
        var appContext = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _this4._initializeContext(appContext);
        if (!_this4._animationFrameId) {
          _this4._animationFrameId = requestAnimationFrame(_this4._frame);
        }
      });
      return this;
    }

    /**
     * Stops a render loop if already running
     */

  }, {
    key: 'stop',
    value: function stop() {
      if (this._animationFrameId) {
        cancelAnimationFrame(this._animationFrameId);
        this._animationFrameId = null;
      }
      return this;
    }

    /**
     * Resize canvas in "CSS coordinates" (may be different from device coords)
     * NOTE: No effect on headless contexts
     * @param {Number} width - new width of canvas in CSS coordinates
     * @param {Number} height - new height of canvas in CSS coordinates
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: 'resizeCanvas',
    value: function resizeCanvas(width, height) {
      this._resizeCanvas(width, height);
      return this;
    }

    // PRIVATE METHODS

  }, {
    key: '_initializeContext',
    value: function _initializeContext(appContext) {
      if (!this._context) {
        this._context = {
          gl: this.gl,
          canvas: this.gl.canvas,
          stop: this.stop,
          tick: 0,
          tock: 0
        };
      }
      this._updateContext();
      if ((typeof appContext === 'undefined' ? 'undefined' : _typeof(appContext)) === 'object' && appContext !== null) {
        this._context = Object.assign({}, appContext, this._context);
      }
    }
  }, {
    key: '_updateContext',
    value: function _updateContext() {
      // Context width and height represent drawing buffer width and height
      var canvas = this._context.canvas;

      this._context.width = canvas.width;
      this._context.height = canvas.height;
      this._context.aspect = canvas.width / canvas.height;
    }

    /**
     * @private
     * Handles a render loop frame- updates context and calls the application
     * callback
     */

  }, {
    key: '_frame',
    value: function _frame() {
      var canvas = this._context.canvas;


      if (this._onSetupFrame) {
        this._onSetupFrame(this._context);
      } else {
        this._resizeCanvasDrawingBuffer(canvas);
        // Default viewport setup
        if (this.autoResizeViewport) {
          this.gl.viewport(0, 0, canvas.width, canvas.height);
        }
      }

      this._updateContext();
      this._onRenderFrame(this._context);

      // Increment tick
      this._context.tick++;

      // Request another render frame (now )
      this._animationFrameId = requestAnimationFrame(this._frame);
    }

    /**
     * Resize canvas in "CSS coordinates" (may be different from device coords)
     * NOTE: No effect on headless contexts
     * @param {Number} width - new width of canvas in CSS coordinates
     * @param {Number} height - new height of canvas in CSS coordinates
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: '_resizeCanvas',
    value: function _resizeCanvas(width, height) {
      var canvas = this._context.canvas;

      if (canvas) {
        if (this.autoResizeDrawingBuffer) {
          var cssToDevicePixels = this.useDevicePixelRatio ? window.devicePixelRatio || 1 : 1;

          // Lookup the size the browser is displaying the canvas in CSS pixels
          // and compute a size needed to make our drawingbuffer match it in
          // device pixels.
          var displayWidth = Math.floor(width * cssToDevicePixels);
          var displayHeight = Math.floor(height * cssToDevicePixels);

          // Check if the canvas is not the same size.
          if (canvas.width !== displayWidth || canvas.height !== displayHeight) {
            // Make the canvas the same size
            canvas.width = displayWidth;
            canvas.height = displayHeight;
          }
        }

        canvas.style.width = width + 'px';
        canvas.style.height = height + 'px';
      }
      return this;
    }

    // Resize the render buffer of the canvas to match canvas client size
    // multiplying with dpr (Optionally can be turned off)
    // http://webgl2fundamentals.org/webgl/lessons/webgl-resizing-the-canvas.html

  }, {
    key: '_resizeCanvasDrawingBuffer',
    value: function _resizeCanvasDrawingBuffer() {
      if (this.autoResizeDrawingBuffer) {
        var canvas = this._context.canvas;

        var cssToDevicePixels = this.useDevicePixelRatio ? window.devicePixelRatio || 1 : 1;

        // Lookup the size the browser is displaying the canvas in CSS pixels
        // and compute a size needed to make our drawingbuffer match it in
        // device pixels.
        var oldWidth = window.innerWidth;
        var oldHeight = window.innerHeight;
        var displayWidth = Math.floor(oldWidth * cssToDevicePixels);
        var displayHeight = Math.floor(oldHeight * cssToDevicePixels);

        // Check if the canvas is not the same size.
        if (oldWidth !== displayWidth || oldHeight !== displayHeight) {
          // Make the canvas the same size
          canvas.width = displayWidth;
          canvas.height = displayHeight;
          canvas.style.width = oldWidth;
          canvas.style.height = oldHeight;
        }
      }
    }

    /**
     * Resize canvas drawing buffer
     * NOTE: The drawing buffer will be scaled to the viewport
     * for best visual results, usually set to either:
     *  canvas CSS width x CSS height
     *  canvas CSS width * devicePixelRatio x CSS height * devicePixelRatio
     * TODO - add separate call for headless contexts
     * @param {Number} width - new width of canvas in CSS coordinates
     * @param {Number} height - new height of canvas in CSS coordinates
     * @return {Renderer} - returns self for chaining
     */

  }, {
    key: '_resizeDrawingBuffer',
    value: function _resizeDrawingBuffer(width, height) {
      var canvas = this._context.canvas;

      if (canvas) {
        canvas.width = width;
        canvas.height = height;
        this.autoResizeDrawingBuffer = false;
      }
      return this;
    }
  }]);

  return AnimationFrame;
}();

exports.default = AnimationFrame;
//# sourceMappingURL=data:application/json;base64,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