'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Material = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('../webgl');

var _object3d = require('../deprecated/scenegraph/object-3d');

var _object3d2 = _interopRequireDefault(_object3d);

var _utils = require('../utils');

var _geometry = require('../geometry');

var _shaders = require('../experimental/shaders');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } // A scenegraph object node
/* eslint-disable guard-for-in */

// Define some locals


var MSG_INSTANCED_PARAM_DEPRECATED = 'Warning: Model constructor: parameter "instanced" renamed to "isInstanced".\nThis will become a hard error in a future version of luma.gl.';

var MSG_TEXTURES_PARAM_REMOVED = 'Model: parameter "textures" removed. Use uniforms to set textures';

// TODO - experimental, not yet used

var Material = exports.Material = function Material() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$shininess = _ref.shininess,
      shininess = _ref$shininess === undefined ? 0 : _ref$shininess,
      _ref$reflection = _ref.reflection,
      reflection = _ref$reflection === undefined ? 0 : _ref$reflection,
      _ref$refraction = _ref.refraction,
      refraction = _ref$refraction === undefined ? 0 : _ref$refraction;

  _classCallCheck(this, Material);

  this.shininess = shininess;
  this.reflection = reflection;
  this.refraction = refraction;
};

// Model abstract O3D Class


var Model = function (_Object3D) {
  _inherits(Model, _Object3D);

  function Model(gl) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Model);

    opts = (0, _webgl.isWebGLContext)(gl) ? Object.assign({}, opts, { gl: gl }) : gl;

    var _this = _possibleConstructorReturn(this, (Model.__proto__ || Object.getPrototypeOf(Model)).call(this, opts));

    _this.init(opts);
    return _this;
  }

  /* eslint-disable max-statements  */
  /* eslint-disable complexity  */


  _createClass(Model, [{
    key: 'init',
    value: function init() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          program = _ref2.program,
          _ref2$gl = _ref2.gl,
          gl = _ref2$gl === undefined ? null : _ref2$gl,
          _ref2$vs = _ref2.vs,
          vs = _ref2$vs === undefined ? _shaders.SHADERS.vs : _ref2$vs,
          _ref2$fs = _ref2.fs,
          fs = _ref2$fs === undefined ? _shaders.SHADERS.fs : _ref2$fs,
          defaultUniforms = _ref2.defaultUniforms,
          geometry = _ref2.geometry,
          _ref2$material = _ref2.material,
          material = _ref2$material === undefined ? null : _ref2$material,
          textures = _ref2.textures,
          _ref2$isInstanced = _ref2.isInstanced,
          isInstanced = _ref2$isInstanced === undefined ? false : _ref2$isInstanced,
          instanced = _ref2.instanced,
          _ref2$instanceCount = _ref2.instanceCount,
          instanceCount = _ref2$instanceCount === undefined ? 0 : _ref2$instanceCount,
          _ref2$vertexCount = _ref2.vertexCount,
          vertexCount = _ref2$vertexCount === undefined ? undefined : _ref2$vertexCount,
          _ref2$pickable = _ref2.pickable,
          pickable = _ref2$pickable === undefined ? true : _ref2$pickable,
          _ref2$pick = _ref2.pick,
          pick = _ref2$pick === undefined ? null : _ref2$pick,
          _ref2$uniforms = _ref2.uniforms,
          uniforms = _ref2$uniforms === undefined ? {} : _ref2$uniforms,
          _ref2$attributes = _ref2.attributes,
          attributes = _ref2$attributes === undefined ? {} : _ref2$attributes,
          _ref2$render = _ref2.render,
          render = _ref2$render === undefined ? null : _ref2$render,
          _ref2$onBeforeRender = _ref2.onBeforeRender,
          onBeforeRender = _ref2$onBeforeRender === undefined ? function () {} : _ref2$onBeforeRender,
          _ref2$onAfterRender = _ref2.onAfterRender,
          onAfterRender = _ref2$onAfterRender === undefined ? function () {} : _ref2$onAfterRender,
          _ref2$timerQueryEnabl = _ref2.timerQueryEnabled,
          timerQueryEnabled = _ref2$timerQueryEnabl === undefined ? false : _ref2$timerQueryEnabl;

      // assert(program || program instanceof Program);
      (0, _assert2.default)(geometry instanceof _geometry.Geometry, 'Model needs a geometry');

      // Assign default uniforms if any of the default shaders is being used
      if (vs === _shaders.SHADERS.vs || fs === _shaders.SHADERS.fs && defaultUniforms === undefined) {
        defaultUniforms = _shaders.SHADERS.defaultUniforms;
      }

      // set a custom program per o3d
      this.program = program || new _webgl.Program(gl, { vs: vs, fs: fs });
      (0, _assert2.default)(this.program instanceof _webgl.Program, 'Model needs a program');

      if (instanced) {
        /* global console */
        /* eslint-disable no-console */
        console.warn(MSG_INSTANCED_PARAM_DEPRECATED);
        isInstanced = isInstanced || instanced;
      }

      if (textures) {
        throw new Error(MSG_TEXTURES_PARAM_REMOVED);
      }

      // TODO - remove?
      this.buffers = {};
      this.userData = {};
      this.drawParams = {};
      this.dynamic = false;
      this.needsRedraw = true;

      this.material = material;

      // Attributes and buffers
      this.setGeometry(geometry);
      this.attributes = {};
      this.setAttributes(attributes);

      uniforms = Object.assign({}, this.program.defaultUniforms, uniforms);
      this.uniforms = {};
      this.setUniforms(uniforms);

      // instanced rendering
      this.isInstanced = isInstanced;
      this.instanceCount = instanceCount;
      this.vertexCount = vertexCount;

      // picking options
      this.pickable = Boolean(pickable);
      this.pick = pick || function () {
        return false;
      };

      this.onBeforeRender = onBeforeRender;
      this.onAfterRender = onAfterRender;

      this.timeElapsedQuery = undefined;
      this.ext = this.program.gl.getExtension('EXT_disjoint_timer_query');

      this.lastQueryReturned = true;
      this.accumulatedFrameTime = 0;
      this.averageFrameTime = 0;
      this.profileFrameCount = 0;

      this.timerQueryEnabled = timerQueryEnabled && this.ext !== null;
    }
    /* eslint-enable max-statements */
    /* eslint-enable complexity */

  }, {
    key: 'destroy',
    value: function destroy() {}
  }, {
    key: 'setNeedsRedraw',
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.needsRedraw = redraw;
      return this;
    }
  }, {
    key: 'getNeedsRedraw',
    value: function getNeedsRedraw() {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref3$clearRedrawFlag = _ref3.clearRedrawFlags,
          clearRedrawFlags = _ref3$clearRedrawFlag === undefined ? false : _ref3$clearRedrawFlag;

      var redraw = false;
      redraw = redraw || this.needsRedraw;
      this.needsRedraw = this.needsRedraw && !clearRedrawFlags;
      redraw = redraw || this.geometry.getNeedsRedraw({ clearRedrawFlags: clearRedrawFlags });
      return redraw;
    }
  }, {
    key: 'setInstanceCount',
    value: function setInstanceCount(instanceCount) {
      (0, _assert2.default)(instanceCount !== undefined);
      this.instanceCount = instanceCount;
      return this;
    }
  }, {
    key: 'getInstanceCount',
    value: function getInstanceCount() {
      return this.instanceCount;
    }
  }, {
    key: 'setVertexCount',
    value: function setVertexCount(vertexCount) {
      this.vertexCount = vertexCount;
      return this;
    }
  }, {
    key: 'getVertexCount',
    value: function getVertexCount() {
      return this.vertexCount === undefined ? this.geometry.getVertexCount() : this.vertexCount;
    }
  }, {
    key: 'isPickable',
    value: function isPickable() {
      return this.pickable;
    }
  }, {
    key: 'setPickable',
    value: function setPickable() {
      var pickable = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.pickable = Boolean(pickable);
      return this;
    }
  }, {
    key: 'getProgram',
    value: function getProgram() {
      return this.program;
    }
  }, {
    key: 'getGeometry',
    value: function getGeometry() {
      return this.geometry;
    }
  }, {
    key: 'setGeometry',
    value: function setGeometry(geometry) {
      this.geometry = geometry;
      this._createBuffersFromAttributeDescriptors(this.geometry.getAttributes());
      this.setNeedsRedraw();
      return this;
    }
  }, {
    key: 'getAttributes',
    value: function getAttributes() {
      return this.attributes;
    }
  }, {
    key: 'setAttributes',
    value: function setAttributes() {
      var attributes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      Object.assign(this.attributes, attributes);
      this._createBuffersFromAttributeDescriptors(attributes);
      this.setNeedsRedraw();
      return this;
    }
  }, {
    key: 'getUniforms',
    value: function getUniforms() {
      return this.uniforms;
    }
  }, {
    key: 'setUniforms',
    value: function setUniforms() {
      var uniforms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      (0, _webgl.checkUniformValues)(uniforms, this.id);
      Object.assign(this.uniforms, uniforms);
      this.setNeedsRedraw();
      return this;
    }
  }, {
    key: 'draw',
    value: function draw() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$uniforms = _ref4.uniforms,
          uniforms = _ref4$uniforms === undefined ? {} : _ref4$uniforms,
          _ref4$attributes = _ref4.attributes,
          attributes = _ref4$attributes === undefined ? {} : _ref4$attributes,
          _ref4$settings = _ref4.settings,
          settings = _ref4$settings === undefined ? {} : _ref4$settings;

      return this.render(uniforms);
    }

    // TODO - uniform names are too strongly linked camera <=> default shaders
    // At least all special handling is collected here.

  }, {
    key: 'addViewUniforms',
    value: function addViewUniforms(uniforms) {
      // TODO - special treatment of these parameters should be removed
      var camera = uniforms.camera,
          viewMatrix = uniforms.viewMatrix,
          modelMatrix = uniforms.modelMatrix;
      // Camera exposes uniforms that can be used directly in shaders

      var cameraUniforms = camera ? camera.getUniforms() : {};

      var viewUniforms = viewMatrix ? this.getCoordinateUniforms(viewMatrix, modelMatrix) : {};

      return Object.assign({}, uniforms, cameraUniforms, viewUniforms);
    }

    /*
     * @param {Camera} opt.camera=
     * @param {Camera} opt.viewMatrix=
     */
    /* eslint-disable max-statements */

  }, {
    key: 'render',
    value: function render() {
      var uniforms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var resolvedUniforms = this.addViewUniforms(uniforms);

      this.setUniforms(resolvedUniforms);

      _utils.log.log(2, '>>> RENDERING MODEL ' + this.id, this);

      this.setProgramState();

      this._logAttributesAndUniforms(3, resolvedUniforms);

      this.onBeforeRender();

      var drawParams = this.drawParams;
      if (drawParams.isInstanced && !this.isInstanced) {
        _utils.log.warn(0, 'Found instanced attributes on non-instanced model');
      }
      var isIndexed = drawParams.isIndexed,
          indexType = drawParams.indexType;
      var geometry = this.geometry,
          isInstanced = this.isInstanced,
          instanceCount = this.instanceCount;


      if (this.timerQueryEnabled === true && this.lastQueryReturned === true) {
        this.program.gl.getParameter(this.ext.GPU_DISJOINT_EXT);
        this.timeElapsedQuery = this.ext.createQueryEXT();
        this.ext.beginQueryEXT(this.ext.TIME_ELAPSED_EXT, this.timeElapsedQuery);
      }

      (0, _webgl.draw)(this.program.gl, {
        drawMode: geometry.drawMode,
        vertexCount: this.getVertexCount(),
        isIndexed: isIndexed,
        indexType: indexType,
        isInstanced: isInstanced,
        instanceCount: instanceCount
      });

      if (this.timerQueryEnabled === true) {
        if (this.lastQueryReturned === true) {
          this.ext.endQueryEXT(this.ext.TIME_ELAPSED_EXT);
          this.profileFrameCount++;
          this.lastQueryReturned = false;
        }
        // ...at some point in the future, after returning control to the browser and being called again:
        var disjoint = this.program.gl.getParameter(this.ext.GPU_DISJOINT_EXT);
        if (disjoint) {
          this.lastQueryReturned = true;
          // Have to redo all of the measurements.
        } else {
          var available = this.ext.getQueryObjectEXT(this.timeElapsedQuery, this.ext.QUERY_RESULT_AVAILABLE_EXT);

          if (available) {
            var timeElapsed = this.ext.getQueryObjectEXT(this.timeElapsedQuery, this.ext.QUERY_RESULT_EXT) / 1e6;
            this.accumulatedFrameTime += timeElapsed;
            this.averageFrameTime = this.accumulatedFrameTime / this.profileFrameCount;
            // Do something useful with the time.  Note that care should be
            // taken to use all significant bits of the result, not just the
            // least significant 32 bits.
            _utils.log.log(2, 'program.id: ', this.program.id);
            _utils.log.log(2, 'last frame time: ', timeElapsed, 'ms');
            _utils.log.log(2, 'average frame time: ', this.averageFrameTime, 'ms');
            _utils.log.log(2, 'accumulated frame time: ', this.accumulatedFrameTime, 'ms');
            _utils.log.log(2, 'profile frame count: ', this.profileFrameCount);
            this.lastQueryReturned = true;
          }
        }
      }
      this.onAfterRender();

      this.unsetProgramState();

      this.setNeedsRedraw(false);

      _utils.log.log(2, '<<< RENDERING MODEL ' + this.id + ' - complete');

      return this;
    }
  }, {
    key: 'setProgramState',
    value: function setProgramState() {
      var program = this.program;

      program.use();
      this.drawParams = {};
      program.setBuffers(this.buffers, { drawParams: this.drawParams });
      program.setUniforms(this.uniforms);
      return this;
    }
  }, {
    key: 'unsetProgramState',
    value: function unsetProgramState() {
      // Ensures all vertex attributes are disabled and ELEMENT_ARRAY_BUFFER
      // is unbound
      this.program.unsetBuffers();
      return this;
    }

    // Makes sure buffers are created for all attributes
    // and that the program is updated with those buffers
    // TODO - do we need the separation between "attributes" and "buffers"
    // couldn't apps just create buffers directly?

  }, {
    key: '_createBuffersFromAttributeDescriptors',
    value: function _createBuffersFromAttributeDescriptors(attributes) {
      var gl = this.program.gl;


      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        if (attribute instanceof _webgl.Buffer) {
          this.buffers[attributeName] = attribute;
        } else {
          // Autocreate a buffer
          this.buffers[attributeName] = this.buffers[attributeName] || new _webgl.Buffer(gl);

          var buffer = this.buffers[attributeName];
          buffer.setData(Object.assign({}, attribute, {
            data: attribute.value,
            target: attribute.isIndexed ? _webgl.GL.ELEMENT_ARRAY_BUFFER : _webgl.GL.ARRAY_BUFFER
          }));
        }
      }

      return this;
    }
  }, {
    key: '_logAttributesAndUniforms',
    value: function _logAttributesAndUniforms() {
      var priority = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 3;
      var uniforms = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (_utils.log.priority >= priority) {
        var attributeTable = this._getAttributesTable({
          header: 'Attributes ' + this.id,
          program: this.program,
          attributes: Object.assign({}, this.geometry.attributes, this.attributes)
        });
        _utils.log.table(priority, attributeTable);

        var _getUniformsTable = (0, _webgl.getUniformsTable)({
          header: 'Uniforms ' + this.id,
          program: this.program,
          uniforms: Object.assign({}, this.uniforms, uniforms)
        }),
            table = _getUniformsTable.table,
            unusedTable = _getUniformsTable.unusedTable,
            unusedCount = _getUniformsTable.unusedCount;

        _utils.log.table(priority, table);
        _utils.log.log(priority, (unusedCount || 'No') + ' unused uniforms ', unusedTable);
      }
    }

    // Todo move to attributes manager

  }, {
    key: '_getAttributesTable',
    value: function _getAttributesTable() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          attributes = _ref5.attributes,
          _ref5$header = _ref5.header,
          header = _ref5$header === undefined ? 'Attributes' : _ref5$header,
          instanced = _ref5.instanced,
          program = _ref5.program;

      (0, _assert2.default)(program);
      var attributeLocations = program._attributeLocations;
      var table = _defineProperty({}, header, {});

      // Add used attributes
      for (var attributeName in attributeLocations) {
        var attribute = attributes[attributeName];
        var location = attributeLocations[attributeName];
        table[attributeName] = this._getAttributeEntry(attribute, location);
      }

      // Add any unused attributes
      for (var _attributeName in attributes) {
        var _attribute = attributes[_attributeName];
        if (!table[_attributeName]) {
          table[_attributeName] = this._getAttributeEntry(_attribute, null);
        }
      }

      return table;
    }
  }, {
    key: '_getAttributeEntry',
    value: function _getAttributeEntry(attribute, location) {
      var round = function round(num) {
        return Math.round(num * 10) / 10;
      };

      var type = 'NOT PROVIDED';
      var instanced = 0;
      var size = 'N/A';
      var verts = 'N/A';
      var bytes = 'N/A';
      var value = 'N/A';

      if (attribute && location === null) {
        location = attribute.isIndexed ? 'ELEMENT_ARRAY_BUFFER' : 'NOT USED';
      }

      if (attribute instanceof _webgl.Buffer) {
        var buffer = attribute;
        type = buffer.layout.type;
        instanced = buffer.layout.instanced;
        size = buffer.layout.size;
        verts = round(buffer.data.length / buffer.layout.size);
        bytes = buffer.data.length * buffer.data.BYTES_PER_ELEMENT;
      } else if (attribute) {
        type = attribute.value.constructor.name;
        instanced = attribute.instanced;
        size = attribute.size;
        verts = round(attribute.value.length / attribute.size);
        bytes = attribute.value.length * attribute.value.BYTES_PER_ELEMENT;
        value = attribute.value;
      }

      // Generate a type name by dropping Array from Float32Array etc.
      type = String(type).replace('Array', '');
      // Look for 'nt' to detect integer types, e.g. Int32Array, Uint32Array
      var isInteger = type.indexOf('nt') !== -1;

      location = '' + location + (instanced ? ' [instanced]' : '');

      return {
        Location: location,
        'Type Size x Verts = Bytes': type + ' ' + size + ' x ' + verts + ' = ' + bytes,
        Value: (0, _utils.formatValue)(value, { size: size, isInteger: isInteger })
      };
    }

    // DEPRECATED / REMOVED

  }, {
    key: 'setTextures',
    value: function setTextures() {
      var textures = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

      throw new Error('model.setTextures replaced: setUniforms({sampler2D: new Texture2D})');
    }
  }, {
    key: 'hash',
    get: function get() {
      return this.id + ' ' + this.$pickingIndex;
    }
  }]);

  return Model;
}(_object3d2.default);

exports.default = Model;
//# sourceMappingURL=data:application/json;base64,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