'use strict';

require('../headless');

var _ = require('..');

var _tapeCatch = require('tape-catch');

var _tapeCatch2 = _interopRequireDefault(_tapeCatch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var fixture = {
  gl: (0, _.createGLContext)()
};

var VS = '\nattribute vec3 positions;\n\nuniform mat4 uMVMatrix;\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * uMVMatrix * vec4(positions, 1.0);\n}\n';

var FS = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n}\n';

(0, _tapeCatch2.default)('WebGL#FramebufferObject construct/delete', function (t) {
  var gl = fixture.gl;


  t.throws(function () {
    return new _.FramebufferObject();
  }, /.*WebGLRenderingContext.*/, 'FramebufferObject throws on missing gl context');

  var fbo = new _.FramebufferObject(gl);
  t.ok(fbo instanceof _.FramebufferObject, 'FramebufferObject construction successful');

  fbo.delete();
  t.ok(fbo instanceof _.FramebufferObject, 'FramebufferObject delete successful');

  fbo.delete();
  t.ok(fbo instanceof _.FramebufferObject, 'FramebufferObject repeated delete successful');

  t.end();
});

(0, _tapeCatch2.default)('WebGL#FramebufferObject buffer update', function (t) {
  var gl = fixture.gl;


  var fbo = new _.FramebufferObject(gl, { fs: FS, vs: VS });
  t.ok(fbo instanceof _.FramebufferObject, 'FramebufferObject construction successful');

  t.end();
});
//# sourceMappingURL=data:application/json;base64,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