'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /* eslint-disable max-statements */


var _math = require('./math');

var _tapeCatch = require('tape-catch');

var _tapeCatch2 = _interopRequireDefault(_tapeCatch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var abs = Math.abs;
var delta = 0.001;

(0, _tapeCatch2.default)('Math#types', function (t) {
  t.equals(typeof _math.Vec3 === 'undefined' ? 'undefined' : _typeof(_math.Vec3), 'function');
  t.equals(typeof _math.Mat4 === 'undefined' ? 'undefined' : _typeof(_math.Mat4), 'function');
  t.equals(typeof _math.Quat === 'undefined' ? 'undefined' : _typeof(_math.Quat), 'function');
  t.end();
});

(0, _tapeCatch2.default)('Vec3#members and methods', function (t) {
  var v = new _math.Vec3();
  t.equals(v.x, 0);
  t.equals(v.y, 0);
  t.equals(v.z, 0);
  t.equals(_typeof(v.add), 'function');
  t.equals(_typeof(v.add2), 'function');
  t.equals(_typeof(v.clone), 'function');
  t.equals(_typeof(v.cross), 'function');
  t.equals(_typeof(v.distTo), 'function');
  t.equals(_typeof(v.distToSq), 'function');
  t.equals(_typeof(v.dot), 'function');
  t.equals(_typeof(v.neg), 'function');
  t.equals(_typeof(v.norm), 'function');
  t.equals(_typeof(v.normSq), 'function');
  t.equals(_typeof(v.scale), 'function');
  t.equals(_typeof(v.setVec3), 'function');
  t.equals(_typeof(v.sub), 'function');
  t.equals(_typeof(v.sub2), 'function');
  t.equals(_typeof(v.unit), 'function');
  t.end();
});

(0, _tapeCatch2.default)('Mat4#getters and setters', function (t) {
  var m = new _math.Mat4();
  t.equals(m.n11, 1);
  t.equals(m.n12, 0);
  t.equals(m.n13, 0);
  t.equals(m.n14, 0);
  t.equals(m.n21, 0);
  t.equals(m.n22, 1);
  t.equals(m.n23, 0);
  t.equals(m.n24, 0);
  t.equals(m.n31, 0);
  t.equals(m.n32, 0);
  t.equals(m.n33, 1);
  t.equals(m.n34, 0);
  t.equals(m.n41, 0);
  t.equals(m.n42, 0);
  t.equals(m.n43, 0);
  t.equals(m.n44, 1);
  t.end();
});

(0, _tapeCatch2.default)('Mat4#id (identity matrix)', function (t) {
  t.equals(_typeof(_math.Mat4.id), 'function');
  var m = new _math.Mat4();
  m.id();
  t.equals(m[0], 1);
  t.equals(m[1], 0);
  t.equals(m[2], 0);
  t.equals(m[3], 0);
  t.equals(m[4], 0);
  t.equals(m[5], 1);
  t.equals(m[6], 0);
  t.equals(m[7], 0);
  t.equals(m[8], 0);
  t.equals(m[9], 0);
  t.equals(m[10], 1);
  t.equals(m[11], 0);
  t.equals(m[12], 0);
  t.equals(m[13], 0);
  t.equals(m[14], 0);
  t.equals(m[15], 1);
  t.end();
});

(0, _tapeCatch2.default)('Mat4#set', function (t) {
  t.equals(_typeof(_math.Mat4.set), 'function');
  var m = new _math.Mat4();
  m.id();
  m.set(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
  t.equals(m[0], 1);
  t.equals(m[1], 5);
  t.equals(m[2], 9);
  t.equals(m[3], 13);
  t.equals(m[4], 2);
  t.equals(m[5], 6);
  t.equals(m[6], 10);
  t.equals(m[7], 14);
  t.equals(m[8], 3);
  t.equals(m[9], 7);
  t.equals(m[10], 11);
  t.equals(m[11], 15);
  t.equals(m[12], 4);
  t.equals(m[13], 8);
  t.equals(m[14], 12);
  t.equals(m[15], 16);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.add', function (t) {
  t.equals(_typeof(_math.Mat4.add), 'function');
  var m = new _math.Mat4();
  m.id();
  m = m.add(m);
  t.equals(m[0], 2);
  t.equals(m[1], 0);
  t.equals(m[2], 0);
  t.equals(m[3], 0);
  t.equals(m[4], 0);
  t.equals(m[5], 2);
  t.equals(m[6], 0);
  t.equals(m[7], 0);
  t.equals(m[8], 0);
  t.equals(m[9], 0);
  t.equals(m[10], 2);
  t.equals(m[11], 0);
  t.equals(m[12], 0);
  t.equals(m[13], 0);
  t.equals(m[14], 0);
  t.equals(m[15], 2);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.transpose', function (t) {
  t.equals(_typeof(_math.Mat4.transpose), 'function');
  var m = new _math.Mat4();
  m.id();
  m.set(1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15, 4, 8, 12, 16);

  var ans = m.transpose();

  t.ok(abs(ans.n11 - 1) < delta);
  t.ok(abs(ans.n12 - 2) < delta);
  t.ok(abs(ans.n13 - 3) < delta);
  t.ok(abs(ans.n14 - 4) < delta);
  t.ok(abs(ans.n21 - 5) < delta);
  t.ok(abs(ans.n22 - 6) < delta);
  t.ok(abs(ans.n23 - 7) < delta);
  t.ok(abs(ans.n24 - 8) < delta);
  t.ok(abs(ans.n31 - 9) < delta);
  t.ok(abs(ans.n32 - 10) < delta);
  t.ok(abs(ans.n33 - 11) < delta);
  t.ok(abs(ans.n34 - 12) < delta);
  t.ok(abs(ans.n41 - 13) < delta);
  t.ok(abs(ans.n42 - 14) < delta);
  t.ok(abs(ans.n43 - 15) < delta);
  t.ok(abs(ans.n44 - 16) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.mulMat42', function (t) {
  t.equals(_typeof(_math.Mat4.mulMat42), 'function');
  var m1 = new _math.Mat4();
  m1.set(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);

  var m2 = new _math.Mat4();
  m2.set(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16).$transpose();

  var ans = new _math.Mat4();
  ans.mulMat42(m1, m2);
  t.ok(abs(ans.n11 - 30) < delta);
  t.ok(abs(ans.n12 - 70) < delta);
  t.ok(abs(ans.n13 - 110) < delta);
  t.ok(abs(ans.n14 - 150) < delta);
  t.ok(abs(ans.n21 - 70) < delta);
  t.ok(abs(ans.n22 - 174) < delta);
  t.ok(abs(ans.n23 - 278) < delta);
  t.ok(abs(ans.n24 - 382) < delta);
  t.ok(abs(ans.n31 - 110) < delta);
  t.ok(abs(ans.n32 - 278) < delta);
  t.ok(abs(ans.n33 - 446) < delta);
  t.ok(abs(ans.n34 - 614) < delta);
  t.ok(abs(ans.n41 - 150) < delta);
  t.ok(abs(ans.n42 - 382) < delta);
  t.ok(abs(ans.n43 - 614) < delta);
  t.ok(abs(ans.n44 - 846) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.rotateAxis', function (t) {
  t.equals(_typeof(_math.Mat4.rotateAxis), 'function');
  var v = [1, 2, 3];
  var len = Math.sqrt(1 * 1 + 2 * 2 + 3 * 3);
  var theta = Math.PI / 4;
  var m = new _math.Mat4();

  v[0] /= len;
  v[1] /= len;
  v[2] /= len;

  var ans = m.rotateAxis(theta, v);
  t.ok(abs(ans.n11 - 0.7280277013778687) < delta);
  t.ok(abs(ans.n12 - -0.525104820728302) < delta);
  t.ok(abs(ans.n13 - 0.4407272934913635) < delta);
  t.ok(abs(ans.n14 - 0) < delta);
  t.ok(abs(ans.n21 - 0.6087885979157627) < delta);
  t.ok(abs(ans.n22 - 0.7907905578613281) < delta);
  t.ok(abs(ans.n23 - -0.06345657259225845) < delta);
  t.ok(abs(ans.n24 - 0) < delta);
  t.ok(abs(ans.n31 - -0.3152016404063445) < delta);
  t.ok(abs(ans.n32 - 0.3145079017103789) < delta);
  t.ok(abs(ans.n33 - 0.8953952789306641) < delta);
  t.ok(abs(ans.n34 - 0) < delta);
  t.ok(abs(ans.n41 - 0) < delta);
  t.ok(abs(ans.n42 - 0) < delta);
  t.ok(abs(ans.n43 - 0) < delta);
  t.ok(abs(ans.n44 - 1) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.rotateXYZ', function (t) {
  t.equals(_typeof(_math.Mat4.rotateXYZ), 'function');
  var m = new _math.Mat4();
  m.id();
  var ans = m.rotateXYZ(1, 2, 3);
  t.ok(abs(ans.n11 - 0.411982245665683) < delta);
  t.ok(abs(ans.n12 - -0.8337376517741568) < delta);
  t.ok(abs(ans.n13 - -0.36763046292489926) < delta);
  t.ok(abs(ans.n14 - 0) < delta);
  t.ok(abs(ans.n21 - -0.05872664492762098) < delta);
  t.ok(abs(ans.n22 - -0.42691762127620736) < delta);
  t.ok(abs(ans.n23 - 0.9023815854833308) < delta);
  t.ok(abs(ans.n24 - 0) < delta);
  t.ok(abs(ans.n31 - -0.9092974268256817) < delta);
  t.ok(abs(ans.n32 - -0.35017548837401463) < delta);
  t.ok(abs(ans.n33 - -0.2248450953661529) < delta);
  t.ok(abs(ans.n34 - 0) < delta);
  t.ok(abs(ans.n41 - 0) < delta);
  t.ok(abs(ans.n42 - 0) < delta);
  t.ok(abs(ans.n43 - 0) < delta);
  t.ok(abs(ans.n44 - 1) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.scale', function (t) {
  t.equals(_typeof(_math.Mat4.scale), 'function');
  var m = new _math.Mat4();
  m.id();
  var ans = m.scale(1, 2, 3);

  t.equals(ans[0], 1);
  t.equals(ans[1], 0);
  t.equals(ans[2], 0);
  t.equals(ans[3], 0);
  t.equals(ans[4], 0);
  t.equals(ans[5], 2);
  t.equals(ans[6], 0);
  t.equals(ans[7], 0);
  t.equals(ans[8], 0);
  t.equals(ans[9], 0);
  t.equals(ans[10], 3);
  t.equals(ans[11], 0);
  t.equals(ans[12], 0);
  t.equals(ans[13], 0);
  t.equals(ans[14], 0);
  t.equals(ans[15], 1);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.translate', function (t) {
  t.equals(_typeof(_math.Mat4.translate), 'function');
  var m = new _math.Mat4();
  m.id();
  var ans = m.translate(1, 2, 3);
  t.ok(abs(ans.n11 - 1) < delta);
  t.ok(abs(ans.n12 - 0) < delta);
  t.ok(abs(ans.n13 - 0) < delta);
  t.ok(abs(ans.n14 - 1) < delta);
  t.ok(abs(ans.n21 - 0) < delta);
  t.ok(abs(ans.n22 - 1) < delta);
  t.ok(abs(ans.n23 - 0) < delta);
  t.ok(abs(ans.n24 - 2) < delta);
  t.ok(abs(ans.n31 - 0) < delta);
  t.ok(abs(ans.n32 - 0) < delta);
  t.ok(abs(ans.n33 - 1) < delta);
  t.ok(abs(ans.n34 - 3) < delta);
  t.ok(abs(ans.n41 - 0) < delta);
  t.ok(abs(ans.n42 - 0) < delta);
  t.ok(abs(ans.n43 - 0) < delta);
  t.ok(abs(ans.n44 - 1) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.frustum', function (t) {
  t.equals(_typeof(_math.Mat4.frustum), 'function');
  var m = new _math.Mat4();
  m.id();
  var ans = m.frustum(-1, 1, -1, 1, 0.1, 100);
  t.ok(abs(ans.n11 - 0.1) < delta);
  t.ok(abs(ans.n12 - 0) < delta);
  t.ok(abs(ans.n13 - 0) < delta);
  t.ok(abs(ans.n14 - 0) < delta);
  t.ok(abs(ans.n21 - 0) < delta);
  t.ok(abs(ans.n22 - 0.1) < delta);
  t.ok(abs(ans.n23 - 0) < delta);
  t.ok(abs(ans.n24 - 0) < delta);
  t.ok(abs(ans.n31 - 0) < delta);
  t.ok(abs(ans.n32 - 0) < delta);
  t.ok(abs(ans.n33 - -1.002002002002002) < delta);
  t.ok(abs(ans.n34 - -0.20020020020020018) < delta);
  t.ok(abs(ans.n41 - 0) < delta);
  t.ok(abs(ans.n42 - 0) < delta);
  t.ok(abs(ans.n43 - -1) < delta);
  t.ok(abs(ans.n44 - 0) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.invert', function (t) {
  t.equals(_typeof(_math.Mat4.invert), 'function');
  var m = new _math.Mat4();
  m.id();
  var ans = m.frustum(-1, 1, -1, 1, 0.1, 100).invert();
  t.ok(abs(ans.n11 - 9.99999999) < delta);
  t.ok(abs(ans.n12 - 0) < delta);
  t.ok(abs(ans.n13 - 0) < delta);
  t.ok(abs(ans.n14 - 0) < delta);
  t.ok(abs(ans.n21 - 0) < delta);
  t.ok(abs(ans.n22 - 9.99999999) < delta);
  t.ok(abs(ans.n23 - 0) < delta);
  t.ok(abs(ans.n24 - 0) < delta);
  t.ok(abs(ans.n31 - 0) < delta);
  t.ok(abs(ans.n32 - 0) < delta);
  t.ok(abs(ans.n33 - 0) < delta);
  t.ok(abs(ans.n34 - -1) < delta);
  t.ok(abs(ans.n41 - 0) < delta);
  t.ok(abs(ans.n42 - 0) < delta);
  t.ok(abs(ans.n43 - -4.995) < delta);
  t.ok(abs(ans.n44 - 5.005) < delta);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.lookAt', function (t) {
  t.equals(_typeof(_math.Mat4.lookAt), 'function');
  t.end();
});

(0, _tapeCatch2.default)('Mat4.mulVec3', function (t) {
  t.equals(_typeof(_math.Mat4.mulVec3), 'function');
  var v = new _math.Vec3(1, 1, 1);
  var m = new _math.Mat4();
  var ans = m.mulVec3(v);

  t.equals(ans[0], 1);
  t.equals(ans[1], 1);
  t.equals(ans[2], 1);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.$mulVec3', function (t) {
  t.equals(_typeof(_math.Mat4.$mulVec3), 'function');
  var v = new _math.Vec3(1, 1, 1);
  var m = new _math.Mat4();

  m.$mulVec3(v);

  t.equals(v[0], 1);
  t.equals(v[1], 1);
  t.equals(v[2], 1);
  t.end();
});

(0, _tapeCatch2.default)('Mat4.perspective', function (t) {
  t.equals(_typeof(_math.Mat4.perspective), 'function');
  t.end();
});

(0, _tapeCatch2.default)('Mat4.toFloat32Array', function (t) {
  t.equals(_typeof(_math.Mat4.toFloat32Array), 'function');
  var m = new _math.Mat4();
  m.id();
  t.equals(m.toFloat32Array().BYTES_PER_ELEMENT, 4);
  t.end();
});

(0, _tapeCatch2.default)('Quat#methods', function (t) {
  var q = new _math.Quat();
  t.equals(q[0], 0);
  t.equals(q[1], 0);
  t.equals(q[2], 0);
  t.equals(q[3], 0);
  // t.equals(typeof q.add, 'function');
  // t.equals(typeof q.clone, 'function');
  // t.equals(typeof q.conjugate, 'function');
  // t.equals(typeof q.divQuat, 'function');
  // t.equals(typeof q.invert, 'function');
  // t.equals(typeof q.mulQuat, 'function');
  // t.equals(typeof q.neg, 'function');
  // t.equals(typeof q.norm, 'function');
  // t.equals(typeof q.normSq, 'function');
  // t.equals(typeof q.scale, 'function');
  // t.equals(typeof q.set, 'function');
  // t.equals(typeof q.setQuat, 'function');
  // t.equals(typeof q.sub, 'function');
  // t.equals(typeof q.unit, 'function');
  t.end();
});

(0, _tapeCatch2.default)('Quat.fromAxisRotation', function (t) {
  var q = _math.Quat.fromAxisRotation(new _math.Vec3(0, 0, 1), Math.PI);
  t.equals(q[0], 0);
  t.equals(q[1], 0);
  t.equals(q[2], 1);
  t.equals(q[3], Math.cos(Math.PI / 2));

  q = _math.Quat.fromAxisRotation(new _math.Vec3(0, 1, 0), Math.PI);
  t.equals(q[0], 0);
  t.equals(q[1], 1);
  t.equals(q[2], 0);
  t.equals(q[3], Math.cos(Math.PI / 2));

  q = _math.Quat.fromAxisRotation(new _math.Vec3(1, 0, 0), Math.PI);
  t.equals(q[0], 1);
  t.equals(q[1], 0);
  t.equals(q[2], 0);
  t.equals(q[3], Math.cos(Math.PI / 2));

  // const q1 = Quat.fromAxisRotation(new Vec3(5, 0, -2), Math.PI / 3);
  // const q2 = Quat.fromAxisRotation(new Vec3(1, 3, 0), Math.PI / 4);
  // q1.$mulQuat(q2);
  // t.equals(q1[0], 0.6011183144537015);
  // t.equals(q1[1], 0.29193457751898655);
  // t.equals(q1[2], -0.0030205353559888126);
  // t.equals(q1[3], 0.7439232829017486);
  t.end();
});
//# sourceMappingURL=data:application/json;base64,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