'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _object3d = require('./object-3d');

var _object3d2 = _interopRequireDefault(_object3d);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Group = function (_Object3D) {
  _inherits(Group, _Object3D);

  function Group() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Group);

    var _opts$children = opts.children,
        children = _opts$children === undefined ? [] : _opts$children;

    children.every(function (child) {
      return (0, _assert2.default)(child instanceof _object3d2.default);
    });

    var _this = _possibleConstructorReturn(this, (Group.__proto__ || Object.getPrototypeOf(Group)).call(this, opts));

    _this.children = children;
    return _this;
  }

  // Unpacks arrays and nested arrays of children


  _createClass(Group, [{
    key: 'add',
    value: function add() {
      for (var _len = arguments.length, children = Array(_len), _key = 0; _key < _len; _key++) {
        children[_key] = arguments[_key];
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var child = _step.value;

          if (Array.isArray(child)) {
            this.add.apply(this, _toConsumableArray(child));
          } else {
            this.children.push(child);
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this;
    }
  }, {
    key: 'remove',
    value: function remove(child) {
      var children = this.children;
      var indexOf = children.indexOf(child);
      if (indexOf > -1) {
        children.splice(indexOf, 1);
      }
      return this;
    }
  }, {
    key: 'removeAll',
    value: function removeAll() {
      this.children = [];
      return this;
    }
  }]);

  return Group;
}(_object3d2.default);

exports.default = Group;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9kZXByZWNhdGVkL3NjZW5lZ3JhcGgvZ3JvdXAuanMiXSwibmFtZXMiOlsiR3JvdXAiLCJvcHRzIiwiY2hpbGRyZW4iLCJldmVyeSIsImNoaWxkIiwiQXJyYXkiLCJpc0FycmF5IiwiYWRkIiwicHVzaCIsImluZGV4T2YiLCJzcGxpY2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7O0lBRXFCQSxLOzs7QUFDbkIsbUJBQXVCO0FBQUEsUUFBWEMsSUFBVyx1RUFBSixFQUFJOztBQUFBOztBQUFBLHlCQUNHQSxJQURILENBQ2RDLFFBRGM7QUFBQSxRQUNkQSxRQURjLGtDQUNILEVBREc7O0FBRXJCQSxhQUFTQyxLQUFULENBQWU7QUFBQSxhQUFTLHNCQUFPQyxtQ0FBUCxDQUFUO0FBQUEsS0FBZjs7QUFGcUIsOEdBR2ZILElBSGU7O0FBSXJCLFVBQUtDLFFBQUwsR0FBZ0JBLFFBQWhCO0FBSnFCO0FBS3RCOztBQUVEOzs7OzswQkFDaUI7QUFBQSx3Q0FBVkEsUUFBVTtBQUFWQSxnQkFBVTtBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUNmLDZCQUFvQkEsUUFBcEIsOEhBQThCO0FBQUEsY0FBbkJFLEtBQW1COztBQUM1QixjQUFJQyxNQUFNQyxPQUFOLENBQWNGLEtBQWQsQ0FBSixFQUEwQjtBQUN4QixpQkFBS0csR0FBTCxnQ0FBWUgsS0FBWjtBQUNELFdBRkQsTUFFTztBQUNMLGlCQUFLRixRQUFMLENBQWNNLElBQWQsQ0FBbUJKLEtBQW5CO0FBQ0Q7QUFDRjtBQVBjO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBUWYsYUFBTyxJQUFQO0FBQ0Q7OzsyQkFFTUEsSyxFQUFPO0FBQ1osVUFBTUYsV0FBVyxLQUFLQSxRQUF0QjtBQUNBLFVBQU1PLFVBQVVQLFNBQVNPLE9BQVQsQ0FBaUJMLEtBQWpCLENBQWhCO0FBQ0EsVUFBSUssVUFBVSxDQUFDLENBQWYsRUFBa0I7QUFDaEJQLGlCQUFTUSxNQUFULENBQWdCRCxPQUFoQixFQUF5QixDQUF6QjtBQUNEO0FBQ0QsYUFBTyxJQUFQO0FBQ0Q7OztnQ0FFVztBQUNWLFdBQUtQLFFBQUwsR0FBZ0IsRUFBaEI7QUFDQSxhQUFPLElBQVA7QUFDRDs7Ozs7O2tCQWhDa0JGLEsiLCJmaWxlIjoiZ3JvdXAuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgT2JqZWN0M0QgZnJvbSAnLi9vYmplY3QtM2QnO1xuaW1wb3J0IGFzc2VydCBmcm9tICdhc3NlcnQnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBHcm91cCBleHRlbmRzIE9iamVjdDNEIHtcbiAgY29uc3RydWN0b3Iob3B0cyA9IHt9KSB7XG4gICAgY29uc3Qge2NoaWxkcmVuID0gW119ID0gb3B0cztcbiAgICBjaGlsZHJlbi5ldmVyeShjaGlsZCA9PiBhc3NlcnQoY2hpbGQgaW5zdGFuY2VvZiBPYmplY3QzRCkpO1xuICAgIHN1cGVyKG9wdHMpO1xuICAgIHRoaXMuY2hpbGRyZW4gPSBjaGlsZHJlbjtcbiAgfVxuXG4gIC8vIFVucGFja3MgYXJyYXlzIGFuZCBuZXN0ZWQgYXJyYXlzIG9mIGNoaWxkcmVuXG4gIGFkZCguLi5jaGlsZHJlbikge1xuICAgIGZvciAoY29uc3QgY2hpbGQgb2YgY2hpbGRyZW4pIHtcbiAgICAgIGlmIChBcnJheS5pc0FycmF5KGNoaWxkKSkge1xuICAgICAgICB0aGlzLmFkZCguLi5jaGlsZCk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLmNoaWxkcmVuLnB1c2goY2hpbGQpO1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHJlbW92ZShjaGlsZCkge1xuICAgIGNvbnN0IGNoaWxkcmVuID0gdGhpcy5jaGlsZHJlbjtcbiAgICBjb25zdCBpbmRleE9mID0gY2hpbGRyZW4uaW5kZXhPZihjaGlsZCk7XG4gICAgaWYgKGluZGV4T2YgPiAtMSkge1xuICAgICAgY2hpbGRyZW4uc3BsaWNlKGluZGV4T2YsIDEpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIHJlbW92ZUFsbCgpIHtcbiAgICB0aGlzLmNoaWxkcmVuID0gW107XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cbn1cbiJdfQ==