'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pickModels = pickModels;

var _webgl = require('../../webgl');

var _webglChecks = require('../../webgl/webgl-checks');

var _group = require('./group');

var _group2 = _interopRequireDefault(_group);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TODO - this is the new picking for deck.gl
/* eslint-disable max-statements, no-try-catch */
/* global window */
var ILLEGAL_ARG = 'Illegal argument to pick';

function pickModels(gl, _ref) {
  var group = _ref.group,
      uniforms = _ref.uniforms,
      x = _ref.x,
      y = _ref.y,
      _ref$framebuffer = _ref.framebuffer,
      framebuffer = _ref$framebuffer === undefined ? null : _ref$framebuffer,
      _ref$pickingFBO = _ref.pickingFBO,
      pickingFBO = _ref$pickingFBO === undefined ? null : _ref$pickingFBO,
      _ref$pickingProgram = _ref.pickingProgram,
      pickingProgram = _ref$pickingProgram === undefined ? null : _ref$pickingProgram,
      _ref$pickingColors = _ref.pickingColors,
      pickingColors = _ref$pickingColors === undefined ? null : _ref$pickingColors;

  (0, _webglChecks.assertWebGLContext)(gl);
  (0, _assert2.default)(group instanceof _group2.default, ILLEGAL_ARG);

  var dpr = typeof window !== 'undefined' ? window.devicePixelRatio : 1;
  var deviceX = x * dpr;
  var deviceY = gl.canvas.height - y * dpr;

  // Set up a frame buffer if needed
  // TODO - cache picking fbo (needs to be resized)?
  framebuffer = framebuffer || pickingFBO || new _webgl.Framebuffer(gl, {
    width: gl.canvas.width,
    height: gl.canvas.height
  });

  framebuffer.resize({ width: gl.canvas.width, height: gl.canvas.height });

  // Make sure we clear scissor test and fbo bindings in case of exceptions
  return (0, _webgl.glContextWithState)(gl, {
    framebuffer: framebuffer,
    // We are only interested in one pixel, no need to render anything else
    scissorTest: { x: deviceX, y: deviceY, w: 1, h: 1 }
  }, function () {
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = group.traverseReverse()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var model = _step.value;

        if (model.isPickable()) {

          // Clear the frame buffer, render and sample
          gl.clear(_webgl.GL.COLOR_BUFFER_BIT | _webgl.GL.DEPTH_BUFFER_BIT);

          model.setUniforms({
            renderPickingBuffer: 1,
            enablePicking: true
          });

          model.render(uniforms);

          model.setUniforms({
            renderPickingBuffer: false,
            enablePicking: false
          });

          // Read color in the central pixel, to be mapped with picking colors
          var color = new Uint8Array(4);
          gl.readPixels(deviceX, deviceY, 1, 1, gl.RGBA, gl.UNSIGNED_BYTE, color);

          var isPicked = color[0] !== 0 || color[1] !== 0 || color[2] !== 0 || color[3] !== 0;

          // Add the information to the stack
          if (isPicked) {
            return {
              model: model,
              color: color,
              x: x,
              y: y,
              deviceX: deviceX,
              deviceY: deviceY
            };
          }
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return null;
  });
}
//# sourceMappingURL=data:application/json;base64,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