'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _config = require('../../core/config');

var config = _interopRequireWildcard(_config);

var _math = require('../../packages/math');

var _utils = require('../../utils');

var _group = require('./group');

var _group2 = _interopRequireDefault(_group);

var _pick = require('./pick');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Scene Object management and rendering
/* eslint-disable max-statements, no-try-catch */

var INVALID_ARGUMENT = 'LumaGL.Scene invalid argument';

var DEFAULT_SCENE_OPTS = {
  lights: {
    enable: false,
    // ambient light
    ambient: { r: 0.2, g: 0.2, b: 0.2 },
    // directional light
    directional: {
      direction: { x: 1, y: 1, z: 1 },
      color: { r: 0, g: 0, b: 0 }
    }
    // point light
    // points: []
  },
  effects: {
    fog: false
    // { near, far, color }
  },
  clearColor: true,
  clearDepth: true,
  backgroundColor: { r: 0, g: 0, b: 0, a: 1 },
  backgroundDepth: 1
};

// Scene class

var Scene = function (_Group) {
  _inherits(Scene, _Group);

  function Scene(gl, opts) {
    _classCallCheck(this, Scene);

    (0, _assert2.default)(gl, INVALID_ARGUMENT);

    opts = (0, _utils.merge)(DEFAULT_SCENE_OPTS, opts);

    var _this = _possibleConstructorReturn(this, (Scene.__proto__ || Object.getPrototypeOf(Scene)).call(this, opts));

    _this.gl = gl;
    _this.config = opts;
    _this.needsRedraw = false;
    Object.seal(_this);
    return _this;
  }

  _createClass(Scene, [{
    key: 'setNeedsRedraw',
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.needsRedraw = redraw;
      return this;
    }
  }, {
    key: 'getNeedsRedraw',
    value: function getNeedsRedraw() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$clearRedrawFlags = _ref.clearRedrawFlags,
          clearRedrawFlags = _ref$clearRedrawFlags === undefined ? false : _ref$clearRedrawFlags;

      var redraw = false;
      redraw = redraw || this.needsRedraw;
      this.needsRedraw = this.needsRedraw && !clearRedrawFlags;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = this.traverse()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var model = _step.value;

          redraw = redraw || model.getNeedsRedraw({ clearRedrawFlags: clearRedrawFlags });
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return redraw;
    }
  }, {
    key: 'clear',
    value: function clear() {
      var gl = this.gl;

      if (this.config.clearColor) {
        var bg = this.config.backgroundColor;
        gl.clearColor(bg.r, bg.g, bg.b, bg.a);
      }
      if (this.config.clearDepth) {
        gl.clearDepth(this.config.backgroundDepth);
      }
      if (this.config.clearColor && this.config.clearDepth) {
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
      } else if (this.config.clearColor) {
        gl.clear(gl.COLOR_BUFFER_BIT);
      } else if (this.config.clearDepth) {
        gl.clear(gl.DEPTH_BUFFER_BIT);
      }
      return this;
    }

    // Renders all objects in the scene.

  }, {
    key: 'render',
    value: function render() {
      var uniforms = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      this.clear();
      // Go through each model and render it.
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this.traverse()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var model = _step2.value;

          if (model.display) {
            this.renderObject({ model: model, uniforms: uniforms });
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return this;
    }
  }, {
    key: 'renderObject',
    value: function renderObject(_ref2) {
      var model = _ref2.model,
          uniforms = _ref2.uniforms;

      // Setup lighting and scene effects like fog, etc.
      model.render(Object.assign({}, this.getSceneUniforms(), { uniforms: uniforms }));
      return this;
    }
  }, {
    key: 'pickModels',
    value: function pickModels() {
      var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var x = opts.x,
          y = opts.y,
          _opts$uniforms = opts.uniforms,
          uniforms = _opts$uniforms === undefined ? {} : _opts$uniforms;

      return (0, _pick.pickModels)(this.gl, Object.assign({
        group: this,
        x: x, y: y,
        uniforms: uniforms
      }, opts));
    }

    // Setup the lighting system: ambient, directional, point lights.

  }, {
    key: 'getSceneUniforms',
    value: function getSceneUniforms() {
      // Setup Lighting
      var _config$lights = this.config.lights,
          enable = _config$lights.enable,
          ambient = _config$lights.ambient,
          directional = _config$lights.directional,
          points = _config$lights.points;

      // Set light uniforms. Ambient and directional lights.

      return Object.assign({}, this.getEffectsUniforms(), { enableLights: enable }, enable && ambient ? this.getAmbientUniforms(ambient) : {}, enable && directional ? this.getDirectionalUniforms(directional) : {}, enable && points ? this.getPointUniforms(points) : {});
    }
  }, {
    key: 'getAmbientUniforms',
    value: function getAmbientUniforms(ambient) {
      return {
        ambientColor: [ambient.r, ambient.g, ambient.b]
      };
    }
  }, {
    key: 'getDirectionalUniforms',
    value: function getDirectionalUniforms(directional) {
      var color = directional.color,
          direction = directional.direction;

      // Normalize lighting direction vector

      var dir = new _math.Vector3(direction.x, direction.y, direction.z).normalize().scale(-1, -1, -1);

      return {
        directionalColor: [color.r, color.g, color.b],
        lightingDirection: [dir.x, dir.y, dir.z]
      };
    }
  }, {
    key: 'getPointUniforms',
    value: function getPointUniforms(points) {
      points = points instanceof Array ? points : [points];
      var numberPoints = points.length;
      var uniforms = { numberPoints: numberPoints };

      var pointLocations = [];
      var pointColors = [];
      var enableSpecular = [];
      var pointSpecularColors = [];
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = points[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var point = _step3.value;
          var position = point.position,
              color = point.color,
              diffuse = point.diffuse,
              specular = point.specular;

          var pointColor = color || diffuse;

          pointLocations.push(position.x, position.y, position.z);
          pointColors.push(pointColor.r, pointColor.g, pointColor.b);

          // Add specular color
          enableSpecular.push(Number(Boolean(specular)));
          if (specular) {
            pointSpecularColors.push(specular.r, specular.g, specular.b);
          } else {
            pointSpecularColors.push(0, 0, 0);
          }
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      if (pointLocations.length) {
        Object.assign(uniforms, {
          pointLocation: pointLocations,
          pointColor: pointColors,
          enableSpecular: enableSpecular,
          pointSpecularColor: pointSpecularColors
        });
      }

      return uniforms;
    }

    // Setup effects like fog, etc.

  }, {
    key: 'getEffectsUniforms',
    value: function getEffectsUniforms() {
      var fog = this.config.effects.fog;


      if (fog) {
        var _fog$color = fog.color,
            color = _fog$color === undefined ? { r: 0.5, g: 0.5, b: 0.5 } : _fog$color;

        return {
          hasFog: true,
          fogNear: fog.near,
          fogFar: fog.far,
          fogColor: [color.r, color.g, color.b]
        };
      }
      return { hasFog: false };
    }
  }]);

  return Scene;
}(_group2.default);

exports.default = Scene;


Scene.MAX_TEXTURES = config.MAX_TEXTURES;
Scene.MAX_POINT_LIGHTS = config.MAX_POINT_LIGHTS;
Scene.PICKING_RES = config.PICKING_RES;
//# sourceMappingURL=data:application/json;base64,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