'use strict';

var _path = require('path');

// Default Shaders
var vs = '#define SHADER_NAME luma-default-vertex\n\n#define LIGHT_MAX 4\n\n// object attributes\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec4 colors;\nattribute vec4 pickingColors;\nattribute vec2 texCoords;\n\n// camera and object matrices\nuniform mat4 viewMatrix;\nuniform mat4 viewInverseMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewProjectionMatrix;\n\n// objectMatrix * viewMatrix = worldMatrix\nuniform mat4 worldMatrix;\nuniform mat4 worldInverseMatrix;\nuniform mat4 worldInverseTransposeMatrix;\nuniform mat4 objectMatrix;\nuniform vec3 cameraPosition;\n\n// lighting configuration\nuniform bool enableLights;\nuniform vec3 ambientColor;\nuniform vec3 directionalColor;\nuniform vec3 lightingDirection;\n\n// point lights configuration\nuniform vec3 pointLocation[LIGHT_MAX];\nuniform vec3 pointColor[LIGHT_MAX];\nuniform int numberPoints;\n\n// reflection / refraction configuration\nuniform bool useReflection;\n\n// varyings\nvarying vec3 vReflection;\nvarying vec4 vColor;\nvarying vec4 vPickingColor;\nvarying vec2 vTexCoord;\nvarying vec4 vNormal;\nvarying vec3 lightWeighting;\n\nvoid main(void) {\n  vec4 mvPosition = worldMatrix * vec4(positions, 1.0);\n  vec4 transformedNormal = worldInverseTransposeMatrix * vec4(normals, 1.0);\n\n  // lighting code\n  if(!enableLights) {\n    lightWeighting = vec3(1.0, 1.0, 1.0);\n  } else {\n    vec3 plightDirection;\n    vec3 pointWeight = vec3(0.0, 0.0, 0.0);\n    float directionalLightWeighting =\n      max(dot(transformedNormal.xyz, lightingDirection), 0.0);\n    for (int i = 0; i < LIGHT_MAX; i++) {\n      if (i < numberPoints) {\n        plightDirection = normalize(\n          (viewMatrix * vec4(pointLocation[i], 1.0)).xyz - mvPosition.xyz);\n         pointWeight += max(\n          dot(transformedNormal.xyz, plightDirection), 0.0) * pointColor[i];\n       } else {\n         break;\n       }\n     }\n\n    lightWeighting = ambientColor +\n      (directionalColor * directionalLightWeighting) + pointWeight;\n  }\n\n  // refraction / reflection code\n  if (useReflection) {\n    vReflection =\n      (viewInverseMatrix[3] - (worldMatrix * vec4(positions, 1.0))).xyz;\n  } else {\n    vReflection = vec3(1.0, 1.0, 1.0);\n  }\n\n  // pass results to varyings\n  vColor = colors;\n  vPickingColor = pickingColors;\n  vTexCoord = texCoords;\n  vNormal = transformedNormal;\n  gl_Position = projectionMatrix * worldMatrix * vec4(positions, 1.0);\n}\n';
var fs = '#define SHADER_NAME luma-default-fragment\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\n// varyings\nvarying vec4 vColor;\nvarying vec4 vPickingColor;\nvarying vec2 vTexCoord;\nvarying vec3 lightWeighting;\nvarying vec3 vReflection;\nvarying vec4 vNormal;\n\n// texture configs\nuniform bool hasTexture1;\nuniform sampler2D sampler1;\nuniform bool hasTextureCube1;\nuniform samplerCube samplerCube1;\n\n// picking configs\nuniform bool enablePicking;\nuniform bool hasPickingColors;\nuniform vec3 pickColor;\n\n// reflection / refraction configs\nuniform float reflection;\nuniform float refraction;\n\n// fog configuration\nuniform bool hasFog;\nuniform vec3 fogColor;\nuniform float fogNear;\nuniform float fogFar;\n\nvoid main(){\n  // set color from texture\n  if (!hasTexture1) {\n    gl_FragColor = vec4(vColor.rgb * lightWeighting, vColor.a);\n  } else {\n    gl_FragColor =\n      vec4(texture2D(sampler1, vec2(vTexCoord.s, vTexCoord.t)).rgb *\n      lightWeighting, 1.0);\n  }\n\n  // has cube texture then apply reflection\n  // if (hasTextureCube1) {\n  //   vec3 nReflection = normalize(vReflection);\n  //   vec3 reflectionValue;\n  //   if (refraction > 0.0) {\n  //    reflectionValue = refract(nReflection, vNormal.xyz, refraction);\n  //   } else {\n  //    reflectionValue = -reflect(nReflection, vNormal.xyz);\n  //   }\n\n  //   // TODO(nico): check whether this is right.\n  //   vec4 cubeColor = textureCube(samplerCube1,\n  //       vec3(-reflectionValue.x, -reflectionValue.y, reflectionValue.z));\n  //   gl_FragColor = vec4(mix(gl_FragColor.xyz, cubeColor.xyz, reflection), 1.0);\n  // }\n\n  // set picking\n  if (enablePicking) {\n    if (hasPickingColors) {\n      gl_FragColor = vPickingColor;\n    } else {\n      gl_FragColor = vec4(pickColor, 1.0);\n    }\n  }\n\n  // handle fog\n  // if (hasFog) {\n  //   float depth = gl_FragCoord.z / gl_FragCoord.w;\n  //   float fogFactor = smoothstep(fogNear, fogFar, depth);\n  //   gl_FragColor = mix(gl_FragColor, vec4(fogColor, gl_FragColor.w), fogFactor);\n  // }\n}\n';
var defaultUniforms = require('./default-uniforms');

module.exports = {
  default: {
    vs: vs,
    fs: fs,
    defaultUniforms: defaultUniforms
  }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9kZXByZWNhdGVkL3NoYWRlcmxpYi9pbmRleC5qcyJdLCJuYW1lcyI6WyJ2cyIsImZzIiwiZGVmYXVsdFVuaWZvcm1zIiwicmVxdWlyZSIsIm1vZHVsZSIsImV4cG9ydHMiLCJkZWZhdWx0Il0sIm1hcHBpbmdzIjoiOztBQUNBOztBQUVBO0FBQ0EsSUFBTUEsbzVFQUFOO0FBQ0EsSUFBTUMsMmdFQUFOO0FBQ0EsSUFBTUMsa0JBQWtCQyxRQUFRLG9CQUFSLENBQXhCOztBQUVBQyxPQUFPQyxPQUFQLEdBQWlCO0FBQ2ZDLFdBQVM7QUFDUE4sVUFETztBQUVQQyxVQUZPO0FBR1BDO0FBSE87QUFETSxDQUFqQiIsImZpbGUiOiJpbmRleC5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7cmVhZEZpbGVTeW5jfSBmcm9tICdmcyc7XG5pbXBvcnQge2pvaW59IGZyb20gJ3BhdGgnO1xuXG4vLyBEZWZhdWx0IFNoYWRlcnNcbmNvbnN0IHZzID0gcmVhZEZpbGVTeW5jKGpvaW4oX19kaXJuYW1lLCAnLi9kZWZhdWx0LXZlcnRleC5nbHNsJyksICd1dGY4Jyk7XG5jb25zdCBmcyA9IHJlYWRGaWxlU3luYyhqb2luKF9fZGlybmFtZSwgJy4vZGVmYXVsdC1mcmFnbWVudC5nbHNsJyksICd1dGY4Jyk7XG5jb25zdCBkZWZhdWx0VW5pZm9ybXMgPSByZXF1aXJlKCcuL2RlZmF1bHQtdW5pZm9ybXMnKTtcblxubW9kdWxlLmV4cG9ydHMgPSB7XG4gIGRlZmF1bHQ6IHtcbiAgICB2cyxcbiAgICBmcyxcbiAgICBkZWZhdWx0VW5pZm9ybXNcbiAgfVxufTtcbiJdfQ==