'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timestamp = exports.logger = exports.IS_NODE = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /**
                                                                                                                                                                                                                                                                               * Common environment setup
                                                                                                                                                                                                                                                                               */
/* eslint-disable no-console */
/* global process */


var _console = require('global/console');

var _console2 = _interopRequireDefault(_console);

var _window = require('global/window');

var _window2 = _interopRequireDefault(_window);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Duck-type Node context
var IS_NODE = exports.IS_NODE = (typeof process === 'undefined' ? 'undefined' : _typeof(process)) !== undefined && process.toString() === '[object process]';

// Configure console

// Console.debug is useful in chrome as it gives blue styling, but is not
// available in node
_console2.default.debug = _console2.default.debug || _console2.default.log;

// Some instrumentation may override console methods, so preserve them here
_console2.default.native = {
  debug: _console2.default.debug.bind(_console2.default),
  log: _console2.default.log.bind(_console2.default),
  warn: _console2.default.warn.bind(_console2.default),
  error: _console2.default.error.bind(_console2.default)
};

exports.logger = _console2.default;

// Set up high resolution timer

var timestamp = void 0;
if (IS_NODE) {
  exports.timestamp = timestamp = function timestamp() {
    var _process$hrtime = process.hrtime(),
        _process$hrtime2 = _slicedToArray(_process$hrtime, 2),
        seconds = _process$hrtime2[0],
        nanoseconds = _process$hrtime2[1];

    return seconds + nanoseconds / 1e6;
  };
} else if (_window2.default.performance) {
  exports.timestamp = timestamp = function timestamp() {
    return _window2.default.performance.now();
  };
} else {
  exports.timestamp = timestamp = function timestamp() {
    return Date.now();
  };
}

exports.timestamp = timestamp;
//# sourceMappingURL=data:application/json;base64,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