'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /* eslint-disable no-console */


exports.formatTime = formatTime;

var _env = require('./env');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// TODO - this used to use d3.format(.3s)
function formatSI(value) {
  return value.toFixed(3);
}

// TODO: Currently unused, keeping in case we want it later for log formatting
function formatTime(ms) {
  var formatted = void 0;
  if (ms < 10) {
    formatted = ms.toFixed(2) + 'ms';
  } else if (ms < 100) {
    formatted = ms.toFixed(1) + 'ms';
  } else if (ms < 1000) {
    formatted = (ms / 1000).toFixed(3) + 's';
  } else {
    formatted = (ms / 1000).toFixed(2) + 's';
  }
  return formatted;
}

var DEFAULT_CONFIG = {
  // off by default
  isEnabled: false,
  // logging level
  level: 1,
  // Whether logging is turned on
  isLogEnabled: true,
  // Whether logging prints to console
  isPrintEnabled: true,
  // Whether Probe#run executes code
  isRunEnabled: true
};

function noop() {}

var TO_DISABLE = ['_probe', '_fps', '_externalProbe', '_log', 'run', 'getOption', 'getIterationsPerSecond', 'logIterationsPerSecond'];

var Probe = function () {

  /**
   * @constructor
   * @param {Object} config Optional configuration args; see #configure
   */
  function Probe() {
    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Probe);

    // Data containers
    this._logStore = [];
    this._sampleStore = {};
    this._fpsStore = {};
    this._startStore = {};
    // Timestamps - pegged to an arbitrary time in the past
    this._startTs = (0, _env.timestamp)();
    this._deltaTs = (0, _env.timestamp)();
    // Other systems passing in epoch info require an epoch ts to convert
    this._startEpochTs = Date.now();
    this._iterationsTs = null;
    // Configuration
    this._config = config.ignoreEnvironment ? Object.assign({}, DEFAULT_CONFIG) : this._getConfigFromEnvironment();
    // Override with new configuration, if any
    this.configure(config);
    // Disable methods if necessary
    if (!this._config.isEnabled) {
      this.disable();
    }
  }

  /**
   * Turn probe on
   * @return {Probe} self, to support chaining
   */


  _createClass(Probe, [{
    key: 'enable',
    value: function enable() {
      // Swap in live methods
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = TO_DISABLE[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var method = _step.value;

          this[method] = Probe.prototype[method];
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this.configure({ isEnabled: true });
    }

    /**
     * Turn probe off
     * @return {Probe} self, to support chaining
     */

  }, {
    key: 'disable',
    value: function disable() {
      // Swap in noops for live methods
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = TO_DISABLE[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var method = _step2.value;

          this[method] = noop;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return this.configure({ isEnabled: false });
    }

    /**
     * Convenience function: Set probe level
     * @param {Number} level Level to set
     * @return {Probe} self, to support chaining
     */

  }, {
    key: 'setLevel',
    value: function setLevel(level) {
      return this.configure({ level: level });
    }

    /**
     * Configure probe with new values (can include custom key/value pairs).
     * Configuration will be persisted across browser sessions
     * @param {Object} config - named parameters
     * @param {Boolean} config.isEnabled Whether probe is enabled
     * @param {Number} config.level Logging level
     * @param {Boolean} config.isLogEnabled Whether logging prints to console
     * @param {Boolean} config.isRunEnabled Whether #run executes code
     * @return {Probe} self, to support chaining
     */

  }, {
    key: 'configure',
    value: function configure() {
      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var newConfig = Object.assign({}, this._config, config);
      this._config = newConfig;
      // if (!IS_NODE) {
      //   const serialized = JSON.stringify(newConfig);
      //   cookie.set(COOKIE_NAME, serialized);
      // }
      // Support chaining
      return this;
    }

    /**
     * Get a single option from preset configuration. Useful when using Probe to
     * set developer-only switches.
     * @param  {String} key Key to get value for
     * @return {mixed}     Option value, or undefined
     */

  }, {
    key: 'getOption',
    value: function getOption(key) {
      return this._config[key];
    }

    /**
     * Get current log, as an array of log row objects
     * @return {Object[]} Log
     */

  }, {
    key: 'getLog',
    value: function getLog() {
      return this._logStore.slice();
    }

    /**
     * Whether Probe is currently enabled
     * @return {Boolean} isEnabled
     */

  }, {
    key: 'isEnabled',
    value: function isEnabled() {
      return Boolean(this._config.isEnabled);
    }

    /**
     * Reset all internal stores, dropping logs
     */

  }, {
    key: 'reset',
    value: function reset() {
      // Data containers
      this._logStore = [];
      this._sampleStore = {};
      this._fpsStore = {};
      this._startStore = {};
      // Timestamps
      this._startTs = (0, _env.timestamp)();
      this._deltaTs = (0, _env.timestamp)();
      this._iterationsTs = null;
    }

    /**
     * Reset the long timer
     */

  }, {
    key: 'resetStart',
    value: function resetStart() {
      this._startTs = this._deltaTs = (0, _env.timestamp)();
    }

    /**
     * Reset the time since last probe
     */

  }, {
    key: 'resetDelta',
    value: function resetDelta() {
      this._deltaTs = (0, _env.timestamp)();
    }

    /**
     * @return {Number} milliseconds, with fractions
     */

  }, {
    key: 'getTotal',
    value: function getTotal() {
      return (0, _env.timestamp)() - this._startTs;
    }

    /**
     * @return {Number} milliseconds, with fractions
     */

  }, {
    key: 'getDelta',
    value: function getDelta() {
      return (0, _env.timestamp)() - this._deltaTs;
    }
  }, {
    key: '_getElapsedTime',
    value: function _getElapsedTime() {
      var total = (0, _env.timestamp)() - this._startTs;
      var delta = (0, _env.timestamp)() - this._deltaTs;
      // reset delta timer
      this._deltaTs = (0, _env.timestamp)();
      return { total: total, delta: delta };
    }
  }, {
    key: '_log',
    value: function _log(level, name) {
      var meta = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      var times = this._getElapsedTime();
      var logRow = Object.assign({ level: level, name: name }, times, meta);
      // duration handling
      if (meta.start) {
        this._startStore[name] = (0, _env.timestamp)();
      } else if (meta.end) {
        // If start isn't found, take the full duration since initialization
        var start = this._startStore[name] || this._startTs;
        logRow.duration = (0, _env.timestamp)() - start;
      }
      this._logStore.push(logRow);
      // Log to console if enabled
      if (this._config.isPrintEnabled) {
        // TODO: Nicer console logging
        _env.logger.debug(JSON.stringify(logRow));
      }
    }
  }, {
    key: '_shouldLog',
    value: function _shouldLog(probeLevel) {
      var _config = this._config,
          isEnabled = _config.isEnabled,
          isLogEnabled = _config.isLogEnabled,
          level = _config.level;

      return isEnabled && isLogEnabled && level >= probeLevel;
    }

    /**
     * Displays a double timing (from "start time" and from last probe).
     */

  }, {
    key: 'probe',
    value: function probe() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      this._probe.apply(this, [1].concat(args));
    }
  }, {
    key: 'probe1',
    value: function probe1() {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      this._probe.apply(this, [1].concat(args));
    }
  }, {
    key: 'probe2',
    value: function probe2() {
      for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      this._probe.apply(this, [2].concat(args));
    }
  }, {
    key: 'probe3',
    value: function probe3() {
      for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }

      this._probe.apply(this, [3].concat(args));
    }
  }, {
    key: '_probe',
    value: function _probe(level, name, meta) {
      if (this._shouldLog(level)) {
        this._log(level, name, meta);
      }
    }

    /**
     * Display an averaged value of the time since last probe.
     * Keyed on the first string argument.
     */

  }, {
    key: 'sample',
    value: function sample() {
      for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        args[_key5] = arguments[_key5];
      }

      this._sample.apply(this, [1].concat(args));
    }
  }, {
    key: 'sample1',
    value: function sample1() {
      for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
        args[_key6] = arguments[_key6];
      }

      this._sample.apply(this, [1].concat(args));
    }
  }, {
    key: 'sample2',
    value: function sample2() {
      for (var _len7 = arguments.length, args = Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        args[_key7] = arguments[_key7];
      }

      this._sample.apply(this, [2].concat(args));
    }
  }, {
    key: 'sample3',
    value: function sample3() {
      for (var _len8 = arguments.length, args = Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
        args[_key8] = arguments[_key8];
      }

      this._sample.apply(this, [3].concat(args));
    }
  }, {
    key: '_sample',
    value: function _sample(level, name, meta) {
      if (this._shouldLog(level)) {
        var samples = this._sampleStore;

        var probeData = samples[name] || (samples[name] = { timeSum: 0, count: 0, averageTime: 0 });
        probeData.timeSum += (0, _env.timestamp)() - this._deltaTs;
        probeData.count += 1;
        probeData.averageTime = probeData.timeSum / probeData.count;

        this._log(level, name, Object.assign({}, meta, { averageTime: probeData.averageTime }));

        // Weight more heavily on later samples. Otherwise it gets almost
        // impossible to see outliers after a while.
        if (probeData.count === 10) {
          probeData.count = 5;
          probeData.timeSum /= 2;
        }
      }
    }

    /**
     * These functions will average the time between calls and log that value
     * every couple of calls, in effect showing a times per second this
     * function is called - sometimes representing a "frames per second" count.
     */

  }, {
    key: 'fps',
    value: function fps() {
      for (var _len9 = arguments.length, args = Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
        args[_key9] = arguments[_key9];
      }

      this._fps.apply(this, [1].concat(args));
    }
  }, {
    key: 'fps1',
    value: function fps1() {
      for (var _len10 = arguments.length, args = Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
        args[_key10] = arguments[_key10];
      }

      this._fps.apply(this, [1].concat(args));
    }
  }, {
    key: 'fps2',
    value: function fps2() {
      for (var _len11 = arguments.length, args = Array(_len11), _key11 = 0; _key11 < _len11; _key11++) {
        args[_key11] = arguments[_key11];
      }

      this._fps.apply(this, [2].concat(args));
    }
  }, {
    key: 'fps3',
    value: function fps3() {
      for (var _len12 = arguments.length, args = Array(_len12), _key12 = 0; _key12 < _len12; _key12++) {
        args[_key12] = arguments[_key12];
      }

      this._fps.apply(this, [3].concat(args));
    }
  }, {
    key: '_fps',
    value: function _fps(level) {
      var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'default';
      var opts = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var _opts$count = opts.count,
          count = _opts$count === undefined ? 10 : _opts$count;

      if (this._shouldLog(level)) {
        var fpsLog = this._fpsStore;
        var fpsData = fpsLog[name];
        if (!fpsData) {
          fpsLog[name] = { count: 1, time: (0, _env.timestamp)() };
        } else if (++fpsData.count >= count) {
          var fps = fpsData.count / ((0, _env.timestamp)() - fpsData.time);
          fpsData.count = 0;
          fpsData.time = (0, _env.timestamp)();
          this._log(level, name, Object.assign({ fps: fps }, opts));
        }
      }
    }

    /**
     * Display a measurement from an external source, such as a server,
     * inline with other local measurements in the style of Probe's output.
     */

  }, {
    key: 'externalProbe',
    value: function externalProbe() {
      for (var _len13 = arguments.length, args = Array(_len13), _key13 = 0; _key13 < _len13; _key13++) {
        args[_key13] = arguments[_key13];
      }

      this._externalProbe.apply(this, [1].concat(args));
    }
  }, {
    key: 'externalProbe1',
    value: function externalProbe1() {
      for (var _len14 = arguments.length, args = Array(_len14), _key14 = 0; _key14 < _len14; _key14++) {
        args[_key14] = arguments[_key14];
      }

      this._externalProbe.apply(this, [1].concat(args));
    }
  }, {
    key: 'externalProbe2',
    value: function externalProbe2() {
      for (var _len15 = arguments.length, args = Array(_len15), _key15 = 0; _key15 < _len15; _key15++) {
        args[_key15] = arguments[_key15];
      }

      this._externalProbe.apply(this, [2].concat(args));
    }
  }, {
    key: 'externalProbe3',
    value: function externalProbe3() {
      for (var _len16 = arguments.length, args = Array(_len16), _key16 = 0; _key16 < _len16; _key16++) {
        args[_key16] = arguments[_key16];
      }

      this._externalProbe.apply(this, [3].concat(args));
    }
  }, {
    key: '_externalProbe',
    value: function _externalProbe(level, name, timeStart, timeSpent, meta) {
      if (this._shouldLog(level)) {
        // External probes are expected to provide epoch timestamps
        var total = timeStart - this._startEpochTs;
        var delta = timeSpent;
        this._log(level, name, Object.assign({ total: total, delta: delta }, meta));
      }
    }

    /* Conditionally run a function only when probe is enabled */

  }, {
    key: 'run',
    value: function run(func, arg) {
      var _config2 = this._config,
          isEnabled = _config2.isEnabled,
          isRunEnabled = _config2.isRunEnabled;

      if (isEnabled && isRunEnabled) {
        func(arg);
      }
    }
  }, {
    key: 'startIiterations',
    value: function startIiterations() {
      this._iterationsTs = (0, _env.timestamp)();
    }

    /**
     * Get config from persistent store, if available
     * @return {Object} config
     */

  }, {
    key: '_getConfigFromEnvironment',
    value: function _getConfigFromEnvironment() {
      var customConfig = {};
      if (!_env.IS_NODE) {
        var serialized = {}; // cookie.get(COOKIE_NAME);
        if (serialized) {
          customConfig = JSON.parse(serialized);
        }
      }
      return Object.assign({}, DEFAULT_CONFIG, customConfig);
    }

    /* Count iterations per second. Runs the provided function a
     * specified number of times and normalizes the result to represent
     * iterations per second.
     *
     * TODO/ib Measure one iteration and auto adjust iteration count.
     */

  }, {
    key: 'getIterationsPerSecond',
    value: function getIterationsPerSecond() {
      var iterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 10000;
      var func = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var context = arguments[2];

      if (func) {
        Probe.startIiterations();
        // Keep call overhead minimal, only use Function.call if context supplied
        if (context) {
          for (var i = 0; i < iterations; i++) {
            func.call(context);
          }
        } else {
          for (var _i = 0; _i < iterations; _i++) {
            func();
          }
        }
      }
      var elapsedMillis = (0, _env.timestamp)() - this._iterationsTs;
      var iterationsPerSecond = formatSI(iterations * 1000 / elapsedMillis);
      return iterationsPerSecond;
    }

    /*
     * Print the number of iterations per second measured using the provided
     * function
     */

  }, {
    key: 'logIterationsPerSecond',
    value: function logIterationsPerSecond(testName) {
      var iterations = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 10000;
      var func = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

      var elapsedMs = this.getIterationsPerSecond(iterations, func, context);
      var iterationsPerSecond = formatSI(iterations * 1000 / elapsedMs);
      _env.logger.log(testName + ': ' + iterationsPerSecond + ' iterations/s');
    }

    /**
     * Show current log in a table, if supported by console
     * @param {Number} tail If supplied, show only the last n entries
     */

  }, {
    key: 'table',
    value: function table(tail) {
      if (typeof _env.logger.table === 'function') {
        var rows = tail ? this._logStore.slice(-tail) : this._logStore;
        _env.logger.table(rows);
      }
    }
  }]);

  return Probe;
}();

exports.default = Probe;
//# sourceMappingURL=data:application/json;base64,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