'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fragmentShader = exports.vertexShader = exports.config = exports.name = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.getUniforms = getUniforms;

var _path = require('path');

var _math = require('../../../packages/math');

var commonShader = Buffer('', 'base64');

var name = exports.name = 'lighting';

var config = exports.config = {
  MAX_POINT_LIGHTS: 4
};

var vertexShader = exports.vertexShader = commonShader + '\n' + Buffer('CiNkZWZpbmUgTElHSFRfTUFYIDQKCi8qCi8vIGxpZ2h0aW5nIGNvbmZpZ3VyYXRpb24KdW5pZm9ybSBib29sIGVuYWJsZUxpZ2h0czsKdW5pZm9ybSB2ZWMzIGFtYmllbnRDb2xvcjsKdW5pZm9ybSB2ZWMzIGRpcmVjdGlvbmFsQ29sb3I7CnVuaWZvcm0gdmVjMyBsaWdodGluZ0RpcmVjdGlvbjsKCi8vIHBvaW50IGxpZ2h0cyBjb25maWd1cmF0aW9uCnVuaWZvcm0gdmVjMyBwb2ludExvY2F0aW9uW0xJR0hUX01BWF07CnVuaWZvcm0gdmVjMyBwb2ludENvbG9yW0xJR0hUX01BWF07CnVuaWZvcm0gaW50IG51bWJlclBvaW50czsKCi8vIHJlZmxlY3Rpb24gLyByZWZyYWN0aW9uIGNvbmZpZ3VyYXRpb24KdW5pZm9ybSBib29sIHVzZVJlZmxlY3Rpb247CiovCgp1bmlmb3JtIGJvb2wgbGlnaHRpbmdfdUVuYWJsZUxpZ2h0czsKdW5pZm9ybSB2ZWMzIGxpZ2h0aW5nX3VBbWJpZW50Q29sb3I7CnVuaWZvcm0gdmVjMyBsaWdodGluZ191RGlyZWN0aW9uOwp1bmlmb3JtIHZlYzMgbGlnaHRpbmdfdURpcmVjdGlvbmFsQ29sb3I7CgovLyBwb2ludCBsaWdodHMgY29uZmlndXJhdGlvbgp1bmlmb3JtIGludCAgbGlnaHRpbmdfdVBvaW50Q291bnQ7CnVuaWZvcm0gdmVjMyBsaWdodGluZ191UG9pbnRMb2NhdGlvbltMSUdIVF9NQVhdOwp1bmlmb3JtIHZlYzMgbGlnaHRpbmdfdVBvaW50Q29sb3JbTElHSFRfTUFYXTsKCi8vIHJlZmxlY3Rpb24gLyByZWZyYWN0aW9uIGNvbmZpZ3VyYXRpb24KdW5pZm9ybSBib29sIGxpZ2h0aW5nX3VFbmFibGVSZWZsZWN0aW9uczsKCi8vIHZhcnlpbmdzCnZhcnlpbmcgdmVjNCBsaWdodGluZ192UG9zaXRpb247CnZhcnlpbmcgdmVjNCBsaWdodGluZ192Tm9ybWFsOwp2YXJ5aW5nIHZlYzMgbGlnaHRpbmdfdkNvbG9yOwp2YXJ5aW5nIHZlYzMgbGlnaHRpbmdfdkxpZ2h0V2VpZ2h0aW5nOwp2YXJ5aW5nIHZlYzMgbGlnaHRpbmdfdlJlZmxlY3Rpb247Cgp2b2lkIGxpZ2h0aW5nX3NldFBvc2l0aW9uQW5kTm9ybWFsKHZlYzMgcG9zaXRpb24sIHZlYzMgbm9ybWFsKSB7CiAgbGlnaHRpbmdfdlBvc2l0aW9uID0gd29ybGRNYXRyaXggKiB2ZWM0KHBvc2l0aW9uLCAxLik7CiAgbGlnaHRpbmdfdk5vcm1hbCA9IHdvcmxkSW52ZXJzZVRyYW5zcG9zZU1hdHJpeCAqIHZlYzQobm9ybWFsLCAxLik7Owp9Cgp2b2lkIGxpZ2h0aW5nX19nZXRMaWdodFdlaWd0aW5nKCkgewogIGZsb2F0IGRpcmVjdGlvbmFsTGlnaHRXZWlnaHRpbmcgPSBtYXgoZG90KGxpZ2h0aW5nX3ZOb3JtYWwueHl6LCBsaWdodGluZ191RGlyZWN0aW9uKSwgMC4pOwogIHZlYzMgcG9pbnRXZWlnaHQgPSB2ZWMzKDAuLCAwLiwgMC4pOwogIGZvciAoaW50IGkgPSAwOyBpIDwgTElHSFRfTUFYOyBpKyspIHsKICAgIGlmIChpIDwgbnVtYmVyUG9pbnRzKSB7CiAgICAgIHZlYzQgbXZMaWdodFBvc2l0aW9uID0gdmlld01hdHJpeCAqIHZlYzQobGlnaHRpbmdfdVBvaW50TG9jYXRpb25baV0sIDEuKTsKICAgICAgdmVjMyBwb2ludExpZ2h0RGlyZWN0aW9uID0gbm9ybWFsaXplKG12TGlnaHRQb3NpdGlvbi54eXogLSBsaWdodGluZ192UG9zaXRpb24ueHl6KTsKICAgICAgcG9pbnRXZWlnaHQgKz0gbWF4KGRvdChsaWdodGluZ192Tm9ybWFsLnh5eiwgcG9pbnRMaWdodERpcmVjdGlvbiksIDAuKSAqIHBvaW50Q29sb3JbaV07CiAgICAgfSBlbHNlIHsKICAgICAgIGJyZWFrOwogICAgIH0KICAgfQogICByZXR1cm4gYW1iaWVudENvbG9yICsgKGRpcmVjdGlvbmFsQ29sb3IgKiBkaXJlY3Rpb25hbExpZ2h0V2VpZ2h0aW5nKSArIHBvaW50V2VpZ2h0Owp9Cgp2b2lkIGxpZ2h0aW5nX2FwcGx5KHZlYzMgcG9zaXRpb24sIHZlYzMgbm9ybWFsKSB7CiAgbGlnaHRpbmdfc2V0UG9zaXRpb25BbmROb3JtYWwocG9zaXRpb24sIG5vcm1hbCk7CgogIC8vIGxpZ2h0aW5nIGNvZGUKICBpZighbGlnaHRpbmdfdUVuYWJsZUxpZ2h0cykgewogICAgbGlnaHRpbmdfdkxpZ2h0V2VpZ2h0aW5nID0gdmVjMygxLiwgMS4sIDEuKTsKICB9IGVsc2UgewogICAgbGlnaHRpbmdfdkxpZ2h0V2VpZ2h0aW5nID0gbGlnaHRpbmdfX2dldExpZ2h0V2VpZ2h0aW5nKCk7CiAgfQp9Cgp2b2lkIGxpZ2h0aW5nX3NldF9yZWZsZWN0aW9uKHZlYzMgcG9zaXRpb24pIHsKICAgIC8vIHJlZnJhY3Rpb24gLyByZWZsZWN0aW9uIGNvZGUKICBpZiAobGlnaHRpbmdfdUVuYWJsZVJlZmxlY3Rpb25zKSB7CiAgICBsaWdodGluZ192UmVmbGVjdGlvbiA9ICh2aWV3SW52ZXJzZU1hdHJpeFszXSAtICh3b3JsZE1hdHJpeCAqIHZlYzQocG9zaXRpb24sIDEuKSkpLnh5ejsKICB9IGVsc2UgewogICAgbGlnaHRpbmdfdlJlZmxlY3Rpb24gPSB2ZWMzKDEuLCAxLiwgMS4pOwogIH0KfQo=', 'base64') + '\n';

var fragmentShader = exports.fragmentShader = commonShader + '\n' + Buffer('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', 'base64') + '\n';

// Setup the lighting system: ambient, directional, point lights.
function getUniforms(_ref) {
  var _ref$lightingEnable = _ref.lightingEnable,
      lightingEnable = _ref$lightingEnable === undefined ? false : _ref$lightingEnable,
      _ref$lightingAmbientC = _ref.lightingAmbientColor,
      lightingAmbientColor = _ref$lightingAmbientC === undefined ? [0.2, 0.2, 0.2] : _ref$lightingAmbientC,
      _ref$lightingDirectio = _ref.lightingDirection,
      lightingDirection = _ref$lightingDirectio === undefined ? [1, 1, 1] : _ref$lightingDirectio,
      _ref$lightingDirectio2 = _ref.lightingDirectionalColor,
      lightingDirectionalColor = _ref$lightingDirectio2 === undefined ? [0, 0, 0] : _ref$lightingDirectio2,
      _ref$lightingPointLig = _ref.lightingPointLights,
      lightingPointLights = _ref$lightingPointLig === undefined ? [] : _ref$lightingPointLig;

  // Set light uniforms. Ambient, directional and point lights.
  return _extends({
    lightingEnable: lightingEnable,
    // Ambient
    lightingAmbientColor: lightingAmbientColor
  }, getDirectionalUniforms(lightingDirection), getPointUniforms(lightingPointLights));
}

function getDirectionalUniforms(_ref2) {
  var color = _ref2.color,
      direction = _ref2.direction;

  // Normalize lighting direction vector
  var dir = new _math.Vector3(direction.x, direction.y, direction.z).normalize().scale(-1, -1, -1);

  return {
    directionalColor: [color.r, color.g, color.b],
    lightingDirection: [dir.x, dir.y, dir.z]
  };
}

function getPointUniforms(points) {
  points = points instanceof Array ? points : [points];
  var numberPoints = points.length;
  var pointLocations = [];
  var pointColors = [];
  var enableSpecular = [];
  var pointSpecularColors = [];
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = points[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var point = _step.value;
      var position = point.position,
          color = point.color,
          diffuse = point.diffuse,
          specular = point.specular;

      var pointColor = color || diffuse;

      pointLocations.push(position.x, position.y, position.z);
      pointColors.push(pointColor.r, pointColor.g, pointColor.b);

      // Add specular color
      enableSpecular.push(Number(Boolean(specular)));
      if (specular) {
        pointSpecularColors.push(specular.r, specular.g, specular.b);
      } else {
        pointSpecularColors.push(0, 0, 0);
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return {
    numberPoints: numberPoints,
    pointLocation: pointLocations,
    pointColor: pointColors,
    enableSpecular: enableSpecular,
    pointSpecularColor: pointSpecularColors
  };
}
//# sourceMappingURL=data:application/json;base64,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