'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _webgl = require('../../webgl');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ERR_SOURCE = 'ShaderCache expects source strings';
var ERR_CONTEXT = 'ShaderCache does not support caching across multiple contexts';

var ShaderCache = function () {

  /**
   * A cache of compiled shaders, keyed by shader source strings.
   * Compilation of long shaders can be time consuming.
   * By using this class, the application can ensure that each shader
   * is only compiled once.
   */
  function ShaderCache() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        gl = _ref.gl;

    _classCallCheck(this, ShaderCache);

    this.gl = gl;
    this.vertexShaders = {};
    this.fragmentShaders = {};
  }

  /**
   * Deletes shader references
   * @return {ShaderCache} - returns this for chaining
   */


  _createClass(ShaderCache, [{
    key: 'delete',
    value: function _delete() {
      // TODO - requires reference counting to avoid deleting shaders in use
      return this;
    }

    /**
     * Returns a compiled `VertexShader` object corresponding to the supplied
     * GLSL source code string, if possible from cache.
     *
     * @param {WebGLRenderingContext} gl - gl context
     * @param {String} source - Source code for shader
     * @return {VertexShader} - a compiled vertex shader
     */

  }, {
    key: 'getVertexShader',
    value: function getVertexShader(gl, source) {
      (0, _assert2.default)(typeof source === 'string', ERR_SOURCE);

      var shader = this.vertexShaders[source];
      (0, _assert2.default)(!shader || shader.gl === gl, ERR_CONTEXT);

      if (!shader) {
        shader = new _webgl.VertexShader(gl, source);
        this.vertexShaders[source] = shader;
      }
      return shader;
    }

    /**
     * Returns a compiled `VertexShader` object corresponding to the supplied
     * GLSL source code string, if possible from cache.
     *
     * @param {WebGLRenderingContext} gl - gl context
     * @param {String} source - Source code for shader
     * @return {FragmentShader} - a compiled fragment shader, possibly from chache
     */

  }, {
    key: 'getFragmentShader',
    value: function getFragmentShader(gl, source) {
      (0, _assert2.default)(typeof source === 'string', ERR_SOURCE);

      var shader = this.fragmentShaders[source];
      (0, _assert2.default)(!shader || shader.gl === gl, ERR_CONTEXT);

      if (!shader) {
        shader = new _webgl.FragmentShader(gl, source);
        this.fragmentShaders[source] = shader;
      }
      return shader;
    }
  }]);

  return ShaderCache;
}();

exports.default = ShaderCache;
//# sourceMappingURL=data:application/json;base64,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