'use strict';

require('luma.gl/headless');

var _luma = require('luma.gl');

var _ = require('..');

var _tapeCatch = require('tape-catch');

var _tapeCatch2 = _interopRequireDefault(_tapeCatch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var fixture = {
  gl: (0, _luma.createGLContext)()
};

var VS1 = '\nattribute vec3 positions;\n\nuniform mat4 uMVMatrix;\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * uMVMatrix * vec4(positions, 1.0);\n}\n';

var VS2 = '\nattribute vec3 positions;\n\nuniform mat4 uMVMatrix;\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * uMVMatrix * vec4(positions, 1.0);\n}\n';

var VS3 = '\nattribute vec3 positions;\n\nuniform mat4 uPMatrix;\n\nvoid main(void) {\n  gl_Position = uPMatrix * vec4(positions, 1.0);\n}\n';

var FS1 = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n}\n';

var FS2 = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\n}\n';

var FS3 = '\nvoid main(void) {\n  gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n}\n';

(0, _tapeCatch2.default)('Experimental#ShaderCache import', function (t) {
  t.ok(_.ShaderCache !== undefined, 'ShaderCache import successful');
  t.end();
});

(0, _tapeCatch2.default)('Experimental#ShaderCache construct/delete', function (t) {
  var shaderCache = new _.ShaderCache();
  t.ok(shaderCache instanceof _.ShaderCache, 'ShaderCache construction successful');
  shaderCache = shaderCache.delete();
  t.ok(shaderCache instanceof _.ShaderCache, 'ShaderCache delete successful');
  t.end();
});

(0, _tapeCatch2.default)('Experimental#ShaderCache get cached vertex shaders', function (t) {
  var gl = fixture.gl;


  var shaderCache = new _.ShaderCache(gl);

  var vs1 = shaderCache.getVertexShader(gl, VS1);
  var vs2 = shaderCache.getVertexShader(gl, VS2);

  t.ok(vs1 instanceof _luma.VertexShader, 'Got good VertexShader from cache');
  t.ok(vs2 instanceof _luma.VertexShader, 'Got good VertexShader from cache');

  t.equal(vs1, vs2, 'Second VertexShader was cached');

  var vs3 = shaderCache.getVertexShader(gl, VS3);
  t.ok(vs3 instanceof _luma.VertexShader, 'Got good VertexShader from cache');

  t.notEqual(vs1, vs3, 'Third VertexShader was not cached');

  t.end();
});

(0, _tapeCatch2.default)('Experimental#ShaderCache get cached fragment shaders', function (t) {
  var gl = fixture.gl;


  var shaderCache = new _.ShaderCache(gl);

  var fs1 = shaderCache.getFragmentShader(gl, FS1);
  var fs2 = shaderCache.getFragmentShader(gl, FS2);

  t.ok(fs1 instanceof _luma.FragmentShader, 'Got good FragmentShader from cache');
  t.ok(fs2 instanceof _luma.FragmentShader, 'Got good FragmentShader from cache');

  t.equal(fs1, fs2, 'Second FragmentShader was cached');

  var fs3 = shaderCache.getFragmentShader(gl, FS3);
  t.ok(fs3 instanceof _luma.FragmentShader, 'Got good FragmentShader from cache');

  t.notEqual(fs1, fs3, 'Third FragmentShader was not cached');

  t.end();
});

(0, _tapeCatch2.default)('Experimental#ShaderCache - construct Program from cached shaders', function (t) {
  var gl = fixture.gl;


  var shaderCache = new _.ShaderCache();
  shaderCache.getVertexShader(gl, VS1);
  shaderCache.getFragmentShader(gl, FS1);

  var program = new _luma.Program(gl, {
    vs: shaderCache.getVertexShader(gl, VS1),
    fs: shaderCache.getFragmentShader(gl, FS1)
  });
  t.ok(program instanceof _luma.Program, 'Program constructed from cached shaders successful ');

  program = program.delete();
  t.ok(program instanceof _luma.Program, 'Program delete successful');

  var program2 = new _luma.Program(gl, {
    vs: shaderCache.getVertexShader(gl, VS1),
    fs: shaderCache.getFragmentShader(gl, FS1)
  });
  t.ok(program2 instanceof _luma.Program, 'Program constructed from cached shaders successful after delete of first program');

  t.end();
});
//# sourceMappingURL=data:application/json;base64,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