'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _geometry = require('./geometry');

var _geometry2 = _interopRequireDefault(_geometry);

var _utils = require('../utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CubeGeometry = function (_Geometry) {
  _inherits(CubeGeometry, _Geometry);

  function CubeGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, CubeGeometry);

    var _opts$id = opts.id,
        id = _opts$id === undefined ? (0, _utils.uid)('cube-geometry') : _opts$id;
    return _possibleConstructorReturn(this, (CubeGeometry.__proto__ || Object.getPrototypeOf(CubeGeometry)).call(this, Object.assign({}, opts, { id: id, attributes: getCubeAttributes() })));
  }

  return CubeGeometry;
}(_geometry2.default);

/* eslint-disable no-multi-spaces, indent */


exports.default = CubeGeometry;
var CUBE_INDICES = new Uint16Array([0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11, 12, 13, 14, 12, 14, 15, 16, 17, 18, 16, 18, 19, 20, 21, 22, 20, 22, 23]);

var CUBE_POSITIONS = new Float32Array([-1, -1, 1, 1, -1, 1, 1, 1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, 1, 1, -1, 1, -1, -1, -1, 1, -1, -1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 1, -1, -1, 1, -1, 1, -1, -1, 1, 1, -1, -1, 1, 1, -1, 1, 1, 1, 1, -1, 1, -1, -1, -1, -1, -1, 1, -1, 1, 1, -1, 1, -1]);

var CUBE_NORMALS = new Float32Array([
// Front face
0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0,

// Back face
0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0,

// Top face
0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0,

// Bottom face
0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0,

// Right face
1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0,

// Left face
-1.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0]);

var CUBE_TEX_COORDS = new Float32Array([
// Front face
0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0,

// Back face
1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0,

// Top face
0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0,

// Bottom face
1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0,

// Right face
1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0,

// Left face
0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0]);
/* eslint-enable no-multi-spaces, indent */

function getCubeAttributes() {
  return {
    indices: new Uint16Array(CUBE_INDICES),
    positions: new Float32Array(CUBE_POSITIONS),
    normals: new Float32Array(CUBE_NORMALS),
    texCoords: new Float32Array(CUBE_TEX_COORDS)
  };
}
//# sourceMappingURL=data:application/json;base64,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