'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _utils = require('../utils');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ILLEGAL_ARG = 'Geometry: Illegal argument';

var Geometry = function () {
  function Geometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Geometry);

    var id = opts.id,
        _opts$drawMode = opts.drawMode,
        drawMode = _opts$drawMode === undefined ? 'TRIANGLES' : _opts$drawMode,
        _opts$vertexCount = opts.vertexCount,
        vertexCount = _opts$vertexCount === undefined ? undefined : _opts$vertexCount,
        attributes = opts.attributes;


    (0, _assert2.default)(drawMode, ILLEGAL_ARG);

    this.id = id || (0, _utils.uid)(this.constructor.name);
    this.drawMode = drawMode;
    this.vertexCount = vertexCount;
    this.attributes = {};
    this.needsRedraw = true;
    this.userData = {};
    Object.seal(this);

    if (attributes) {
      this.setAttributes(attributes);
    } else {
      _utils.log.once('Geometry: top-level attributes are deprecated, use "attributes" param');
      // TODO this is deprecated
      delete opts.id;
      delete opts.drawMode;
      delete opts.vertexCount;
      delete opts.attributes;
      this.setAttributes(opts);
    }
  }

  _createClass(Geometry, [{
    key: 'setNeedsRedraw',
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      this.needsRedraw = redraw;
      return this;
    }
  }, {
    key: 'getNeedsRedraw',
    value: function getNeedsRedraw() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$clearRedrawFlags = _ref.clearRedrawFlags,
          clearRedrawFlags = _ref$clearRedrawFlags === undefined ? false : _ref$clearRedrawFlags;

      var redraw = false;
      redraw = redraw || this.needsRedraw;
      this.needsRedraw = this.needsRedraw && !clearRedrawFlags;
      return redraw;
    }
  }, {
    key: 'setVertexCount',
    value: function setVertexCount(vertexCount) {
      this.vertexCount = vertexCount;
    }
  }, {
    key: 'getVertexCount',
    value: function getVertexCount() {
      if (this.vertexCount !== undefined) {
        return this.vertexCount;
      } else if (this.attributes.indices) {
        return this.attributes.indices.value.length;
      } else if (this.attributes.vertices) {
        return this.attributes.vertices.value.length / 3;
      } else if (this.attributes.positions) {
        return this.attributes.positions.value.length / 3;
      }
      return false;
    }
  }, {
    key: 'hasAttribute',
    value: function hasAttribute(attributeName) {
      return Boolean(this.attributes[attributeName]);
    }
  }, {
    key: 'getAttribute',
    value: function getAttribute(attributeName) {
      var attribute = this.attributes[attributeName];
      (0, _assert2.default)(attribute);
      return attribute.value;
    }
  }, {
    key: 'getArray',
    value: function getArray(attributeName) {
      var attribute = this.attributes[attributeName];
      (0, _assert2.default)(attribute);
      return attribute.value;
    }
  }, {
    key: 'getAttributes',
    value: function getAttributes() {
      return this.attributes;
    }

    // Attribute
    // value: typed array
    // type: indices, vertices, uvs
    // size: elements per vertex
    // target: WebGL buffer type (string or constant)

  }, {
    key: 'setAttributes',
    value: function setAttributes(attributes) {
      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        // Wrap "unwrapped" arrays and try to autodetect their type
        attribute = ArrayBuffer.isView(attribute) ? { value: attribute } : attribute;

        (0, _assert2.default)(ArrayBuffer.isView(attribute.value), this._print(attributeName) + ': must be typed array or object with value as typed array');

        this._autoDetectAttribute(attributeName, attribute);

        this.attributes[attributeName] = Object.assign({}, attribute, {
          instanced: attribute.instanced || 0
        });
      }
      this.setNeedsRedraw();
      return this;
    }

    // Check for well known attribute names
    /* eslint-disable default-case, complexity */

  }, {
    key: '_autoDetectAttribute',
    value: function _autoDetectAttribute(attributeName, attribute) {
      var category = void 0;
      switch (attributeName) {
        case 'indices':
          category = category || 'indices';
          break;
        case 'texCoords':
        case 'texCoord1':
        case 'texCoord2':
        case 'texCoord3':
          category = 'uvs';
          break;
        case 'vertices':
        case 'positions':
        case 'normals':
        case 'pickingColors':
          category = 'vectors';
          break;
      }

      // Check for categorys
      switch (category) {
        case 'vectors':
          attribute.size = attribute.size || 3;
          break;
        case 'uvs':
          attribute.size = attribute.size || 2;
          break;
        case 'indices':
          attribute.size = attribute.size || 1;
          attribute.isIndexed = attribute.isIndexed || true;
          (0, _assert2.default)(attribute.value instanceof Uint16Array || attribute.value instanceof Uint32Array, 'attribute array for "indices" must be of integer type');
          break;
      }

      (0, _assert2.default)(attribute.size, 'attribute ' + attributeName + ' needs size');
    }
    /* eslint-enable default-case, complexity */

  }, {
    key: '_print',
    value: function _print(attributeName) {
      return 'Geometry ' + this.id + ' attribute ' + attributeName;
    }
  }]);

  return Geometry;
}();

exports.default = Geometry;
//# sourceMappingURL=data:application/json;base64,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