'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _geometry = require('./geometry');

var _geometry2 = _interopRequireDefault(_geometry);

var _math = require('../packages/math');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/* eslint-disable comma-spacing, max-statements, complexity */

var ICO_POSITIONS = [-1, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 1, 0, -1, 0, 1, 0, 0];
var ICO_INDICES = [3, 4, 5, 3, 5, 1, 3, 1, 0, 3, 0, 4, 4, 0, 2, 4, 2, 5, 2, 0, 1, 5, 2, 1];

var IcoSphereGeometry = function (_Geometry) {
  _inherits(IcoSphereGeometry, _Geometry);

  function IcoSphereGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, IcoSphereGeometry);

    var _ref = {},
        _ref$iterations = _ref.iterations,
        iterations = _ref$iterations === undefined ? 0 : _ref$iterations;


    var PI = Math.PI;
    var PI2 = PI * 2;

    var positions = [].concat(ICO_POSITIONS);
    var indices = [].concat(ICO_INDICES);

    positions.push();
    indices.push();

    var getMiddlePoint = function () {
      var pointMemo = {};

      return function (i1, i2) {
        i1 *= 3;
        i2 *= 3;
        var mini = i1 < i2 ? i1 : i2;
        var maxi = i1 > i2 ? i1 : i2;
        var key = mini + '|' + maxi;

        if (key in pointMemo) {
          return pointMemo[key];
        }

        var x1 = positions[i1];
        var y1 = positions[i1 + 1];
        var z1 = positions[i1 + 2];
        var x2 = positions[i2];
        var y2 = positions[i2 + 1];
        var z2 = positions[i2 + 2];
        var xm = (x1 + x2) / 2;
        var ym = (y1 + y2) / 2;
        var zm = (z1 + z2) / 2;
        var len = Math.sqrt(xm * xm + ym * ym + zm * zm);

        xm /= len;
        ym /= len;
        zm /= len;

        positions.push(xm, ym, zm);

        return pointMemo[key] = positions.length / 3 - 1;
      };
    }();

    for (var i = 0; i < iterations; i++) {
      var indices2 = [];
      for (var j = 0; j < indices.length; j += 3) {
        var a = getMiddlePoint(indices[j + 0], indices[j + 1]);
        var b = getMiddlePoint(indices[j + 1], indices[j + 2]);
        var c = getMiddlePoint(indices[j + 2], indices[j + 0]);

        indices2.push(c, indices[j + 0], a, a, indices[j + 1], b, b, indices[j + 2], c, a, b, c);
      }
      indices = indices2;
    }

    // Calculate texCoords and normals
    var normals = new Array(indices.length * 3);
    var texCoords = new Array(indices.length * 2);

    var l = indices.length;
    for (var _i = l - 3; _i >= 0; _i -= 3) {
      var i1 = indices[_i + 0];
      var i2 = indices[_i + 1];
      var i3 = indices[_i + 2];
      var in1 = i1 * 3;
      var in2 = i2 * 3;
      var in3 = i3 * 3;
      var iu1 = i1 * 2;
      var iu2 = i2 * 2;
      var iu3 = i3 * 2;
      var x1 = positions[in1 + 0];
      var y1 = positions[in1 + 1];
      var z1 = positions[in1 + 2];
      var theta1 = Math.acos(z1 / Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
      var phi1 = Math.atan2(y1, x1) + PI;
      var v1 = theta1 / PI;
      var u1 = 1 - phi1 / PI2;
      var x2 = positions[in2 + 0];
      var y2 = positions[in2 + 1];
      var z2 = positions[in2 + 2];
      var theta2 = Math.acos(z2 / Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2));
      var phi2 = Math.atan2(y2, x2) + PI;
      var v2 = theta2 / PI;
      var u2 = 1 - phi2 / PI2;
      var x3 = positions[in3 + 0];
      var y3 = positions[in3 + 1];
      var z3 = positions[in3 + 2];
      var theta3 = Math.acos(z3 / Math.sqrt(x3 * x3 + y3 * y3 + z3 * z3));
      var phi3 = Math.atan2(y3, x3) + PI;
      var v3 = theta3 / PI;
      var u3 = 1 - phi3 / PI2;
      var vec1 = [x3 - x2, y3 - y2, z3 - z2];
      var vec2 = [x1 - x2, y1 - y2, z1 - z2];
      var normal = _math.Vector3.cross(vec1, vec2).normalize();
      var newIndex = void 0;

      if ((u1 === 0 || u2 === 0 || u3 === 0) && (u1 === 0 || u1 > 0.5) && (u2 === 0 || u2 > 0.5) && (u3 === 0 || u3 > 0.5)) {

        positions.push(positions[in1 + 0], positions[in1 + 1], positions[in1 + 2]);
        newIndex = positions.length / 3 - 1;
        indices.push(newIndex);
        texCoords[newIndex * 2 + 0] = 1;
        texCoords[newIndex * 2 + 1] = v1;
        normals[newIndex * 3 + 0] = normal.x;
        normals[newIndex * 3 + 1] = normal.y;
        normals[newIndex * 3 + 2] = normal.z;

        positions.push(positions[in2 + 0], positions[in2 + 1], positions[in2 + 2]);
        newIndex = positions.length / 3 - 1;
        indices.push(newIndex);
        texCoords[newIndex * 2 + 0] = 1;
        texCoords[newIndex * 2 + 1] = v2;
        normals[newIndex * 3 + 0] = normal.x;
        normals[newIndex * 3 + 1] = normal.y;
        normals[newIndex * 3 + 2] = normal.z;

        positions.push(positions[in3 + 0], positions[in3 + 1], positions[in3 + 2]);
        newIndex = positions.length / 3 - 1;
        indices.push(newIndex);
        texCoords[newIndex * 2 + 0] = 1;
        texCoords[newIndex * 2 + 1] = v3;
        normals[newIndex * 3 + 0] = normal.x;
        normals[newIndex * 3 + 1] = normal.y;
        normals[newIndex * 3 + 2] = normal.z;
      }

      normals[in1 + 0] = normals[in2 + 0] = normals[in3 + 0] = normal.x;
      normals[in1 + 1] = normals[in2 + 1] = normals[in3 + 1] = normal.y;
      normals[in1 + 2] = normals[in2 + 2] = normals[in3 + 2] = normal.z;

      texCoords[iu1 + 0] = u1;
      texCoords[iu1 + 1] = v1;

      texCoords[iu2 + 0] = u2;
      texCoords[iu2 + 1] = v2;

      texCoords[iu3 + 0] = u3;
      texCoords[iu3 + 1] = v3;
    }

    return _possibleConstructorReturn(this, (IcoSphereGeometry.__proto__ || Object.getPrototypeOf(IcoSphereGeometry)).call(this, Object.assign({}, opts, {
      attributes: {
        positions: new Float32Array(positions),
        normals: new Float32Array(normals),
        texCoords: new Float32Array(texCoords),
        indices: new Uint16Array(indices)
      }
    })));
  }

  return IcoSphereGeometry;
}(_geometry2.default);

exports.default = IcoSphereGeometry;
//# sourceMappingURL=data:application/json;base64,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