'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _geometry = require('./geometry');

var _geometry2 = _interopRequireDefault(_geometry);

var _utils = require('../utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SphereGeometry = function (_Geometry) {
  _inherits(SphereGeometry, _Geometry);

  function SphereGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, SphereGeometry);

    var _opts$nlat = opts.nlat,
        nlat = _opts$nlat === undefined ? 10 : _opts$nlat,
        _opts$nlong = opts.nlong,
        nlong = _opts$nlong === undefined ? 10 : _opts$nlong,
        _opts$radius = opts.radius,
        radius = _opts$radius === undefined ? 1 : _opts$radius,
        _opts$id = opts.id,
        id = _opts$id === undefined ? (0, _utils.uid)('sphere-geometry') : _opts$id;
    return _possibleConstructorReturn(this, (SphereGeometry.__proto__ || Object.getPrototypeOf(SphereGeometry)).call(this, Object.assign({}, opts, { id: id, attributes: getSphereAttributes(nlat, nlong, radius) })));
  }

  return SphereGeometry;
}(_geometry2.default);

// Primitives inspired by TDL http://code.google.com/p/webglsamples/,
// copyright 2011 Google Inc. new BSD License
// (http://www.opensource.org/licenses/bsd-license.php).
/* eslint-disable max-statements, complexity */


exports.default = SphereGeometry;
function getSphereAttributes(nlat, nlong, radius) {
  var startLat = 0;
  var endLat = Math.PI;
  var latRange = endLat - startLat;
  var startLong = 0;
  var endLong = 2 * Math.PI;
  var longRange = endLong - startLong;
  var numVertices = (nlat + 1) * (nlong + 1);

  if (typeof radius === 'number') {
    (function () {
      var value = radius;
      radius = function radius(n1, n2, n3, u, v) {
        return value;
      };
    })();
  }

  var positions = new Float32Array(numVertices * 3);
  var normals = new Float32Array(numVertices * 3);
  var texCoords = new Float32Array(numVertices * 2);
  var indices = new Uint16Array(nlat * nlong * 6);

  // Create positions, normals and texCoords
  for (var y = 0; y <= nlat; y++) {
    for (var x = 0; x <= nlong; x++) {

      var u = x / nlong;
      var v = y / nlat;

      var index = x + y * (nlong + 1);
      var i2 = index * 2;
      var i3 = index * 3;

      var theta = longRange * u;
      var phi = latRange * v;
      var sinTheta = Math.sin(theta);
      var cosTheta = Math.cos(theta);
      var sinPhi = Math.sin(phi);
      var cosPhi = Math.cos(phi);
      var ux = cosTheta * sinPhi;
      var uy = cosPhi;
      var uz = sinTheta * sinPhi;

      var r = radius(ux, uy, uz, u, v);

      positions[i3 + 0] = r * ux;
      positions[i3 + 1] = r * uy;
      positions[i3 + 2] = r * uz;

      normals[i3 + 0] = ux;
      normals[i3 + 1] = uy;
      normals[i3 + 2] = uz;

      texCoords[i2 + 0] = u;
      texCoords[i2 + 1] = v;
    }
  }

  // Create indices
  var numVertsAround = nlat + 1;
  for (var _x2 = 0; _x2 < nlat; _x2++) {
    for (var _y = 0; _y < nlong; _y++) {
      var _index = (_x2 * nlong + _y) * 6;

      indices[_index + 0] = _y * numVertsAround + _x2;
      indices[_index + 1] = _y * numVertsAround + _x2 + 1;
      indices[_index + 2] = (_y + 1) * numVertsAround + _x2;

      indices[_index + 3] = (_y + 1) * numVertsAround + _x2;
      indices[_index + 4] = _y * numVertsAround + _x2 + 1;
      indices[_index + 5] = (_y + 1) * numVertsAround + _x2 + 1;
    }
  }

  return {
    positions: positions,
    indices: indices,
    normals: normals,
    texCoords: texCoords
  };
}
//# sourceMappingURL=data:application/json;base64,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