'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _geometry = require('./geometry');

var _geometry2 = _interopRequireDefault(_geometry);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TruncatedConeGeometry = function (_Geometry) {
  _inherits(TruncatedConeGeometry, _Geometry);

  // Primitives inspired by TDL http://code.google.com/p/webglsamples/,
  // copyright 2011 Google Inc. new BSD License
  // (http://www.opensource.org/licenses/bsd-license.php).
  /* eslint-disable max-statements, complexity */
  function TruncatedConeGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, TruncatedConeGeometry);

    var _opts$bottomRadius = opts.bottomRadius,
        bottomRadius = _opts$bottomRadius === undefined ? 0 : _opts$bottomRadius,
        _opts$topRadius = opts.topRadius,
        topRadius = _opts$topRadius === undefined ? 0 : _opts$topRadius,
        _opts$height = opts.height,
        height = _opts$height === undefined ? 1 : _opts$height,
        _opts$nradial = opts.nradial,
        nradial = _opts$nradial === undefined ? 10 : _opts$nradial,
        _opts$nvertical = opts.nvertical,
        nvertical = _opts$nvertical === undefined ? 10 : _opts$nvertical,
        _opts$topCap = opts.topCap,
        topCap = _opts$topCap === undefined ? false : _opts$topCap,
        _opts$bottomCap = opts.bottomCap,
        bottomCap = _opts$bottomCap === undefined ? false : _opts$bottomCap;


    var extra = (topCap ? 2 : 0) + (bottomCap ? 2 : 0);
    var numVertices = (nradial + 1) * (nvertical + 1 + extra);

    var slant = Math.atan2(bottomRadius - topRadius, height);
    var msin = Math.sin;
    var mcos = Math.cos;
    var mpi = Math.PI;
    var cosSlant = mcos(slant);
    var sinSlant = msin(slant);
    var start = topCap ? -2 : 0;
    var end = nvertical + (bottomCap ? 2 : 0);
    var vertsAroundEdge = nradial + 1;

    var positions = new Float32Array(numVertices * 3);
    var normals = new Float32Array(numVertices * 3);
    var texCoords = new Float32Array(numVertices * 2);
    var indices = new Uint16Array(nradial * (nvertical + extra) * 6);

    var i3 = 0;
    var i2 = 0;
    for (var i = start; i <= end; i++) {
      var v = i / nvertical;
      var y = height * v;
      var ringRadius = void 0;

      if (i < 0) {
        y = 0;
        v = 1;
        ringRadius = bottomRadius;
      } else if (i > nvertical) {
        y = height;
        v = 1;
        ringRadius = topRadius;
      } else {
        ringRadius = bottomRadius + (topRadius - bottomRadius) * (i / nvertical);
      }
      if (i === -2 || i === nvertical + 2) {
        ringRadius = 0;
        v = 0;
      }
      y -= height / 2;
      for (var j = 0; j < vertsAroundEdge; j++) {
        var sin = msin(j * mpi * 2 / nradial);
        var cos = mcos(j * mpi * 2 / nradial);

        positions[i3 + 0] = sin * ringRadius;
        positions[i3 + 1] = y;
        positions[i3 + 2] = cos * ringRadius;

        normals[i3 + 0] = i < 0 || i > nvertical ? 0 : sin * cosSlant;
        normals[i3 + 1] = i < 0 ? -1 : i > nvertical ? 1 : sinSlant;
        normals[i3 + 2] = i < 0 || i > nvertical ? 0 : cos * cosSlant;

        texCoords[i2 + 0] = j / nradial;
        texCoords[i2 + 1] = v;

        i2 += 2;
        i3 += 3;
      }
    }

    for (var _i = 0; _i < nvertical + extra; _i++) {
      for (var _j = 0; _j < nradial; _j++) {
        var index = (_i * nradial + _j) * 6;
        indices[index + 0] = vertsAroundEdge * (_i + 0) + 0 + _j;
        indices[index + 1] = vertsAroundEdge * (_i + 0) + 1 + _j;
        indices[index + 2] = vertsAroundEdge * (_i + 1) + 1 + _j;
        indices[index + 3] = vertsAroundEdge * (_i + 0) + 0 + _j;
        indices[index + 4] = vertsAroundEdge * (_i + 1) + 1 + _j;
        indices[index + 5] = vertsAroundEdge * (_i + 1) + 0 + _j;
      }
    }

    return _possibleConstructorReturn(this, (TruncatedConeGeometry.__proto__ || Object.getPrototypeOf(TruncatedConeGeometry)).call(this, Object.assign({}, opts, {
      attributes: {
        positions: positions,
        normals: normals,
        texCoords: texCoords,
        indices: indices
      }
    })));
  }

  return TruncatedConeGeometry;
}(_geometry2.default);

exports.default = TruncatedConeGeometry;
//# sourceMappingURL=data:application/json;base64,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