'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.global = undefined;

var _isBrowser = require('./utils/is-browser');

var _globals = require('./utils/globals');

var _log = require('./utils/log');

var _log2 = _interopRequireDefault(_log);

var _package = require('../package.json');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var STARTUP_MESSAGE = 'Assign luma.log.priority in console to control logging: 0: none, 1: minimal, 2: verbose, 3: attribute/uniforms, 4: gl logs\nluma.log.break[], set to gl funcs, luma.log.profile[] set to model names';
// Version detection
// TODO - this imports a rather large JSON file, we only need one field


if (_globals.global.luma && _globals.global.luma.VERSION !== _package.version) {
  throw new Error('luma.gl - multiple versions detected: ' + _globals.global.luma.VERSION + ' vs ' + _package.version);
}

if (!_globals.global.luma) {
  /* global console */
  /* eslint-disable no-console */
  if (_isBrowser.isBrowser) {
    console.log('luma.gl ' + _package.version + ' - ' + STARTUP_MESSAGE);
  }

  _globals.global.luma = _globals.global.luma || {
    VERSION: _package.version,
    version: _package.version,
    log: _log2.default,

    // Keep some luma globals in a sub-object
    // This allows us to dynamically detect if certain modules have been
    // included (such as IO and headless) and enable related functionality,
    // without unconditionally requiring and thus bundling big dependencies
    // into the app.
    globals: {
      headlessGL: null,
      headlessTypes: null,
      modules: {},
      nodeIO: {}
    }
  };
}

exports.global = _globals.global;
exports.default = _globals.global.luma;
//# sourceMappingURL=data:application/json;base64,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