'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.glMatrix = undefined;
exports.configure = configure;
exports.formatValue = formatValue;
exports.isArray = isArray;
exports.clone = clone;
exports.radians = radians;
exports.degrees = degrees;
exports.sin = sin;
exports.cos = cos;
exports.tan = tan;
exports.asin = asin;
exports.acos = acos;
exports.atan = atan;
exports.clamp = clamp;
exports.equals = equals;

var _glMatrix = require('gl-matrix');

// TODO - remove
_glMatrix.glMatrix.debug = true; /* eslint-disable no-shadow */

_glMatrix.glMatrix.printRowMajor = true;

exports.glMatrix = _glMatrix.glMatrix;
function configure(options) {
  if ('epsilon' in options) {
    _glMatrix.glMatrix.EPSILON = options.epsilon;
  }

  if ('debug' in options) {
    _glMatrix.glMatrix.debug = options.debug;
  }
}

function formatValue(value) {
  var precision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _glMatrix.glMatrix.precision || 4;

  return parseFloat(value.toPrecision(precision));
}

// Returns true if value is either an array or a typed array
// Note: does not return true for ArrayBuffers and DataViews
function isArray(value) {
  return Array.isArray(value) || ArrayBuffer.isView(value) && value.length !== undefined;
}

// If the array has a clone function, calls it, otherwise returns a copy
function clone(array) {
  return array.clone ? array.clone() : new Array(array);
}

// If the argument value is an array, applies the func element wise,
// otherwise applies func to the argument value
function map(value, func) {
  if (isArray(value)) {
    var result = clone(value);
    for (var i = 0; i < result.length; ++i) {
      result[i] = func(result[i], i, result);
    }
    return result;
  }
  return func(value);
}

//
// GLSL math function equivalents
// Works on both single values and vectors
//

function radians(degrees) {
  return map(degrees, function (degrees) {
    return degrees / 180 * Math.PI;
  });
}

// GLSL equivalent: Works on single values and vectors
function degrees(radians) {
  return map(radians, function (radians) {
    return radians * 180 / Math.PI;
  });
}

// GLSL equivalent: Works on single values and vectors
function sin(radians) {
  return map(radians, function (angle) {
    return Math.sin(angle);
  });
}

// GLSL equivalent: Works on single values and vectors
function cos(radians) {
  return map(radians, function (angle) {
    return Math.cos(angle);
  });
}

// GLSL equivalent: Works on single values and vectors
function tan(radians) {
  return map(radians, function (angle) {
    return Math.tan(angle);
  });
}

// GLSL equivalent: Works on single values and vectors
function asin(radians) {
  return map(radians, function (angle) {
    return Math.asin(angle);
  });
}

// GLSL equivalent: Works on single values and vectors
function acos(radians) {
  return map(radians, function (angle) {
    return Math.acos(angle);
  });
}

// GLSL equivalent: Works on single values and vectors
function atan(radians) {
  return map(radians, function (angle) {
    return Math.atan(angle);
  });
}

// TODO - glsl equivalent
function clamp(value, min, max) {
  return Math.max(min, Math.min(max, value));
}

function equals(a, b) {
  return Math.abs(a - b) <= _glMatrix.glMatrix.EPSILON * Math.max(1.0, Math.abs(a), Math.abs(b));
}
//# sourceMappingURL=data:application/json;base64,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