'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _vector = require('./vector2');

var _vector2 = _interopRequireDefault(_vector);

var _vector3 = require('./vector3');

var _vector4 = _interopRequireDefault(_vector3);

var _vector5 = require('./vector4');

var _vector6 = _interopRequireDefault(_vector5);

var _glMatrix = require('gl-matrix');

var _validators = require('./utils/validators');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Matrix4 = function (_MathArray) {
  _inherits(Matrix4, _MathArray);

  function Matrix4() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _classCallCheck(this, Matrix4);

    var _this = _possibleConstructorReturn(this, (Matrix4.__proto__ || Object.getPrototypeOf(Matrix4)).call(this));

    if (Array.isArray(args[0]) && arguments.length === 1) {
      _this.copy(args[0]);
    } else {
      _this.identity();
    }
    return _this;
  }

  _createClass(Matrix4, [{
    key: 'setRowMajor',


    /* eslint-disable max-params */
    value: function setRowMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m20 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m30 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m01 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var m11 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var m21 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m31 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m02 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
      var m12 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
      var m22 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
      var m32 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
      var m03 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
      var m13 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
      var m23 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
      var m33 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;

      _glMatrix.mat4.set(this, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
      this.check();
      return this;
    }
  }, {
    key: 'setColumnMajor',
    value: function setColumnMajor() {
      var m00 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var m01 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var m02 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var m03 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var m10 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var m11 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
      var m12 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var m13 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
      var m20 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
      var m21 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
      var m22 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
      var m23 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
      var m30 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
      var m31 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
      var m32 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
      var m33 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;

      _glMatrix.mat4.set(this, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
      this.check();
      return this;
    }
    /* eslint-enable max-params */

  }, {
    key: 'equals',
    value: function equals(a) {
      return _glMatrix.mat4.equals(this, a);
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(a) {
      return _glMatrix.mat4.exactEquals(this, a);
    }
  }, {
    key: 'toString',
    value: function toString() {
      if (_common.glMatrix.printRowMajor) {
        _glMatrix.mat4.str(this);
      } else {
        _glMatrix.mat4.str(this);
      }
    }

    // Row major setters and getters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'determinant',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    // Accessors

    value: function determinant() {
      return _glMatrix.mat4.determinant(this);
    }
  }, {
    key: 'getRotation',
    value: function getRotation() {
      throw new Error('Not implemented');
    }

    // Constructors

  }, {
    key: 'identity',
    value: function identity() {
      _glMatrix.mat4.identity(this);
      this.check();
      return this;
    }

    // Generates a frustum matrix with the given bounds
    // left  Number  Left bound of the frustum
    // right Number  Right bound of the frustum
    // bottom  Number  Bottom bound of the frustum
    // top Number  Top bound of the frustum
    // near  Number  Near bound of the frustum
    // far Number  Far bound of the frustum

  }, {
    key: 'frustum',
    value: function frustum(_ref) {
      var left = _ref.left,
          right = _ref.right,
          bottom = _ref.bottom,
          top = _ref.top,
          near = _ref.near,
          far = _ref.far;

      _glMatrix.mat4.frustum(this, left, right, bottom, top, near, far);
      this.check();
      return this;
    }
  }, {
    key: 'lookAt',


    // Generates a look-at matrix with the given eye position, focal point,
    // and up axis
    // eye vec3  Position of the viewer
    // center  vec3  Point the viewer is looking at
    // up  vec3  vec3 pointing up
    value: function lookAt() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          eye = _ref2.eye,
          _ref2$center = _ref2.center,
          center = _ref2$center === undefined ? [0, 0, 0] : _ref2$center,
          _ref2$up = _ref2.up,
          up = _ref2$up === undefined ? [0, 1, 0] : _ref2$up;

      _glMatrix.mat4.lookAt(this, eye, center, up);
      this.check();
      return this;
    }
  }, {
    key: 'ortho',


    // Generates a orthogonal projection matrix with the given bounds
    // left  number  Left bound of the frustum
    // right number  Right bound of the frustum
    // bottom  number  Bottom bound of the frustum
    // top number  Top bound of the frustum
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum
    value: function ortho(_ref3) {
      var left = _ref3.left,
          right = _ref3.right,
          bottom = _ref3.bottom,
          top = _ref3.top,
          _ref3$near = _ref3.near,
          near = _ref3$near === undefined ? 0.1 : _ref3$near,
          _ref3$far = _ref3.far,
          far = _ref3$far === undefined ? 500 : _ref3$far;

      _glMatrix.mat4.ortho(this, left, right, bottom, top, near, far);
      this.check();
      return this;
    }
  }, {
    key: 'perspective',


    // Generates a perspective projection matrix with the given bounds
    // fovy  number  Vertical field of view in radians
    // aspect  number  Aspect ratio. typically viewport width/height
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum
    value: function perspective() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$fov = _ref4.fov,
          fov = _ref4$fov === undefined ? 45 * Math.PI / 180 : _ref4$fov,
          _ref4$aspect = _ref4.aspect,
          aspect = _ref4$aspect === undefined ? 1 : _ref4$aspect,
          _ref4$near = _ref4.near,
          near = _ref4$near === undefined ? 0.1 : _ref4$near,
          _ref4$far = _ref4.far,
          far = _ref4$far === undefined ? 500 : _ref4$far;

      if (fov > Math.PI * 2) {
        throw Error('radians');
      }
      _glMatrix.mat4.perspective(this, fov, aspect, near, far);
      this.check();
      return this;
    }
  }, {
    key: 'perspectiveFromFieldOfView',


    // Generates a perspective projection matrix with the given field of view.
    // This is primarily useful for generating projection matrices to be used
    // with the still experiemental WebVR API.
    // fov Object  Object containing the following values:
    //   upDegrees, downDegrees, leftDegrees, rightDegrees
    // near  number  Near bound of the frustum
    // far number  Far bound of the frustum
    value: function perspectiveFromFieldOfView(out, fov, near, far) {
      _glMatrix.mat4.perspectiveFromFieldOfView(out, fov, near, far);
      this.check();
      return this;
    }
  }, {
    key: 'fromQuaternion',


    // Calculates a 4x4 matrix from the given quaternion
    // q quat  Quaternion to create matrix from
    value: function fromQuaternion(q) {
      _glMatrix.mat4.fromQuat(this, q);
      this.check();
      return this;
    }
  }, {
    key: 'fromRotation',


    // Creates a matrix from a given angle around a given axis
    // his is equivalent to (but much faster than): mat4.identity(dest);
    // mat4.rotate(dest, dest, rad, axis);
    // rad Number  the angle to rotate the matrix by
    // axis  vec3  the axis to rotate around
    value: function fromRotation(rad, axis) {
      _glMatrix.mat4.fromRotation(this, rad, axis);
      this.check();
      return this;
    }

    // Creates a matrix from a quaternion rotation and vector translation
    // This is equivalent to (but much faster than): mat4.identity(dest);
    // mat4.translate(dest, vec);
    // var quatMat = mat4.create();
    // quat4.toMat4(quat, quatMat);
    // mat4.multiply(dest, quatMat);
    // q quat4 Rotation quaternion
    // v vec3  Translation vector

  }, {
    key: 'fromRotationTranslation',
    value: function fromRotationTranslation(q, v) {
      _glMatrix.mat4.fromRotationTranslation(this, q, v);
      this.check();
      return this;
    }

    // Creates a matrix from a quaternion rotation,
    // vector translation and vector scale
    // This is equivalent to (but much faster than):
    // mat4.identity(dest);
    // mat4.translate(dest, vec);
    // var quatMat = mat4.create();
    // quat4.toMat4(quat, quatMat);
    // mat4.multiply(dest, quatMat);
    // mat4.scale(dest, scale)
    // q quat4 Rotation quaternion
    // v vec3  Translation vector
    // s vec3  Scaling vector

  }, {
    key: 'fromRotationTranslationScale',
    value: function fromRotationTranslationScale(q, v, s) {
      _glMatrix.mat4.fromRotationTranslationScale(this, q, v, s);
      this.check();
      return this;
    }

    // Creates a matrix from a quaternion rotation, vector translation and
    // vector scale, rotating and scaling around the given origin
    // This is equivalent to (but much faster than):
    // mat4.identity(dest);
    // mat4.translate(dest, vec);
    // mat4.translate(dest, origin);
    // var quatMat = mat4.create();
    // quat4.toMat4(quat, quatMat);
    // mat4.multiply(dest, quatMat);
    // mat4.scale(dest, scale)
    // mat4.translate(dest, negativeOrigin);
    // q quat4 Rotation quaternion
    // v vec3  Translation vector
    // s vec3  Scaling vector
    // o vec3  The origin vector around which to scale and rotate

  }, {
    key: 'fromRotationTranslationScaleOrigin',
    value: function fromRotationTranslationScaleOrigin(q, v, s, o) {
      _glMatrix.mat4.fromRotationTranslationScaleOrigin(this, q, v, s, o);
      this.check();
      return this;
    }

    // Creates a matrix from a vector scaling This is equivalent to
    // (but much faster than):
    // mat4.identity(dest); mat4.scale(dest, dest, vec);
    // v vec3  Scaling vector

  }, {
    key: 'fromScaling',
    value: function fromScaling(v) {
      _glMatrix.mat4.fromScaling(this, v);
      this.check();
      return this;
    }

    // Creates a matrix from a vector translation
    // This is equivalent to (but much faster than):
    // mat4.identity(dest); mat4.translate(dest, dest, vec);
    // v vec3  Translation vector

  }, {
    key: 'fromTranslation',
    value: function fromTranslation(v) {
      _glMatrix.mat4.fromTranslation(this, v);
      this.check();
      return this;
    }

    // Create a new mat4 with the given values
    // m00 Number  Component in column 0, row 0 position (index 0)
    // m01 Number  Component in column 0, row 1 position (index 1)
    // m02 Number  Component in column 0, row 2 position (index 2)
    // m03 Number  Component in column 0, row 3 position (index 3)
    // m10 Number  Component in column 1, row 0 position (index 4)
    // m11 Number  Component in column 1, row 1 position (index 5)
    // m12 Number  Component in column 1, row 2 position (index 6)
    // m13 Number  Component in column 1, row 3 position (index 7)
    // m20 Number  Component in column 2, row 0 position (index 8)
    // m21 Number  Component in column 2, row 1 position (index 9)
    // m22 Number  Component in column 2, row 2 position (index 10)
    // m23 Number  Component in column 2, row 3 position (index 11)
    // m30 Number  Component in column 3, row 0 position (index 12)
    // m31 Number  Component in column 3, row 1 position (index 13)
    // m32 Number  Component in column 3, row 2 position (index 14)
    // m33 Number  Component in column 3, row 3 position (index 15)
    // fromValues(m00, m01, m02, m03, m10, m11, m12, m13,
    //   m20, m21, m22, m23, m30, m31, m32, m33) {mat4}

    // Creates a matrix from the given angle around the X axis
    // This is equivalent to (but much faster than):
    // mat4.identity(dest);
    // mat4.rotateX(dest, dest, rad);
    // rad Number  the angle to rotate the matrix by

  }, {
    key: 'fromXRotation',
    value: function fromXRotation(rad) {
      _glMatrix.mat4.fromXRotation(this, rad);
      this.check();
      return this;
    }

    // Creates a matrix from the given angle around the Y axis
    // This is equivalent to (but much faster than):
    // mat4.identity(dest);
    // mat4.rotateY(dest, dest, rad);
    // rad Number  the angle to rotate the matrix by

  }, {
    key: 'fromYRotation',
    value: function fromYRotation(rad) {
      _glMatrix.mat4.fromYRotation(this, rad);
      this.check();
      return this;
    }

    // Creates a matrix from the given angle around the Z axis
    // This is equivalent to (but much faster than):
    // mat4.identity(dest);
    // mat4.rotateZ(dest, dest, rad);
    // rad Number  the angle to rotate the matrix by

  }, {
    key: 'fromZRotation',
    value: function fromZRotation(rad) {
      _glMatrix.mat4.fromZRotation(this, rad);
      this.check();
      return this;
    }

    // Modifiers

  }, {
    key: 'transpose',
    value: function transpose() {
      _glMatrix.mat4.transpose(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'invert',
    value: function invert() {
      _glMatrix.mat4.invert(this, this);
      this.check();
      return this;
    }
  }, {
    key: 'adjoint',
    value: function adjoint() {
      _glMatrix.mat4.adjoint(this, this);
      this.check();
      return this;
    }

    // Operations

  }, {
    key: 'add',
    value: function add(a, b) {
      _glMatrix.mat4.add(this, this, a);
      this.check();
      return this;
    }
  }, {
    key: 'multiplyLeft',
    value: function multiplyLeft(a) {
      _glMatrix.mat4.multiply(this, a, this);
      this.check();
      return this;
    }
  }, {
    key: 'multiplyRight',
    value: function multiplyRight(a) {
      _glMatrix.mat4.multiply(this, this, a);
      this.check();
      return this;
    }

    // Rotates a matrix by the given angle around the X axis
    // uses SIMD if available and enabled

  }, {
    key: 'rotateX',
    value: function rotateX(radians) {
      _glMatrix.mat4.rotateX(this, this, radians);
      this.check();
      return this;
    }

    // Rotates a matrix by the given angle around the Y axis.
    // Uses SIMD if available and enabled

  }, {
    key: 'rotateY',
    value: function rotateY(radians) {
      _glMatrix.mat4.rotateY(this, this, radians);
      this.check();
      return this;
    }

    // Rotates a matrix by the given angle around the Z axis.
    // Uses SIMD if available and enabled

  }, {
    key: 'rotateZ',
    value: function rotateZ(radians) {
      _glMatrix.mat4.rotateZ(this, this, radians);
      this.check();
      return this;
    }

    // TODO - may not be needed
    /* eslint-disable max-statements */

  }, {
    key: 'rotateXYZ',
    value: function rotateXYZ(_ref5) {
      var _ref6 = _slicedToArray(_ref5, 3),
          rx = _ref6[0],
          ry = _ref6[1],
          rz = _ref6[2];

      var d11 = this[0];
      var d12 = this[1];
      var d13 = this[2];
      var d14 = this[3];
      var d21 = this[4];
      var d22 = this[5];
      var d23 = this[6];
      var d24 = this[7];
      var d31 = this[8];
      var d32 = this[9];
      var d33 = this[10];
      var d34 = this[11];
      var crx = Math.cos(rx);
      var cry = Math.cos(ry);
      var crz = Math.cos(rz);
      var srx = Math.sin(rx);
      var sry = Math.sin(ry);
      var srz = Math.sin(rz);
      var m11 = cry * crz;
      var m21 = -crx * srz + srx * sry * crz;
      var m31 = srx * srz + crx * sry * crz;
      var m12 = cry * srz;
      var m22 = crx * crz + srx * sry * srz;
      var m32 = -srx * crz + crx * sry * srz;
      var m13 = -sry;
      var m23 = srx * cry;
      var m33 = crx * cry;

      this[0] = d11 * m11 + d21 * m12 + d31 * m13;
      this[1] = d12 * m11 + d22 * m12 + d32 * m13;
      this[2] = d13 * m11 + d23 * m12 + d33 * m13;
      this[3] = d14 * m11 + d24 * m12 + d34 * m13;

      this[4] = d11 * m21 + d21 * m22 + d31 * m23;
      this[5] = d12 * m21 + d22 * m22 + d32 * m23;
      this[6] = d13 * m21 + d23 * m22 + d33 * m23;
      this[7] = d14 * m21 + d24 * m22 + d34 * m23;

      this[8] = d11 * m31 + d21 * m32 + d31 * m33;
      this[9] = d12 * m31 + d22 * m32 + d32 * m33;
      this[10] = d13 * m31 + d23 * m32 + d33 * m33;
      this[11] = d14 * m31 + d24 * m32 + d34 * m33;

      this.check();
      return this;
    }
    /* eslint-enable max-statements */

  }, {
    key: 'scale',
    value: function scale(vec) {
      _glMatrix.mat4.scale(this, this, vec);
      this.check();
      return this;
    }
  }, {
    key: 'translate',
    value: function translate(vec) {
      _glMatrix.mat4.translate(this, this, vec);
      this.check();
      return this;
    }
  }, {
    key: 'transformVector2',
    value: function transformVector2(vector) {
      var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _vector2.default();

      _glMatrix.vec2.transformMat4(out, vector, this);
      (0, _validators.checkVector2)(out);
      return out;
    }
  }, {
    key: 'transformVector3',
    value: function transformVector3(vector) {
      var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _vector4.default();

      _glMatrix.vec3.transformMat4(out, vector, this);
      (0, _validators.checkVector3)(out);
      return out;
    }
  }, {
    key: 'transformVector4',
    value: function transformVector4(vector) {
      var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new _vector6.default();

      _glMatrix.vec4.transformMat4(out, vector, this);
      (0, _validators.checkVector4)(out);
      return out;
    }

    // Transforms any 2, 3 or 4 element vector
    // returns a newly minted Vector2, Vector3 or Vector4

  }, {
    key: 'transformVector',
    value: function transformVector(vector) {
      switch (vector.length) {
        case 2:
          return this.transformVector2(vector);
        case 3:
          return this.transformVector3(vector);
        case 4:
          return this.transformVector4(vector);
        default:
          throw new Error('Illegal vector');
      }
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 16;
    }
  }, {
    key: 'm00',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm01',
    get: function get() {
      return this[4];
    },
    set: function set(value) {
      return this[4] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm02',
    get: function get() {
      return this[8];
    },
    set: function set(value) {
      return this[8] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm03',
    get: function get() {
      return this[12];
    },
    set: function set(value) {
      return this[12] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm10',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm11',
    get: function get() {
      return this[5];
    },
    set: function set(value) {
      return this[5] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm12',
    get: function get() {
      return this[9];
    },
    set: function set(value) {
      return this[9] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm13',
    get: function get() {
      return this[13];
    },
    set: function set(value) {
      return this[13] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm20',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm21',
    get: function get() {
      return this[6];
    },
    set: function set(value) {
      return this[6] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm22',
    get: function get() {
      return this[10];
    },
    set: function set(value) {
      return this[10] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm23',
    get: function get() {
      return this[14];
    },
    set: function set(value) {
      return this[14] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm30',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm31',
    get: function get() {
      return this[7];
    },
    set: function set(value) {
      return this[7] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm32',
    get: function get() {
      return this[11];
    },
    set: function set(value) {
      return this[11] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'm33',
    get: function get() {
      return this[15];
    },
    set: function set(value) {
      return this[15] = (0, _common.checkNumber)(value);
    }
  }], [{
    key: 'equals',
    value: function equals(a, b) {
      return _glMatrix.mat4.equals(a, b);
    }
  }, {
    key: 'exactEquals',
    value: function exactEquals(a, b) {
      return _glMatrix.mat4.exactEquals(a, b);
    }
  }, {
    key: 'determinant',
    value: function determinant(m) {
      return _glMatrix.mat4.determinant(m);
    }
  }, {
    key: 'frustum',
    value: function frustum(opts) {
      return new Matrix4().frustum(opts);
    }
  }, {
    key: 'lookAt',
    value: function lookAt(opts) {
      return new Matrix4().lookAt(opts);
    }
  }, {
    key: 'ortho',
    value: function ortho(opts) {
      return new Matrix4().ortho(opts);
    }
  }, {
    key: 'perspective',
    value: function perspective(opts) {
      return new Matrix4().perspective(opts);
    }
  }, {
    key: 'perspectiveFromFieldOfView',
    value: function perspectiveFromFieldOfView(opts) {
      return new Matrix4().perspectiveFromFieldOfView(opts);
    }
  }, {
    key: 'fromQuaternion',
    value: function fromQuaternion(q) {
      return new Matrix4().fromQuaternion(q);
    }
  }]);

  return Matrix4;
}(_mathArray2.default);

exports.default = Matrix4;
//# sourceMappingURL=data:application/json;base64,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