'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _mathArray = require('./math-array');

var _mathArray2 = _interopRequireDefault(_mathArray);

var _common = require('./common');

var _glMatrix = require('gl-matrix');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Quaternion = function (_MathArray) {
  _inherits(Quaternion, _MathArray);

  // Creates a new identity quat
  function Quaternion() {
    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;

    _classCallCheck(this, Quaternion);

    var _this = _possibleConstructorReturn(this, (Quaternion.__proto__ || Object.getPrototypeOf(Quaternion)).call(this));

    if (Array.isArray(x) && arguments.length === 1) {
      _this.copy(x);
    } else {
      _this.set(x, y, z, w);
    }
    return _this;
  }

  // Creates a quaternion from the given 3x3 rotation matrix.
  // NOTE: The resultant quaternion is not normalized, so you should
  // be sure to renormalize the quaternion yourself where necessary.


  _createClass(Quaternion, [{
    key: 'fromMatrix3',
    value: function fromMatrix3(m) {
      _glMatrix.quat.fromMat3(this, m);
      this.check();
      return this;
    }

    // Creates a new quat initialized with the given values

  }, {
    key: 'fromValues',
    value: function fromValues(x, y, z, w) {
      return this.set(x, y, z, w);
    }

    // Set a quat to the identity quaternion

  }, {
    key: 'identity',
    value: function identity() {
      _glMatrix.quat.identity(this);
      this.check();
      return this;
    }
  }, {
    key: 'equals',
    value: function equals(quaternion) {
      return _glMatrix.quat.equals(this, quaternion);
    }

    // Returns whether or not the quaternions have exactly the same elements
    // in the same position (when compared with ===)

  }, {
    key: 'exactEquals',
    value: function exactEquals(quaternion) {
      return _glMatrix.quat.exactEquals(this, quaternion);
    }

    // Getters/setters
    /* eslint-disable no-multi-spaces, brace-style, no-return-assign */

  }, {
    key: 'length',

    /* eslint-enable no-multi-spaces, brace-style, no-return-assign */

    // Calculates the length of a quat
    value: function length() {
      return _glMatrix.quat.length(this);
    }

    // Calculates the squared length of a quat

  }, {
    key: 'squaredLength',
    value: function squaredLength(a) {
      return _glMatrix.quat.squaredLength(this);
    }

    // Calculates the dot product of two quat's
    // @return {Number}

  }, {
    key: 'dot',
    value: function dot(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.dot only takes one argument');
      }
      return _glMatrix.quat.dot(this, a);
    }

    // Gets the rotation axis and angle for a given quaternion.
    // If a quaternion is created with setAxisAngle, this method will
    // return the same values as providied in the original parameter
    // list OR functionally equivalent values.
    // Example: The quaternion formed by axis [0, 0, 1] and angle -90
    // is the same as the quaternion formed by [0, 0, 1] and 270.
    // This method favors the latter.
    // @return {{[x,y,z], Number}}

  }, {
    key: 'getAxisAngle',
    value: function getAxisAngle() {
      var axis = [];
      var angle = _glMatrix.quat.getAxisAngle(axis, this);
      return { axis: axis, angle: angle };
    }

    // MODIFIERS

    // Sets a quaternion to represent the shortest rotation from one vector
    // to another. Both vectors are assumed to be unit length.

  }, {
    key: 'rotationTo',
    value: function rotationTo(vectorA, vectorB) {
      _glMatrix.quat.rotationTo(this, vectorA, vectorB);
      this.check();
      return this;
    }

    // Sets the specified quaternion with values corresponding to the given axes.
    // Each axis is a vec3 and is expected to be unit length and perpendicular
    // to all other specified axes.
    // setAxes() {
    //   Number
    // }

    // Performs a spherical linear interpolation with two control points
    // sqlerp() {
    //   Number;
    // }

    // Adds two quat's

  }, {
    key: 'add',
    value: function add(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.add only takes one argument');
      }
      _glMatrix.quat.add(this, a);
      this.check();
      return this;
    }

    // Calculates the W component of a quat from the X, Y, and Z components.
    // Any existing W component will be ignored.

  }, {
    key: 'calculateW',
    value: function calculateW() {
      _glMatrix.quat.calculateW(this, this);
      this.check();
      return this;
    }

    // Calculates the conjugate of a quat If the quaternion is normalized,
    // this function is faster than quat.inverse and produces the same result.

  }, {
    key: 'conjugate',
    value: function conjugate() {
      _glMatrix.quat.conjugate(this, this);
      this.check();
      return this;
    }

    // Calculates the inverse of a quat

  }, {
    key: 'invert',
    value: function invert() {
      _glMatrix.quat.invert(this, this);
      this.check();
      return this;
    }

    // Performs a linear interpolation between two quat's

  }, {
    key: 'lerp',
    value: function lerp(a, b, t) {
      _glMatrix.quat.lerp(this, a, b, t);
      this.check();
      return this;
    }

    // Multiplies two quat's

  }, {
    key: 'multiply',
    value: function multiply(a, b) {
      if (b !== undefined) {
        throw new Error('Quaternion.multiply only takes one argument');
      }
      _glMatrix.quat.multiply(this, this, b);
      this.check();
      return this;
    }

    // Normalize a quat

  }, {
    key: 'normalize',
    value: function normalize() {
      _glMatrix.quat.normalize(this, this);
      this.check();
      return this;
    }

    // Rotates a quaternion by the given angle about the X axis

  }, {
    key: 'rotateX',
    value: function rotateX(rad) {
      _glMatrix.quat.rotateX(this, this, rad);
      this.check();
      return this;
    }

    // Rotates a quaternion by the given angle about the Y axis

  }, {
    key: 'rotateY',
    value: function rotateY(rad) {
      _glMatrix.quat.rotateY(this, this, rad);
      this.check();
      return this;
    }

    // Rotates a quaternion by the given angle about the Z axis

  }, {
    key: 'rotateZ',
    value: function rotateZ(rad) {
      _glMatrix.quat.rotateZ(this, this, rad);
      this.check();
      return this;
    }

    // Scales a quat by a scalar number

  }, {
    key: 'scale',
    value: function scale(b) {
      _glMatrix.quat.scale(this, this, b);
      this.check();
      return this;
    }

    // Set the components of a quat to the given values

  }, {
    key: 'set',
    value: function set(i, j, k, l) {
      _glMatrix.quat.set(this, i, j, k, l);
      this.check();
      return this;
    }

    // Sets a quat from the given angle and rotation axis, then returns it.

  }, {
    key: 'setAxisAngle',
    value: function setAxisAngle(axis, rad) {
      _glMatrix.quat.setAxisAngle(this, axis, rad);
      this.check();
      return this;
    }

    // Performs a spherical linear interpolation between two quat

  }, {
    key: 'slerp',
    value: function slerp(a, b, t) {
      _glMatrix.quat.slerp(this, a, b, t);
      this.check();
      return this;
    }
  }, {
    key: 'ELEMENTS',
    get: function get() {
      return 4;
    }
  }, {
    key: 'x',
    get: function get() {
      return this[0];
    },
    set: function set(value) {
      return this[0] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'y',
    get: function get() {
      return this[1];
    },
    set: function set(value) {
      return this[1] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'z',
    get: function get() {
      return this[2];
    },
    set: function set(value) {
      return this[2] = (0, _common.checkNumber)(value);
    }
  }, {
    key: 'w',
    get: function get() {
      return this[3];
    },
    set: function set(value) {
      return this[3] = (0, _common.checkNumber)(value);
    }
  }]);

  return Quaternion;
}(_mathArray2.default);

exports.default = Quaternion;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9wYWNrYWdlcy9tYXRoL3NyYy9xdWF0ZXJuaW9uLmpzIl0sIm5hbWVzIjpbIlF1YXRlcm5pb24iLCJ4IiwieSIsInoiLCJ3IiwiQXJyYXkiLCJpc0FycmF5IiwiYXJndW1lbnRzIiwibGVuZ3RoIiwiY29weSIsInNldCIsIm0iLCJmcm9tTWF0MyIsImNoZWNrIiwiaWRlbnRpdHkiLCJxdWF0ZXJuaW9uIiwiZXF1YWxzIiwiZXhhY3RFcXVhbHMiLCJhIiwic3F1YXJlZExlbmd0aCIsImIiLCJ1bmRlZmluZWQiLCJFcnJvciIsImRvdCIsImF4aXMiLCJhbmdsZSIsImdldEF4aXNBbmdsZSIsInZlY3RvckEiLCJ2ZWN0b3JCIiwicm90YXRpb25UbyIsImFkZCIsImNhbGN1bGF0ZVciLCJjb25qdWdhdGUiLCJpbnZlcnQiLCJ0IiwibGVycCIsIm11bHRpcGx5Iiwibm9ybWFsaXplIiwicmFkIiwicm90YXRlWCIsInJvdGF0ZVkiLCJyb3RhdGVaIiwic2NhbGUiLCJpIiwiaiIsImsiLCJsIiwic2V0QXhpc0FuZ2xlIiwic2xlcnAiLCJ2YWx1ZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7Ozs7QUFDQTs7QUFDQTs7Ozs7Ozs7OztJQUVxQkEsVTs7O0FBQ25CO0FBQ0Esd0JBQXdDO0FBQUEsUUFBNUJDLENBQTRCLHVFQUF4QixDQUF3QjtBQUFBLFFBQXJCQyxDQUFxQix1RUFBakIsQ0FBaUI7QUFBQSxRQUFkQyxDQUFjLHVFQUFWLENBQVU7QUFBQSxRQUFQQyxDQUFPLHVFQUFILENBQUc7O0FBQUE7O0FBQUE7O0FBRXRDLFFBQUlDLE1BQU1DLE9BQU4sQ0FBY0wsQ0FBZCxLQUFvQk0sVUFBVUMsTUFBVixLQUFxQixDQUE3QyxFQUFnRDtBQUM5QyxZQUFLQyxJQUFMLENBQVVSLENBQVY7QUFDRCxLQUZELE1BRU87QUFDTCxZQUFLUyxHQUFMLENBQVNULENBQVQsRUFBWUMsQ0FBWixFQUFlQyxDQUFmLEVBQWtCQyxDQUFsQjtBQUNEO0FBTnFDO0FBT3ZDOztBQUVEO0FBQ0E7QUFDQTs7Ozs7Z0NBQ1lPLEMsRUFBRztBQUNiLHFCQUFLQyxRQUFMLENBQWMsSUFBZCxFQUFvQkQsQ0FBcEI7QUFDQSxXQUFLRSxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7Ozs7K0JBQ1daLEMsRUFBR0MsQyxFQUFHQyxDLEVBQUdDLEMsRUFBRztBQUNyQixhQUFPLEtBQUtNLEdBQUwsQ0FBU1QsQ0FBVCxFQUFZQyxDQUFaLEVBQWVDLENBQWYsRUFBa0JDLENBQWxCLENBQVA7QUFDRDs7QUFFRDs7OzsrQkFDVztBQUNULHFCQUFLVSxRQUFMLENBQWMsSUFBZDtBQUNBLFdBQUtELEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7OzJCQUVNRSxVLEVBQVk7QUFDakIsYUFBTyxlQUFLQyxNQUFMLENBQVksSUFBWixFQUFrQkQsVUFBbEIsQ0FBUDtBQUNEOztBQUVEO0FBQ0E7Ozs7Z0NBQ1lBLFUsRUFBWTtBQUN0QixhQUFPLGVBQUtFLFdBQUwsQ0FBaUIsSUFBakIsRUFBdUJGLFVBQXZCLENBQVA7QUFDRDs7QUFFRDtBQUNBOzs7OztBQVVBOztBQUVBOzZCQUNTO0FBQ1AsYUFBTyxlQUFLUCxNQUFMLENBQVksSUFBWixDQUFQO0FBQ0Q7O0FBRUQ7Ozs7a0NBQ2NVLEMsRUFBRztBQUNmLGFBQU8sZUFBS0MsYUFBTCxDQUFtQixJQUFuQixDQUFQO0FBQ0Q7O0FBRUQ7QUFDQTs7Ozt3QkFDSUQsQyxFQUFHRSxDLEVBQUc7QUFDUixVQUFJQSxNQUFNQyxTQUFWLEVBQXFCO0FBQ25CLGNBQU0sSUFBSUMsS0FBSixDQUFVLHdDQUFWLENBQU47QUFDRDtBQUNELGFBQU8sZUFBS0MsR0FBTCxDQUFTLElBQVQsRUFBZUwsQ0FBZixDQUFQO0FBQ0Q7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7OzttQ0FDZTtBQUNiLFVBQU1NLE9BQU8sRUFBYjtBQUNBLFVBQU1DLFFBQVEsZUFBS0MsWUFBTCxDQUFrQkYsSUFBbEIsRUFBd0IsSUFBeEIsQ0FBZDtBQUNBLGFBQU8sRUFBQ0EsVUFBRCxFQUFPQyxZQUFQLEVBQVA7QUFDRDs7QUFFRDs7QUFFQTtBQUNBOzs7OytCQUNXRSxPLEVBQVNDLE8sRUFBUztBQUMzQixxQkFBS0MsVUFBTCxDQUFnQixJQUFoQixFQUFzQkYsT0FBdEIsRUFBK0JDLE9BQS9CO0FBQ0EsV0FBS2YsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7Ozt3QkFDSUssQyxFQUFHRSxDLEVBQUc7QUFDUixVQUFJQSxNQUFNQyxTQUFWLEVBQXFCO0FBQ25CLGNBQU0sSUFBSUMsS0FBSixDQUFVLHdDQUFWLENBQU47QUFDRDtBQUNELHFCQUFLUSxHQUFMLENBQVMsSUFBVCxFQUFlWixDQUFmO0FBQ0EsV0FBS0wsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEO0FBQ0E7Ozs7aUNBQ2E7QUFDWCxxQkFBS2tCLFVBQUwsQ0FBZ0IsSUFBaEIsRUFBc0IsSUFBdEI7QUFDQSxXQUFLbEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEO0FBQ0E7Ozs7Z0NBQ1k7QUFDVixxQkFBS21CLFNBQUwsQ0FBZSxJQUFmLEVBQXFCLElBQXJCO0FBQ0EsV0FBS25CLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7Ozs2QkFDUztBQUNQLHFCQUFLb0IsTUFBTCxDQUFZLElBQVosRUFBa0IsSUFBbEI7QUFDQSxXQUFLcEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7O3lCQUNLSyxDLEVBQUdFLEMsRUFBR2MsQyxFQUFHO0FBQ1oscUJBQUtDLElBQUwsQ0FBVSxJQUFWLEVBQWdCakIsQ0FBaEIsRUFBbUJFLENBQW5CLEVBQXNCYyxDQUF0QjtBQUNBLFdBQUtyQixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7Ozs7NkJBQ1NLLEMsRUFBR0UsQyxFQUFHO0FBQ2IsVUFBSUEsTUFBTUMsU0FBVixFQUFxQjtBQUNuQixjQUFNLElBQUlDLEtBQUosQ0FBVSw2Q0FBVixDQUFOO0FBQ0Q7QUFDRCxxQkFBS2MsUUFBTCxDQUFjLElBQWQsRUFBb0IsSUFBcEIsRUFBMEJoQixDQUExQjtBQUNBLFdBQUtQLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7OztnQ0FDWTtBQUNWLHFCQUFLd0IsU0FBTCxDQUFlLElBQWYsRUFBcUIsSUFBckI7QUFDQSxXQUFLeEIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7OzRCQUNReUIsRyxFQUFLO0FBQ1gscUJBQUtDLE9BQUwsQ0FBYSxJQUFiLEVBQW1CLElBQW5CLEVBQXlCRCxHQUF6QjtBQUNBLFdBQUt6QixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7Ozs7NEJBQ1F5QixHLEVBQUs7QUFDWCxxQkFBS0UsT0FBTCxDQUFhLElBQWIsRUFBbUIsSUFBbkIsRUFBeUJGLEdBQXpCO0FBQ0EsV0FBS3pCLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7Ozs0QkFDUXlCLEcsRUFBSztBQUNYLHFCQUFLRyxPQUFMLENBQWEsSUFBYixFQUFtQixJQUFuQixFQUF5QkgsR0FBekI7QUFDQSxXQUFLekIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7OzBCQUNNTyxDLEVBQUc7QUFDUCxxQkFBS3NCLEtBQUwsQ0FBVyxJQUFYLEVBQWlCLElBQWpCLEVBQXVCdEIsQ0FBdkI7QUFDQSxXQUFLUCxLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQ7Ozs7d0JBQ0k4QixDLEVBQUdDLEMsRUFBR0MsQyxFQUFHQyxDLEVBQUc7QUFDZCxxQkFBS3BDLEdBQUwsQ0FBUyxJQUFULEVBQWVpQyxDQUFmLEVBQWtCQyxDQUFsQixFQUFxQkMsQ0FBckIsRUFBd0JDLENBQXhCO0FBQ0EsV0FBS2pDLEtBQUw7QUFDQSxhQUFPLElBQVA7QUFDRDs7QUFFRDs7OztpQ0FDYVcsSSxFQUFNYyxHLEVBQUs7QUFDdEIscUJBQUtTLFlBQUwsQ0FBa0IsSUFBbEIsRUFBd0J2QixJQUF4QixFQUE4QmMsR0FBOUI7QUFDQSxXQUFLekIsS0FBTDtBQUNBLGFBQU8sSUFBUDtBQUNEOztBQUVEOzs7OzBCQUNNSyxDLEVBQUdFLEMsRUFBR2MsQyxFQUFHO0FBQ2IscUJBQUtjLEtBQUwsQ0FBVyxJQUFYLEVBQWlCOUIsQ0FBakIsRUFBb0JFLENBQXBCLEVBQXVCYyxDQUF2QjtBQUNBLFdBQUtyQixLQUFMO0FBQ0EsYUFBTyxJQUFQO0FBQ0Q7Ozt3QkExS2M7QUFBRSxhQUFPLENBQVA7QUFBVzs7O3dCQUNmO0FBQUUsYUFBTyxLQUFLLENBQUwsQ0FBUDtBQUFpQixLO3NCQUMxQm9DLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozt3QkFDeEM7QUFBRSxhQUFPLEtBQUssQ0FBTCxDQUFQO0FBQWlCLEs7c0JBQzFCQSxLLEVBQU87QUFBRSxhQUFPLEtBQUssQ0FBTCxJQUFVLHlCQUFZQSxLQUFaLENBQWpCO0FBQXNDOzs7d0JBQ3hDO0FBQUUsYUFBTyxLQUFLLENBQUwsQ0FBUDtBQUFpQixLO3NCQUMxQkEsSyxFQUFPO0FBQUUsYUFBTyxLQUFLLENBQUwsSUFBVSx5QkFBWUEsS0FBWixDQUFqQjtBQUFzQzs7O3dCQUN4QztBQUFFLGFBQU8sS0FBSyxDQUFMLENBQVA7QUFBaUIsSztzQkFDMUJBLEssRUFBTztBQUFFLGFBQU8sS0FBSyxDQUFMLElBQVUseUJBQVlBLEtBQVosQ0FBakI7QUFBc0M7Ozs7OztrQkFwRGxDakQsVSIsImZpbGUiOiJxdWF0ZXJuaW9uLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IE1hdGhBcnJheSBmcm9tICcuL21hdGgtYXJyYXknO1xuaW1wb3J0IHtjaGVja051bWJlcn0gZnJvbSAnLi9jb21tb24nO1xuaW1wb3J0IHtxdWF0fSBmcm9tICdnbC1tYXRyaXgnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBRdWF0ZXJuaW9uIGV4dGVuZHMgTWF0aEFycmF5IHtcbiAgLy8gQ3JlYXRlcyBhIG5ldyBpZGVudGl0eSBxdWF0XG4gIGNvbnN0cnVjdG9yKHggPSAwLCB5ID0gMCwgeiA9IDAsIHcgPSAxKSB7XG4gICAgc3VwZXIoKTtcbiAgICBpZiAoQXJyYXkuaXNBcnJheSh4KSAmJiBhcmd1bWVudHMubGVuZ3RoID09PSAxKSB7XG4gICAgICB0aGlzLmNvcHkoeCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuc2V0KHgsIHksIHosIHcpO1xuICAgIH1cbiAgfVxuXG4gIC8vIENyZWF0ZXMgYSBxdWF0ZXJuaW9uIGZyb20gdGhlIGdpdmVuIDN4MyByb3RhdGlvbiBtYXRyaXguXG4gIC8vIE5PVEU6IFRoZSByZXN1bHRhbnQgcXVhdGVybmlvbiBpcyBub3Qgbm9ybWFsaXplZCwgc28geW91IHNob3VsZFxuICAvLyBiZSBzdXJlIHRvIHJlbm9ybWFsaXplIHRoZSBxdWF0ZXJuaW9uIHlvdXJzZWxmIHdoZXJlIG5lY2Vzc2FyeS5cbiAgZnJvbU1hdHJpeDMobSkge1xuICAgIHF1YXQuZnJvbU1hdDModGhpcywgbSk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gQ3JlYXRlcyBhIG5ldyBxdWF0IGluaXRpYWxpemVkIHdpdGggdGhlIGdpdmVuIHZhbHVlc1xuICBmcm9tVmFsdWVzKHgsIHksIHosIHcpIHtcbiAgICByZXR1cm4gdGhpcy5zZXQoeCwgeSwgeiwgdyk7XG4gIH1cblxuICAvLyBTZXQgYSBxdWF0IHRvIHRoZSBpZGVudGl0eSBxdWF0ZXJuaW9uXG4gIGlkZW50aXR5KCkge1xuICAgIHF1YXQuaWRlbnRpdHkodGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgZXF1YWxzKHF1YXRlcm5pb24pIHtcbiAgICByZXR1cm4gcXVhdC5lcXVhbHModGhpcywgcXVhdGVybmlvbik7XG4gIH1cblxuICAvLyBSZXR1cm5zIHdoZXRoZXIgb3Igbm90IHRoZSBxdWF0ZXJuaW9ucyBoYXZlIGV4YWN0bHkgdGhlIHNhbWUgZWxlbWVudHNcbiAgLy8gaW4gdGhlIHNhbWUgcG9zaXRpb24gKHdoZW4gY29tcGFyZWQgd2l0aCA9PT0pXG4gIGV4YWN0RXF1YWxzKHF1YXRlcm5pb24pIHtcbiAgICByZXR1cm4gcXVhdC5leGFjdEVxdWFscyh0aGlzLCBxdWF0ZXJuaW9uKTtcbiAgfVxuXG4gIC8vIEdldHRlcnMvc2V0dGVyc1xuICAvKiBlc2xpbnQtZGlzYWJsZSBuby1tdWx0aS1zcGFjZXMsIGJyYWNlLXN0eWxlLCBuby1yZXR1cm4tYXNzaWduICovXG4gIGdldCBFTEVNRU5UUygpIHsgcmV0dXJuIDQ7IH1cbiAgZ2V0IHgoKSAgICAgIHsgcmV0dXJuIHRoaXNbMF07IH1cbiAgc2V0IHgodmFsdWUpIHsgcmV0dXJuIHRoaXNbMF0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IHkoKSAgICAgIHsgcmV0dXJuIHRoaXNbMV07IH1cbiAgc2V0IHkodmFsdWUpIHsgcmV0dXJuIHRoaXNbMV0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IHooKSAgICAgIHsgcmV0dXJuIHRoaXNbMl07IH1cbiAgc2V0IHoodmFsdWUpIHsgcmV0dXJuIHRoaXNbMl0gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgZ2V0IHcoKSAgICAgIHsgcmV0dXJuIHRoaXNbM107IH1cbiAgc2V0IHcodmFsdWUpIHsgcmV0dXJuIHRoaXNbM10gPSBjaGVja051bWJlcih2YWx1ZSk7IH1cbiAgLyogZXNsaW50LWVuYWJsZSBuby1tdWx0aS1zcGFjZXMsIGJyYWNlLXN0eWxlLCBuby1yZXR1cm4tYXNzaWduICovXG5cbiAgLy8gQ2FsY3VsYXRlcyB0aGUgbGVuZ3RoIG9mIGEgcXVhdFxuICBsZW5ndGgoKSB7XG4gICAgcmV0dXJuIHF1YXQubGVuZ3RoKHRoaXMpO1xuICB9XG5cbiAgLy8gQ2FsY3VsYXRlcyB0aGUgc3F1YXJlZCBsZW5ndGggb2YgYSBxdWF0XG4gIHNxdWFyZWRMZW5ndGgoYSkge1xuICAgIHJldHVybiBxdWF0LnNxdWFyZWRMZW5ndGgodGhpcyk7XG4gIH1cblxuICAvLyBDYWxjdWxhdGVzIHRoZSBkb3QgcHJvZHVjdCBvZiB0d28gcXVhdCdzXG4gIC8vIEByZXR1cm4ge051bWJlcn1cbiAgZG90KGEsIGIpIHtcbiAgICBpZiAoYiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1F1YXRlcm5pb24uZG90IG9ubHkgdGFrZXMgb25lIGFyZ3VtZW50Jyk7XG4gICAgfVxuICAgIHJldHVybiBxdWF0LmRvdCh0aGlzLCBhKTtcbiAgfVxuXG4gIC8vIEdldHMgdGhlIHJvdGF0aW9uIGF4aXMgYW5kIGFuZ2xlIGZvciBhIGdpdmVuIHF1YXRlcm5pb24uXG4gIC8vIElmIGEgcXVhdGVybmlvbiBpcyBjcmVhdGVkIHdpdGggc2V0QXhpc0FuZ2xlLCB0aGlzIG1ldGhvZCB3aWxsXG4gIC8vIHJldHVybiB0aGUgc2FtZSB2YWx1ZXMgYXMgcHJvdmlkaWVkIGluIHRoZSBvcmlnaW5hbCBwYXJhbWV0ZXJcbiAgLy8gbGlzdCBPUiBmdW5jdGlvbmFsbHkgZXF1aXZhbGVudCB2YWx1ZXMuXG4gIC8vIEV4YW1wbGU6IFRoZSBxdWF0ZXJuaW9uIGZvcm1lZCBieSBheGlzIFswLCAwLCAxXSBhbmQgYW5nbGUgLTkwXG4gIC8vIGlzIHRoZSBzYW1lIGFzIHRoZSBxdWF0ZXJuaW9uIGZvcm1lZCBieSBbMCwgMCwgMV0gYW5kIDI3MC5cbiAgLy8gVGhpcyBtZXRob2QgZmF2b3JzIHRoZSBsYXR0ZXIuXG4gIC8vIEByZXR1cm4ge3tbeCx5LHpdLCBOdW1iZXJ9fVxuICBnZXRBeGlzQW5nbGUoKSB7XG4gICAgY29uc3QgYXhpcyA9IFtdO1xuICAgIGNvbnN0IGFuZ2xlID0gcXVhdC5nZXRBeGlzQW5nbGUoYXhpcywgdGhpcyk7XG4gICAgcmV0dXJuIHtheGlzLCBhbmdsZX07XG4gIH1cblxuICAvLyBNT0RJRklFUlNcblxuICAvLyBTZXRzIGEgcXVhdGVybmlvbiB0byByZXByZXNlbnQgdGhlIHNob3J0ZXN0IHJvdGF0aW9uIGZyb20gb25lIHZlY3RvclxuICAvLyB0byBhbm90aGVyLiBCb3RoIHZlY3RvcnMgYXJlIGFzc3VtZWQgdG8gYmUgdW5pdCBsZW5ndGguXG4gIHJvdGF0aW9uVG8odmVjdG9yQSwgdmVjdG9yQikge1xuICAgIHF1YXQucm90YXRpb25Ubyh0aGlzLCB2ZWN0b3JBLCB2ZWN0b3JCKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyBTZXRzIHRoZSBzcGVjaWZpZWQgcXVhdGVybmlvbiB3aXRoIHZhbHVlcyBjb3JyZXNwb25kaW5nIHRvIHRoZSBnaXZlbiBheGVzLlxuICAvLyBFYWNoIGF4aXMgaXMgYSB2ZWMzIGFuZCBpcyBleHBlY3RlZCB0byBiZSB1bml0IGxlbmd0aCBhbmQgcGVycGVuZGljdWxhclxuICAvLyB0byBhbGwgb3RoZXIgc3BlY2lmaWVkIGF4ZXMuXG4gIC8vIHNldEF4ZXMoKSB7XG4gIC8vICAgTnVtYmVyXG4gIC8vIH1cblxuICAvLyBQZXJmb3JtcyBhIHNwaGVyaWNhbCBsaW5lYXIgaW50ZXJwb2xhdGlvbiB3aXRoIHR3byBjb250cm9sIHBvaW50c1xuICAvLyBzcWxlcnAoKSB7XG4gIC8vICAgTnVtYmVyO1xuICAvLyB9XG5cbiAgLy8gQWRkcyB0d28gcXVhdCdzXG4gIGFkZChhLCBiKSB7XG4gICAgaWYgKGIgIT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdRdWF0ZXJuaW9uLmFkZCBvbmx5IHRha2VzIG9uZSBhcmd1bWVudCcpO1xuICAgIH1cbiAgICBxdWF0LmFkZCh0aGlzLCBhKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyBDYWxjdWxhdGVzIHRoZSBXIGNvbXBvbmVudCBvZiBhIHF1YXQgZnJvbSB0aGUgWCwgWSwgYW5kIFogY29tcG9uZW50cy5cbiAgLy8gQW55IGV4aXN0aW5nIFcgY29tcG9uZW50IHdpbGwgYmUgaWdub3JlZC5cbiAgY2FsY3VsYXRlVygpIHtcbiAgICBxdWF0LmNhbGN1bGF0ZVcodGhpcywgdGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gQ2FsY3VsYXRlcyB0aGUgY29uanVnYXRlIG9mIGEgcXVhdCBJZiB0aGUgcXVhdGVybmlvbiBpcyBub3JtYWxpemVkLFxuICAvLyB0aGlzIGZ1bmN0aW9uIGlzIGZhc3RlciB0aGFuIHF1YXQuaW52ZXJzZSBhbmQgcHJvZHVjZXMgdGhlIHNhbWUgcmVzdWx0LlxuICBjb25qdWdhdGUoKSB7XG4gICAgcXVhdC5jb25qdWdhdGUodGhpcywgdGhpcyk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gQ2FsY3VsYXRlcyB0aGUgaW52ZXJzZSBvZiBhIHF1YXRcbiAgaW52ZXJ0KCkge1xuICAgIHF1YXQuaW52ZXJ0KHRoaXMsIHRoaXMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFBlcmZvcm1zIGEgbGluZWFyIGludGVycG9sYXRpb24gYmV0d2VlbiB0d28gcXVhdCdzXG4gIGxlcnAoYSwgYiwgdCkge1xuICAgIHF1YXQubGVycCh0aGlzLCBhLCBiLCB0KTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyBNdWx0aXBsaWVzIHR3byBxdWF0J3NcbiAgbXVsdGlwbHkoYSwgYikge1xuICAgIGlmIChiICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignUXVhdGVybmlvbi5tdWx0aXBseSBvbmx5IHRha2VzIG9uZSBhcmd1bWVudCcpO1xuICAgIH1cbiAgICBxdWF0Lm11bHRpcGx5KHRoaXMsIHRoaXMsIGIpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIE5vcm1hbGl6ZSBhIHF1YXRcbiAgbm9ybWFsaXplKCkge1xuICAgIHF1YXQubm9ybWFsaXplKHRoaXMsIHRoaXMpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFJvdGF0ZXMgYSBxdWF0ZXJuaW9uIGJ5IHRoZSBnaXZlbiBhbmdsZSBhYm91dCB0aGUgWCBheGlzXG4gIHJvdGF0ZVgocmFkKSB7XG4gICAgcXVhdC5yb3RhdGVYKHRoaXMsIHRoaXMsIHJhZCk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLy8gUm90YXRlcyBhIHF1YXRlcm5pb24gYnkgdGhlIGdpdmVuIGFuZ2xlIGFib3V0IHRoZSBZIGF4aXNcbiAgcm90YXRlWShyYWQpIHtcbiAgICBxdWF0LnJvdGF0ZVkodGhpcywgdGhpcywgcmFkKTtcbiAgICB0aGlzLmNoZWNrKCk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvLyBSb3RhdGVzIGEgcXVhdGVybmlvbiBieSB0aGUgZ2l2ZW4gYW5nbGUgYWJvdXQgdGhlIFogYXhpc1xuICByb3RhdGVaKHJhZCkge1xuICAgIHF1YXQucm90YXRlWih0aGlzLCB0aGlzLCByYWQpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFNjYWxlcyBhIHF1YXQgYnkgYSBzY2FsYXIgbnVtYmVyXG4gIHNjYWxlKGIpIHtcbiAgICBxdWF0LnNjYWxlKHRoaXMsIHRoaXMsIGIpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFNldCB0aGUgY29tcG9uZW50cyBvZiBhIHF1YXQgdG8gdGhlIGdpdmVuIHZhbHVlc1xuICBzZXQoaSwgaiwgaywgbCkge1xuICAgIHF1YXQuc2V0KHRoaXMsIGksIGosIGssIGwpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFNldHMgYSBxdWF0IGZyb20gdGhlIGdpdmVuIGFuZ2xlIGFuZCByb3RhdGlvbiBheGlzLCB0aGVuIHJldHVybnMgaXQuXG4gIHNldEF4aXNBbmdsZShheGlzLCByYWQpIHtcbiAgICBxdWF0LnNldEF4aXNBbmdsZSh0aGlzLCBheGlzLCByYWQpO1xuICAgIHRoaXMuY2hlY2soKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8vIFBlcmZvcm1zIGEgc3BoZXJpY2FsIGxpbmVhciBpbnRlcnBvbGF0aW9uIGJldHdlZW4gdHdvIHF1YXRcbiAgc2xlcnAoYSwgYiwgdCkge1xuICAgIHF1YXQuc2xlcnAodGhpcywgYSwgYiwgdCk7XG4gICAgdGhpcy5jaGVjaygpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG4iXX0=