'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; /* eslint-disable max-statements */


exports.tapeEquals = tapeEquals;

var _ = require('../');

var _tapeCatch = require('tape-catch');

var _tapeCatch2 = _interopRequireDefault(_tapeCatch);

require('./common.spec');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// FOR TAPE TESTING
// Use tape assert to compares using a.equals(b)
// Usage test(..., t => { tapeEquals(t, a, b, ...); });
function tapeEquals(t, a, b, msg, extra) {
  /* eslint-disable no-invalid-this */
  t._assert(a.equals(b), {
    message: msg || 'should be equal',
    operator: 'equal',
    actual: a,
    expected: b,
    extra: extra
  });
}

var IDENTITY_MATRIX = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];

var INDICES_MATRIX = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16];

var TRANSPOSED_INDICES_MATRIX = [1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15, 4, 8, 12, 16];

// const MATRIX_TEST_CASES = {
//   identity: {
//     title: 'identity matrix',
//     INPUTS: [],
//     RESULT: IDENTITY_MATRIX
//   },
//   set: {}
// };

(0, _tapeCatch2.default)('Math#types', function (t) {
  t.equals(typeof _.Vector2 === 'undefined' ? 'undefined' : _typeof(_.Vector2), 'function');
  t.equals(typeof _.Vector3 === 'undefined' ? 'undefined' : _typeof(_.Vector3), 'function');
  t.equals(typeof _.Vector4 === 'undefined' ? 'undefined' : _typeof(_.Vector4), 'function');
  t.equals(typeof _.Matrix4 === 'undefined' ? 'undefined' : _typeof(_.Matrix4), 'function');
  t.equals(typeof _.Quaternion === 'undefined' ? 'undefined' : _typeof(_.Quaternion), 'function');
  t.end();
});

(0, _tapeCatch2.default)('Math#construct and Array.isArray check', function (t) {
  t.ok(Array.isArray(new _.Vector2()));
  t.ok(Array.isArray(new _.Vector3()));
  t.ok(Array.isArray(new _.Vector4()));
  t.ok(Array.isArray(new _.Matrix4()));
  t.ok(Array.isArray(new _.Quaternion()));
  t.end();
});

// ['add', 'cross'];
var VECTOR_METHODS = ['clone'];

(0, _tapeCatch2.default)('Vector2#members and methods', function (t) {
  var v = new _.Vector2();
  t.equals(v.x, 0);
  t.equals(v.y, 0);

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = VECTOR_METHODS[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var method = _step.value;

      t.equals(_typeof(v[method]), 'function');
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  t.end();
});

(0, _tapeCatch2.default)('Vector3#members and methods', function (t) {
  var v = new _.Vector3();
  t.equals(v.x, 0);
  t.equals(v.y, 0);
  t.equals(v.z, 0);

  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = VECTOR_METHODS[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var method = _step2.value;

      t.equals(_typeof(v[method]), 'function');
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  t.end();
});

(0, _tapeCatch2.default)('Vector4#members and methods', function (t) {
  var v = new _.Vector4();
  t.equals(v.x, 0);
  t.equals(v.y, 0);
  t.equals(v.z, 0);
  t.equals(v.w, 0);

  var _iteratorNormalCompletion3 = true;
  var _didIteratorError3 = false;
  var _iteratorError3 = undefined;

  try {
    for (var _iterator3 = VECTOR_METHODS[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
      var method = _step3.value;

      t.equals(_typeof(v[method]), 'function');
    }
  } catch (err) {
    _didIteratorError3 = true;
    _iteratorError3 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion3 && _iterator3.return) {
        _iterator3.return();
      }
    } finally {
      if (_didIteratorError3) {
        throw _iteratorError3;
      }
    }
  }

  t.end();
});

(0, _tapeCatch2.default)('Matrix4.toFloat32Array', function (t) {
  t.equals(_typeof(_.Matrix4.prototype.toFloat32Array), 'function');
  var m = new _.Matrix4();
  m.identity();
  t.equals(m.toFloat32Array().BYTES_PER_ELEMENT, 4);
  t.end();
});

(0, _tapeCatch2.default)('Matrix4#identity (identity matrix)', function (t) {
  t.equals(_typeof(_.Matrix4.prototype.identity), 'function');
  var m = new _.Matrix4();
  m.identity();

  var RESULT = IDENTITY_MATRIX;

  tapeEquals(t, m, RESULT);
  t.end();
});

(0, _tapeCatch2.default)('Matrix4#set', function (t) {
  var _ref;

  t.equals(_typeof(_.Matrix4.prototype.set), 'function');

  var INPUT = INDICES_MATRIX;
  var RESULT = INDICES_MATRIX;

  var m = (_ref = new _.Matrix4()).set.apply(_ref, INPUT);

  tapeEquals(t, m, RESULT, 'set gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.transpose', function (t) {
  var _ref2;

  t.equals(_typeof(_.Matrix4.prototype.transpose), 'function');

  var INPUT = INDICES_MATRIX;
  var RESULT = TRANSPOSED_INDICES_MATRIX;

  var m = (_ref2 = new _.Matrix4()).set.apply(_ref2, INPUT);

  var result = m.transpose();

  tapeEquals(t, result, RESULT, 'transpose gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.add', function (t) {
  var RESULT = [2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2];

  t.equals(_typeof(_.Matrix4.prototype.add), 'function');
  var m = new _.Matrix4().identity();
  m = m.add(m);

  tapeEquals(t, m, RESULT, 'add gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.scale', function (t) {
  var RESULT = [1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1];

  t.equals(_typeof(_.Matrix4.prototype.scale), 'function');
  var m = new _.Matrix4().identity();
  var result = m.scale([1, 2, 3]);

  tapeEquals(t, result, RESULT, 'scale gave the right result');
  t.end();
});

(0, _tapeCatch2.default)('Matrix4.translate', function (t) {
  var RESULT = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 2, 3, 1];

  t.equals(_typeof(_.Matrix4.prototype.translate), 'function');
  var m = new _.Matrix4().identity();
  var result = m.translate([1, 2, 3]);

  tapeEquals(t, result, RESULT, 'translate gave the right result');
  t.end();
});

// test('Matrix4.invert', t => {
//   t.equals(typeof Matrix4.prototype.invert, 'function');
//   const m = new Matrix4();
//   m.identity();
//   const ans = m.frustum(-1, 1, -1, 1, 0.1, 100).invert();
//   t.ok(abs(ans.n11 - 9.99999999) < delta);
//   t.ok(abs(ans.n12 - 0) < delta);
//   t.ok(abs(ans.n13 - 0) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - 0) < delta);
//   t.ok(abs(ans.n22 - 9.99999999) < delta);
//   t.ok(abs(ans.n23 - 0) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - 0) < delta);
//   t.ok(abs(ans.n32 - 0) < delta);
//   t.ok(abs(ans.n33 - 0) < delta);
//   t.ok(abs(ans.n34 - -1) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - -4.995) < delta);
//   t.ok(abs(ans.n44 - 5.005) < delta);
//   t.end();
// });

// test('Matrix4.mulVector3', t => {
//   t.equals(typeof Matrix4.prototype.mulVector3, 'function');
//   const v = new Vector3(1, 1, 1);
//   const m = new Matrix4();
//   const ans = m.mulVector3(v);

//   t.equals(ans[0], 1);
//   t.equals(ans[1], 1);
//   t.equals(ans[2], 1);
//   t.end();
// });

// test('Matrix4.$mulVector3', t => {
//   t.equals(typeof Matrix4.prototype.$mulVector3, 'function');
//   const v = new Vector3(1, 1, 1);
//   const m = new Matrix4();

//   m.$mulVector3(v);

//   t.equals(v[0], 1);
//   t.equals(v[1], 1);
//   t.equals(v[2], 1);
//   t.end();
// });

// test('Matrix4.mulMatrix42', t => {
//   t.equals(typeof Matrix4.prototype.mulMatrix42, 'function');
//   const m1 = new Matrix4();
//   m1.set(1, 2, 3, 4,
//          5, 6, 7, 8,
//          9, 10, 11, 12,
//          13, 14, 15, 16);

//   const m2 = new Matrix4();
//   m2.set(1, 2, 3, 4,
//          5, 6, 7, 8,
//          9, 10, 11, 12,
//          13, 14, 15, 16).$transpose();

//   const ans = new Matrix4();
//   ans.mulMatrix42(m1, m2);
//   t.ok(abs(ans.n11 - 30) < delta);
//   t.ok(abs(ans.n12 - 70) < delta);
//   t.ok(abs(ans.n13 - 110) < delta);
//   t.ok(abs(ans.n14 - 150) < delta);
//   t.ok(abs(ans.n21 - 70) < delta);
//   t.ok(abs(ans.n22 - 174) < delta);
//   t.ok(abs(ans.n23 - 278) < delta);
//   t.ok(abs(ans.n24 - 382) < delta);
//   t.ok(abs(ans.n31 - 110) < delta);
//   t.ok(abs(ans.n32 - 278) < delta);
//   t.ok(abs(ans.n33 - 446) < delta);
//   t.ok(abs(ans.n34 - 614) < delta);
//   t.ok(abs(ans.n41 - 150) < delta);
//   t.ok(abs(ans.n42 - 382) < delta);
//   t.ok(abs(ans.n43 - 614) < delta);
//   t.ok(abs(ans.n44 - 846) < delta);
//   t.end();
// });

// test('Matrix4.lookAt', t => {
//   t.equals(typeof Matrix4.prototype.lookAt, 'function');
//   t.end();
// });

// test('Matrix4.perspective', t => {
//   t.equals(typeof Matrix4.prototype.perspective, 'function');
//   t.end();
// });

// test('Matrix4.frustum', t => {
//   t.equals(typeof Matrix4.prototype.frustum, 'function');
//   const m = new Matrix4();
//   m.identity();
//   const ans = m.frustum(-1, 1, -1, 1, 0.1, 100);
//   t.ok(abs(ans.n11 - 0.1) < delta);
//   t.ok(abs(ans.n12 - 0) < delta);
//   t.ok(abs(ans.n13 - 0) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - 0) < delta);
//   t.ok(abs(ans.n22 - 0.1) < delta);
//   t.ok(abs(ans.n23 - 0) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - 0) < delta);
//   t.ok(abs(ans.n32 - 0) < delta);
//   t.ok(abs(ans.n33 - -1.002002002002002) < delta);
//   t.ok(abs(ans.n34 - -0.20020020020020018) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - -1) < delta);
//   t.ok(abs(ans.n44 - 0) < delta);
//   t.end();
// });

// test('Matrix4.rotateAxis', t => {
//   t.equals(typeof Matrix4.prototype.rotateAxis, 'function');
//   const v = [1, 2, 3];
//   const len = Math.sqrt(1 * 1 + 2 * 2 + 3 * 3);
//   const theta = Math.PI / 4;
//   const m = new Matrix4();

//   v[0] /= len;
//   v[1] /= len;
//   v[2] /= len;

//   const ans = m.rotateAxis(theta, v);
//   t.ok(abs(ans.n11 - 0.7280277013778687) < delta);
//   t.ok(abs(ans.n12 - -0.525104820728302) < delta);
//   t.ok(abs(ans.n13 - 0.4407272934913635) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - 0.6087885979157627) < delta);
//   t.ok(abs(ans.n22 - 0.7907905578613281) < delta);
//   t.ok(abs(ans.n23 - -0.06345657259225845) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - -0.3152016404063445) < delta);
//   t.ok(abs(ans.n32 - 0.3145079017103789) < delta);
//   t.ok(abs(ans.n33 - 0.8953952789306641) < delta);
//   t.ok(abs(ans.n34 - 0) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - 0) < delta);
//   t.ok(abs(ans.n44 - 1) < delta);
//   t.end();
// });

// test('Matrix4.rotateXYZ', t => {
//   t.equals(typeof Matrix4.prototype.rotateXYZ, 'function');
//   const m = new Matrix4();
//   m.identity();
//   const ans = m.rotateXYZ(1, 2, 3);
//   t.ok(abs(ans.n11 - 0.411982245665683) < delta);
//   t.ok(abs(ans.n12 - -0.8337376517741568) < delta);
//   t.ok(abs(ans.n13 - -0.36763046292489926) < delta);
//   t.ok(abs(ans.n14 - 0) < delta);
//   t.ok(abs(ans.n21 - -0.05872664492762098) < delta);
//   t.ok(abs(ans.n22 - -0.42691762127620736) < delta);
//   t.ok(abs(ans.n23 - 0.9023815854833308) < delta);
//   t.ok(abs(ans.n24 - 0) < delta);
//   t.ok(abs(ans.n31 - -0.9092974268256817) < delta);
//   t.ok(abs(ans.n32 - -0.35017548837401463) < delta);
//   t.ok(abs(ans.n33 - -0.2248450953661529) < delta);
//   t.ok(abs(ans.n34 - 0) < delta);
//   t.ok(abs(ans.n41 - 0) < delta);
//   t.ok(abs(ans.n42 - 0) < delta);
//   t.ok(abs(ans.n43 - 0) < delta);
//   t.ok(abs(ans.n44 - 1) < delta);
//   t.end();
// });

(0, _tapeCatch2.default)('Quaternion#methods', function (t) {
  var q = new _.Quaternion();
  t.equals(q[0], 0);
  t.equals(q[1], 0);
  t.equals(q[2], 0);
  t.equals(q[3], 1);
  t.equals(_typeof(q.add), 'function');
  t.equals(_typeof(q.clone), 'function');
  t.equals(_typeof(q.conjugate), 'function');
  // t.equals(typeof q.divQuaternion, 'function');
  t.equals(_typeof(q.invert), 'function');
  t.equals(_typeof(q.multiply), 'function');
  // t.equals(typeof q.negate, 'function');
  // t.equals(typeof q.norm, 'function');
  // t.equals(typeof q.normSq, 'function');
  t.equals(_typeof(q.scale), 'function');
  t.equals(_typeof(q.set), 'function');
  // t.equals(typeof q.setQuaternion, 'function');
  // t.equals(typeof q.sub, 'function');
  // t.equals(typeof q.unit, 'function');
  t.end();
});

// test('Quaternion.fromAxisRotation', t => {
//   let q = Quaternion.fromAxisRotation(new Vector3(0, 0, 1), Math.PI);
//   t.equals(q[0], 0);
//   t.equals(q[1], 0);
//   t.equals(q[2], 1);
//   t.equals(q[3], Math.cos(Math.PI / 2));

//   q = Quaternion.fromAxisRotation(new Vector3(0, 1, 0), Math.PI);
//   t.equals(q[0], 0);
//   t.equals(q[1], 1);
//   t.equals(q[2], 0);
//   t.equals(q[3], Math.cos(Math.PI / 2));

//   q = Quaternion.fromAxisRotation(new Vector3(1, 0, 0), Math.PI);
//   t.equals(q[0], 1);
//   t.equals(q[1], 0);
//   t.equals(q[2], 0);
//   t.equals(q[3], Math.cos(Math.PI / 2));

//   const q1 = Quaternion.fromAxisRotation(new Vector3(5, 0, -2), Math.PI / 3);
//   const q2 = Quaternion.fromAxisRotation(new Vector3(1, 3, 0), Math.PI / 4);
//   q1.$mulQuaternion(q2);
//   t.equals(q1[0], 0.6011183144537015);
//   t.equals(q1[1], 0.29193457751898655);
//   t.equals(q1[2], -0.0030205353559888126);
//   t.equals(q1[3], 0.7439232829017486);
//   t.end();
// });
//# sourceMappingURL=data:application/json;base64,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