'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatValue = formatValue;
/* eslint-disable no-console */
/* global console */
var cache = {};

var _log = {
  priority: 0,
  table: function table(priority, _table) {
    if (priority <= _log.priority && _table) {
      console.table(_table);
    }
  },
  log: function log(priority) {
    if (priority <= _log.priority) {
      var _console;

      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      (_console = console).debug.apply(_console, args);
    }
  },
  info: function info(priority) {
    if (priority <= _log.priority) {
      var _console2;

      for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      (_console2 = console).log.apply(_console2, args);
    }
  },
  warn: function warn(priority) {
    if (priority <= _log.priority) {
      var _console3;

      for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
        args[_key3 - 1] = arguments[_key3];
      }

      (_console3 = console).warn.apply(_console3, args);
    }
  },
  once: function once(priority, arg) {
    if (!cache[arg]) {
      for (var _len4 = arguments.length, args = Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
        args[_key4 - 2] = arguments[_key4];
      }

      _log.log.apply(_log, [priority, arg].concat(args));
    }
    cache[arg] = true;
  }
};

function formatArrayValue(v, opts) {
  var _opts$maxElts = opts.maxElts,
      maxElts = _opts$maxElts === undefined ? 16 : _opts$maxElts,
      _opts$size = opts.size,
      size = _opts$size === undefined ? 1 : _opts$size;

  var string = '[';
  for (var i = 0; i < v.length && i < maxElts; ++i) {
    if (i > 0) {
      string += ',' + (i % size === 0 ? ' ' : '');
    }
    string += formatValue(v[i], opts);
  }
  var terminator = v.length > maxElts ? '...' : ']';
  return '' + string + terminator;
}

function formatValue(v) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _opts$isInteger = opts.isInteger,
      isInteger = _opts$isInteger === undefined ? false : _opts$isInteger;

  if (Array.isArray(v) || ArrayBuffer.isView(v)) {
    return formatArrayValue(v, opts);
  }
  if (!Number.isFinite(v)) {
    return String(v);
  }
  if (isInteger) {
    return v.toFixed(0);
  }
  if (Math.abs(v) > 100 && Math.abs(v) < 10000) {
    return v.toFixed(0);
  }
  var string = v.toPrecision(2);
  var decimal = string.indexOf('.0');
  return decimal === string.length - 2 ? string.slice(0, -1) : string;
}

exports.default = _log;
//# sourceMappingURL=data:application/json;base64,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