'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splat = splat;
exports.noop = noop;
exports.uid = uid;
exports.merge = merge;
/**
 * Wraps the argument in an array if it is not one.
 * @param {object} a - The object to wrap.
 * @return {Array} array
 **/
function splat(a) {
  return a ? Array.isArray(a) ? a : [a] : [];
}

/**
* Provides a standard noop function.
**/
function noop() {}

var uidCounters = {};

/**
 * Returns a UID.
 * @param {String} id= - Identifier base name
 * @return {number} uid
 **/
function uid() {
  var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';

  uidCounters[id] = uidCounters[id] || 1;
  var count = uidCounters[id]++;
  return id + '-' + count;
}

/**
 * Merge multiple objects into one.
 * @param {...object} objects - The objects to merge.
 * @return {object} object
 **/
function merge(objects) {
  var mix = {};
  for (var i = 0, l = arguments.length; i < l; i++) {
    var object = arguments[i];
    if (!object || object.constructor.name !== 'Object') {
      /* eslint-disable no-continue */
      continue;
    }
    for (var key in object) {
      var op = object[key];
      var mp = mix[key];
      if (mp && op.constructor.name === 'Object' && mp.constructor.name === 'Object') {
        mix[key] = merge(mp, op);
      } else {
        mix[key] = detach(op);
      }
    }
  }
  return mix;
}

/**
 * Internal function for duplicating an object.
 * @param {object} elem - The object to recursively duplicate.
 * @return {object} object
 **/
function detach(elem) {
  var t = elem.constructor.name;
  var ans = void 0;
  if (t === 'Object') {
    ans = {};
    for (var p in elem) {
      ans[p] = detach(elem[p]);
    }
  } else if (t === 'Array') {
    ans = [];
    for (var i = 0, l = elem.length; i < l; i++) {
      ans[i] = detach(elem[i]);
    }
  } else {
    ans = elem;
  }

  return ans;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy91dGlscy5qcyJdLCJuYW1lcyI6WyJzcGxhdCIsIm5vb3AiLCJ1aWQiLCJtZXJnZSIsImEiLCJBcnJheSIsImlzQXJyYXkiLCJ1aWRDb3VudGVycyIsImlkIiwiY291bnQiLCJvYmplY3RzIiwibWl4IiwiaSIsImwiLCJhcmd1bWVudHMiLCJsZW5ndGgiLCJvYmplY3QiLCJjb25zdHJ1Y3RvciIsIm5hbWUiLCJrZXkiLCJvcCIsIm1wIiwiZGV0YWNoIiwiZWxlbSIsInQiLCJhbnMiLCJwIl0sIm1hcHBpbmdzIjoiOzs7OztRQUtnQkEsSyxHQUFBQSxLO1FBT0FDLEksR0FBQUEsSTtRQVNBQyxHLEdBQUFBLEc7UUFXQUMsSyxHQUFBQSxLO0FBaENoQjs7Ozs7QUFLTyxTQUFTSCxLQUFULENBQWVJLENBQWYsRUFBa0I7QUFDdkIsU0FBT0EsSUFBS0MsTUFBTUMsT0FBTixDQUFjRixDQUFkLElBQW1CQSxDQUFuQixHQUF1QixDQUFDQSxDQUFELENBQTVCLEdBQW1DLEVBQTFDO0FBQ0Q7O0FBRUQ7OztBQUdPLFNBQVNILElBQVQsR0FBZ0IsQ0FBRTs7QUFFekIsSUFBTU0sY0FBYyxFQUFwQjs7QUFFQTs7Ozs7QUFLTyxTQUFTTCxHQUFULEdBQXdCO0FBQUEsTUFBWE0sRUFBVyx1RUFBTixJQUFNOztBQUM3QkQsY0FBWUMsRUFBWixJQUFrQkQsWUFBWUMsRUFBWixLQUFtQixDQUFyQztBQUNBLE1BQU1DLFFBQVFGLFlBQVlDLEVBQVosR0FBZDtBQUNBLFNBQVVBLEVBQVYsU0FBZ0JDLEtBQWhCO0FBQ0Q7O0FBRUQ7Ozs7O0FBS08sU0FBU04sS0FBVCxDQUFlTyxPQUFmLEVBQXdCO0FBQzdCLE1BQU1DLE1BQU0sRUFBWjtBQUNBLE9BQUssSUFBSUMsSUFBSSxDQUFSLEVBQVdDLElBQUlDLFVBQVVDLE1BQTlCLEVBQXNDSCxJQUFJQyxDQUExQyxFQUE2Q0QsR0FBN0MsRUFBa0Q7QUFDaEQsUUFBTUksU0FBU0YsVUFBVUYsQ0FBVixDQUFmO0FBQ0EsUUFBSSxDQUFDSSxNQUFELElBQVdBLE9BQU9DLFdBQVAsQ0FBbUJDLElBQW5CLEtBQTRCLFFBQTNDLEVBQXFEO0FBQ25EO0FBQ0E7QUFDRDtBQUNELFNBQUssSUFBTUMsR0FBWCxJQUFrQkgsTUFBbEIsRUFBMEI7QUFDeEIsVUFBTUksS0FBS0osT0FBT0csR0FBUCxDQUFYO0FBQ0EsVUFBTUUsS0FBS1YsSUFBSVEsR0FBSixDQUFYO0FBQ0EsVUFBSUUsTUFBTUQsR0FBR0gsV0FBSCxDQUFlQyxJQUFmLEtBQXdCLFFBQTlCLElBQ0ZHLEdBQUdKLFdBQUgsQ0FBZUMsSUFBZixLQUF3QixRQUQxQixFQUNvQztBQUNsQ1AsWUFBSVEsR0FBSixJQUFXaEIsTUFBTWtCLEVBQU4sRUFBVUQsRUFBVixDQUFYO0FBQ0QsT0FIRCxNQUdPO0FBQ0xULFlBQUlRLEdBQUosSUFBV0csT0FBT0YsRUFBUCxDQUFYO0FBQ0Q7QUFDRjtBQUNGO0FBQ0QsU0FBT1QsR0FBUDtBQUNEOztBQUVEOzs7OztBQUtBLFNBQVNXLE1BQVQsQ0FBZ0JDLElBQWhCLEVBQXNCO0FBQ3BCLE1BQU1DLElBQUlELEtBQUtOLFdBQUwsQ0FBaUJDLElBQTNCO0FBQ0EsTUFBSU8sWUFBSjtBQUNBLE1BQUlELE1BQU0sUUFBVixFQUFvQjtBQUNsQkMsVUFBTSxFQUFOO0FBQ0EsU0FBSyxJQUFNQyxDQUFYLElBQWdCSCxJQUFoQixFQUFzQjtBQUNwQkUsVUFBSUMsQ0FBSixJQUFTSixPQUFPQyxLQUFLRyxDQUFMLENBQVAsQ0FBVDtBQUNEO0FBQ0YsR0FMRCxNQUtPLElBQUlGLE1BQU0sT0FBVixFQUFtQjtBQUN4QkMsVUFBTSxFQUFOO0FBQ0EsU0FBSyxJQUFJYixJQUFJLENBQVIsRUFBV0MsSUFBSVUsS0FBS1IsTUFBekIsRUFBaUNILElBQUlDLENBQXJDLEVBQXdDRCxHQUF4QyxFQUE2QztBQUMzQ2EsVUFBSWIsQ0FBSixJQUFTVSxPQUFPQyxLQUFLWCxDQUFMLENBQVAsQ0FBVDtBQUNEO0FBQ0YsR0FMTSxNQUtBO0FBQ0xhLFVBQU1GLElBQU47QUFDRDs7QUFFRCxTQUFPRSxHQUFQO0FBQ0QiLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFdyYXBzIHRoZSBhcmd1bWVudCBpbiBhbiBhcnJheSBpZiBpdCBpcyBub3Qgb25lLlxuICogQHBhcmFtIHtvYmplY3R9IGEgLSBUaGUgb2JqZWN0IHRvIHdyYXAuXG4gKiBAcmV0dXJuIHtBcnJheX0gYXJyYXlcbiAqKi9cbmV4cG9ydCBmdW5jdGlvbiBzcGxhdChhKSB7XG4gIHJldHVybiBhID8gKEFycmF5LmlzQXJyYXkoYSkgPyBhIDogW2FdKSA6IFtdO1xufVxuXG4vKipcbiogUHJvdmlkZXMgYSBzdGFuZGFyZCBub29wIGZ1bmN0aW9uLlxuKiovXG5leHBvcnQgZnVuY3Rpb24gbm9vcCgpIHt9XG5cbmNvbnN0IHVpZENvdW50ZXJzID0ge307XG5cbi8qKlxuICogUmV0dXJucyBhIFVJRC5cbiAqIEBwYXJhbSB7U3RyaW5nfSBpZD0gLSBJZGVudGlmaWVyIGJhc2UgbmFtZVxuICogQHJldHVybiB7bnVtYmVyfSB1aWRcbiAqKi9cbmV4cG9ydCBmdW5jdGlvbiB1aWQoaWQgPSAnaWQnKSB7XG4gIHVpZENvdW50ZXJzW2lkXSA9IHVpZENvdW50ZXJzW2lkXSB8fCAxO1xuICBjb25zdCBjb3VudCA9IHVpZENvdW50ZXJzW2lkXSsrO1xuICByZXR1cm4gYCR7aWR9LSR7Y291bnR9YDtcbn1cblxuLyoqXG4gKiBNZXJnZSBtdWx0aXBsZSBvYmplY3RzIGludG8gb25lLlxuICogQHBhcmFtIHsuLi5vYmplY3R9IG9iamVjdHMgLSBUaGUgb2JqZWN0cyB0byBtZXJnZS5cbiAqIEByZXR1cm4ge29iamVjdH0gb2JqZWN0XG4gKiovXG5leHBvcnQgZnVuY3Rpb24gbWVyZ2Uob2JqZWN0cykge1xuICBjb25zdCBtaXggPSB7fTtcbiAgZm9yIChsZXQgaSA9IDAsIGwgPSBhcmd1bWVudHMubGVuZ3RoOyBpIDwgbDsgaSsrKSB7XG4gICAgY29uc3Qgb2JqZWN0ID0gYXJndW1lbnRzW2ldO1xuICAgIGlmICghb2JqZWN0IHx8IG9iamVjdC5jb25zdHJ1Y3Rvci5uYW1lICE9PSAnT2JqZWN0Jykge1xuICAgICAgLyogZXNsaW50LWRpc2FibGUgbm8tY29udGludWUgKi9cbiAgICAgIGNvbnRpbnVlO1xuICAgIH1cbiAgICBmb3IgKGNvbnN0IGtleSBpbiBvYmplY3QpIHtcbiAgICAgIGNvbnN0IG9wID0gb2JqZWN0W2tleV07XG4gICAgICBjb25zdCBtcCA9IG1peFtrZXldO1xuICAgICAgaWYgKG1wICYmIG9wLmNvbnN0cnVjdG9yLm5hbWUgPT09ICdPYmplY3QnICYmXG4gICAgICAgIG1wLmNvbnN0cnVjdG9yLm5hbWUgPT09ICdPYmplY3QnKSB7XG4gICAgICAgIG1peFtrZXldID0gbWVyZ2UobXAsIG9wKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIG1peFtrZXldID0gZGV0YWNoKG9wKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIG1peDtcbn1cblxuLyoqXG4gKiBJbnRlcm5hbCBmdW5jdGlvbiBmb3IgZHVwbGljYXRpbmcgYW4gb2JqZWN0LlxuICogQHBhcmFtIHtvYmplY3R9IGVsZW0gLSBUaGUgb2JqZWN0IHRvIHJlY3Vyc2l2ZWx5IGR1cGxpY2F0ZS5cbiAqIEByZXR1cm4ge29iamVjdH0gb2JqZWN0XG4gKiovXG5mdW5jdGlvbiBkZXRhY2goZWxlbSkge1xuICBjb25zdCB0ID0gZWxlbS5jb25zdHJ1Y3Rvci5uYW1lO1xuICBsZXQgYW5zO1xuICBpZiAodCA9PT0gJ09iamVjdCcpIHtcbiAgICBhbnMgPSB7fTtcbiAgICBmb3IgKGNvbnN0IHAgaW4gZWxlbSkge1xuICAgICAgYW5zW3BdID0gZGV0YWNoKGVsZW1bcF0pO1xuICAgIH1cbiAgfSBlbHNlIGlmICh0ID09PSAnQXJyYXknKSB7XG4gICAgYW5zID0gW107XG4gICAgZm9yIChsZXQgaSA9IDAsIGwgPSBlbGVtLmxlbmd0aDsgaSA8IGw7IGkrKykge1xuICAgICAgYW5zW2ldID0gZGV0YWNoKGVsZW1baV0pO1xuICAgIH1cbiAgfSBlbHNlIHtcbiAgICBhbnMgPSBlbGVtO1xuICB9XG5cbiAgcmV0dXJuIGFucztcbn1cbiJdfQ==