'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.draw = draw;

var _context = require('./context');

var _webgl = require('./webgl');

var _webglChecks = require('./webgl-checks');

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// A good thing about webGL is that there are so many ways to draw things,
// e.g. depending on whether data is indexed and/or isInstanced.
// This function unifies those into a single call with simple parameters
// that have sane defaults.
/* eslint-disable */
// TODO - generic draw call
// One of the good things about GL is that there are so many ways to draw things
function draw(gl, _ref) {
  var _ref$drawMode = _ref.drawMode,
      drawMode = _ref$drawMode === undefined ? _webgl.GL.TRIANGLES : _ref$drawMode,
      vertexCount = _ref.vertexCount,
      _ref$offset = _ref.offset,
      offset = _ref$offset === undefined ? 0 : _ref$offset,
      _ref$isIndexed = _ref.isIndexed,
      isIndexed = _ref$isIndexed === undefined ? false : _ref$isIndexed,
      _ref$indexType = _ref.indexType,
      indexType = _ref$indexType === undefined ? _webgl.GL.UNSIGNED_SHORT : _ref$indexType,
      _ref$isInstanced = _ref.isInstanced,
      isInstanced = _ref$isInstanced === undefined ? false : _ref$isInstanced,
      _ref$instanceCount = _ref.instanceCount,
      instanceCount = _ref$instanceCount === undefined ? 0 : _ref$instanceCount;

  (0, _webglChecks.assertWebGLContext)(gl);

  drawMode = (0, _webgl.glGet)(drawMode);
  indexType = (0, _webgl.glGet)(indexType);

  (0, _webglChecks.assertDrawMode)(drawMode, 'in draw');
  if (isIndexed) {
    (0, _webglChecks.assertIndexType)(indexType, 'in draw');
  }

  // TODO - Use polyfilled WebGL2RenderingContext instead of ANGLE extension
  if (isInstanced) {
    var webgl2 = (0, _webglChecks.isWebGL2Context)(gl);
    var extension = gl.getExtension('ANGLE_instanced_arrays');
    var context = webgl2 ? gl : extension;
    var suffix = webgl2 ? '' : 'ANGLE';
    var drawElements = 'drawElementsInstanced' + suffix;
    var drawArrays = 'drawArraysInstanced' + suffix;

    if (isIndexed) {
      context[drawElements](drawMode, vertexCount, indexType, offset, instanceCount);
    } else {
      context[drawArrays](drawMode, offset, vertexCount, instanceCount);
    }
  } else if (isIndexed) {
    gl.drawElements(drawMode, vertexCount, indexType, offset);
  } else {
    gl.drawArrays(drawMode, offset, vertexCount);
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWJnbC9kcmF3LmpzIl0sIm5hbWVzIjpbImRyYXciLCJnbCIsImRyYXdNb2RlIiwiVFJJQU5HTEVTIiwidmVydGV4Q291bnQiLCJvZmZzZXQiLCJpc0luZGV4ZWQiLCJpbmRleFR5cGUiLCJVTlNJR05FRF9TSE9SVCIsImlzSW5zdGFuY2VkIiwiaW5zdGFuY2VDb3VudCIsIndlYmdsMiIsImV4dGVuc2lvbiIsImdldEV4dGVuc2lvbiIsImNvbnRleHQiLCJzdWZmaXgiLCJkcmF3RWxlbWVudHMiLCJkcmF3QXJyYXlzIl0sIm1hcHBpbmdzIjoiOzs7OztRQVlnQkEsSSxHQUFBQSxJOztBQVRoQjs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFYQTtBQUNBO0FBQ0E7QUFVTyxTQUFTQSxJQUFULENBQWNDLEVBQWQsUUFRSjtBQUFBLDJCQVBEQyxRQU9DO0FBQUEsTUFQREEsUUFPQyxpQ0FQVSxVQUFHQyxTQU9iO0FBQUEsTUFOREMsV0FNQyxRQU5EQSxXQU1DO0FBQUEseUJBTERDLE1BS0M7QUFBQSxNQUxEQSxNQUtDLCtCQUxRLENBS1I7QUFBQSw0QkFKREMsU0FJQztBQUFBLE1BSkRBLFNBSUMsa0NBSlcsS0FJWDtBQUFBLDRCQUhEQyxTQUdDO0FBQUEsTUFIREEsU0FHQyxrQ0FIVyxVQUFHQyxjQUdkO0FBQUEsOEJBRkRDLFdBRUM7QUFBQSxNQUZEQSxXQUVDLG9DQUZhLEtBRWI7QUFBQSxnQ0FEREMsYUFDQztBQUFBLE1BRERBLGFBQ0Msc0NBRGUsQ0FDZjs7QUFDRCx1Q0FBbUJULEVBQW5COztBQUVBQyxhQUFXLGtCQUFNQSxRQUFOLENBQVg7QUFDQUssY0FBWSxrQkFBTUEsU0FBTixDQUFaOztBQUVBLG1DQUFlTCxRQUFmLEVBQXlCLFNBQXpCO0FBQ0EsTUFBSUksU0FBSixFQUFlO0FBQ2Isc0NBQWdCQyxTQUFoQixFQUEyQixTQUEzQjtBQUNEOztBQUVEO0FBQ0EsTUFBSUUsV0FBSixFQUFpQjtBQUNmLFFBQU1FLFNBQVMsa0NBQWdCVixFQUFoQixDQUFmO0FBQ0EsUUFBTVcsWUFBWVgsR0FBR1ksWUFBSCxDQUFnQix3QkFBaEIsQ0FBbEI7QUFDQSxRQUFNQyxVQUFVSCxTQUFTVixFQUFULEdBQWNXLFNBQTlCO0FBQ0EsUUFBTUcsU0FBU0osU0FBUyxFQUFULEdBQWMsT0FBN0I7QUFDQSxRQUFNSyxlQUFlLDBCQUEwQkQsTUFBL0M7QUFDQSxRQUFNRSxhQUFhLHdCQUF3QkYsTUFBM0M7O0FBRUEsUUFBSVQsU0FBSixFQUFlO0FBQ2JRLGNBQVFFLFlBQVIsRUFDRWQsUUFERixFQUNZRSxXQURaLEVBQ3lCRyxTQUR6QixFQUNvQ0YsTUFEcEMsRUFDNENLLGFBRDVDO0FBR0QsS0FKRCxNQUlPO0FBQ0xJLGNBQVFHLFVBQVIsRUFDRWYsUUFERixFQUNZRyxNQURaLEVBQ29CRCxXQURwQixFQUNpQ00sYUFEakM7QUFHRDtBQUNGLEdBakJELE1BaUJPLElBQUlKLFNBQUosRUFBZTtBQUNwQkwsT0FBR2UsWUFBSCxDQUFnQmQsUUFBaEIsRUFBMEJFLFdBQTFCLEVBQXVDRyxTQUF2QyxFQUFrREYsTUFBbEQ7QUFDRCxHQUZNLE1BRUE7QUFDTEosT0FBR2dCLFVBQUgsQ0FBY2YsUUFBZCxFQUF3QkcsTUFBeEIsRUFBZ0NELFdBQWhDO0FBQ0Q7QUFDRiIsImZpbGUiOiJkcmF3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyogZXNsaW50LWRpc2FibGUgKi9cbi8vIFRPRE8gLSBnZW5lcmljIGRyYXcgY2FsbFxuLy8gT25lIG9mIHRoZSBnb29kIHRoaW5ncyBhYm91dCBHTCBpcyB0aGF0IHRoZXJlIGFyZSBzbyBtYW55IHdheXMgdG8gZHJhdyB0aGluZ3NcbmltcG9ydCB7Z2V0RXh0ZW5zaW9ufSBmcm9tICcuL2NvbnRleHQnO1xuaW1wb3J0IHtHTCwgZ2xHZXR9IGZyb20gJy4vd2ViZ2wnO1xuaW1wb3J0IHthc3NlcnRXZWJHTENvbnRleHQsIGFzc2VydERyYXdNb2RlLCBhc3NlcnRJbmRleFR5cGUsIGlzV2ViR0wyQ29udGV4dH0gZnJvbSAnLi93ZWJnbC1jaGVja3MnO1xuaW1wb3J0IGFzc2VydCBmcm9tICdhc3NlcnQnO1xuXG4vLyBBIGdvb2QgdGhpbmcgYWJvdXQgd2ViR0wgaXMgdGhhdCB0aGVyZSBhcmUgc28gbWFueSB3YXlzIHRvIGRyYXcgdGhpbmdzLFxuLy8gZS5nLiBkZXBlbmRpbmcgb24gd2hldGhlciBkYXRhIGlzIGluZGV4ZWQgYW5kL29yIGlzSW5zdGFuY2VkLlxuLy8gVGhpcyBmdW5jdGlvbiB1bmlmaWVzIHRob3NlIGludG8gYSBzaW5nbGUgY2FsbCB3aXRoIHNpbXBsZSBwYXJhbWV0ZXJzXG4vLyB0aGF0IGhhdmUgc2FuZSBkZWZhdWx0cy5cbmV4cG9ydCBmdW5jdGlvbiBkcmF3KGdsLCB7XG4gIGRyYXdNb2RlID0gR0wuVFJJQU5HTEVTLFxuICB2ZXJ0ZXhDb3VudCxcbiAgb2Zmc2V0ID0gMCxcbiAgaXNJbmRleGVkID0gZmFsc2UsXG4gIGluZGV4VHlwZSA9IEdMLlVOU0lHTkVEX1NIT1JULFxuICBpc0luc3RhbmNlZCA9IGZhbHNlLFxuICBpbnN0YW5jZUNvdW50ID0gMFxufSkge1xuICBhc3NlcnRXZWJHTENvbnRleHQoZ2wpO1xuXG4gIGRyYXdNb2RlID0gZ2xHZXQoZHJhd01vZGUpO1xuICBpbmRleFR5cGUgPSBnbEdldChpbmRleFR5cGUpO1xuXG4gIGFzc2VydERyYXdNb2RlKGRyYXdNb2RlLCAnaW4gZHJhdycpO1xuICBpZiAoaXNJbmRleGVkKSB7XG4gICAgYXNzZXJ0SW5kZXhUeXBlKGluZGV4VHlwZSwgJ2luIGRyYXcnKTtcbiAgfVxuXG4gIC8vIFRPRE8gLSBVc2UgcG9seWZpbGxlZCBXZWJHTDJSZW5kZXJpbmdDb250ZXh0IGluc3RlYWQgb2YgQU5HTEUgZXh0ZW5zaW9uXG4gIGlmIChpc0luc3RhbmNlZCkge1xuICAgIGNvbnN0IHdlYmdsMiA9IGlzV2ViR0wyQ29udGV4dChnbCk7XG4gICAgY29uc3QgZXh0ZW5zaW9uID0gZ2wuZ2V0RXh0ZW5zaW9uKCdBTkdMRV9pbnN0YW5jZWRfYXJyYXlzJyk7XG4gICAgY29uc3QgY29udGV4dCA9IHdlYmdsMiA/IGdsIDogZXh0ZW5zaW9uO1xuICAgIGNvbnN0IHN1ZmZpeCA9IHdlYmdsMiA/ICcnIDogJ0FOR0xFJztcbiAgICBjb25zdCBkcmF3RWxlbWVudHMgPSAnZHJhd0VsZW1lbnRzSW5zdGFuY2VkJyArIHN1ZmZpeDtcbiAgICBjb25zdCBkcmF3QXJyYXlzID0gJ2RyYXdBcnJheXNJbnN0YW5jZWQnICsgc3VmZml4O1xuICAgIFxuICAgIGlmIChpc0luZGV4ZWQpIHtcbiAgICAgIGNvbnRleHRbZHJhd0VsZW1lbnRzXShcbiAgICAgICAgZHJhd01vZGUsIHZlcnRleENvdW50LCBpbmRleFR5cGUsIG9mZnNldCwgaW5zdGFuY2VDb3VudFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgY29udGV4dFtkcmF3QXJyYXlzXShcbiAgICAgICAgZHJhd01vZGUsIG9mZnNldCwgdmVydGV4Q291bnQsIGluc3RhbmNlQ291bnRcbiAgICAgICk7XG4gICAgfVxuICB9IGVsc2UgaWYgKGlzSW5kZXhlZCkge1xuICAgIGdsLmRyYXdFbGVtZW50cyhkcmF3TW9kZSwgdmVydGV4Q291bnQsIGluZGV4VHlwZSwgb2Zmc2V0KTtcbiAgfSBlbHNlIHtcbiAgICBnbC5kcmF3QXJyYXlzKGRyYXdNb2RlLCBvZmZzZXQsIHZlcnRleENvdW50KTtcbiAgfVxufVxuIl19