'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _ERR_FRAMEBUFFER;

var _webglTypes = require('./webgl-types');

var _webglChecks = require('./webgl-checks');

var _texture = require('./texture');

var _renderbuffer = require('./renderbuffer');

var _renderbuffer2 = _interopRequireDefault(_renderbuffer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /* eslint-disable */


/* eslint-disable max-len, no-multi-str */
var ERR_FRAMEBUFFER = (_ERR_FRAMEBUFFER = {}, _defineProperty(_ERR_FRAMEBUFFER, _webglTypes.GL.FRAMEBUFFER_COMPLETE, 'Success. Framebuffer is correctly set up'), _defineProperty(_ERR_FRAMEBUFFER, _webglTypes.GL.FRAMEBUFFER_INCOMPLETE_ATTACHMENT, 'The attachment types are mismatched or not all framebuffer attachment \
points are framebuffer attachment complete.'), _defineProperty(_ERR_FRAMEBUFFER, _webglTypes.GL.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT, 'There is no attachment.'), _defineProperty(_ERR_FRAMEBUFFER, _webglTypes.GL.FRAMEBUFFER_INCOMPLETE_DIMENSIONS, 'Height and width of the attachment are not the same.'), _defineProperty(_ERR_FRAMEBUFFER, _webglTypes.GL.FRAMEBUFFER_UNSUPPORTED, 'The format of the attachment is not supported or if depth and stencil \
attachments are not the same renderbuffer.'), _defineProperty(_ERR_FRAMEBUFFER, _webglTypes.GL.FRAMEBUFFER_INCOMPLETE_MULTISAMPLE, 'The values of GL.RENDERBUFFER_SAMPLES are different among attached \
renderbuffers, or are non-zero if the attached images are a mix of \
renderbuffers and textures.'), _ERR_FRAMEBUFFER);
/* eslint-enable max-len */

function getFrameBufferStatus(status) {
  return ERR_FRAMEBUFFER[status] || 'Framebuffer error ' + status;
}

function glFormatComponents(format) {
  switch (format) {
    case _webglTypes.GL.ALPHA:
      return 1;
    case _webglTypes.GL.RGB:
      return 3;
    case _webglTypes.GL.RGBA:
      return 4;
    default:
      throw new Error('Unknown format');
  }
}

var Framebuffer = function () {
  _createClass(Framebuffer, null, [{
    key: 'makeFrom',
    value: function makeFrom(gl) {
      var object = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      return object instanceof Framebuffer ? object :
      // Use .handle (e.g from stack.gl's gl-buffer), else use buffer directly
      new Framebuffer(gl, { handle: object.handle || object });
    }
  }]);

  function Framebuffer(gl) {
    _classCallCheck(this, Framebuffer);

    (0, _webglChecks.assertWebGLContext)(gl);

    this.gl = gl;
    this.handle = gl.createFramebuffer();
    if (!this.handle) {
      throw new Error('Failed to create WebGL Framebuffer');
    }
  }

  _createClass(Framebuffer, [{
    key: 'delete',
    value: function _delete() {
      var gl = this.gl;

      gl.deleteFramebuffer(this.handle);
    }

    // SIMPLIFIED INTERFACE

    // WEBGL INTERFACE

  }, {
    key: 'bind',
    value: function bind() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$target = _ref.target,
          target = _ref$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref$target;

      var gl = this.gl;

      gl.bindFramebuffer((0, _webglTypes.glGet)(target), this.handle);
      return this;
    }
  }, {
    key: 'unbind',
    value: function unbind() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$target = _ref2.target,
          target = _ref2$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref2$target;

      var gl = this.gl;

      gl.bindFramebuffer((0, _webglTypes.glGet)(target), null);
      return this;
    }

    // TODO - move out of renderbuffer since it should also work on draw buffer?
    //
    // NOTE: Slow requires roundtrip to GPU
    // App can provide pixelArray or have it auto allocated by this method
    // @returns {Uint8Array|Uint16Array|FloatArray} - pixel array,
    //  newly allocated by this method unless provided by app.

  }, {
    key: 'readPixels',
    value: function readPixels(_ref3) {
      var _ref3$x = _ref3.x,
          x = _ref3$x === undefined ? 0 : _ref3$x,
          _ref3$y = _ref3.y,
          y = _ref3$y === undefined ? 0 : _ref3$y,
          width = _ref3.width,
          height = _ref3.height,
          _ref3$format = _ref3.format,
          format = _ref3$format === undefined ? _webglTypes.GL.RGBA : _ref3$format,
          type = _ref3.type,
          _ref3$pixelArray = _ref3.pixelArray,
          pixelArray = _ref3$pixelArray === undefined ? null : _ref3$pixelArray;
      var gl = this.gl;

      // Deduce type and allocated pixelArray if needed

      if (!pixelArray) {
        // Allocate pixel array if not already available, using supplied type
        type = type || _webglTypes.GL.UNSIGNED_BYTE;
        var ArrayType = (0, _webglTypes.glArrayFromType)(type);
        var components = glFormatComponents(format);
        // TODO - check for composite type (components = 1).
        pixelArray = pixelArray || new ArrayType(width * height * components);
      }

      // Pixel array available, if necessary, deduce type from it.
      type = type || (0, _webglTypes.glTypeFromArray)(pixelArray);

      this.bind();
      gl.readPixels(x, y, width, height, format, type, pixelArray);
      this.unbind();

      return pixelArray;
    }

    /**
     * Used to attach textures to a framebuffer, the textures will store
     * the various buffers.
     *
     *  The set of available attachments is larger in WebGL2, and also the
     *  extensions WEBGL_draw_buffers and WEBGL_depth_texture provide additional
     *  attachments that match or exceed the WebGL2 set.
     *
     * @param {Texture2D|TextureCube|WebGLTexture|null} opt.texture=null -
     *    default is null which unbinds the texture for the attachment
     * @param {String|Number} opt.attachment= - which attachment to bind
     *    defaults to gl.COLOR_ATTACHMENT0.
     * @param {String|Number} opt.target= - bind point, normally gl.FRAMEBUFFER
     *    (WebGL2 support separating bet)
     * @param {String|Number} opt.textureTarget= - can be used to specify
     *    faces of a cube map.
     * @returns {FrameBuffer} returns itself to enable chaining
     */

  }, {
    key: 'attachTexture',
    value: function attachTexture() {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref4$texture = _ref4.texture,
          texture = _ref4$texture === undefined ? null : _ref4$texture,
          _ref4$target = _ref4.target,
          target = _ref4$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref4$target,
          _ref4$attachment = _ref4.attachment,
          attachment = _ref4$attachment === undefined ? _webglTypes.GL.COLOR_ATTACHMENT0 : _ref4$attachment,
          _ref4$textureTarget = _ref4.textureTarget,
          textureTarget = _ref4$textureTarget === undefined ? _webglTypes.GL.TEXTURE_2D : _ref4$textureTarget,
          _ref4$mipmapLevel = _ref4.mipmapLevel,
          mipmapLevel = _ref4$mipmapLevel === undefined ? 0 : _ref4$mipmapLevel;

      var gl = this.gl;


      texture = texture && _texture.Texture2D.makeFrom(gl, texture);

      this.bind({ target: target });

      gl.framebufferTexture2D((0, _webglTypes.glGet)(target), (0, _webglTypes.glGet)(attachment), (0, _webglTypes.glGet)(textureTarget), texture.handle, mipmapLevel);

      this.unbind();
      return this;
    }

    /**
     * Used to attach a renderbuffer to a framebuffer, the renderbuffer will
     * store the various buffers.
     * @param {Object} opts= - named parameters
     * @param {RenderBuffer|WebGLRenderBuffer|null} opts.renderbuffer=null -
     *    renderbuffer to bind
     *    default is null which unbinds the renderbuffer for the attachment
     * @param {String|Number} opts.attachment= - which buffer to bind
     * @returns {FrameBuffer} returns itself to enable chaining
     */

  }, {
    key: 'attachRenderbuffer',
    value: function attachRenderbuffer() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref5$renderbuffer = _ref5.renderbuffer,
          renderbuffer = _ref5$renderbuffer === undefined ? null : _ref5$renderbuffer,
          _ref5$attachment = _ref5.attachment,
          attachment = _ref5$attachment === undefined ? _webglTypes.GL.COLOR_ATTACHMENT0 : _ref5$attachment,
          _ref5$target = _ref5.target,
          target = _ref5$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref5$target,
          _ref5$renderbufferTar = _ref5.renderbufferTarget,
          renderbufferTarget = _ref5$renderbufferTar === undefined ? _webglTypes.GL.RENDERBUFFER : _ref5$renderbufferTar;

      var gl = this.gl;

      renderbuffer = renderbuffer && _renderbuffer2.default.makeFrom(gl, renderbuffer);

      this.bind({ target: target });

      gl.framebufferRenderbuffer((0, _webglTypes.glGet)(target), (0, _webglTypes.glGet)(attachment), (0, _webglTypes.glGet)(renderbufferTarget), renderbuffer.handle);

      this.unbind({ target: target });

      return this;
    }
  }, {
    key: 'checkStatus',
    value: function checkStatus() {
      var _ref6 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref6$target = _ref6.target,
          target = _ref6$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref6$target;

      var gl = this.gl;


      this.bind({ target: target });

      var status = gl.checkFramebufferStatus((0, _webglTypes.glGet)(target));

      this.unbind({ target: target });

      if (status !== gl.FRAMEBUFFER_COMPLETE) {
        throw new Error(getFrameBufferStatus(status));
      }

      return this;
    }

    // WEBGL2 INTERFACE

  }, {
    key: 'blit',
    value: function blit(_ref7) {
      var srcX0 = _ref7.srcX0,
          srcY0 = _ref7.srcY0,
          srcX1 = _ref7.srcX1,
          srcY1 = _ref7.srcY1,
          dstX0 = _ref7.dstX0,
          dstY0 = _ref7.dstY0,
          dstX1 = _ref7.dstX1,
          dstY1 = _ref7.dstY1,
          mask = _ref7.mask,
          _ref7$filter = _ref7.filter,
          filter = _ref7$filter === undefined ? _webglTypes.GL.NEAREST : _ref7$filter;
      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      gl.blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
      return this;
    }
  }, {
    key: 'textureLayer',
    value: function textureLayer() {
      var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref8$target = _ref8.target,
          target = _ref8$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref8$target,
          attachment = _ref8.attachment,
          texture = _ref8.texture,
          level = _ref8.level,
          layer = _ref8.layer;

      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      gl.framebufferTextureLayer(target, attachment, texture, level, layer);
      return this;
    }
  }, {
    key: 'invalidate',
    value: function invalidate(_ref9) {
      var _ref9$target = _ref9.target,
          target = _ref9$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref9$target,
          _ref9$attachments = _ref9.attachments,
          attachments = _ref9$attachments === undefined ? [] : _ref9$attachments;
      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      gl.invalidateFramebuffer(target, attachments);
      return this;
    }
  }, {
    key: 'invalidateSub',
    value: function invalidateSub(_ref10) {
      var _ref10$target = _ref10.target,
          target = _ref10$target === undefined ? _webglTypes.GL.FRAMEBUFFER : _ref10$target,
          _ref10$attachments = _ref10.attachments,
          attachments = _ref10$attachments === undefined ? [] : _ref10$attachments,
          _ref10$x = _ref10.x,
          x = _ref10$x === undefined ? 0 : _ref10$x,
          _ref10$y = _ref10.y,
          y = _ref10$y === undefined ? 0 : _ref10$y,
          width = _ref10.width,
          height = _ref10.height;
      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      gl.invalidateFramebuffer(target, attachments, x, y, width, height);
      return this;
    }

    // Selects a color buffer as the source for pixels for subsequent calls to
    // copyTexImage2D, copyTexSubImage2D, copyTexSubImage3D or readPixels.
    // src
    //  gl.BACK: Reads from the back color buffer.
    //  gl.NONE: Reads from no color buffer.
    //  gl.COLOR_ATTACHMENT{0-15}: Reads from one of 16 color attachment buffers.

  }, {
    key: 'readBuffer',
    value: function readBuffer(_ref11) {
      var src = _ref11.src;
      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      gl.readBuffer(src);
      return this;
    }

    // @returns {GLint}

  }, {
    key: 'alphaSize',
    value: function alphaSize() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'blueSize',
    value: function blueSize() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE);
    }

    // @returns {GLenum}

  }, {
    key: 'colorEncoding',
    value: function colorEncoding() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING);
    }

    // @returns {GLenum}

  }, {
    key: 'componentType',
    value: function componentType() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE);
    }

    // @returns {GLint}

  }, {
    key: 'depthSize',
    value: function depthSize() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'greenSize',
    value: function greenSize() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE);
    }

    // @returns {WebGLRenderbuffer|WebGLTexture}

  }, {
    key: 'objectName',
    value: function objectName() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME);
    }

    // @returns {GLenum}

  }, {
    key: 'objectType',
    value: function objectType() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE);
    }

    // @returns {GLint}

  }, {
    key: 'redSize',
    value: function redSize() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_RED_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'stencilSize',
    value: function stencilSize() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE);
    }

    // @returns {GLint}

  }, {
    key: 'cubeMapFace',
    value: function cubeMapFace() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE);
    }

    // @returns {GLint}

  }, {
    key: 'layer',
    value: function layer() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER);
    }

    // @returns {GLint}

  }, {
    key: 'level',
    value: function level() {
      return this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL);
    }
  }, {
    key: 'getParameters',
    value: function getParameters() {
      return {
        alphaSize: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE),
        blueSize: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE),
        colorEncoding: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING),
        componentType: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE),
        depthSize: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE),
        greenSize: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE),
        objectName: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME),
        objectType: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE),
        redSize: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_RED_SIZE),
        stencilSize: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE),
        cubeMapFace: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE),
        layer: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER),
        level: this.getAttachmentParameter(_webglTypes.GL.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL)
      };
    }

    // (OpenGL ES 3.0.4 §6.1.13, similar to glGetFramebufferAttachmentParameteriv)
    // Return the value for the passed pname given the target and attachment.
    // The type returned is the natural type for the requested pname:
    // pname returned type
    // FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_BLUE_SIZE  GLint
    // FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING GLenum
    // FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE GLenum
    // FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_GREEN_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_OBJECT_NAME  WebGLRenderbuffer or WebGLTexture
    // FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE  GLenum
    // FRAMEBUFFER_ATTACHMENT_RED_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE GLint
    // FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE  GLint
    // FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER  GLint
    // FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL  GLint
    // If pname is not in the table above, generates an INVALID_ENUM error.
    // If an OpenGL error is generated, returns null.

  }, {
    key: 'getAttachmentParameter',
    value: function getAttachmentParameter() {
      var _ref12 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          pname = _ref12.pname,
          target = _ref12.target,
          attachment = _ref12.attachment;

      var gl = this.gl;

      (0, _webglChecks.assertWebGL2Context)(gl);
      var value = gl.getFramebufferAttachmentParameter(target, attachment, pname);
      return value;
    }
  }]);

  return Framebuffer;
}();

exports.default = Framebuffer;
//# sourceMappingURL=data:application/json;base64,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