'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VertexArrayObject = exports.TimerQuery = exports.VertexAttributes = exports.TextureCube = exports.Texture2D = exports.Renderbuffer = exports.Framebuffer = exports.Program = exports.FragmentShader = exports.VertexShader = exports.Shader = exports.Buffer = exports.isWebGL2Context = exports.isWebGLContext = undefined;

var _webgl = require('./webgl');

Object.keys(_webgl).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _webgl[key];
    }
  });
});

var _context = require('./context');

Object.keys(_context).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _context[key];
    }
  });
});

var _webglChecks = require('./webgl-checks');

Object.defineProperty(exports, 'isWebGLContext', {
  enumerable: true,
  get: function get() {
    return _webglChecks.isWebGLContext;
  }
});
Object.defineProperty(exports, 'isWebGL2Context', {
  enumerable: true,
  get: function get() {
    return _webglChecks.isWebGL2Context;
  }
});

var _buffer = require('./buffer');

Object.defineProperty(exports, 'Buffer', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_buffer).default;
  }
});

var _shader = require('./shader');

Object.defineProperty(exports, 'Shader', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_shader).default;
  }
});
Object.defineProperty(exports, 'VertexShader', {
  enumerable: true,
  get: function get() {
    return _shader.VertexShader;
  }
});
Object.defineProperty(exports, 'FragmentShader', {
  enumerable: true,
  get: function get() {
    return _shader.FragmentShader;
  }
});

var _program = require('./program');

Object.defineProperty(exports, 'Program', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_program).default;
  }
});

var _framebuffer = require('./framebuffer');

Object.defineProperty(exports, 'Framebuffer', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_framebuffer).default;
  }
});

var _renderbuffer = require('./renderbuffer');

Object.defineProperty(exports, 'Renderbuffer', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_renderbuffer).default;
  }
});

var _texture2d = require('./texture-2d');

Object.defineProperty(exports, 'Texture2D', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_texture2d).default;
  }
});

var _textureCube = require('./texture-cube');

Object.defineProperty(exports, 'TextureCube', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_textureCube).default;
  }
});

var _timerQuery = require('./timer-query');

Object.defineProperty(exports, 'TimerQuery', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_timerQuery).default;
  }
});

var _draw = require('./draw');

Object.keys(_draw).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _draw[key];
    }
  });
});

var _uniforms = require('./uniforms');

Object.keys(_uniforms).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _uniforms[key];
    }
  });
});

var _vertexArrayObject = require('./vertex-array-object');

Object.defineProperty(exports, 'VertexArrayObject', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_vertexArrayObject).default;
  }
});

var _vertexAttributes = require('./vertex-attributes');

var VertexAttributes = _interopRequireWildcard(_vertexAttributes);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.VertexAttributes = VertexAttributes;

// Extensions


// Functions
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWJnbC9pbmRleC5qcyJdLCJuYW1lcyI6WyJpc1dlYkdMQ29udGV4dCIsImlzV2ViR0wyQ29udGV4dCIsImRlZmF1bHQiLCJWZXJ0ZXhTaGFkZXIiLCJGcmFnbWVudFNoYWRlciIsIlZlcnRleEF0dHJpYnV0ZXMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUtBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTs7OztBQUdBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTs7Ozs7Ozt3QkFDUUEsYzs7Ozs7O3dCQUFnQkMsZTs7Ozs7Ozs7OzJDQUdoQkMsTzs7Ozs7Ozs7OzJDQUNBQSxPOzs7Ozs7bUJBQW1CQyxZOzs7Ozs7bUJBQWNDLGM7Ozs7Ozs7Ozs0Q0FDakNGLE87Ozs7Ozs7OztnREFDQUEsTzs7Ozs7Ozs7O2lEQUNBQSxPOzs7Ozs7Ozs7OENBQ0FBLE87Ozs7Ozs7OztnREFDQUEsTzs7Ozs7Ozs7OytDQU1BQSxPOzs7Ozs7QUFHUjtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7Ozs7QUFDQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7Ozs7Ozs7c0RBR1FBLE87Ozs7QUFYUjs7SUFBWUcsZ0I7Ozs7OztRQUNKQSxnQixHQUFBQSxnQjs7QUFFUjs7O0FBR0EiLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBsdW1hLmdsIEJhc2UgV2ViR0wgd3JhcHBlciBsaWJyYXJ5XG4vLyBQcm92aWRlcyBzaW1wbGUgY2xhc3MvZnVuY3Rpb24gd3JhcHBlcnMgYXJvdW5kIHRoZSBsb3cgbGV2ZWwgd2ViZ2wgb2JqZWN0c1xuLy8gVGhlc2UgY2xhc3NlcyBhcmUgaW50ZW50aW9uYWxseSBjbG9zZSB0byB0aGUgV2ViR0wgQVBJXG4vLyBidXQgbWFrZSBpdCBlYXNpZXIgdG8gdXNlLlxuLy8gSGlnaGVyIGxldmVsIGFic3RyYWN0aW9ucyBjYW4gYmUgYnVpbHQgb24gdGhlc2UgY2xhc3Nlc1xuZXhwb3J0ICogZnJvbSAnLi93ZWJnbCc7XG5cbi8vIFdlYkdMIGNvbnRleHQgZnVuY3Rpb25zIGFuZCBoZWxwZXJzXG5leHBvcnQgKiBmcm9tICcuL2NvbnRleHQnO1xuZXhwb3J0IHtpc1dlYkdMQ29udGV4dCwgaXNXZWJHTDJDb250ZXh0fSBmcm9tICcuL3dlYmdsLWNoZWNrcyc7XG5cbi8vIFdlYkdMMSBvYmplY3RzXG5leHBvcnQge2RlZmF1bHQgYXMgQnVmZmVyfSBmcm9tICcuL2J1ZmZlcic7XG5leHBvcnQge2RlZmF1bHQgYXMgU2hhZGVyLCBWZXJ0ZXhTaGFkZXIsIEZyYWdtZW50U2hhZGVyfSBmcm9tICcuL3NoYWRlcic7XG5leHBvcnQge2RlZmF1bHQgYXMgUHJvZ3JhbX0gZnJvbSAnLi9wcm9ncmFtJztcbmV4cG9ydCB7ZGVmYXVsdCBhcyBGcmFtZWJ1ZmZlcn0gZnJvbSAnLi9mcmFtZWJ1ZmZlcic7XG5leHBvcnQge2RlZmF1bHQgYXMgUmVuZGVyYnVmZmVyfSBmcm9tICcuL3JlbmRlcmJ1ZmZlcic7XG5leHBvcnQge2RlZmF1bHQgYXMgVGV4dHVyZTJEfSBmcm9tICcuL3RleHR1cmUtMmQnO1xuZXhwb3J0IHtkZWZhdWx0IGFzIFRleHR1cmVDdWJlfSBmcm9tICcuL3RleHR1cmUtY3ViZSc7XG5cbmltcG9ydCAqIGFzIFZlcnRleEF0dHJpYnV0ZXMgZnJvbSAnLi92ZXJ0ZXgtYXR0cmlidXRlcyc7XG5leHBvcnQge1ZlcnRleEF0dHJpYnV0ZXN9O1xuXG4vLyBFeHRlbnNpb25zXG5leHBvcnQge2RlZmF1bHQgYXMgVGltZXJRdWVyeX0gZnJvbSAnLi90aW1lci1xdWVyeSc7XG5cbi8vIEZ1bmN0aW9uc1xuZXhwb3J0ICogZnJvbSAnLi9kcmF3JztcbmV4cG9ydCAqIGZyb20gJy4vdW5pZm9ybXMnO1xuXG4vLyBXZWJHTDJcbmV4cG9ydCB7ZGVmYXVsdCBhcyBWZXJ0ZXhBcnJheU9iamVjdH0gZnJvbSAnLi92ZXJ0ZXgtYXJyYXktb2JqZWN0JztcbiJdfQ==